
package edu.uthscsa.ric.volume;

/**
 * A point of interest.
 * 
 * @author michaelmartinez
 *
 */
public interface AnalysisPoint {

	/**
	 * The coordinate.
	 * 
	 * @return coordinate
	 */
	Coordinate4D getCoordinate();



	/**
	 * Returns a string description of this analysis.
	 * 
	 * @return a string description of this analysis
	 */
	String getDescription();



	/**
	 * Returns the atlas labels at this point.
	 * 
	 * @return the atlas labels
	 */
	String[] getLabels();



	/**
	 * Returns the name of this analysis.
	 * 
	 * @return the name of this analysis
	 */
	String getName();



	/**
	 * Returns the ROI color index.
	 * 
	 * @return the ROI color index
	 */
	int getROI();



	/**
	 * Returns the analysis type.
	 * 
	 * @return the analysis type
	 */
	String getType();



	/**
	 * Returns the value at this point.
	 * 
	 * @return the value
	 */
	double getValue();
}
