
package edu.uthscsa.ric.volume;

/**
 * A result of a statistical operation.
 * 
 * @author michaelmartinez
 *
 */
public interface Analysis {

	String DESCRIPTION_CLUSTER = "Cluster";
	String DESCRIPTION_LINE = "Line";
	String DESCRIPTION_LOGICAL = "Logical";
	String DESCRIPTION_POINT = "Point";
	String DESCRIPTION_SLICE = "Slice";
	String DESCRIPTION_TIMESERIES = "Series";
	String DESCRIPTION_VOLUME = "Volume";
	int TYPE_CLUSTER = 5;
	int TYPE_LINE = 1;
	int TYPE_LOGICAL = 6;
	int TYPE_POINT = 0;
	int TYPE_SLICE = 2;
	int TYPE_SURFACE = 7;
	int TYPE_TIMESERIES = 4;
	int TYPE_VOLUME = 3;



	/**
	 * Returns the coordinate of the centroid value.
	 * 
	 * @return the coordinate of the centroid value
	 */
	Coordinate4D getCentroidCoordinate();



	/**
	 * Returns the value at the centroid coordinate.
	 * 
	 * @return the value at the centroid coordinate
	 */
	double getCentroidValue();



	/**
	 * Returns the voxel count.
	 * 
	 * @return the voxel count
	 */
	int getCount();



	/**
	 * Returns a string description of this analysis.
	 * 
	 * @return a string description of this analysis
	 */
	String getDescription();



	/**
	 * Returns the coordinate of the max value.
	 * 
	 * @return the coordinate of the max value
	 */
	Coordinate4D getMaxCoordinate();



	/**
	 * Returns the value at the max coordinate.
	 * 
	 * @return the value at the max coordinate
	 */
	double getMaxValue();



	/**
	 * Returns the mean.
	 * 
	 * @return the mean
	 */
	double getMean();



	/**
	 * Returns the coordinate of the min value.
	 * 
	 * @return the coordinate of the min value
	 */
	Coordinate4D getMinCoordinate();



	/**
	 * Returns the value at the min coordinate.
	 * 
	 * @return the value at the min coordinate
	 */
	double getMinValue();



	/**
	 * Returns the name of this analysis.
	 * 
	 * @return the name of this analysis
	 */
	String getName();



	/**
	 * Returns the size of the region of this analysis.
	 * 
	 * @return the size of the region of this analysis
	 */
	double getRegionSize();



	/**
	 * Returns the ROI color index.
	 * 
	 * @return the ROI color index
	 */
	int getROI();



	/**
	 * Returns the slice direction.
	 * 
	 * @return the slice direction
	 */
	int getSliceDirection();



	/**
	 * Returns the slice number.
	 * 
	 * @return the slice number
	 */
	int getSliceNum();



	/**
	 * Returns the standard deviation.
	 * 
	 * @return the standard deviation
	 */
	double getStandardDev();



	/**
	 * Returns the sum.
	 * 
	 * @return the sum
	 */
	double getSum();



	/**
	 * Returns the analysis type (see constants).
	 * 
	 * @return the analysis type
	 */
	int getType();



	/**
	 * Returns the unit size.
	 * 
	 * @return the unit size
	 */
	double getUnitSize();
}
