
package edu.uthscsa.ric.visualization.surface.primitives;

import javax.vecmath.Point3d;


/**
 * A Shape represents a surface line or point.
 * 
 * @author michaelmartinez
 *
 */
public interface Shape {

	/**
	 * Returns a three float array of RGB values representing the surface color.
	 * 
	 * @return a three float array of RGB values
	 */
	float[] getColor();



	/**
	 * Returns the length of the shape.
	 * 
	 * @return the length of the shape
	 */
	double getDistance();



	/**
	 * Returns point array
	 * 
	 * @return point array
	 */
	Point3d[] getPoints();



	/**
	 * Returns true if the shape is visible
	 * 
	 * @return true if the shape is visible, false otherwise
	 */
	boolean isVisible();



	/**
	 * Sets the visibility of the shape.
	 * 
	 * @param visible true to make the shape visible, false otherwise
	 */
	void setVisible(boolean visible);
}
