
package edu.uthscsa.ric.visualization.surface.io;

import java.nio.FloatBuffer;


public class FloatIterator {

	private final FloatBuffer[] buffers;

	private int currentBufferIndex;



	/**
	 * Constructor.
	 * 
	 * @param buffers the buffers
	 */
	public FloatIterator(final FloatBuffer[] buffers) {
		this.buffers = buffers;

		if (buffers != null) {
			for (final FloatBuffer buffer : buffers) {
				buffer.clear();
			}
		}
	}



	/**
	 * Returns true if there is more data.
	 * 
	 * @return true if there is more data, false otherwise.
	 */
	public boolean hasNext() {
		if (this.buffers == null) {
			return false;
		} else if (this.buffers[this.currentBufferIndex].hasRemaining()) {
			return true;
		} else {
			this.currentBufferIndex++;

			if (this.currentBufferIndex < this.buffers.length) {
				return hasNext();
			} else {
				return false;
			}
		}
	}



	/**
	 * Returns the next float element.
	 * 
	 * @return float
	 */
	public float next() {
		return this.buffers[this.currentBufferIndex].get();
	}
}
