
package edu.uthscsa.ric.roi;

import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.List;

import edu.uthscsa.ric.roi.mask.ROIMaskBuffer;
import edu.uthscsa.ric.volume.LabelManager;


/**
 * 
 * @author michaelmartinez
 *
 */
public interface ROIMaskManager extends LabelManager {

	void addMaskValue(int xLoc, int yLoc, int zLoc, int tLoc, long mask);



	void addMaskValue(int xLoc, int yLoc, int zLoc, long mask);



	@Deprecated
	void addROIMaskValue(int xLoc, int yLoc, int zLoc, byte roiVal);



	@Deprecated
	void addROIMaskValue(int xLoc, int yLoc, int zLoc, int tLoc, byte roiVal);



	long getAvailableMask();



	long getMaskValue(int xLoc, int yLoc, int zLoc);



	long getMaskValue(int xLoc, int yLoc, int zLoc, int tLoc);



	Color getROIColor(int colorIndex);



	ROIMaskBuffer getROIDataBuffer();



	String getROILabel(int colorIndex);



	@Deprecated
	ByteBuffer getROIMaskBuffer();



	@Deprecated
	byte getROIMaskValue(int xLoc, int yLoc, int zLoc);



	@Deprecated
	byte getROIMaskValue(int xLoc, int yLoc, int zLoc, int tLoc);



	long getSelectedMask();



	List<ROI> getSelectedMasks();



	@Deprecated
	byte getSelectedROIs();



	long getUsedMask();



	List<ROI> getUsedMasks();



	@Deprecated
	byte getUsedROIs();



	boolean hasSelectedInRange(final int xMin, final int xMax, final int yMin, final int yMax, final int zMin, final int zMax);



	void initMask(long mask);



	@Deprecated
	void initROIMask(byte mask);



	boolean isInsideSelectedROIs(final int offset);



	void replaceMaskValue(int xLoc, int yLoc, int zLoc, int tLoc, long mask);



	void replaceMaskValue(int xLoc, int yLoc, int zLoc, long mask);



	@Deprecated
	void replaceROIMaskValue(int xLoc, int yLoc, int zLoc, byte roiVal);



	@Deprecated
	void replaceROIMaskValue(int xLoc, int yLoc, int zLoc, int tLoc, byte roiVal);



	void roiMaskOperationCompleted();



	void roiMaskOperationCompleted(String message);



	void setUseROISeries(boolean useROISeries);
}
