
package edu.uthscsa.ric.roi;

import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.ImageBounds;


/**
 * A ROI.
 * 
 * @author michaelmartinez
 *
 */
public interface ROI {

	/**
	 * Returns the color representation of this ROI as an index in the list of specified Mango ROI colors.
	 * 
	 * @return the ROI color
	 */
	int getColor();



	/**
	 * Returns the label of this ROI.
	 * 
	 * @param canUseDefault true to return a default label if none is stored, false otherwise
	 * @return the label
	 */
	String getLabel(boolean canUseDefault);



	/**
	 * Returns the bounds of this ROI.
	 * 
	 * @param useSeries true to include the whole series, false otherwise
	 * @return the bounds
	 */
	ImageBounds getROIBounds(boolean useSeries);



	/**
	 * Returns the stats of this ROI
	 * 
	 * @return the stats
	 */
	Analysis getStats();



	/**
	 * Returns the stats at a specified series point.
	 * 
	 * @param seriesPoint the series point
	 * @return the stats
	 */
	Analysis getStats(int seriesPoint);



	/**
	 * Sets the highlight state of this ROI.
	 * 
	 * @param highlight true to turn on highlighting of this ROI, false otherwise
	 */
	void setHighlighted(boolean highlight);



	/**
	 * Returns a string representation of this ROI.
	 * 
	 * @return a string representation of this ROI
	 */
	@Override
	String toString();
}
