
package edu.uthscsa.ric.mango.viewerprojection;

import javax.swing.JFrame;

import edu.uthscsa.ric.cli.ParameterNameAnnotation;


/**
 * Manages projection data.
 * 
 * @author michaelmartinez
 *
 */
public interface ProjectionManager {

	int QUALITY_BEST = 4;
	int QUALITY_DEFAULT = 2;
	int QUALITY_FAST = 1;
	int QUALITY_FASTEST = 0;
	int QUALITY_GOOD = 3;
	int RANK_TYPE_MAX = 0;
	int RANK_TYPE_MEDIAN = 1;
	int RANK_TYPE_MIN = 2;
	int ROTATION_AXIS_X = 0;
	int ROTATION_AXIS_Y = 1;
	int ROTATION_AXIS_Z = 2;
	int VIDEO_FORMAT_AVI_DIB = 2;
	int VIDEO_FORMAT_AVI_MJPG = 0;
	int VIDEO_FORMAT_AVI_PNG = 1;
	int VIDEO_FORMAT_QUICKTIME_ANIMATION = 5;
	int VIDEO_FORMAT_QUICKTIME_JPEG = 3;
	int VIDEO_FORMAT_QUICKTIME_PNG = 4;
	int VIDEO_FORMAT_QUICKTIME_RAW = 6;
	int VIDEO_QUALITY_BEST = 0;
	int VIDEO_QUALITY_FASTEST = 2;
	int VIDEO_QUALITY_GOOD = 1;



	/**
	 * Save a snapshot of the projection viewer to the specified location.
	 * 
	 * @param saveLocation the location to save the snapshot file
	 */
	@ParameterNameAnnotation(names = { "saveLocation" })
	void captureSnapshot(String saveLocation);



	/**
	 * Starts saving a captured video to the specified file location.
	 * 
	 * @param saveLocation the location to save the video file
	 * @param videoFormat the video format code (see constants)
	 * @param videoQuality the video quality code (see constants)
	 * @param fps the frames per second
	 * @param animate true to automatically animate the projection, false otherwise
	 */
	@ParameterNameAnnotation(names = { "saveLocation", "videoFormat", "videoQuality", "fps", "record/animate" })
	void captureVideoStart(String saveLocation, int videoFormat, int videoQuality, int fps, boolean animate);



	/**
	 * Stops the video capture.
	 */
	void captureVideoStop();



	/**
	 * Returns the parent window of the projection.
	 * 
	 * @return the parent window of the projection
	 */
	JFrame getFrame();



	/**
	 * Pauses execution of a running script.
	 */
	void pauseScriptForUserInput();



	/**
	 * Selects menu options.
	 * 
	 * @param name the menu item name
	 */
	@ParameterNameAnnotation(names = { "name" })
	void selectMenuOption(final String name);



	/**
	 * Sets projection options.
	 * 
	 * @param colorTable the projection color table name
	 * @param thresholdMin the projection color table minimum
	 * @param thresholdMax the projection color table maximum
	 */
	@ParameterNameAnnotation(names = { "colorTable", "thresholdMin", "thresholdMax" })
	void setOptions(String colorTable, double thresholdMin, double thresholdMax);



	/**
	 * Sets menu items (typically checkboxes).
	 * 
	 * @param name the menu item name
	 * @param value the menu item value
	 */
	@ParameterNameAnnotation(names = { "name", "value" })
	void setMenuOption(final String name, final boolean value);
}
