
package edu.uthscsa.ric.mango;

import java.awt.image.LookupTable;
import java.net.URI;

import edu.uthscsa.ric.volume.ImageVolume;


/**
 * ScreenImage allows access to lookup table and other screen rendering information.
 */
public interface ScreenImage {

	/**
	 * Returns the dynamic screen maximum value (as controlled by the toolbox slider).
	 * 
	 * @return the dynamic screen maximum value
	 */
	double getDynamicScreenMax();



	/**
	 * Returns the dynamic screen minimum value (as controlled by the toolbox slider).
	 * 
	 * @return the dynamic screen minimum value
	 */
	double getDynamicScreenMin();



	/**
	 * Returns the ImageVolume.
	 * 
	 * @return the ImageVolume
	 */
	ImageVolume getImageVolume();



	/**
	 * Returns the lookup table for this image.
	 * 
	 * @return the lookup table
	 */
	LookupTable getLookupTable();



	/**
	 * Returns the screen maximum value.
	 * 
	 * @return the screen maximum value
	 */
	double getScreenMax();



	/**
	 * Returns the screen minimum value.
	 * 
	 * @return the screen minimum value
	 */
	double getScreenMin();



	/**
	 * Returns the URI used to load the image.
	 * 
	 * @return the URI used to load the image
	 */
	URI getURI();



	/**
	 * Returns true if this is the base image (the first loaded image, lowest in the stack).
	 * 
	 * @return true if this is the base image
	 */
	boolean isBaseImage();



	/**
	 * Returns the "hidden" state of the image.
	 * 
	 * @return true if the image is hidde, false otherwise.
	 */
	boolean isHidden();
}
