
package edu.uthscsa.ric.mango;

import java.io.InputStream;

import javax.swing.JButton;
import javax.swing.JPanel;

import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.VoxelDimensions;


/**
 * An ImageLoader provides the application with a way to access an online library of images.
 */
public interface ImageLoader extends MangoPluginType {

	String NO_DATA_MESSAGE = "No data provided.";



	/**
	 * (Not yet implemented.)
	 * 
	 * @return data
	 */
	byte[] getData();



	/**
	 * This method should return a GUI allowing the user to select a base image.
	 * 
	 * @param loadButton the dialog load button is provided to intersect with the GUI (e.g., double-clicking selection can programatically click load button)
	 * @return the GUI panel or null if none is to be provided
	 */
	JPanel getImageSelectionPanel(JButton loadButton);



	/**
	 * (Not yet implemented.)
	 * 
	 * @return input stream
	 */
	InputStream getInputStream();



	/**
	 * This method should return a GUI allowing the user to select an overlay image.
	 * 
	 * @param imageName the name of the loaded base image
	 * @param id the image dimensions of the loaded base image
	 * @param vd the voxel dimensions of the loaded base image
	 * @param loadButton the dialog load button is provided to intersect with the GUI (e.g., double-clicking selection can programatically click load button)
	 * @return the GUI panel or null if none is to be provided
	 */
	JPanel getOverlaySelectionPanel(String imageName, ImageDimensions id, VoxelDimensions vd, JButton loadButton);



	/**
	 * This method should return a GUI allowing the user to select a ROI. The ROI can either be in Mango ROI format (e.g., "myROI.roi.gz") or an image that will
	 * be imported as an ROI [see the importROI() method in ViewerController].
	 * 
	 * @param imageName the name of the loaded base image
	 * @param id the image dimensions of the loaded base image
	 * @param vd the voxel dimensions of the loaded base image
	 * @param loadButton the dialog load button is provided to intersect with the GUI (e.g., double-clicking selection can programatically click load button)
	 * @return the GUI panel or null if none is to be provided
	 */
	JPanel getROISelectionPanel(String imageName, ImageDimensions id, VoxelDimensions vd, JButton loadButton);



	/**
	 * This method is called after the dialog has been closed using the load button. It should return an absolute URL to the data. For example, it may return
	 * the string "http://www.mywebsite.org/images/myimage". If null is returned, nothing will happen.
	 * 
	 * @return the relative path
	 */
	String getSelectedAbsolutePath();



	/**
	 * This method is called after the dialog has been closed using the load button (applet use only). It should return a relative URL to the data. For example,
	 * it may return the string "images/myimage". This will be appended to the URL returned from the applet method getCodeBase(). If getCodeBase() returns
	 * "http://www.mywebsite.org", an attempt to access the data will be made at the URL: "http://www.mywebsite.org/images/myimage". If null is returned,
	 * nothing will happen.
	 * 
	 * @return the relative path
	 */
	String getSelectedRelativePath();



	/**
	 * In the case of ROIs, this method should return true if the ROI is to be imported in world space. Note, this option is only considered if the user has not
	 * already opted to be in world space.
	 * 
	 * @return true if the ROI should be imported in world space, false otherwise
	 */
	boolean isImportingInWorldSpace();



	/**
	 * In the case of ROIs, this method should return true if the ROI is to be imported as an image, rather than ROI format.
	 * 
	 * @return true if the ROI is importing, false otherwise
	 */
	boolean isImportingROI();



	/**
	 * In the case of overlay, this method should return true if the overlay should load both in the positive and negative range.
	 * 
	 * @return true if the overlay is parametric, false otherwise
	 */
	boolean isParametricOverlay();



	/**
	 * If an image is not public, its address will not be displayed (e.g., in the Image Info dialog) and it will not be added to the recent files list.
	 * 
	 * @return true if the image is publicly accessible, false otherwise
	 */
	boolean isPublic();



	/**
	 * (Not yet implemented.)
	 * 
	 * @return true if saveable
	 */
	boolean isSaveable();
}
