
package edu.uthscsa.ric.mango;

import java.io.File;


/**
 * A class that implements Atlas can be used to provide labels for coordinate positions within an image.
 */
public interface Atlas extends MangoPluginType {

	int MAX_LABEL_LENGTH_ONE_COLUMN = 45;
	int MAX_LABEL_LENGTH_TWO_COLUMN = 23;
	int MAX_RETURN_LABELS_LENGTH = 4;



	/**
	 * Call to clear atlas of resources.
	 */
	void clear();



	/**
	 * Returns labels based on a coordinate position. The maximum length of the return array is MAX_RETURN_LABELS_LENGTH. The maximum length of a label is
	 * MAX_LABEL_SIZE. Regarding the return value, an index of 0 indicates the most general label level, while an index of (MAX_RETURN_LABELS_LENGTH - 1) would
	 * indicate the finest label level.
	 * 
	 * @param xPos the x coordinate position
	 * @param yPos the y coordinate position
	 * @param zPos the z coordinate position
	 * @return the labels found at that position
	 */
	String[] getLabel(double xPos, double yPos, double zPos);



	/**
	 * This is the maximum number of labels that will be displayed using this atlas, not to exceed MAX_RETURN_LABELS_LENGTH;
	 * 
	 * @return max number
	 */
	int getMaxReturnedLabels();



	/**
	 * Loads the atlas. This method is called only once in the lifetime of the application instance, i.e., the first time the atlas is used.
	 * 
	 * @param tempDir temporary directory where atlas image data can be stored, if necessary
	 */
	void loadAtlas(File tempDir);
}
