
package edu.uthscsa.ric.cli;

import edu.uthscsa.ric.mango.MangoContext;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;


/**
 * A plugin that can be called by a script.
 * 
 * @author michaelmartinez
 *
 */
public interface ScriptablePlugin {

	/**
	 * The method that is called by the script. See also VolumeManager.recordPluginAction().
	 * 
	 * @param context the MangoContext
	 * @param viewer the VolumeManager
	 * @param headless true if the application is not running as a GUI, false otherwise
	 * @param args the arguments
	 * @return an optional return object
	 */
	Object doOperation(MangoContext context, VolumeManager viewer, boolean headless, String... args);
}
