
package edu.uthscsa.ric.cli;

import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.swing.JButton;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.components.MangoColorSelectedListener;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.InvalidHeaderException;


/**
 * An application context. This is the most executive class in the application and maintains a list of open VolumeManagers.
 * 
 * @author michaelmartinez
 * @deprecated
 */
@Deprecated
public interface MangoContext {

	int TOOL_MODE_ADD_POINT = 11;
	int TOOL_MODE_ADD_REGION = 12;
	int TOOL_MODE_DRAW_ELLIPSE = 8;
	int TOOL_MODE_DRAW_RECT = 7;
	int TOOL_MODE_NAV = 0;
	int TOOL_MODE_PAINT_ELLIPSE_EDIT = 1;
	int TOOL_MODE_PAINT_ELLIPSE_ERASE = 2;
	int TOOL_MODE_PAINT_ELLIPSE_PAINT = 3;
	int TOOL_MODE_PAINT_RECT_EDIT = 4;
	int TOOL_MODE_PAINT_RECT_ERASE = 5;
	int TOOL_MODE_PAINT_RECT_PAINT = 6;
	int TOOL_MODE_TRACE_LINE = 10;
	int TOOL_MODE_TRACE_REGION = 9;
	int TOOL_MODE_WAND_COPY = 16;
	int TOOL_MODE_WAND_DILATE_ERODE = 15;
	int TOOL_MODE_WAND_PRESERVE = 13;
	int TOOL_MODE_WAND_REMOVE = 14;



	/**
	 * Programmatically clicks the Toolbox camera button.
	 */
	void capture();



	/**
	 * Creates a ROI color picker widget.
	 * 
	 * @param manager the VolumeManager
	 * @param listener the listener
	 * @param showUsedOnly true to enable only used ROI colors, false otherwise
	 * @return the ROI color picker widget
	 */
	@ParameterNameAnnotation(names = { "manager", "listener", "showUsedOnly" })
	JButton createColorPickerButton(VolumeManager manager, final MangoColorSelectedListener listener, final boolean showUsedOnly);



	/**
	 * Returns a list of all the currently loaded VolumeManagers.
	 * 
	 * @return a list of all the currently loaded VolumeManagers
	 */
	List<VolumeManager> getAllVolumeManagers();



	/**
	 * Returns the Mango build number.
	 * 
	 * @return the Mango build number
	 */
	String getBuildNumber();



	/**
	 * Returns the currently selected VolumeManager.
	 * 
	 * @return the currently selected VolumeManager
	 */
	VolumeManager getCurrentVolumeManager();



	/**
	 * Returns the index of the currently selected VolumeManager.
	 * 
	 * @return the index of the currently selected VolumeManager
	 */
	int getCurrentVolumeManagerIndex();



	/**
	 * Returns the lib directory.
	 * 
	 * @return the lib directory
	 */
	File getLibDir();



	/**
	 * Returns a list of all the currently loaded VolumeManagers, except the specified.
	 * 
	 * @param manager the VolumeManager to ignore
	 * @return a list of all the currently loaded VolumeManagers, except the specified
	 */
	@ParameterNameAnnotation(names = { "manager" })
	List<VolumeManager> getOtherVolumeManagers(VolumeManager manager);



	/**
	 * Returns the Mango version.
	 * 
	 * @return the Mango version
	 */
	String getVersion();



	/**
	 * Creates a new ImageVolume.
	 * 
	 * @return a new ImageVolume
	 */
	ImageVolume makeNewVolume();



	/**
	 * Creates a new VolumeManager by loading an ImageVolume from the specified location.
	 * 
	 * @param openLocation the location of a ImageVolume to load
	 * @return a new VolumeManager
	 * @throws InvalidHeaderException
	 * @throws IOException
	 */
	@ParameterNameAnnotation(names = { "openLocation" })
	VolumeManager makeNewVolumeManager(String openLocation) throws InvalidHeaderException, IOException;



	/**
	 * Creates a new VolumeManager by loading an ImageVolume from the specified URL.
	 * 
	 * @param url the location of the ImageVolume to load
	 * @return a new VolumeManager
	 * @throws InvalidHeaderException
	 * @throws IOException
	 */
	@ParameterNameAnnotation(names = { "url" })
	VolumeManager makeNewVolumeManagerURL(String url) throws InvalidHeaderException, IOException;



	/**
	 * Creates a ProgressMeter.
	 * 
	 * @return a ProgressMeter
	 */
	ProgressMeter makeProgressMeter();



	/**
	 * Runs the specified script.
	 * 
	 * @param scriptName the name of the script to run
	 */
	@ParameterNameAnnotation(names = { "scriptName" })
	void runScript(String scriptName);



	/**
	 * Sets the current Atlas.
	 * 
	 * @param name the name of the atlas to make current
	 */
	@ParameterNameAnnotation(names = { "name" })
	void setAtlas(String name);



	/**
	 * Sets the specified VolumeManager to be currently selected.
	 * 
	 * @param manager the VolumeManager to set as current
	 */
	@ParameterNameAnnotation(names = { "manager" })
	void setCurrentVolumeManager(VolumeManager manager);



	/**
	 * Sets the VolumeManager at the specified index to be currently selected.
	 * 
	 * @param index the index of the VolumeManager to set as current
	 */
	@ParameterNameAnnotation(names = { "index" })
	void setCurrentVolumeManagerIndex(int index);



	/**
	 * Sets ROI "multislice" mode.
	 * 
	 * @param multislice true for multislice mode, false otherwise
	 */
	@ParameterNameAnnotation(names = { "multislice" })
	void setMultisliceMode(boolean multislice);



	/**
	 * Sets the current ROI tool (see tool code constants).
	 * 
	 * @param code the ROI tool code
	 */
	@ParameterNameAnnotation(names = { "code" })
	void setTool(int code);



	/**
	 * Sets the ROI tool intensity range.
	 * 
	 * @param useRange true to use range, false to not use range
	 * @param min the tool range minimum
	 * @param max the tool range maximum
	 * @param onlyWhenShiftKeyPressed only enable the range when the Shift key is depressed
	 */
	@ParameterNameAnnotation(names = { "useRange", "min", "max", "onlyWhenShiftKeyPressed" })
	void setToolRange(boolean useRange, double min, double max, boolean onlyWhenShiftKeyPressed);



	/**
	 * Sets the ROI tool relative range (only applies to "magic wand" Add tool).
	 * 
	 * @param range the range, above and below, the selected voxel value
	 */
	@ParameterNameAnnotation(names = { "size" })
	void setToolRelativeRange(double range);



	/**
	 * Sets "world space" mode.
	 * 
	 * @param world true for "world space", false otherwise
	 */
	@ParameterNameAnnotation(names = { "world" })
	void setWorldMode(boolean world);



	/**
	 * Redraws all the VolumeManagers.
	 */
	void updateViewers();
}
