
package edu.uthscsa.ric.cli;

import edu.uthscsa.ric.mango.MangoContext;


/**
 * A plugin that can be run at the command-line.
 * 
 * @author michaelmartinez
 *
 */
public interface ConsolePlugin {

	/**
	 * The method that is executed when the plugin is run from the command-line.
	 * 
	 * @param context an application context
	 * @param args the command-line arguments
	 * @return an optional return object
	 */
	Object doOperation(MangoContext context, String... args);



	/**
	 * The name of the command-line program.
	 * 
	 * @return the name of the command-line program
	 */
	String getCommandLineName();



	/**
	 * A Unix-style usage message
	 * 
	 * @return a Unix-style usage message
	 */
	String getUsage();
}
