/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.visualization.surface.io.formats.gifti;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Label {
    private double alpha;
    private double blue;
    private double green;
    private double red;
    private String label;
    public static final List<String> ORDER = new ArrayList<String>();
    public static final String ATT_ALPHA = "Alpha";
    public static final String ATT_BLUE = "Blue";
    public static final String ATT_GREEN = "Green";
    public static final String ATT_KEY = "Key";
    public static final String ATT_RED = "Red";

    public static int computeHash(double red, double green, double blue, double alpha) {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(alpha);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(blue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(green);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(red);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public Label(double red, double green, double blue, double alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public Label(double red, double green, double blue, double alpha, String label) {
        this(red, green, blue, alpha);
        this.label = label;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Label other = (Label)obj;
        if (Double.doubleToLongBits(this.alpha) != Double.doubleToLongBits(other.alpha)) {
            return false;
        }
        if (Double.doubleToLongBits(this.blue) != Double.doubleToLongBits(other.blue)) {
            return false;
        }
        if (Double.doubleToLongBits(this.green) != Double.doubleToLongBits(other.green)) {
            return false;
        }
        return Double.doubleToLongBits(this.red) == Double.doubleToLongBits(other.red);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ATT_RED, String.valueOf(this.red));
        map.put(ATT_GREEN, String.valueOf(this.green));
        map.put(ATT_BLUE, String.valueOf(this.blue));
        map.put(ATT_ALPHA, String.valueOf(this.alpha));
        return map;
    }

    public double getBlue() {
        return this.blue;
    }

    public double getGreen() {
        return this.green;
    }

    public String getLabel() {
        return this.label;
    }

    public double getRed() {
        return this.red;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.alpha);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.blue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.green);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.red);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public void setBlue(double blue) {
        this.blue = blue;
    }

    public void setGreen(double green) {
        this.green = green;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setRed(double red) {
        this.red = red;
    }

    static {
        ORDER.add(ATT_KEY);
        ORDER.add(ATT_RED);
        ORDER.add(ATT_GREEN);
        ORDER.add(ATT_BLUE);
        ORDER.add(ATT_ALPHA);
    }
}

