/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.visualization.surface.io.formats.gifti;

import edu.uthscsa.ric.visualization.surface.io.formats.gifti.DataArray;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class GiftiWriterDataHandler {
    private FloatBuffer floatBuffer;
    private IntBuffer intBuffer;
    private int index;
    private int capacity;

    public GiftiWriterDataHandler(DataArray dataArray) {
        if (dataArray.isFloat32()) {
            this.floatBuffer = dataArray.getAsFloatBuffer();
            this.capacity = this.floatBuffer.capacity();
        } else if (dataArray.isInt32()) {
            this.intBuffer = dataArray.getAsIntBuffer();
            this.capacity = this.intBuffer.capacity();
        }
    }

    public boolean hasNext() {
        return this.index < this.capacity;
    }

    public int next() {
        if (this.floatBuffer != null) {
            return Float.floatToIntBits(this.floatBuffer.get(this.index++));
        }
        if (this.intBuffer != null) {
            return this.intBuffer.get(this.index++);
        }
        return 0;
    }
}

