/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.visualization.surface.io.formats.gifti;

import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class GiftiReaderDataHandler {
    private byte[] data;
    private int position;
    private Inflater inflater;

    public GiftiReaderDataHandler(boolean isCompressed) {
        if (isCompressed) {
            this.inflater = new Inflater();
        }
    }

    public void setData(byte[] data) {
        if (this.inflater != null) {
            this.inflater.setInput(data);
        } else {
            this.position = 0;
            this.data = data;
        }
    }

    public boolean hasMoreData() {
        if (this.inflater != null) {
            return !this.inflater.needsInput();
        }
        return this.position < this.data.length;
    }

    public int readData(byte[] buffer, int offset, int length) throws DataFormatException {
        if (this.inflater != null) {
            return this.inflater.inflate(buffer, offset, length);
        }
        length = Math.min(length, this.data.length - this.position);
        System.arraycopy(this.data, this.position, buffer, offset, length);
        this.position += length;
        return length;
    }
}

