/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.visualization.surface.io.formats.gifti;

import edu.uthscsa.ric.visualization.surface.io.formats.gifti.DataArray;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.Label;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.MetadataHolder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class GIFTI
implements MetadataHolder {
    private final Map<String, String> metadata;
    private final Map<String, String> attributes;
    private final Vector<DataArray> dataArrays;
    private Map<Integer, Label> labelTable;
    public static final String ATT_VERSION = "Version";
    public static final String ATT_NUMBEROFDATAARRAYS = "NumberOfDataArrays";
    public static final String DEFAULT_VERSION = "1.0";
    public static final String DOC_TYPE = "<!DOCTYPE GIFTI SYSTEM \"http://gifti.projects.nitrc.org/gifti.dtd\">";

    public GIFTI(Map<String, String> attributes) {
        this.attributes = attributes;
        this.metadata = new HashMap<String, String>();
        this.dataArrays = new Vector();
    }

    @Override
    public void addMetadata(Map<String, String> metadata) {
        this.metadata.putAll(metadata);
    }

    public void addDataArray(DataArray dataArray) {
        this.dataArrays.add(dataArray);
    }

    public String getVersion() {
        return this.attributes.get(ATT_VERSION);
    }

    public int getNumDataArrays() {
        int num = 0;
        try {
            num = Integer.parseInt(this.attributes.get(ATT_NUMBEROFDATAARRAYS));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return num;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public FloatBuffer getPoints() {
        for (DataArray dataArray : this.dataArrays) {
            if (!dataArray.isPoints()) continue;
            return dataArray.getAsFloatBuffer();
        }
        return null;
    }

    public FloatBuffer getRGBA() {
        for (DataArray dataArray : this.dataArrays) {
            if (!dataArray.isRGBA()) continue;
            return dataArray.getAsFloatBuffer();
        }
        return null;
    }

    public int getNumPoints() {
        for (DataArray dataArray : this.dataArrays) {
            if (!dataArray.isPoints()) continue;
            return dataArray.getNumElements();
        }
        return 0;
    }

    public FloatBuffer getNormals() {
        for (DataArray dataArray : this.dataArrays) {
            if (!dataArray.isNormals()) continue;
            return dataArray.getAsFloatBuffer();
        }
        return null;
    }

    public IntBuffer getIndices() {
        for (DataArray dataArray : this.dataArrays) {
            if (!dataArray.isIndices()) continue;
            return dataArray.getAsIntBuffer();
        }
        return null;
    }

    public int getNumTriangles() {
        for (DataArray dataArray : this.dataArrays) {
            if (!dataArray.isIndices()) continue;
            return dataArray.getNumElements() / 3;
        }
        return 0;
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        Set<String> keys = this.metadata.keySet();
        for (String key : keys) {
            sb.append("  " + key + " = " + this.metadata.get(key) + "\n");
        }
        return sb.toString();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Vector<DataArray> getDataArrays() {
        return this.dataArrays;
    }

    public Map<Integer, Label> getLabelTable() {
        return this.labelTable;
    }

    public void setLabelTable(Map<Integer, Label> labelTable) {
        this.labelTable = labelTable;
    }
}

