/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.visualization.surface.io.formats.gifti;

import edu.uthscsa.ric.visualization.surface.io.formats.gifti.GiftiTransform;
import edu.uthscsa.ric.visualization.surface.io.formats.gifti.MetadataHolder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class DataArray
implements MetadataHolder {
    private final Map<String, String> attributes;
    private Buffer buffer;
    private final Map<String, String> metadata;
    private final Vector<GiftiTransform> transforms;
    public static final String ATT_ARRAYINDEXINGORDER = "ArrayIndexingOrder";
    public static final String ATT_DATATYPE = "DataType";
    public static final String ATT_DIMENSIONALITY = "Dimensionality";
    public static final String ATT_DIMN = "Dim";
    public static final String ATT_ENCODING = "Encoding";
    public static final String ATT_ENDIAN = "Endian";
    public static final String ATT_EXTERNALFILENAME = "ExternalFileName";
    public static final String ATT_EXTERNALFILEOFFSET = "ExternalFileOffset";
    public static final String ATT_INTENT = "Intent";
    public static final String DATA_ORDER_BIGENDIAN = "BigEndian";
    public static final String DATA_ORDER_LITTLEENDIAN = "LittleEndian";
    public static final String DIM_ORDER_COLUMNMAJORORDER = "ColumnMajorOrder";
    public static final String DIM_ORDER_ROWMAJORORDER = "RowMajorOrder";
    public static final String ENCODING_ASCII = "ASCII";
    public static final String ENCODING_BASE64BINARY = "Base64Binary";
    public static final String ENCODING_EXTERNALFILEBINARY = "ExternalFileBinary";
    public static final String ENCODING_GZIPBASE64BINARY = "GZipBase64Binary";
    public static final String NIFTI_INTENT_GENMATRIX = "NIFTI_INTENT_GENMATRIX";
    public static final String NIFTI_INTENT_LABEL = "NIFTI_INTENT_LABEL";
    public static final String NIFTI_INTENT_NODE_INDEX = "NIFTI_INTENT_NODE_INDEX";
    public static final String NIFTI_INTENT_NONE = "NIFTI_INTENT_NONE";
    public static final String NIFTI_INTENT_POINTSET = "NIFTI_INTENT_POINTSET";
    public static final String NIFTI_INTENT_RGB_VECTOR = "NIFTI_INTENT_RGB_VECTOR";
    public static final String NIFTI_INTENT_RGBA_VECTOR = "NIFTI_INTENT_RGBA_VECTOR";
    public static final String NIFTI_INTENT_SHAPE = "NIFTI_INTENT_SHAPE";
    public static final String NIFTI_INTENT_TIME_SERIES = "NIFTI_INTENT_TIME_SERIES";
    public static final String NIFTI_INTENT_TRIANGLE = "NIFTI_INTENT_TRIANGLE";
    public static final String NIFTI_INTENT_VECTOR = "NIFTI_INTENT_VECTOR";
    public static final String TYPE_NIFTI_TYPE_FLOAT32 = "NIFTI_TYPE_FLOAT32";
    public static final String TYPE_NIFTI_TYPE_INT32 = "NIFTI_TYPE_INT32";
    public static final String TYPE_NIFTI_TYPE_UINT8 = "NIFTI_TYPE_UINT8";

    public DataArray(Map<String, String> attributes, boolean headerOnly) {
        this.attributes = attributes;
        this.metadata = new HashMap<String, String>();
        this.transforms = new Vector();
        if (!headerOnly) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.getDimensionality() * this.getBytesPerUnit());
            byteBuffer.order(ByteOrder.nativeOrder());
            this.buffer = byteBuffer;
        }
    }

    public DataArray(Map<String, String> attributes, Buffer buffer) {
        this.attributes = attributes;
        this.metadata = new HashMap<String, String>();
        this.transforms = new Vector();
        this.buffer = buffer;
    }

    @Override
    public void addMetadata(Map<String, String> metadata) {
        this.metadata.putAll(metadata);
    }

    public void addTransform(GiftiTransform xform) {
        this.transforms.add(xform);
    }

    public FloatBuffer getAsFloatBuffer() {
        if (this.buffer != null) {
            this.buffer.rewind();
            if (this.buffer instanceof FloatBuffer) {
                return (FloatBuffer)this.buffer;
            }
            if (this.buffer instanceof ByteBuffer) {
                return ((ByteBuffer)this.buffer).asFloatBuffer();
            }
        }
        return null;
    }

    public IntBuffer getAsIntBuffer() {
        if (this.buffer != null) {
            this.buffer.rewind();
            if (this.buffer instanceof IntBuffer) {
                return (IntBuffer)this.buffer;
            }
            if (this.buffer instanceof ByteBuffer) {
                return ((ByteBuffer)this.buffer).asIntBuffer();
            }
        }
        return null;
    }

    public ByteBuffer getAsByteBuffer() {
        if (this.buffer != null) {
            this.buffer.rewind();
            if (this.buffer instanceof ByteBuffer) {
                return (ByteBuffer)this.buffer;
            }
        }
        return null;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public final int getBytesPerUnit() {
        if (this.isFloat32()) {
            return 4;
        }
        if (this.isInt32()) {
            return 4;
        }
        if (this.isUnsignedInt8()) {
            return 1;
        }
        return 0;
    }

    public final int getDimensionality() {
        int total = 1;
        for (int ctr = 0; ctr < this.getDimensions(); ++ctr) {
            total *= this.getNumElements(ctr);
        }
        return total;
    }

    public final int getDimensions() {
        int dims = 0;
        try {
            dims = Integer.parseInt(this.attributes.get(ATT_DIMENSIONALITY));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return dims;
    }

    public String getExternalFilename() {
        return this.attributes.get(ATT_EXTERNALFILENAME);
    }

    public int getExternalFileOffset() {
        int num = 0;
        try {
            num = Integer.parseInt(this.attributes.get(ATT_EXTERNALFILEOFFSET));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return num;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public final int getNumElements() {
        return this.getNumElements(0);
    }

    public int getNumElements(int dim) {
        int num = 0;
        try {
            num = Integer.parseInt(this.attributes.get(ATT_DIMN + dim));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return num;
    }

    public int getNumTransforms() {
        return this.transforms.size();
    }

    public int getNumValues() {
        if (this.getDimensions() <= 2) {
            if (this.isScalar()) {
                return this.getNumElements();
            }
            if (this.isTriple()) {
                return this.getNumElements() * 3;
            }
            if (this.isQuadruple()) {
                return this.getNumElements() * 4;
            }
        }
        return -1;
    }

    public Vector<GiftiTransform> getTransforms() {
        return this.transforms;
    }

    public boolean isAscii() {
        return ENCODING_ASCII.equals(this.attributes.get(ATT_ENCODING));
    }

    public boolean isBase64Binary() {
        return ENCODING_BASE64BINARY.equals(this.attributes.get(ATT_ENCODING));
    }

    public boolean isBase64Encoded() {
        return this.isBase64Binary() || this.isGzipBase64Binary();
    }

    public boolean isExternalFileBinary() {
        return ENCODING_EXTERNALFILEBINARY.equals(this.attributes.get(ATT_ENCODING));
    }

    public final boolean isFloat32() {
        return TYPE_NIFTI_TYPE_FLOAT32.equals(this.attributes.get(ATT_DATATYPE));
    }

    public boolean isGzipBase64Binary() {
        return ENCODING_GZIPBASE64BINARY.equals(this.attributes.get(ATT_ENCODING));
    }

    public final boolean isInt32() {
        return TYPE_NIFTI_TYPE_INT32.equals(this.attributes.get(ATT_DATATYPE));
    }

    public final boolean isLabels() {
        return NIFTI_INTENT_LABEL.equals(this.attributes.get(ATT_INTENT));
    }

    public boolean isLittleEndian() {
        return DATA_ORDER_LITTLEENDIAN.equals(this.attributes.get(ATT_ENDIAN));
    }

    public boolean isNormals() {
        return NIFTI_INTENT_VECTOR.equals(this.attributes.get(ATT_INTENT));
    }

    public boolean isPoints() {
        return NIFTI_INTENT_POINTSET.equals(this.attributes.get(ATT_INTENT));
    }

    public boolean isQuadruple() {
        return this.getDimensions() == 2 && this.getNumElements(1) == 4;
    }

    public boolean isRGB() {
        return NIFTI_INTENT_RGB_VECTOR.equals(this.attributes.get(ATT_INTENT));
    }

    public boolean isRGBA() {
        return NIFTI_INTENT_RGBA_VECTOR.equals(this.attributes.get(ATT_INTENT));
    }

    public boolean isRowMajorOrder() {
        return !DIM_ORDER_COLUMNMAJORORDER.equals(this.attributes.get(ATT_ARRAYINDEXINGORDER));
    }

    public boolean isScalar() {
        return this.getDimensions() == 1;
    }

    public boolean isIndices() {
        return NIFTI_INTENT_TRIANGLE.equals(this.attributes.get(ATT_INTENT));
    }

    public boolean isTriple() {
        return this.getDimensions() == 2 && this.getNumElements(1) == 3;
    }

    public final boolean isUnsignedInt8() {
        return TYPE_NIFTI_TYPE_UINT8.equals(this.attributes.get(ATT_DATATYPE));
    }
}

