/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.RejectedExecutionException;
import sun.misc.Unsafe;
import sun.nio.ch.Invoker;
import sun.nio.ch.Port;
import sun.nio.ch.ThreadPool;
import sun.nio.ch.Util;

class SolarisEventPort
extends Port {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int addressSize = unsafe.addressSize();
    static final int SIZEOF_PORT_EVENT = SolarisEventPort.dependsArch(16, 24);
    static final int OFFSETOF_EVENTS = 0;
    static final int OFFSETOF_SOURCE = 4;
    static final int OFFSETOF_OBJECT = 8;
    static final short PORT_SOURCE_USER = 3;
    static final short PORT_SOURCE_FD = 4;
    private final int port = SolarisEventPort.port_create();
    private boolean closed;

    private static int dependsArch(int n, int n2) {
        return addressSize == 4 ? n : n2;
    }

    SolarisEventPort(AsynchronousChannelProvider asynchronousChannelProvider, ThreadPool threadPool) throws IOException {
        super(asynchronousChannelProvider, threadPool);
    }

    SolarisEventPort start() {
        this.startThreads(new EventHandlerTask());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implClose() {
        SolarisEventPort solarisEventPort = this;
        synchronized (solarisEventPort) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        SolarisEventPort.port_close(this.port);
    }

    private void wakeup() {
        try {
            SolarisEventPort.port_send(this.port, 0);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeOnHandlerTask(Runnable runnable) {
        SolarisEventPort solarisEventPort = this;
        synchronized (solarisEventPort) {
            if (this.closed) {
                throw new RejectedExecutionException();
            }
            this.offerTask(runnable);
            this.wakeup();
        }
    }

    @Override
    void shutdownHandlerTasks() {
        int n = this.threadCount();
        if (n == 0) {
            this.implClose();
        } else {
            while (n-- > 0) {
                try {
                    SolarisEventPort.port_send(this.port, 0);
                }
                catch (IOException iOException) {
                    throw new AssertionError((Object)iOException);
                }
            }
        }
    }

    @Override
    void startPoll(int n, int n2) {
        try {
            SolarisEventPort.port_associate(this.port, 4, n, n2);
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    static native int port_create() throws IOException;

    static native boolean port_associate(int var0, int var1, long var2, int var4) throws IOException;

    static native boolean port_dissociate(int var0, int var1, long var2) throws IOException;

    static native void port_get(int var0, long var1) throws IOException;

    static native int port_getn(int var0, long var1, int var3, long var4) throws IOException;

    static native void port_send(int var0, int var1) throws IOException;

    static native void port_close(int var0);

    static {
        Util.load();
    }

    private class EventHandlerTask
    implements Runnable {
        private EventHandlerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Invoker.GroupAndInvokeCount groupAndInvokeCount = Invoker.getGroupAndInvokeCount();
            boolean bl = groupAndInvokeCount != null;
            boolean bl2 = false;
            long l = unsafe.allocateMemory(SIZEOF_PORT_EVENT);
            try {
                while (true) {
                    Port.PollableChannel pollableChannel;
                    if (bl) {
                        groupAndInvokeCount.resetInvokeCount();
                    }
                    bl2 = false;
                    try {
                        SolarisEventPort.port_get(SolarisEventPort.this.port, l);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        unsafe.freeMemory(l);
                        int n = SolarisEventPort.this.threadExit(this, bl2);
                        if (n == 0 && SolarisEventPort.this.isShutdown()) {
                            SolarisEventPort.this.implClose();
                        }
                        return;
                    }
                    short s = unsafe.getShort(l + 4L);
                    if (s != 4) {
                        if (s != 3) continue;
                        Runnable runnable = SolarisEventPort.this.pollTask();
                        if (runnable == null) {
                            return;
                        }
                        bl2 = true;
                        runnable.run();
                        continue;
                    }
                    int n = (int)unsafe.getAddress(l + 8L);
                    int n2 = unsafe.getInt(l + 0L);
                    SolarisEventPort.this.fdToChannelLock.readLock().lock();
                    try {
                        pollableChannel = (Port.PollableChannel)SolarisEventPort.this.fdToChannel.get(n);
                    }
                    finally {
                        SolarisEventPort.this.fdToChannelLock.readLock().unlock();
                    }
                    if (pollableChannel == null) continue;
                    bl2 = true;
                    pollableChannel.onEvent(n2, bl);
                }
            }
            finally {
                unsafe.freeMemory(l);
                int n = SolarisEventPort.this.threadExit(this, bl2);
                if (n == 0 && SolarisEventPort.this.isShutdown()) {
                    SolarisEventPort.this.implClose();
                }
            }
        }
    }
}

