/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.jpeg;

import edu.uthscsa.ric.volume.formats.jpeg.DataStream;
import edu.uthscsa.ric.volume.formats.jpeg.ScanComponent;
import java.io.IOException;

public class ScanHeader {
    private int ah;
    private int al;
    private int numComp;
    private int selection;
    private int spectralEnd;
    protected ScanComponent[] components;

    public int getAh() {
        return this.ah;
    }

    public int getAl() {
        return this.al;
    }

    public int getNumComponents() {
        return this.numComp;
    }

    public int getSelection() {
        return this.selection;
    }

    public int getSpectralEnd() {
        return this.spectralEnd;
    }

    public void setAh(int n) {
        this.ah = n;
    }

    public void setAl(int n) {
        this.al = n;
    }

    public void setSelection(int n) {
        this.selection = n;
    }

    public void setSpectralEnd(int n) {
        this.spectralEnd = n;
    }

    protected int read(DataStream dataStream) throws IOException {
        int n;
        int n2 = 0;
        int n3 = dataStream.get16();
        n2 += 2;
        this.numComp = dataStream.get8();
        ++n2;
        this.components = new ScanComponent[this.numComp];
        for (n = 0; n < this.numComp; ++n) {
            this.components[n] = new ScanComponent();
            if (n2 > n3) {
                throw new IOException("ERROR: scan header format error");
            }
            this.components[n].setScanCompSel(dataStream.get8());
            ++n2;
            int n4 = dataStream.get8();
            ++n2;
            this.components[n].setDcTabSel(n4 >> 4);
            this.components[n].setAcTabSel(n4 & 0xF);
        }
        this.setSelection(dataStream.get8());
        ++n2;
        this.setSpectralEnd(dataStream.get8());
        ++n2;
        n = dataStream.get8();
        this.setAh(n >> 4);
        this.setAl(n & 0xF);
        if (++n2 != n3) {
            throw new IOException("ERROR: scan header format error [count!=Ns]");
        }
        return 1;
    }
}

