/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.jpeg;

import edu.uthscsa.ric.volume.formats.jpeg.ComponentSpec;
import edu.uthscsa.ric.volume.formats.jpeg.DataStream;
import edu.uthscsa.ric.volume.formats.jpeg.FrameHeader;
import edu.uthscsa.ric.volume.formats.jpeg.HuffmanTable;
import edu.uthscsa.ric.volume.formats.jpeg.QuantizationTable;
import edu.uthscsa.ric.volume.formats.jpeg.ScanComponent;
import edu.uthscsa.ric.volume.formats.jpeg.ScanHeader;
import java.io.IOException;
import java.nio.ByteBuffer;

public class JPEGLosslessDecoder
implements DataStream {
    private final ByteBuffer buffer;
    private final FrameHeader frame;
    private final HuffmanTable huffTable;
    private final QuantizationTable quantTable;
    private final ScanHeader scan;
    private final int[][][] HuffTab = new int[4][2][12800];
    private final int[] IDCT_Source = new int[64];
    private final int[] nBlock = new int[10];
    private final int[][] acTab = new int[10][];
    private final int[][] dcTab = new int[10][];
    private final int[][] qTab = new int[10][];
    private boolean restarting;
    private int dataBufferIndex;
    private int marker;
    private int markerIndex;
    private int numComp;
    private int restartInterval;
    private int selection;
    private int xDim;
    private int yDim;
    private int xLoc;
    private int yLoc;
    private int mask;
    private int[] outputData;
    private int[] outputRedData;
    private int[] outputGreenData;
    private int[] outputBlueData;
    private static final int[] IDCT_P = new int[]{0, 5, 40, 16, 45, 2, 7, 42, 21, 56, 8, 61, 18, 47, 1, 4, 41, 23, 58, 13, 32, 24, 37, 10, 63, 17, 44, 3, 6, 43, 20, 57, 15, 34, 29, 48, 53, 26, 39, 9, 60, 19, 46, 22, 59, 12, 33, 31, 50, 55, 25, 36, 11, 62, 14, 35, 28, 49, 52, 27, 38, 30, 51, 54};
    private static final int[] TABLE = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};
    public static final int RESTART_MARKER_BEGIN = 65488;
    public static final int RESTART_MARKER_END = 65495;
    public static final int MAX_HUFFMAN_SUBTREE = 50;
    public static final int MSB = Integer.MIN_VALUE;

    public JPEGLosslessDecoder(byte[] byArray) {
        this.buffer = ByteBuffer.wrap(byArray);
        this.frame = new FrameHeader();
        this.scan = new ScanHeader();
        this.quantTable = new QuantizationTable();
        this.huffTable = new HuffmanTable();
    }

    public int[][] decode() throws IOException {
        int n = 0;
        int[] nArray = new int[10];
        Object object = null;
        this.xLoc = 0;
        this.yLoc = 0;
        int n2 = this.get16();
        if (n2 != 65496) {
            throw new IOException("Not a JPEG file");
        }
        n2 = this.get16();
        while (n2 >> 4 != 4092 || n2 == 65476) {
            switch (n2) {
                case 65476: {
                    this.huffTable.read(this, this.HuffTab);
                    break;
                }
                case 65484: {
                    throw new IOException("Program doesn't support arithmetic coding. (format throw new IOException)");
                }
                case 65499: {
                    this.quantTable.read(this, TABLE);
                    break;
                }
                case 65501: {
                    this.restartInterval = this.readNumber();
                    break;
                }
                case 65504: 
                case 65505: 
                case 65506: 
                case 65507: 
                case 65508: 
                case 65509: 
                case 65510: 
                case 65511: 
                case 65512: 
                case 65513: 
                case 65514: 
                case 65515: 
                case 65516: 
                case 65517: 
                case 65518: 
                case 65519: {
                    this.readApp();
                    break;
                }
                case 65534: {
                    this.readComment();
                    break;
                }
                default: {
                    if (n2 >> 8 == 255) break;
                    throw new IOException("ERROR: format throw new IOException! (decode)");
                }
            }
            n2 = this.get16();
        }
        if (n2 < 65472 || n2 > 65479) {
            throw new IOException("ERROR: could not handle arithmetic code!");
        }
        this.frame.read(this);
        n2 = this.get16();
        while (true) {
            if (n2 != 65498) {
                switch (n2) {
                    case 65476: {
                        this.huffTable.read(this, this.HuffTab);
                        break;
                    }
                    case 65484: {
                        throw new IOException("Program doesn't support arithmetic coding. (format throw new IOException)");
                    }
                    case 65499: {
                        this.quantTable.read(this, TABLE);
                        break;
                    }
                    case 65501: {
                        this.restartInterval = this.readNumber();
                        break;
                    }
                    case 65504: 
                    case 65505: 
                    case 65506: 
                    case 65507: 
                    case 65508: 
                    case 65509: 
                    case 65510: 
                    case 65511: 
                    case 65512: 
                    case 65513: 
                    case 65514: 
                    case 65515: 
                    case 65516: 
                    case 65517: 
                    case 65518: 
                    case 65519: {
                        this.readApp();
                        break;
                    }
                    case 65534: {
                        this.readComment();
                        break;
                    }
                    default: {
                        if (n2 >> 8 == 255) break;
                        throw new IOException("ERROR: format throw new IOException! (Parser.decode)");
                    }
                }
                n2 = this.get16();
                continue;
            }
            int n3 = this.frame.getPrecision();
            this.mask = n3 == 8 ? 255 : 65535;
            ComponentSpec[] componentSpecArray = this.frame.getComponents();
            this.scan.read(this);
            this.numComp = this.scan.getNumComponents();
            this.selection = this.scan.getSelection();
            ScanComponent[] scanComponentArray = this.scan.components;
            int[][] nArray2 = this.quantTable.quantTables;
            for (int i = 0; i < this.numComp; ++i) {
                int n4 = scanComponentArray[i].getScanCompSel();
                this.qTab[i] = nArray2[componentSpecArray[n4].quantTableSel];
                this.nBlock[i] = componentSpecArray[n4].vSamp * componentSpecArray[n4].hSamp;
                this.dcTab[i] = this.HuffTab[scanComponentArray[i].getDcTabSel()][0];
                this.acTab[i] = this.HuffTab[scanComponentArray[i].getAcTabSel()][1];
            }
            this.xDim = this.frame.getDimX();
            this.yDim = this.frame.getDimY();
            object = new int[this.numComp][];
            if (this.numComp == 1) {
                this.outputData = new int[this.xDim * this.yDim];
                object[0] = this.outputData;
            } else {
                this.outputRedData = new int[this.xDim * this.yDim];
                this.outputGreenData = new int[this.xDim * this.yDim];
                this.outputBlueData = new int[this.xDim * this.yDim];
                object[0] = this.outputRedData;
                object[1] = this.outputGreenData;
                object[2] = this.outputBlueData;
            }
            ++n;
            do {
                int n5;
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                nArray3[0] = 0;
                nArray4[0] = 0;
                for (n5 = 0; n5 < 10; ++n5) {
                    nArray[n5] = 1 << n3 - 1;
                }
                if (this.restartInterval == 0) {
                    n2 = this.decode(nArray, nArray3, nArray4);
                    while (n2 == 0 && this.xLoc < this.xDim && this.yLoc < this.yDim) {
                        this.output(nArray);
                        n2 = this.decode(nArray, nArray3, nArray4);
                    }
                    break;
                }
                for (n5 = 0; n5 < this.restartInterval; ++n5) {
                    this.restarting = n5 == 0;
                    n2 = this.decode(nArray, nArray3, nArray4);
                    this.output(nArray);
                    if (n2 != 0) break;
                }
                if (n2 != 0) continue;
                if (this.markerIndex != 0) {
                    n2 = 0xFF00 | this.marker;
                    this.markerIndex = 0;
                    continue;
                }
                n2 = this.get16();
            } while (n2 >= 65488 && n2 <= 65495);
            if (n2 == 65500 && n == 1) {
                this.readNumber();
                n2 = this.get16();
            }
            if (n2 == 65497 || this.xLoc >= this.xDim || this.yLoc >= this.yDim || n != 0) break;
        }
        return object;
    }

    @Override
    public final int get16() {
        int n = this.buffer.getShort(this.dataBufferIndex) & 0xFFFF;
        this.dataBufferIndex += 2;
        return n;
    }

    @Override
    public final int get8() {
        return this.buffer.get(this.dataBufferIndex++) & 0xFF;
    }

    private int decode(int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        if (this.numComp == 1) {
            return this.decodeSingle(nArray, nArray2, nArray3);
        }
        if (this.numComp == 3) {
            return this.decodeRGB(nArray, nArray2, nArray3);
        }
        return -1;
    }

    private int decodeSingle(int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        if (this.restarting) {
            this.restarting = false;
            nArray[0] = 1 << this.frame.getPrecision() - 1;
        } else {
            switch (this.selection) {
                case 2: {
                    nArray[0] = this.getPreviousY(this.outputData);
                    break;
                }
                case 3: {
                    nArray[0] = this.getPreviousXY(this.outputData);
                    break;
                }
                case 4: {
                    nArray[0] = this.getPreviousX(this.outputData) + this.getPreviousY(this.outputData) - this.getPreviousXY(this.outputData);
                    break;
                }
                case 5: {
                    nArray[0] = this.getPreviousX(this.outputData) + (this.getPreviousY(this.outputData) - this.getPreviousXY(this.outputData) >> 1);
                    break;
                }
                case 6: {
                    nArray[0] = this.getPreviousY(this.outputData) + (this.getPreviousX(this.outputData) - this.getPreviousXY(this.outputData) >> 1);
                    break;
                }
                case 7: {
                    nArray[0] = (int)(((long)this.getPreviousX(this.outputData) + (long)this.getPreviousY(this.outputData)) / 2L);
                    break;
                }
                default: {
                    nArray[0] = this.getPreviousX(this.outputData);
                }
            }
        }
        for (int i = 0; i < this.nBlock[0]; ++i) {
            int n = this.getHuffmanValue(this.dcTab[0], nArray2, nArray3);
            if (n >= 65280) {
                return n;
            }
            int n2 = this.getn(nArray, n, nArray2, nArray3);
            int n3 = n2 >> 8;
            if (n3 >= 65488 && n3 <= 65495) {
                return n3;
            }
            nArray[0] = nArray[0] + n2;
        }
        return 0;
    }

    private int decodeRGB(int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        switch (this.selection) {
            case 2: {
                nArray[0] = this.getPreviousY(this.outputRedData);
                nArray[1] = this.getPreviousY(this.outputGreenData);
                nArray[2] = this.getPreviousY(this.outputBlueData);
                break;
            }
            case 3: {
                nArray[0] = this.getPreviousXY(this.outputRedData);
                nArray[1] = this.getPreviousXY(this.outputGreenData);
                nArray[2] = this.getPreviousXY(this.outputBlueData);
                break;
            }
            case 4: {
                nArray[0] = this.getPreviousX(this.outputRedData) + this.getPreviousY(this.outputRedData) - this.getPreviousXY(this.outputRedData);
                nArray[1] = this.getPreviousX(this.outputGreenData) + this.getPreviousY(this.outputGreenData) - this.getPreviousXY(this.outputGreenData);
                nArray[2] = this.getPreviousX(this.outputBlueData) + this.getPreviousY(this.outputBlueData) - this.getPreviousXY(this.outputBlueData);
                break;
            }
            case 5: {
                nArray[0] = this.getPreviousX(this.outputRedData) + (this.getPreviousY(this.outputRedData) - this.getPreviousXY(this.outputRedData) >> 1);
                nArray[1] = this.getPreviousX(this.outputGreenData) + (this.getPreviousY(this.outputGreenData) - this.getPreviousXY(this.outputGreenData) >> 1);
                nArray[2] = this.getPreviousX(this.outputBlueData) + (this.getPreviousY(this.outputBlueData) - this.getPreviousXY(this.outputBlueData) >> 1);
                break;
            }
            case 6: {
                nArray[0] = this.getPreviousY(this.outputRedData) + (this.getPreviousX(this.outputRedData) - this.getPreviousXY(this.outputRedData) >> 1);
                nArray[1] = this.getPreviousY(this.outputGreenData) + (this.getPreviousX(this.outputGreenData) - this.getPreviousXY(this.outputGreenData) >> 1);
                nArray[2] = this.getPreviousY(this.outputBlueData) + (this.getPreviousX(this.outputBlueData) - this.getPreviousXY(this.outputBlueData) >> 1);
                break;
            }
            case 7: {
                nArray[0] = (int)(((long)this.getPreviousX(this.outputRedData) + (long)this.getPreviousY(this.outputRedData)) / 2L);
                nArray[1] = (int)(((long)this.getPreviousX(this.outputGreenData) + (long)this.getPreviousY(this.outputGreenData)) / 2L);
                nArray[2] = (int)(((long)this.getPreviousX(this.outputBlueData) + (long)this.getPreviousY(this.outputBlueData)) / 2L);
                break;
            }
            default: {
                nArray[0] = this.getPreviousX(this.outputRedData);
                nArray[1] = this.getPreviousX(this.outputGreenData);
                nArray[2] = this.getPreviousX(this.outputBlueData);
            }
        }
        for (int i = 0; i < this.numComp; ++i) {
            int[] nArray4 = this.qTab[i];
            int[] nArray5 = this.acTab[i];
            int[] nArray6 = this.dcTab[i];
            block9: for (int j = 0; j < this.nBlock[i]; ++j) {
                int n;
                for (n = 0; n < this.IDCT_Source.length; ++n) {
                    this.IDCT_Source[n] = 0;
                }
                int n2 = this.getHuffmanValue(nArray6, nArray2, nArray3);
                if (n2 >= 65280) {
                    return n2;
                }
                nArray[i] = this.IDCT_Source[0] = nArray[i] + this.getn(nArray3, n2, nArray2, nArray3);
                this.IDCT_Source[0] = this.IDCT_Source[0] * nArray4[0];
                for (n = 1; n < 64; ++n) {
                    n2 = this.getHuffmanValue(nArray5, nArray2, nArray3);
                    if (n2 >= 65280) {
                        return n2;
                    }
                    n += n2 >> 4;
                    if ((n2 & 0xF) == 0) {
                        if (n2 >> 4 != 0) continue;
                        continue block9;
                    }
                    this.IDCT_Source[JPEGLosslessDecoder.IDCT_P[n]] = this.getn(nArray3, n2 & 0xF, nArray2, nArray3) * nArray4[n];
                }
            }
        }
        return 0;
    }

    private int getHuffmanValue(int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        int n;
        if (nArray3[0] < 8) {
            nArray2[0] = nArray2[0] << 8;
            n = this.get8();
            if (n == 255) {
                this.marker = this.get8();
                if (this.marker != 0) {
                    this.markerIndex = 9;
                }
            }
            nArray2[0] = nArray2[0] | n;
        } else {
            nArray3[0] = nArray3[0] - 8;
        }
        int n2 = nArray[nArray2[0] >> nArray3[0]];
        if ((n2 & Integer.MIN_VALUE) != 0) {
            if (this.markerIndex != 0) {
                this.markerIndex = 0;
                return 0xFF00 | this.marker;
            }
            nArray2[0] = nArray2[0] & 65535 >> 16 - nArray3[0];
            nArray2[0] = nArray2[0] << 8;
            n = this.get8();
            if (n == 255) {
                this.marker = this.get8();
                if (this.marker != 0) {
                    this.markerIndex = 9;
                }
            }
            nArray2[0] = nArray2[0] | n;
            n2 = nArray[(n2 & 0xFF) * 256 + (nArray2[0] >> nArray3[0])];
            nArray3[0] = nArray3[0] + 8;
        }
        nArray3[0] = nArray3[0] + (8 - (n2 >> 8));
        if (nArray3[0] < 0) {
            throw new IOException("index=" + nArray3[0] + " temp=" + nArray2[0] + " code=" + n2 + " in HuffmanValue()");
        }
        if (nArray3[0] < this.markerIndex) {
            this.markerIndex = 0;
            return 0xFF00 | this.marker;
        }
        nArray2[0] = nArray2[0] & 65535 >> 16 - nArray3[0];
        return n2 & 0xFF;
    }

    private int getn(int[] nArray, int n, int[] nArray2, int[] nArray3) throws IOException {
        int n2;
        if (n == 0) {
            return 0;
        }
        if (n == 16) {
            if (nArray[0] >= 0) {
                return Short.MIN_VALUE;
            }
            return 32768;
        }
        nArray3[0] = nArray3[0] - n;
        if (nArray3[0] >= 0) {
            if (nArray3[0] < this.markerIndex && !this.isLastPixel()) {
                this.markerIndex = 0;
                return (0xFF00 | this.marker) << 8;
            }
            n2 = nArray2[0] >> nArray3[0];
            nArray2[0] = nArray2[0] & 65535 >> 16 - nArray3[0];
        } else {
            nArray2[0] = nArray2[0] << 8;
            int n3 = this.get8();
            if (n3 == 255) {
                this.marker = this.get8();
                if (this.marker != 0) {
                    this.markerIndex = 9;
                }
            }
            nArray2[0] = nArray2[0] | n3;
            nArray3[0] = nArray3[0] + 8;
            if (nArray3[0] < 0) {
                if (this.markerIndex != 0) {
                    this.markerIndex = 0;
                    return (0xFF00 | this.marker) << 8;
                }
                nArray2[0] = nArray2[0] << 8;
                n3 = this.get8();
                if (n3 == 255) {
                    this.marker = this.get8();
                    if (this.marker != 0) {
                        this.markerIndex = 9;
                    }
                }
                nArray2[0] = nArray2[0] | n3;
                nArray3[0] = nArray3[0] + 8;
            }
            if (nArray3[0] < 0) {
                throw new IOException("index=" + nArray3[0] + " in getn()");
            }
            if (nArray3[0] < this.markerIndex) {
                this.markerIndex = 0;
                return (0xFF00 | this.marker) << 8;
            }
            n2 = nArray2[0] >> nArray3[0];
            nArray2[0] = nArray2[0] & 65535 >> 16 - nArray3[0];
        }
        if (n2 < 1 << n - 1) {
            n2 += (-1 << n) + 1;
        }
        return n2;
    }

    private int getPreviousX(int[] nArray) {
        if (this.xLoc > 0) {
            return nArray[this.yLoc * this.xDim + this.xLoc - 1];
        }
        if (this.yLoc > 0) {
            return this.getPreviousY(nArray);
        }
        return 1 << this.frame.getPrecision() - 1;
    }

    private int getPreviousXY(int[] nArray) {
        if (this.xLoc > 0 && this.yLoc > 0) {
            return nArray[(this.yLoc - 1) * this.xDim + this.xLoc - 1];
        }
        return this.getPreviousY(nArray);
    }

    private int getPreviousY(int[] nArray) {
        if (this.yLoc > 0) {
            return nArray[(this.yLoc - 1) * this.xDim + this.xLoc];
        }
        return this.getPreviousX(nArray);
    }

    private boolean isLastPixel() {
        return this.xLoc == this.xDim - 1 && this.yLoc == this.yDim - 1;
    }

    private void output(int[] nArray) {
        if (this.numComp == 1) {
            this.outputSingle(nArray);
        } else {
            this.outputRGB(nArray);
        }
    }

    private void outputSingle(int[] nArray) {
        if (this.xLoc < this.xDim && this.yLoc < this.yDim) {
            this.outputData[this.yLoc * this.xDim + this.xLoc] = this.mask & nArray[0];
            ++this.xLoc;
            if (this.xLoc >= this.xDim) {
                ++this.yLoc;
                this.xLoc = 0;
            }
        }
    }

    private void outputRGB(int[] nArray) {
        if (this.xLoc < this.xDim && this.yLoc < this.yDim) {
            this.outputRedData[this.yLoc * this.xDim + this.xLoc] = nArray[0];
            this.outputGreenData[this.yLoc * this.xDim + this.xLoc] = nArray[1];
            this.outputBlueData[this.yLoc * this.xDim + this.xLoc] = nArray[2];
            ++this.xLoc;
            if (this.xLoc >= this.xDim) {
                ++this.yLoc;
                this.xLoc = 0;
            }
        }
    }

    private int readApp() throws IOException {
        int n = 0;
        int n2 = this.get16();
        n += 2;
        while (n < n2) {
            this.get8();
            ++n;
        }
        return n2;
    }

    private String readComment() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = this.get16();
        n += 2;
        while (n < n2) {
            stringBuffer.append((char)this.get8());
            ++n;
        }
        return stringBuffer.toString();
    }

    private int readNumber() throws IOException {
        int n = this.get16();
        if (n != 4) {
            throw new IOException("ERROR: Define number format throw new IOException [Ld!=4]");
        }
        return this.get16();
    }

    public int getNumComponents() {
        return this.numComp;
    }

    public int getPrecision() {
        return this.frame.getPrecision();
    }
}

