/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram;

import antlr.CommonAST;
import antlr.Token;
import antlr.collections.AST;
import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.GlueGen;
import com.jogamp.gluegen.cgram.CToken;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;

public class TNode
extends CommonAST
implements ASTLocusTag.ASTLocusTagProvider {
    protected int ttype;
    protected String text;
    protected int lineNum = 0;
    protected TNode defNode;
    protected TNode up;
    protected TNode left;
    protected boolean marker = false;
    protected Hashtable<String, Object> attributes = null;
    static String tokenVocabulary;

    @Override
    public ASTLocusTag getASTLocusTag() {
        Object object = this.getAttribute("source");
        if (null != object) {
            return new ASTLocusTag(object, this.getLineNum(), -1, this.getText());
        }
        return null;
    }

    public static void setTokenVocabulary(String string) {
        tokenVocabulary = string;
    }

    public void initialize(Token token) {
        CToken cToken = (CToken)token;
        this.setText(cToken.getText());
        this.setType(cToken.getType());
        this.setLineNum(cToken.getLine());
        this.setAttribute("source", cToken.getSource());
        this.setAttribute("tokenNumber", new Integer(cToken.getTokenNumber()));
    }

    public void initialize(AST aST) {
        TNode tNode = (TNode)aST;
        this.setText(tNode.getText());
        this.setType(tNode.getType());
        this.setLineNum(tNode.getLineNum());
        this.setDefNode(tNode.getDefNode());
        this.attributes = tNode.getAttributesTable();
    }

    public int getType() {
        return this.ttype;
    }

    public void setType(int n) {
        this.ttype = n;
    }

    public boolean getMarker() {
        return this.marker;
    }

    public void setMarker(boolean bl) {
        this.marker = bl;
    }

    public Hashtable<String, Object> getAttributesTable() {
        if (this.attributes == null) {
            this.attributes = new Hashtable(7);
        }
        return this.attributes;
    }

    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new Hashtable(7);
        }
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(string);
    }

    public int getLineNum() {
        if (this.lineNum != 0) {
            return this.lineNum;
        }
        if (this.down == null) {
            return this.lineNum;
        }
        return ((TNode)this.down).getLocalLineNum();
    }

    public int getLocalLineNum() {
        if (this.lineNum != 0) {
            return this.lineNum;
        }
        if (this.down == null) {
            if (this.right == null) {
                return this.lineNum;
            }
            return ((TNode)this.right).getLocalLineNum();
        }
        return ((TNode)this.down).getLocalLineNum();
    }

    public void setLineNum(int n) {
        this.lineNum = n;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getAllChildrenText(String string) {
        if (GlueGen.debug()) {
            System.err.println("TNode.XXX: " + string);
            new DebugASTVisitor(1).visit(this.getFirstChild());
        }
        StringBuilder stringBuilder = new StringBuilder();
        TNode tNode = (TNode)this.getFirstChild();
        if (null == tNode) {
            stringBuilder.append(this.getText());
        } else {
            TNode.getAllChildrenText(stringBuilder, this, tNode);
        }
        return stringBuilder.toString();
    }

    private static void getAllChildrenText(StringBuilder stringBuilder, TNode tNode, TNode tNode2) {
        boolean bl = true;
        while (null != tNode2) {
            boolean bl2 = 48 == tNode2.getType();
            boolean bl3 = 120 == tNode2.getType();
            TNode tNode3 = (TNode)tNode2.getNextSibling();
            TNode tNode4 = (TNode)tNode2.getFirstChild();
            if (!bl2 && (null == tNode4 && null == tNode3 || !bl)) {
                stringBuilder.append(" ").append(tNode.getText());
            }
            if (null != tNode4) {
                if (!bl3) {
                    stringBuilder.append(" (");
                }
                TNode.getAllChildrenText(stringBuilder, tNode2, tNode4);
                if (!bl3) {
                    stringBuilder.append(" )");
                }
            } else if (!bl2) {
                stringBuilder.append(" ").append(tNode2.getText());
            }
            tNode2 = tNode3;
            bl = false;
        }
    }

    public TNode getLastChild() {
        TNode tNode = (TNode)this.getFirstChild();
        if (tNode != null) {
            return tNode.getLastSibling();
        }
        return null;
    }

    public TNode getLastSibling() {
        TNode tNode = (TNode)this.getNextSibling();
        if (tNode != null) {
            return tNode.getLastSibling();
        }
        return this;
    }

    public TNode getFirstSibling() {
        TNode tNode = this.left;
        if (tNode != null) {
            return tNode.getFirstSibling();
        }
        return this;
    }

    public TNode getParent() {
        return this.getFirstSibling().up;
    }

    public void addSibling(AST aST) {
        if (aST == null) {
            return;
        }
        TNode tNode = (TNode)this.right;
        this.right = (TNode)aST;
        ((TNode)aST).left = this;
        TNode tNode2 = ((TNode)aST).getLastSibling();
        tNode2.right = tNode;
        if (tNode != null) {
            tNode.left = tNode2;
        }
    }

    public int numberOfChildren() {
        int n = 0;
        for (AST aST = this.getFirstChild(); aST != null; aST = aST.getNextSibling()) {
            ++n;
        }
        return n;
    }

    public void removeSelf() {
        TNode tNode = this.up;
        TNode tNode2 = this.left;
        TNode tNode3 = (TNode)this.right;
        if (tNode != null) {
            tNode.down = tNode3;
            if (tNode3 != null) {
                tNode3.up = tNode;
                tNode3.left = tNode2;
            }
        } else {
            if (tNode2 != null) {
                tNode2.right = tNode3;
            }
            if (tNode3 != null) {
                tNode3.left = tNode2;
            }
        }
    }

    public TNode getDefNode() {
        return this.defNode;
    }

    public void setDefNode(TNode tNode) {
        this.defNode = tNode;
    }

    public TNode deepCopy() {
        TNode tNode = new TNode();
        tNode.ttype = this.ttype;
        tNode.text = this.text;
        tNode.lineNum = this.lineNum;
        tNode.defNode = this.defNode;
        if (this.attributes != null) {
            tNode.attributes = new Hashtable<String, Object>(this.attributes);
        }
        if (this.down != null) {
            tNode.down = ((TNode)this.down).deepCopyWithRightSiblings();
        }
        tNode.doubleLink();
        return tNode;
    }

    public TNode deepCopyWithRightSiblings() {
        TNode tNode = new TNode();
        tNode.ttype = this.ttype;
        tNode.text = this.text;
        tNode.lineNum = this.lineNum;
        tNode.defNode = this.defNode;
        if (this.attributes != null) {
            tNode.attributes = new Hashtable<String, Object>(this.attributes);
        }
        if (this.down != null) {
            tNode.down = ((TNode)this.down).deepCopyWithRightSiblings();
        }
        if (this.right != null) {
            tNode.right = ((TNode)this.right).deepCopyWithRightSiblings();
        }
        tNode.doubleLink();
        return tNode;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(TNode.getNameForType(this.getType()) + "[" + this.getText() + ", " + "]");
        if (this.getLineNum() != 0) {
            stringBuilder.append(" line:" + this.getLineNum());
        }
        Enumeration<String> enumeration = this.getAttributesTable().keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            stringBuilder.append(" " + string + ":" + this.getAttribute(string));
        }
        return stringBuilder.toString();
    }

    public static void printTree(AST aST) {
        if (aST == null) {
            return;
        }
        TNode.printASTNode(aST, 0);
        System.out.print("\n");
    }

    protected static void printASTNode(AST aST, int n) {
        AST aST2;
        Object object;
        String string;
        AST aST3 = aST.getFirstChild();
        System.out.print("\n");
        for (int i = 0; i < n; ++i) {
            System.out.print("   ");
        }
        if (aST3 != null) {
            System.out.print("(");
        }
        if ((string = aST.getText()) != null && string.length() > 0) {
            System.out.print(TNode.getNameForType(aST.getType()));
            System.out.print(": \"" + string + "\"");
        } else {
            System.out.print(TNode.getNameForType(aST.getType()));
        }
        if (((TNode)aST).getLineNum() != 0) {
            System.out.print(" line:" + ((TNode)aST).getLineNum());
        }
        Enumeration<String> enumeration = ((TNode)aST).getAttributesTable().keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            System.out.print(" " + (String)object + ":" + ((TNode)aST).getAttribute((String)object));
        }
        object = ((TNode)aST).getDefNode();
        if (object != null) {
            System.out.print("[" + TNode.getNameForType(((TNode)object).getType()) + "]");
        }
        if (aST3 != null) {
            TNode.printASTNode(aST3, n + 1);
            System.out.print("\n");
            for (int i = 0; i < n; ++i) {
                System.out.print("   ");
            }
            System.out.print(")");
        }
        if ((aST2 = aST.getNextSibling()) != null) {
            TNode.printASTNode(aST2, n);
        }
    }

    public static String getNameForType(int n) {
        try {
            Class<?> clazz = Class.forName(tokenVocabulary);
            Field[] fieldArray = clazz.getDeclaredFields();
            if (n - 2 < fieldArray.length) {
                return fieldArray[n - 2].getName();
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return "unfoundtype: " + n;
    }

    public void doubleLink() {
        TNode tNode;
        TNode tNode2 = (TNode)this.getNextSibling();
        if (tNode2 != null) {
            tNode2.left = this;
            tNode2.doubleLink();
        }
        if ((tNode = (TNode)this.getFirstChild()) != null) {
            tNode.up = this;
            tNode.doubleLink();
        }
    }

    public TNode parentOfType(int n) {
        if (this.up == null) {
            if (this.left == null) {
                return null;
            }
            return this.left.parentOfType(n);
        }
        if (this.up.getType() == n) {
            return this.up;
        }
        return this.up.parentOfType(n);
    }

    public TNode firstChildOfType(int n) {
        TNode tNode = (TNode)this.getFirstChild();
        if (tNode == null) {
            return null;
        }
        if (tNode.getType() == n) {
            return tNode;
        }
        return tNode.firstSiblingOfType(n);
    }

    public TNode firstSiblingOfType(int n) {
        TNode tNode = (TNode)this.getNextSibling();
        if (tNode == null) {
            return null;
        }
        if (tNode.getType() == n) {
            return tNode;
        }
        return tNode.firstSiblingOfType(n);
    }

    static class DebugASTVisitor {
        protected int level;

        private String tabs(StringBuilder stringBuilder) {
            stringBuilder.setLength(0);
            for (int i = 0; i < this.level; ++i) {
                stringBuilder.append("   ");
            }
            return stringBuilder.toString();
        }

        DebugASTVisitor(int n) {
            this.level = n;
        }

        void visit(AST aST) {
            StringBuilder stringBuilder = new StringBuilder();
            for (AST aST2 = aST; aST2 != null; aST2 = aST2.getNextSibling()) {
                if (aST2.getText() == null) {
                    System.err.printf("%03d: %snil [%d]%n", this.level, this.tabs(stringBuilder), aST2.getType());
                } else {
                    System.err.printf("%03d: %s%s [%d]%n", this.level, this.tabs(stringBuilder), aST2.getText(), aST2.getType());
                }
                if (aST2.getFirstChild() == null) continue;
                ++this.level;
                this.visit(aST2.getFirstChild());
                --this.level;
            }
        }
    }
}

