/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.roi.encoder;

import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.roi.encoder.ROI;
import jj2000.j2k.roi.encoder.ROIMaskGenerator;
import jj2000.j2k.roi.encoder.SubbandRectROIMask;
import jj2000.j2k.wavelet.Subband;

public class RectROIMaskGenerator
extends ROIMaskGenerator {
    private int[] ulxs;
    private int[] ulys;
    private int[] lrxs;
    private int[] lrys;
    private int[] nrROIs;
    private SubbandRectROIMask[] sMasks;

    public RectROIMaskGenerator(ROI[] rOIArray, int n) {
        super(rOIArray, n);
        int n2 = rOIArray.length;
        this.nrROIs = new int[n];
        this.sMasks = new SubbandRectROIMask[n];
        for (int i = n2 - 1; i >= 0; --i) {
            int n3 = rOIArray[i].comp;
            this.nrROIs[n3] = this.nrROIs[n3] + 1;
        }
    }

    @Override
    public boolean getROIMask(DataBlkInt dataBlkInt, Subband subband, int n, int n2) {
        int n3 = dataBlkInt.ulx;
        int n4 = dataBlkInt.uly;
        int n5 = dataBlkInt.w;
        int n6 = dataBlkInt.h;
        int[] nArray = dataBlkInt.getDataInt();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        if (!this.tileMaskMade[n2]) {
            this.makeMask(subband, n, n2);
            this.tileMaskMade[n2] = true;
        }
        if (!this.roiInTile) {
            return false;
        }
        SubbandRectROIMask subbandRectROIMask = (SubbandRectROIMask)this.sMasks[n2].getSubbandRectROIMask(n3, n4);
        int[] nArray2 = subbandRectROIMask.ulxs;
        int[] nArray3 = subbandRectROIMask.ulys;
        int[] nArray4 = subbandRectROIMask.lrxs;
        int[] nArray5 = subbandRectROIMask.lrys;
        int n11 = nArray2.length - 1;
        n3 -= subbandRectROIMask.ulx;
        n4 -= subbandRectROIMask.uly;
        for (int i = n11; i >= 0; --i) {
            int n12;
            n7 = nArray2[i] - n3;
            if (n7 < 0) {
                n7 = 0;
            } else if (n7 >= n5) {
                n7 = n5;
            }
            n8 = nArray3[i] - n4;
            if (n8 < 0) {
                n8 = 0;
            } else if (n8 >= n6) {
                n8 = n6;
            }
            n9 = nArray4[i] - n3;
            if (n9 < 0) {
                n9 = -1;
            } else if (n9 >= n5) {
                n9 = n5 - 1;
            }
            n10 = nArray5[i] - n4;
            if (n10 < 0) {
                n10 = -1;
            } else if (n10 >= n6) {
                n10 = n6 - 1;
            }
            int n13 = n5 * n10 + n9;
            int n14 = n9 - n7;
            int n15 = n5 - n14 - 1;
            for (int j = n12 = n10 - n8; j >= 0; --j) {
                int n16 = n14;
                while (n16 >= 0) {
                    nArray[n13] = n;
                    --n16;
                    --n13;
                }
                n13 -= n15;
            }
        }
        return true;
    }

    public String toString() {
        return "Fast rectangular ROI mask generator";
    }

    @Override
    public void makeMask(Subband subband, int n, int n2) {
        int n3 = this.nrROIs[n2];
        int n4 = subband.ulcx;
        int n5 = subband.ulcy;
        int n6 = subband.w;
        int n7 = subband.h;
        ROI[] rOIArray = this.rois;
        this.ulxs = new int[n3];
        this.ulys = new int[n3];
        this.lrxs = new int[n3];
        this.lrys = new int[n3];
        n3 = 0;
        for (int i = rOIArray.length - 1; i >= 0; --i) {
            if (rOIArray[i].comp != n2) continue;
            int n8 = rOIArray[i].ulx;
            int n9 = rOIArray[i].uly;
            int n10 = rOIArray[i].w + n8 - 1;
            int n11 = rOIArray[i].h + n9 - 1;
            if (n8 > n4 + n6 - 1 || n9 > n5 + n7 - 1 || n10 < n4 || n11 < n5) continue;
            n10 -= n4;
            n11 -= n5;
            n8 = (n8 -= n4) < 0 ? 0 : n8;
            n9 = n9 < 0 ? 0 : (n9 -= n5);
            n10 = n10 > n6 - 1 ? n6 - 1 : n10;
            n11 = n11 > n7 - 1 ? n7 - 1 : n11;
            this.ulxs[n3] = n8;
            this.ulys[n3] = n9;
            this.lrxs[n3] = n10;
            this.lrys[n3] = n11;
            ++n3;
        }
        this.roiInTile = n3 != 0;
        this.sMasks[n2] = new SubbandRectROIMask(subband, this.ulxs, this.ulys, this.lrxs, this.lrys, n3);
    }
}

