/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image.output;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.output.ImgWriter;
import jj2000.j2k.util.FacilityManager;

public class ImgWriterPGM
extends ImgWriter {
    private int levShift;
    private RandomAccessFile out;
    private int c;
    private int fb;
    private DataBlkInt db = new DataBlkInt();
    private int offset;
    private byte[] buf;

    public ImgWriterPGM(File file, BlkImgDataSrc blkImgDataSrc, int n) throws IOException {
        if (n < 0 || n >= blkImgDataSrc.getNumComps()) {
            throw new IllegalArgumentException("Invalid number of components");
        }
        if (blkImgDataSrc.getNomRangeBits(n) > 8) {
            FacilityManager.getMsgLogger().println("Warning: Component " + n + " has nominal bitdepth " + blkImgDataSrc.getNomRangeBits(n) + ". Pixel values will be " + "down-shifted to fit bitdepth of 8 for PGM file", 8, 8);
        }
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not reset file");
        }
        this.out = new RandomAccessFile(file, "rw");
        this.src = blkImgDataSrc;
        this.c = n;
        this.w = blkImgDataSrc.getImgWidth();
        this.h = blkImgDataSrc.getImgHeight();
        this.fb = blkImgDataSrc.getFixedPoint(n);
        this.levShift = 1 << blkImgDataSrc.getNomRangeBits(n) - 1;
        this.writeHeaderInfo();
    }

    public ImgWriterPGM(String string, BlkImgDataSrc blkImgDataSrc, int n) throws IOException {
        this(new File(string), blkImgDataSrc, n);
    }

    @Override
    public void close() throws IOException {
        if (this.out.length() != (long)(this.w * this.h + this.offset)) {
            this.out.seek(this.out.length());
            for (int i = this.offset + this.w * this.h - (int)this.out.length(); i > 0; --i) {
                this.out.writeByte(0);
            }
        }
        this.out.close();
        this.src = null;
        this.out = null;
        this.db = null;
    }

    @Override
    public void flush() throws IOException {
        this.buf = null;
    }

    @Override
    public void write(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.fb;
        this.db.ulx = n;
        this.db.uly = n2;
        this.db.w = n3;
        this.db.h = n4;
        int n6 = this.src.getCompULX(this.c) - (int)Math.ceil((double)this.src.getImgULX() / (double)this.src.getCompSubsX(this.c));
        int n7 = this.src.getCompULY(this.c) - (int)Math.ceil((double)this.src.getImgULY() / (double)this.src.getCompSubsY(this.c));
        if (this.db.data != null && this.db.data.length < n3 * n4) {
            this.db.data = null;
        }
        do {
            this.db = (DataBlkInt)this.src.getInternCompData(this.db, this.c);
        } while (this.db.progressive);
        int n8 = (1 << this.src.getNomRangeBits(this.c)) - 1;
        int n9 = this.src.getNomRangeBits(this.c) - 8;
        if (n9 < 0) {
            n9 = 0;
        }
        if (this.buf == null || this.buf.length < n3) {
            this.buf = new byte[n3];
        }
        for (int i = 0; i < n4; ++i) {
            int n10;
            int n11;
            int n12;
            this.out.seek(this.offset + this.w * (n2 + n7 + i) + n + n6);
            if (n5 == 0) {
                n12 = this.db.offset + i * this.db.scanw + n3 - 1;
                n11 = n3 - 1;
                while (n11 >= 0) {
                    n10 = this.db.data[n12] + this.levShift;
                    this.buf[n11] = (byte)((n10 < 0 ? 0 : (n10 > n8 ? n8 : n10)) >> n9);
                    --n11;
                    --n12;
                }
            } else {
                n12 = this.db.offset + i * this.db.scanw + n3 - 1;
                n11 = n3 - 1;
                while (n11 >= 0) {
                    n10 = (this.db.data[n12] >> n5) + this.levShift;
                    this.buf[n11] = (byte)((n10 < 0 ? 0 : (n10 > n8 ? n8 : n10)) >> n9);
                    --n11;
                    --n12;
                }
            }
            this.out.write(this.buf, 0, n3);
        }
    }

    @Override
    public void write() throws IOException {
        int n = this.src.getTileIdx();
        int n2 = this.src.getTileCompWidth(n, this.c);
        int n3 = this.src.getTileCompHeight(n, this.c);
        for (int i = 0; i < n3; i += 64) {
            this.write(0, i, n2, n3 - i < 64 ? n3 - i : 64);
        }
    }

    private void writeHeaderInfo() throws IOException {
        int n;
        this.out.writeByte(80);
        this.out.write(53);
        this.out.write(10);
        this.offset = 3;
        String string = String.valueOf(this.w);
        byte[] byArray = string.getBytes();
        for (n = 0; n < byArray.length; ++n) {
            this.out.writeByte(byArray[n]);
            ++this.offset;
        }
        this.out.write(32);
        ++this.offset;
        string = String.valueOf(this.h);
        byArray = string.getBytes();
        for (n = 0; n < byArray.length; ++n) {
            this.out.writeByte(byArray[n]);
            ++this.offset;
        }
        this.out.write(10);
        this.out.write(50);
        this.out.write(53);
        this.out.write(53);
        this.out.write(10);
        this.offset += 5;
    }

    public String toString() {
        return "ImgWriterPGM: WxH = " + this.w + "x" + this.h + ", Component=" + this.c + "\nUnderlying RandomAccessFile:\n" + this.out.toString();
    }
}

