/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image;

import jj2000.j2k.NoNextElementException;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.Coord;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.ImgDataAdapter;
import jj2000.j2k.util.FacilityManager;

public class Tiler
extends ImgDataAdapter
implements BlkImgDataSrc {
    private BlkImgDataSrc src = null;
    private int x0siz;
    private int y0siz;
    private int xt0siz;
    private int yt0siz;
    private int xtsiz;
    private int ytsiz;
    private int ntX;
    private int ntY;
    private int[] compW = null;
    private int[] compH = null;
    private int[] tcx0 = null;
    private int[] tcy0 = null;
    private int tx;
    private int ty;
    private int tileW;
    private int tileH;

    public Tiler(BlkImgDataSrc blkImgDataSrc, int n, int n2, int n3, int n4, int n5, int n6) {
        super(blkImgDataSrc);
        this.src = blkImgDataSrc;
        this.x0siz = n;
        this.y0siz = n2;
        this.xt0siz = n3;
        this.yt0siz = n4;
        this.xtsiz = n5;
        this.ytsiz = n6;
        if (blkImgDataSrc.getNumTiles() != 1) {
            throw new IllegalArgumentException("Source is tiled");
        }
        if (blkImgDataSrc.getImgULX() != 0 || blkImgDataSrc.getImgULY() != 0) {
            throw new IllegalArgumentException("Source is \"canvased\"");
        }
        if (this.x0siz < 0 || this.y0siz < 0 || this.xt0siz < 0 || this.yt0siz < 0 || this.xtsiz < 0 || this.ytsiz < 0 || this.xt0siz > this.x0siz || this.yt0siz > this.y0siz) {
            throw new IllegalArgumentException("Invalid image origin, tiling origin or nominal tile size");
        }
        if (this.xtsiz == 0) {
            this.xtsiz = this.x0siz + blkImgDataSrc.getImgWidth() - this.xt0siz;
        }
        if (this.ytsiz == 0) {
            this.ytsiz = this.y0siz + blkImgDataSrc.getImgHeight() - this.yt0siz;
        }
        if (this.x0siz - this.xt0siz >= this.xtsiz) {
            this.xt0siz += (this.x0siz - this.xt0siz) / this.xtsiz * this.xtsiz;
        }
        if (this.y0siz - this.yt0siz >= this.ytsiz) {
            this.yt0siz += (this.y0siz - this.yt0siz) / this.ytsiz * this.ytsiz;
        }
        if (this.x0siz - this.xt0siz >= this.xtsiz || this.y0siz - this.yt0siz >= this.ytsiz) {
            FacilityManager.getMsgLogger().printmsg(1, "Automatically adjusted tiling origin to equivalent one (" + this.xt0siz + "," + this.yt0siz + ") so that " + "first tile overlaps the image");
        }
        this.ntX = (int)Math.ceil((double)(this.x0siz + blkImgDataSrc.getImgWidth()) / (double)this.xtsiz);
        this.ntY = (int)Math.ceil((double)(this.y0siz + blkImgDataSrc.getImgHeight()) / (double)this.ytsiz);
    }

    @Override
    public final int getTileWidth() {
        return this.tileW;
    }

    @Override
    public final int getTileHeight() {
        return this.tileH;
    }

    @Override
    public final int getTileCompWidth(int n, int n2) {
        if (n != this.getTileIdx()) {
            throw new Error("Asking the width of a tile-component which is not in the current tile (call setTile() or nextTile() methods before).");
        }
        return this.compW[n2];
    }

    @Override
    public final int getTileCompHeight(int n, int n2) {
        if (n != this.getTileIdx()) {
            throw new Error("Asking the width of a tile-component which is not in the current tile (call setTile() or nextTile() methods before).");
        }
        return this.compH[n2];
    }

    @Override
    public int getFixedPoint(int n) {
        return this.src.getFixedPoint(n);
    }

    @Override
    public final DataBlk getInternCompData(DataBlk dataBlk, int n) {
        if (dataBlk.ulx < 0 || dataBlk.uly < 0 || dataBlk.w > this.compW[n] || dataBlk.h > this.compH[n]) {
            throw new IllegalArgumentException("Block is outside the tile");
        }
        int n2 = (int)Math.ceil((double)this.x0siz / (double)this.src.getCompSubsX(n));
        int n3 = (int)Math.ceil((double)this.y0siz / (double)this.src.getCompSubsY(n));
        dataBlk.ulx -= n2;
        dataBlk.uly -= n3;
        dataBlk = this.src.getInternCompData(dataBlk, n);
        dataBlk.ulx += n2;
        dataBlk.uly += n3;
        return dataBlk;
    }

    @Override
    public final DataBlk getCompData(DataBlk dataBlk, int n) {
        if (dataBlk.ulx < 0 || dataBlk.uly < 0 || dataBlk.w > this.compW[n] || dataBlk.h > this.compH[n]) {
            throw new IllegalArgumentException("Block is outside the tile");
        }
        int n2 = (int)Math.ceil((double)this.x0siz / (double)this.src.getCompSubsX(n));
        int n3 = (int)Math.ceil((double)this.y0siz / (double)this.src.getCompSubsY(n));
        dataBlk.ulx -= n2;
        dataBlk.uly -= n3;
        dataBlk = this.src.getCompData(dataBlk, n);
        dataBlk.ulx += n2;
        dataBlk.uly += n3;
        return dataBlk;
    }

    @Override
    public final void setTile(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.ntX || n2 >= this.ntY) {
            throw new IllegalArgumentException("Tile's indexes out of bounds");
        }
        this.tx = n;
        this.ty = n2;
        int n3 = n != 0 ? this.xt0siz + n * this.xtsiz : this.x0siz;
        int n4 = n2 != 0 ? this.yt0siz + n2 * this.ytsiz : this.y0siz;
        int n5 = n != this.ntX - 1 ? this.xt0siz + (n + 1) * this.xtsiz : this.x0siz + this.src.getImgWidth();
        int n6 = n2 != this.ntY - 1 ? this.yt0siz + (n2 + 1) * this.ytsiz : this.y0siz + this.src.getImgHeight();
        this.tileW = n5 - n3;
        this.tileH = n6 - n4;
        int n7 = this.src.getNumComps();
        if (this.compW == null) {
            this.compW = new int[n7];
        }
        if (this.compH == null) {
            this.compH = new int[n7];
        }
        if (this.tcx0 == null) {
            this.tcx0 = new int[n7];
        }
        if (this.tcy0 == null) {
            this.tcy0 = new int[n7];
        }
        for (int i = 0; i < n7; ++i) {
            this.tcx0[i] = (int)Math.ceil((double)n3 / (double)this.src.getCompSubsX(i));
            this.tcy0[i] = (int)Math.ceil((double)n4 / (double)this.src.getCompSubsY(i));
            this.compW[i] = (int)Math.ceil((double)n5 / (double)this.src.getCompSubsX(i)) - this.tcx0[i];
            this.compH[i] = (int)Math.ceil((double)n6 / (double)this.src.getCompSubsY(i)) - this.tcy0[i];
        }
    }

    @Override
    public final void nextTile() {
        if (this.tx == this.ntX - 1 && this.ty == this.ntY - 1) {
            throw new NoNextElementException();
        }
        if (this.tx < this.ntX - 1) {
            this.setTile(this.tx + 1, this.ty);
        } else {
            this.setTile(0, this.ty + 1);
        }
    }

    @Override
    public final Coord getTile(Coord coord) {
        if (coord != null) {
            coord.x = this.tx;
            coord.y = this.ty;
            return coord;
        }
        return new Coord(this.tx, this.ty);
    }

    @Override
    public final int getTileIdx() {
        return this.ty * this.ntX + this.tx;
    }

    @Override
    public final int getCompULX(int n) {
        return this.tcx0[n];
    }

    @Override
    public final int getCompULY(int n) {
        return this.tcy0[n];
    }

    @Override
    public int getTilePartULX() {
        return this.xt0siz;
    }

    @Override
    public int getTilePartULY() {
        return this.yt0siz;
    }

    @Override
    public final int getImgULX() {
        return this.x0siz;
    }

    @Override
    public final int getImgULY() {
        return this.y0siz;
    }

    @Override
    public final Coord getNumTiles(Coord coord) {
        if (coord != null) {
            coord.x = this.ntX;
            coord.y = this.ntY;
            return coord;
        }
        return new Coord(this.ntX, this.ntY);
    }

    @Override
    public final int getNumTiles() {
        return this.ntX * this.ntY;
    }

    @Override
    public final int getNomTileWidth() {
        return this.xtsiz;
    }

    @Override
    public final int getNomTileHeight() {
        return this.ytsiz;
    }

    public final Coord getTilingOrigin(Coord coord) {
        if (coord != null) {
            coord.x = this.xt0siz;
            coord.y = this.yt0siz;
            return coord;
        }
        return new Coord(this.xt0siz, this.yt0siz);
    }

    public String toString() {
        return "Tiler: source= " + this.src + "\n" + this.getNumTiles() + " tile(s), nominal width=" + this.xtsiz + ", nominal height=" + this.ytsiz;
    }
}

