/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.encoder;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import jj2000.j2k.encoder.Encoder;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.util.StringFormatException;

public class CmdLnEncoder {
    private ParameterList pl;
    private ParameterList defpl = new ParameterList();
    private Encoder enc;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            FacilityManager.getMsgLogger().println("CmdLnEncoder: JJ2000's JPEG 2000 Encoder\n    use jj2000.j2k.encoder.CmdLnEncoder -u to get help\n", 0, 0);
            System.exit(1);
        }
        new CmdLnEncoder(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmdLnEncoder(String[] stringArray) {
        String[][] stringArray2 = Encoder.getAllParameters();
        for (int i = stringArray2.length - 1; i >= 0; --i) {
            if (stringArray2[i][3] == null) continue;
            this.defpl.put(stringArray2[i][0], stringArray2[i][3]);
        }
        this.pl = new ParameterList(this.defpl);
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("No arguments!");
        }
        try {
            this.pl.parseArgs(stringArray);
        }
        catch (StringFormatException stringFormatException) {
            System.err.println("An error occured while parsing the arguments:\n" + stringFormatException.getMessage());
            return;
        }
        if (this.pl.getParameter("pfile") != null) {
            InputStream inputStream;
            ParameterList parameterList = new ParameterList();
            try {
                inputStream = new FileInputStream(this.pl.getParameter("pfile"));
                inputStream = new BufferedInputStream(inputStream);
                parameterList.load(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Could not load the argument file " + this.pl.getParameter("pfile"));
                return;
            }
            catch (IOException iOException) {
                System.err.println("An error ocurred while reading from the argument file " + this.pl.getParameter("pfile"));
                return;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("[WARNING] Could not close the argument file after reading");
            }
            Enumeration<Object> enumeration = parameterList.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (this.pl.get(string) != null) continue;
                this.pl.put(string, parameterList.get(string));
            }
        }
        try {
            this.pl.checkList(Encoder.vprfxs, ParameterList.toNameArray(stringArray2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            return;
        }
        this.enc = new Encoder(this.pl);
        if (this.enc.getExitCode() != 0) {
            System.exit(this.enc.getExitCode());
        }
        try {
            this.enc.run();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (this.enc.getExitCode() != 0) {
                System.exit(this.enc.getExitCode());
            }
        }
    }
}

