/*
 * Decompiled with CFR 0.152.
 */
package icc.tags;

import icc.ICCProfile;
import icc.tags.ICCTag;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ICCXYZType
extends ICCTag {
    public final long x;
    public final long y;
    public final long z;

    public static long DoubleToXYZ(double d) {
        return (long)Math.floor(d * 65536.0 + 0.5);
    }

    public static double XYZToDouble(long l) {
        return (double)l / 65536.0;
    }

    protected ICCXYZType(int n, byte[] byArray, int n2, int n3) {
        super(n, byArray, n2, n3);
        this.x = ICCProfile.getInt(byArray, n2 + 8);
        this.y = ICCProfile.getInt(byArray, n2 + 12);
        this.z = ICCProfile.getInt(byArray, n2 + 16);
    }

    @Override
    public String toString() {
        return "[" + super.toString() + "(" + this.x + ", " + this.y + ", " + this.z + ")]";
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = ICCProfile.setLong(this.x);
        byte[] byArray2 = ICCProfile.setLong(this.y);
        byte[] byArray3 = ICCProfile.setLong(this.z);
        randomAccessFile.write(byArray, 4, 0);
        randomAccessFile.write(byArray2, 4, 0);
        randomAccessFile.write(byArray3, 4, 0);
    }
}

