/*
 * Decompiled with CFR 0.152.
 */
package icc.lut;

import colorspace.ColorSpace;
import icc.RestrictedICCProfile;
import icc.lut.LookUpTable32LinearSRGBtoSRGB;
import icc.lut.LookUpTableFP;
import icc.lut.MatrixBasedTransformException;
import icc.tags.ICCXYZType;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;

public class MatrixBasedTransformTosRGB {
    private static final String eol = System.getProperty("line.separator");
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final double SRGB00 = 3.1337;
    private static final double SRGB01 = -1.6173;
    private static final double SRGB02 = -0.4907;
    private static final double SRGB10 = -0.9785;
    private static final double SRGB11 = 1.9162;
    private static final double SRGB12 = 0.0334;
    private static final double SRGB20 = 0.072;
    private static final double SRGB21 = -0.229;
    private static final double SRGB22 = 1.4056;
    private static final int M00 = 0;
    private static final int M01 = 1;
    private static final int M02 = 2;
    private static final int M10 = 3;
    private static final int M11 = 4;
    private static final int M12 = 5;
    private static final int M20 = 6;
    private static final int M21 = 7;
    private static final int M22 = 8;
    private static final double ksRGBExponent = 0.4166666666666667;
    private static final double ksRGBScaleAfterExp = 1.055;
    private static final double ksRGBReduceAfterExp = 0.055;
    private static final double ksRGBShadowCutoff = 0.0031308;
    private static final double ksRGBShadowSlope = 12.92;
    private final double[] matrix;
    private LookUpTableFP[] fLut = new LookUpTableFP[3];
    private LookUpTable32LinearSRGBtoSRGB lut;
    private final int[] dwMaxValue;
    private final int[] dwShiftValue;
    private int dwMaxCols = 0;
    private int dwMaxRows = 0;
    private float[][] fBuf = null;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[MatrixBasedTransformTosRGB: ");
        StringBuffer stringBuffer2 = new StringBuffer("  ");
        stringBuffer2.append(eol).append("ksRGBExponent= ").append(String.valueOf(0.4166666666666667));
        stringBuffer2.append(eol).append("ksRGBScaleAfterExp= ").append(String.valueOf(1.055));
        stringBuffer2.append(eol).append("ksRGBReduceAfterExp= ").append(String.valueOf(0.055));
        stringBuffer2.append(eol).append("dwMaxValues= ").append(String.valueOf(this.dwMaxValue[0])).append(", ").append(String.valueOf(this.dwMaxValue[1])).append(", ").append(String.valueOf(this.dwMaxValue[2]));
        stringBuffer2.append(eol).append("dwShiftValues= ").append(String.valueOf(this.dwShiftValue[0])).append(", ").append(String.valueOf(this.dwShiftValue[1])).append(", ").append(String.valueOf(this.dwShiftValue[2]));
        stringBuffer2.append(eol).append(eol).append("fLut= ").append(eol).append(ColorSpace.indent("  ", "fLut[RED]=  " + this.fLut[0].toString())).append(eol).append(ColorSpace.indent("  ", "fLut[GRN]=  " + this.fLut[1].toString())).append(eol).append(ColorSpace.indent("  ", "fLut[BLU]=  " + this.fLut[2].toString()));
        stringBuffer2.append(eol).append(eol).append("[matrix ");
        for (int i = 0; i < 3; ++i) {
            stringBuffer2.append(eol).append("  ");
            for (int j = 0; j < 3; ++j) {
                stringBuffer2.append(this.matrix[3 * i + j] + "   ");
            }
        }
        stringBuffer2.append("]");
        stringBuffer2.append(eol).append(eol).append(this.lut.toString());
        stringBuffer.append(ColorSpace.indent("  ", stringBuffer2)).append("]");
        return stringBuffer.append("]").toString();
    }

    public MatrixBasedTransformTosRGB(RestrictedICCProfile restrictedICCProfile, int[] nArray, int[] nArray2) {
        if (restrictedICCProfile.getType() != 1) {
            throw new IllegalArgumentException("MatrixBasedTransformTosRGB: wrong type ICCProfile supplied");
        }
        this.dwMaxValue = nArray;
        this.dwShiftValue = nArray2;
        for (int i = 0; i < 3; ++i) {
            this.fLut[i] = LookUpTableFP.createInstance(restrictedICCProfile.trc[i], nArray[i] + 1);
        }
        this.matrix = this.createMatrix(restrictedICCProfile, nArray);
        this.lut = LookUpTable32LinearSRGBtoSRGB.createInstance(nArray[0], nArray[0], 0.0031308, 12.92, 1.055, 0.4166666666666667, 0.055);
    }

    private double[] createMatrix(RestrictedICCProfile restrictedICCProfile, int[] nArray) {
        double d = ICCXYZType.XYZToDouble(restrictedICCProfile.colorant[0].x);
        double d2 = ICCXYZType.XYZToDouble(restrictedICCProfile.colorant[1].x);
        double d3 = ICCXYZType.XYZToDouble(restrictedICCProfile.colorant[2].x);
        double d4 = ICCXYZType.XYZToDouble(restrictedICCProfile.colorant[0].y);
        double d5 = ICCXYZType.XYZToDouble(restrictedICCProfile.colorant[1].y);
        double d6 = ICCXYZType.XYZToDouble(restrictedICCProfile.colorant[2].y);
        double d7 = ICCXYZType.XYZToDouble(restrictedICCProfile.colorant[0].z);
        double d8 = ICCXYZType.XYZToDouble(restrictedICCProfile.colorant[1].z);
        double d9 = ICCXYZType.XYZToDouble(restrictedICCProfile.colorant[2].z);
        double[] dArray = new double[]{(double)nArray[0] * (3.1337 * d + -1.6173 * d4 + -0.4907 * d7), (double)nArray[0] * (3.1337 * d2 + -1.6173 * d5 + -0.4907 * d8), (double)nArray[0] * (3.1337 * d3 + -1.6173 * d6 + -0.4907 * d9), (double)nArray[1] * (-0.9785 * d + 1.9162 * d4 + 0.0334 * d7), (double)nArray[1] * (-0.9785 * d2 + 1.9162 * d5 + 0.0334 * d8), (double)nArray[1] * (-0.9785 * d3 + 1.9162 * d6 + 0.0334 * d9), (double)nArray[2] * (0.072 * d + -0.229 * d4 + 1.4056 * d7), (double)nArray[2] * (0.072 * d2 + -0.229 * d5 + 1.4056 * d8), (double)nArray[2] * (0.072 * d3 + -0.229 * d6 + 1.4056 * d9)};
        return dArray;
    }

    public void apply(DataBlkInt[] dataBlkIntArray, DataBlkInt[] dataBlkIntArray2) throws MatrixBasedTransformException {
        int[][] nArrayArray = new int[3][];
        int[][] nArrayArray2 = new int[3][];
        int n = dataBlkIntArray[0].h;
        int n2 = dataBlkIntArray[0].w;
        if (this.fBuf == null || this.fBuf[0].length < n2 * n) {
            this.fBuf = new float[3][n2 * n];
        }
        for (int i = 0; i < 3; ++i) {
            nArrayArray[i] = (int[])dataBlkIntArray[i].getData();
            nArrayArray2[i] = (int[])dataBlkIntArray2[i].getData();
            if (nArrayArray2[i] == null || nArrayArray2[i].length < nArrayArray[i].length) {
                nArrayArray2[i] = new int[nArrayArray[i].length];
                dataBlkIntArray2[i].setData(nArrayArray2[i]);
            }
            MatrixBasedTransformTosRGB.standardizeMatrixLineThroughLut(dataBlkIntArray[i], this.fBuf[i], this.dwMaxValue[i], this.fLut[i]);
        }
        float[] fArray = this.fBuf[0];
        float[] fArray2 = this.fBuf[1];
        float[] fArray3 = this.fBuf[2];
        int[] nArray = nArrayArray2[0];
        int[] nArray2 = nArrayArray2[1];
        int[] nArray3 = nArrayArray2[2];
        int[] nArray4 = this.lut.lut;
        int n3 = 0;
        for (int i = 0; i < dataBlkIntArray[0].h; ++i) {
            int n4 = n3 + dataBlkIntArray[0].w;
            while (n3 < n4) {
                double d = fArray[n3];
                double d2 = fArray2[n3];
                double d3 = fArray3[n3];
                int n5 = (int)(this.matrix[0] * d + this.matrix[1] * d2 + this.matrix[2] * d3 + 0.5);
                nArray[n3] = n5 < 0 ? nArray4[0] : (n5 >= nArray4.length ? nArray4[nArray4.length - 1] : nArray4[n5]);
                n5 = (int)(this.matrix[3] * d + this.matrix[4] * d2 + this.matrix[5] * d3 + 0.5);
                nArray2[n3] = n5 < 0 ? nArray4[0] : (n5 >= nArray4.length ? nArray4[nArray4.length - 1] : nArray4[n5]);
                n5 = (int)(this.matrix[6] * d + this.matrix[7] * d2 + this.matrix[8] * d3 + 0.5);
                nArray3[n3] = n5 < 0 ? nArray4[0] : (n5 >= nArray4.length ? nArray4[nArray4.length - 1] : nArray4[n5]);
                ++n3;
            }
        }
    }

    public void apply(DataBlkFloat[] dataBlkFloatArray, DataBlkFloat[] dataBlkFloatArray2) throws MatrixBasedTransformException {
        float[][] fArrayArray = new float[3][];
        float[][] fArrayArray2 = new float[3][];
        int n = dataBlkFloatArray[0].h;
        int n2 = dataBlkFloatArray[0].w;
        if (this.fBuf == null || this.fBuf[0].length < n2 * n) {
            this.fBuf = new float[3][n2 * n];
        }
        for (int i = 0; i < 3; ++i) {
            fArrayArray[i] = (float[])dataBlkFloatArray[i].getData();
            fArrayArray2[i] = (float[])dataBlkFloatArray2[i].getData();
            if (fArrayArray2[i] == null || fArrayArray2[i].length < fArrayArray[i].length) {
                fArrayArray2[i] = new float[fArrayArray[i].length];
                dataBlkFloatArray2[i].setData(fArrayArray2[i]);
            }
            MatrixBasedTransformTosRGB.standardizeMatrixLineThroughLut(dataBlkFloatArray[i], this.fBuf[i], (float)this.dwMaxValue[i], this.fLut[i]);
        }
        int[] nArray = this.lut.lut;
        int n3 = 0;
        for (int i = 0; i < dataBlkFloatArray[0].h; ++i) {
            int n4 = n3 + dataBlkFloatArray[0].w;
            while (n3 < n4) {
                int n5 = (int)(this.matrix[0] * (double)this.fBuf[0][n3] + this.matrix[1] * (double)this.fBuf[1][n3] + this.matrix[2] * (double)this.fBuf[2][n3] + 0.5);
                fArrayArray2[0][n3] = n5 < 0 ? (float)nArray[0] : (n5 >= nArray.length ? (float)nArray[nArray.length - 1] : (float)nArray[n5]);
                n5 = (int)(this.matrix[3] * (double)this.fBuf[0][n3] + this.matrix[4] * (double)this.fBuf[1][n3] + this.matrix[5] * (double)this.fBuf[2][n3] + 0.5);
                fArrayArray2[1][n3] = n5 < 0 ? (float)nArray[0] : (n5 >= nArray.length ? (float)nArray[nArray.length - 1] : (float)nArray[n5]);
                n5 = (int)(this.matrix[6] * (double)this.fBuf[0][n3] + this.matrix[7] * (double)this.fBuf[1][n3] + this.matrix[8] * (double)this.fBuf[2][n3] + 0.5);
                fArrayArray2[2][n3] = n5 < 0 ? (float)nArray[0] : (n5 >= nArray.length ? (float)nArray[nArray.length - 1] : (float)nArray[n5]);
                ++n3;
            }
        }
    }

    private static void standardizeMatrixLineThroughLut(DataBlkInt dataBlkInt, float[] fArray, int n, LookUpTableFP lookUpTableFP) {
        int n2 = 0;
        int[] nArray = (int[])dataBlkInt.getData();
        float[] fArray2 = lookUpTableFP.lut;
        for (int i = dataBlkInt.uly; i < dataBlkInt.uly + dataBlkInt.h; ++i) {
            for (int j = dataBlkInt.ulx; j < dataBlkInt.ulx + dataBlkInt.w; ++j) {
                int n3 = dataBlkInt.offset + (i - dataBlkInt.uly) * dataBlkInt.scanw + (j - dataBlkInt.ulx);
                int n4 = nArray[n3] > n ? n : (nArray[n3] < 0 ? 0 : nArray[n3]);
                fArray[n2++] = fArray2[n4];
            }
        }
    }

    private static void standardizeMatrixLineThroughLut(DataBlkFloat dataBlkFloat, float[] fArray, float f, LookUpTableFP lookUpTableFP) {
        int n = 0;
        float[] fArray2 = (float[])dataBlkFloat.getData();
        float[] fArray3 = lookUpTableFP.lut;
        for (int i = dataBlkFloat.uly; i < dataBlkFloat.uly + dataBlkFloat.h; ++i) {
            for (int j = dataBlkFloat.ulx; j < dataBlkFloat.ulx + dataBlkFloat.w; ++j) {
                int n2 = dataBlkFloat.offset + (i - dataBlkFloat.uly) * dataBlkFloat.scanw + (j - dataBlkFloat.ulx);
                float f2 = fArray2[n2] > f ? f : (fArray2[n2] < 0.0f ? 0.0f : fArray2[n2]);
                fArray[n++] = fArray3[(int)f2];
            }
        }
    }
}

