/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.stats;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.BitUtilities;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.LabelManager;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.VolumeROI;
import edu.uthscsa.ric.volume.operations.Operation;
import edu.uthscsa.ric.volume.operations.OperationListener;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class VolumeStatROIOp
implements Operation<Map<Long, Analysis>> {
    private int seriesPoint;
    private final Volume volume;
    private final VolumeManager volumeManager;
    private final LabelManager labelManager;
    private final VolumeROI roi;
    private final long selectedROIs;

    public VolumeStatROIOp(VolumeManager volumeManager, Volume volume, VolumeROI roi, long selectedROIs, LabelManager labelManager) {
        this.volumeManager = volumeManager;
        this.volume = volume;
        this.roi = roi;
        this.selectedROIs = selectedROIs;
        this.labelManager = labelManager;
        this.setSeriesPoint(-1);
    }

    @Override
    public Map<Long, Analysis> process(ImageBounds bounds) {
        int xMin = bounds.getMinX();
        int xMax = bounds.getMaxX();
        int yMin = bounds.getMinY();
        int yMax = bounds.getMaxY();
        int zMin = bounds.getMinZ();
        int zMax = bounds.getMaxZ();
        int currentTimepoint = bounds.getMinT();
        VolumeData volData = new VolumeData(this.volumeManager, this.volume);
        boolean dynamicROI = this.roi.getSeriesLength() > 1;
        int xDimROI = this.volumeManager.getBaseVolume().getXDim() + 1;
        int yDimROI = this.volumeManager.getBaseVolume().getYDim() + 1;
        HashMap<Long, Analysis> map = new HashMap<Long, Analysis>();
        for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
            int offsetROIZ = xDimROI * yDimROI * ctrZ;
            for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                int offsetROIY = xDimROI * ctrY;
                for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                    long roiIndex = dynamicROI ? this.roi.get(ctrX + offsetROIY + offsetROIZ, currentTimepoint) : this.roi.getCurrent(ctrX + offsetROIY + offsetROIZ);
                    if ((roiIndex & this.selectedROIs) == 0L) continue;
                    roiIndex &= this.selectedROIs;
                    double current = volData.getValue(ctrX, ctrY, ctrZ, currentTimepoint);
                    long bit = 0L;
                    while ((bit = Long.lowestOneBit(roiIndex)) != 0L) {
                        AnalysisImpl stat = (AnalysisImpl)map.get(bit);
                        if (stat == null) {
                            stat = new AnalysisImpl();
                            stat.roiIndex = BitUtilities.findHighestOneBitIndex((long)bit);
                            stat.centroidCoordinate = new Coordinate4D(0.0, 0.0, 0.0, 0);
                            stat.maxCoordinate = new Coordinate4D(0.0, 0.0, 0.0, 0);
                            stat.minCoordinate = new Coordinate4D(0.0, 0.0, 0.0, 0);
                            stat.maxCoordinate.seriesPoint = currentTimepoint;
                            stat.minCoordinate.seriesPoint = currentTimepoint;
                            map.put(bit, stat);
                            stat.max = stat.min = current;
                            stat.maxCoordinate.xInt = stat.minCoordinate.xInt = ctrX;
                            stat.maxCoordinate.yInt = stat.minCoordinate.yInt = ctrY;
                            stat.maxCoordinate.zInt = stat.minCoordinate.zInt = ctrZ;
                        }
                        if (stat.max < current) {
                            stat.max = current;
                            stat.maxCoordinate.xInt = ctrX;
                            stat.maxCoordinate.yInt = ctrY;
                            stat.maxCoordinate.zInt = ctrZ;
                        } else if (stat.min > current) {
                            stat.min = current;
                            stat.minCoordinate.xInt = ctrX;
                            stat.minCoordinate.yInt = ctrY;
                            stat.minCoordinate.zInt = ctrZ;
                        }
                        double currentABS = Math.abs(current);
                        stat.weightedSumX += currentABS * (double)ctrX;
                        stat.weightedSumY += currentABS * (double)ctrY;
                        stat.weightedSumZ += currentABS * (double)ctrZ;
                        stat.sum += current;
                        stat.comSum += currentABS;
                        stat.sumSquared += MathUtilities.pow((double)current, (double)2.0);
                        ++stat.count;
                        roiIndex &= bit ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                }
            }
        }
        for (Analysis stat : map.values()) {
            AnalysisImpl statImpl = (AnalysisImpl)stat;
            statImpl.mean = statImpl.sum / (double)statImpl.count;
            statImpl.stdev = Math.sqrt(((double)statImpl.count * statImpl.sumSquared - MathUtilities.pow((double)statImpl.sum, (double)2.0)) / ((double)statImpl.count * ((double)statImpl.count - 1.0)));
            statImpl.centroidCoordinate.setValues(statImpl.weightedSumX / statImpl.comSum, statImpl.weightedSumY / statImpl.comSum, statImpl.weightedSumZ / statImpl.comSum, currentTimepoint);
            statImpl.centroid = volData.getValue(statImpl.centroidCoordinate.xInt, statImpl.centroidCoordinate.yInt, statImpl.centroidCoordinate.zInt, currentTimepoint);
        }
        return map;
    }

    @Override
    public Map<Long, Analysis> accumulate(List<Map<Long, Analysis>> results) {
        VolumeData volData = new VolumeData(this.volumeManager);
        TreeMap<Long, Analysis> map = new TreeMap<Long, Analysis>();
        for (Map<Long, Analysis> map2 : results) {
            for (Map.Entry<Long, Analysis> resultStatEntry : map2.entrySet()) {
                AnalysisImpl mappedStat = (AnalysisImpl)map.get(resultStatEntry.getKey());
                AnalysisImpl resultStat = (AnalysisImpl)resultStatEntry.getValue();
                if (mappedStat == null) {
                    mappedStat = new AnalysisImpl();
                    mappedStat.roiIndex = resultStat.roiIndex;
                    mappedStat.centroidCoordinate = new Coordinate4D(0.0, 0.0, 0.0, 0);
                    mappedStat.maxCoordinate = new Coordinate4D(0.0, 0.0, 0.0, 0);
                    mappedStat.minCoordinate = new Coordinate4D(0.0, 0.0, 0.0, 0);
                    map.put(resultStatEntry.getKey(), mappedStat);
                    mappedStat.max = resultStat.max;
                    mappedStat.maxCoordinate.xInt = resultStat.getMaxCoordinate().xInt;
                    mappedStat.maxCoordinate.yInt = resultStat.getMaxCoordinate().yInt;
                    mappedStat.maxCoordinate.zInt = resultStat.getMaxCoordinate().zInt;
                    mappedStat.maxCoordinate.seriesPoint = resultStat.getMaxCoordinate().seriesPoint;
                    mappedStat.min = resultStat.min;
                    mappedStat.minCoordinate.xInt = resultStat.getMinCoordinate().xInt;
                    mappedStat.minCoordinate.yInt = resultStat.getMinCoordinate().yInt;
                    mappedStat.minCoordinate.zInt = resultStat.getMinCoordinate().zInt;
                    mappedStat.minCoordinate.seriesPoint = resultStat.getMinCoordinate().seriesPoint;
                } else {
                    if (mappedStat.max < resultStat.getMaxValue() || mappedStat.max == resultStat.getMaxValue() && this.distanceFromCorner((Coordinate)resultStat.getMaxCoordinate()) < this.distanceFromCorner((Coordinate)mappedStat.maxCoordinate)) {
                        mappedStat.max = resultStat.getMaxValue();
                        mappedStat.maxCoordinate.xInt = resultStat.getMaxCoordinate().xInt;
                        mappedStat.maxCoordinate.yInt = resultStat.getMaxCoordinate().yInt;
                        mappedStat.maxCoordinate.zInt = resultStat.getMaxCoordinate().zInt;
                        mappedStat.maxCoordinate.seriesPoint = resultStat.getMaxCoordinate().seriesPoint;
                    }
                    if (mappedStat.min > resultStat.getMinValue() || mappedStat.min == resultStat.getMinValue() && this.distanceFromCorner((Coordinate)resultStat.getMinCoordinate()) < this.distanceFromCorner((Coordinate)mappedStat.minCoordinate)) {
                        mappedStat.min = resultStat.getMinValue();
                        mappedStat.minCoordinate.xInt = resultStat.getMinCoordinate().xInt;
                        mappedStat.minCoordinate.yInt = resultStat.getMinCoordinate().yInt;
                        mappedStat.minCoordinate.zInt = resultStat.getMinCoordinate().zInt;
                        mappedStat.minCoordinate.seriesPoint = resultStat.getMinCoordinate().seriesPoint;
                    }
                }
                mappedStat.weightedSumX += resultStat.getWeightedSumX();
                mappedStat.weightedSumY += resultStat.getWeightedSumY();
                mappedStat.weightedSumZ += resultStat.getWeightedSumZ();
                mappedStat.sum += resultStat.getSum();
                mappedStat.comSum += resultStat.getComSum();
                mappedStat.sumSquared += resultStat.getSumSquared();
                mappedStat.count += resultStat.getCount();
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            AnalysisImpl stat = (AnalysisImpl)entry.getValue();
            stat.mean = stat.sum / (double)stat.count;
            stat.stdev = Math.sqrt(((double)stat.count * stat.sumSquared - MathUtilities.pow((double)stat.sum, (double)2.0)) / ((double)stat.count * ((double)stat.count - 1.0)));
            stat.centroidCoordinate.setValues(stat.weightedSumX / stat.comSum, stat.weightedSumY / stat.comSum, stat.weightedSumZ / stat.comSum, stat.maxCoordinate.seriesPoint);
            stat.centroid = volData.getValue(stat.centroidCoordinate.xInt, stat.centroidCoordinate.yInt, stat.centroidCoordinate.zInt, stat.centroidCoordinate.seriesPoint);
            stat.setMaxCoordinate(stat.maxCoordinate);
            stat.setMinCoordinate(stat.minCoordinate);
            stat.setCentroidCoordinate(stat.centroidCoordinate);
            stat.setType(3);
            stat.setUnitSize(this.volumeManager.getBaseVolume().getXSize() * this.volumeManager.getBaseVolume().getYSize() * this.volumeManager.getBaseVolume().getZSize());
            stat.setDescription("Volume");
            stat.setDescription(this.labelManager.getLabel(stat.getROI(), "ROI " + stat.getDescription()));
            stat.setName(this.volumeManager.getName((ImageVolume)this.volume));
        }
        return map;
    }

    private double distanceFromCorner(Coordinate coor) {
        double disX = 0 - coor.xInt;
        double disY = 0 - coor.yInt;
        double disZ = 0 - coor.zInt;
        return Math.sqrt(disX * disX + disY * disY + disZ * disZ);
    }

    @Override
    public ImageBounds getSectionBounds(int index) {
        ImageVolume volumeBase = this.volumeManager.getBaseVolume();
        int xDim = volumeBase.getXDim();
        int yDim = volumeBase.getYDim();
        int zDim = volumeBase.getZDim();
        ImageBounds bounds = null;
        if (index == 0) {
            bounds = new ImageBounds(0, xDim / 2 - 1, 0, yDim / 2 - 1, 0, zDim / 2 - 1);
        } else if (index == 1) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, 0, yDim / 2 - 1, 0, zDim / 2 - 1);
        } else if (index == 2) {
            bounds = new ImageBounds(0, xDim / 2 - 1, yDim / 2, yDim - 1, 0, zDim / 2 - 1);
        } else if (index == 3) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, yDim / 2, yDim - 1, 0, zDim / 2 - 1);
        } else if (index == 4) {
            bounds = new ImageBounds(0, xDim / 2 - 1, 0, yDim / 2 - 1, zDim / 2, zDim - 1);
        } else if (index == 5) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, 0, yDim / 2 - 1, zDim / 2, zDim - 1);
        } else if (index == 6) {
            bounds = new ImageBounds(0, xDim / 2 - 1, yDim / 2, yDim - 1, zDim / 2, zDim - 1);
        } else if (index == 7) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, yDim / 2, yDim - 1, zDim / 2, zDim - 1);
        }
        if (bounds != null) {
            if (this.seriesPoint != -1) {
                bounds.setRangeT(this.seriesPoint, this.seriesPoint);
            } else {
                bounds.setRangeT(volumeBase.getCurrentSeriesPoint(), volumeBase.getCurrentSeriesPoint());
            }
        }
        return bounds;
    }

    public void calculateAllVolumesStatsAsync(final OperationListener listener) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                VolumeStatROIOp.this.calculateAllVolumesStatsSync(listener);
            }
        }, "VolumeStatOp.calculateAllVolumesStatsAsync() Thread");
        workThread.start();
    }

    public List<Analysis> calculateAllVolumesStatsSync(OperationListener listener) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        ProgressMeter pb = this.volumeManager.makeProgressMeter();
        pb.setDescription("Calculating Volume Stats");
        int xDim = this.volumeManager.getBaseVolume().getXDim();
        int yDim = this.volumeManager.getBaseVolume().getYDim();
        int zDim = this.volumeManager.getBaseVolume().getZDim();
        int tDim = this.volumeManager.getCurrentVolume().getSeriesLength();
        pb.start(0, 0, tDim);
        for (int ctr = 0; ctr < tDim; ++ctr) {
            ImageBounds bounds = new ImageBounds(0, xDim - 1, 0, yDim - 1, 0, zDim - 1);
            bounds.setRangeT(ctr, ctr);
            Object analysisMap = this.process(bounds);
            for (Analysis stat : analysisMap.values()) {
                AnalysisImpl analysis = (AnalysisImpl)stat;
                analysis.setMaxCoordinate(analysis.maxCoordinate);
                analysis.setMinCoordinate(analysis.minCoordinate);
                analysis.setCentroidCoordinate(analysis.centroidCoordinate);
                analysis.setType(3);
                analysis.setDescription("Volume");
                analysis.setDescription(this.labelManager.getLabel(analysis.getROI(), "ROI " + analysis.getDescription()));
                analysis.setName(this.volumeManager.getName((ImageVolume)this.volume));
                analysis.setUnitSize(this.volumeManager.getBaseVolume().getXSize() * this.volumeManager.getBaseVolume().getYSize() * this.volumeManager.getBaseVolume().getZSize());
                stats.add(analysis);
            }
            if (listener != null) {
                listener.operationFinished(analysisMap, this.volume);
                Thread.yield();
            }
            pb.setValue(ctr);
        }
        pb.setValue(pb.getMax());
        return stats;
    }

    public int getSeriesPoint() {
        return this.seriesPoint;
    }

    public void setSeriesPoint(int seriesPoint) {
        this.seriesPoint = seriesPoint;
    }

    @Override
    public boolean testProcessValidity() {
        return true;
    }
}

