/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.stats;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.operations.Operation;
import edu.uthscsa.ric.volume.operations.OperationListener;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.util.ArrayList;
import java.util.List;

public class VolumeStatOp
implements Operation<Analysis> {
    private final VolumeManager volumeManager;
    private final Volume volume;

    public VolumeStatOp(VolumeManager volumeManager, Volume volume) {
        this.volumeManager = volumeManager;
        this.volume = volume;
    }

    @Override
    public Analysis process(ImageBounds bounds) {
        int xMin = bounds.getMinX();
        int xMax = bounds.getMaxX();
        int yMin = bounds.getMinY();
        int yMax = bounds.getMaxY();
        int zMin = bounds.getMinZ();
        int zMax = bounds.getMaxZ();
        int currentTimepoint = bounds.getMinT();
        VolumeData volData = new VolumeData(this.volumeManager, this.volume);
        Coordinate4D centerOfMass = new Coordinate4D(0.0, 0.0, 0.0, 0);
        Coordinate4D maxVoxel = new Coordinate4D(0.0, 0.0, 0.0, 0);
        Coordinate4D minVoxel = new Coordinate4D(0.0, 0.0, 0.0, 0);
        double max = 0.0;
        double min = 0.0;
        double com = 0.0;
        double mean = 0.0;
        double size = 0.0;
        double sum = 0.0;
        double stdev = 0.0;
        double sumSquared = 0.0;
        double weightedSumX = 0.0;
        double weightedSumY = 0.0;
        double weightedSumZ = 0.0;
        boolean notInitialized = true;
        double comSum = 0.0;
        for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
            for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                    double current = volData.getValue(ctrX, ctrY, ctrZ, currentTimepoint);
                    if (notInitialized) {
                        notInitialized = false;
                        max = min = current;
                        maxVoxel.xInt = minVoxel.xInt = ctrX;
                        maxVoxel.yInt = minVoxel.yInt = ctrY;
                        maxVoxel.zInt = minVoxel.zInt = ctrZ;
                    }
                    if (max < current) {
                        max = current;
                        maxVoxel.xInt = ctrX;
                        maxVoxel.yInt = ctrY;
                        maxVoxel.zInt = ctrZ;
                    } else if (min > current) {
                        min = current;
                        minVoxel.xInt = ctrX;
                        minVoxel.yInt = ctrY;
                        minVoxel.zInt = ctrZ;
                    }
                    double currentABS = Math.abs(current);
                    weightedSumX += currentABS * (double)ctrX;
                    weightedSumY += currentABS * (double)ctrY;
                    weightedSumZ += currentABS * (double)ctrZ;
                    sum += current;
                    comSum += currentABS;
                    sumSquared += MathUtilities.pow((double)current, (double)2.0);
                    size += 1.0;
                }
            }
        }
        maxVoxel.seriesPoint = currentTimepoint;
        minVoxel.seriesPoint = currentTimepoint;
        mean = sum / size;
        stdev = Math.sqrt((size * sumSquared - MathUtilities.pow((double)sum, (double)2.0)) / (size * (size - 1.0)));
        centerOfMass.setValues(weightedSumX / comSum, weightedSumY / comSum, weightedSumZ / comSum, currentTimepoint);
        com = volData.getValue(centerOfMass.xInt, centerOfMass.yInt, centerOfMass.zInt, currentTimepoint);
        AnalysisImpl analysis = new AnalysisImpl(mean, min, max, sum, stdev, (int)size);
        analysis.setMaxCoordinate(maxVoxel);
        analysis.setMinCoordinate(minVoxel);
        analysis.setCentroid(com);
        analysis.setCentroidCoordinate(centerOfMass);
        analysis.setSumSquared(sumSquared);
        analysis.setWeightedSumX(weightedSumX);
        analysis.setWeightedSumY(weightedSumY);
        analysis.setWeightedSumZ(weightedSumZ);
        analysis.setComSum(comSum);
        return analysis;
    }

    @Override
    public Analysis accumulate(List<Analysis> results) {
        VolumeData volData = new VolumeData(this.volumeManager);
        Coordinate4D centerOfMass = new Coordinate4D(0.0, 0.0, 0.0, 0);
        Coordinate4D maxVoxel = new Coordinate4D(0.0, 0.0, 0.0, 0);
        Coordinate4D minVoxel = new Coordinate4D(0.0, 0.0, 0.0, 0);
        double max = 0.0;
        double min = 0.0;
        double com = 0.0;
        double mean = 0.0;
        double size = 0.0;
        double stdev = 0.0;
        double sum = 0.0;
        double sumSquared = 0.0;
        double weightedSumX = 0.0;
        double weightedSumY = 0.0;
        double weightedSumZ = 0.0;
        boolean notInitialized = true;
        double comSum = 0.0;
        for (Analysis analysis : results) {
            AnalysisImpl ai = (AnalysisImpl)analysis;
            if (notInitialized) {
                max = ai.getMaxValue();
                maxVoxel.xInt = ai.getMaxCoordinate().xInt;
                maxVoxel.yInt = ai.getMaxCoordinate().yInt;
                maxVoxel.zInt = ai.getMaxCoordinate().zInt;
                maxVoxel.seriesPoint = ai.getMaxCoordinate().seriesPoint;
                min = ai.getMinValue();
                minVoxel.xInt = ai.getMinCoordinate().xInt;
                minVoxel.yInt = ai.getMinCoordinate().yInt;
                minVoxel.zInt = ai.getMinCoordinate().zInt;
                minVoxel.seriesPoint = ai.getMinCoordinate().seriesPoint;
                notInitialized = false;
            } else {
                if (max < ai.getMaxValue() || max == ai.getMaxValue() && this.distanceFromCorner((Coordinate)ai.getMaxCoordinate()) < this.distanceFromCorner((Coordinate)maxVoxel)) {
                    max = ai.getMaxValue();
                    maxVoxel.xInt = ai.getMaxCoordinate().xInt;
                    maxVoxel.yInt = ai.getMaxCoordinate().yInt;
                    maxVoxel.zInt = ai.getMaxCoordinate().zInt;
                    maxVoxel.seriesPoint = ai.getMaxCoordinate().seriesPoint;
                }
                if (min > ai.getMinValue() || min == ai.getMinValue() && this.distanceFromCorner((Coordinate)ai.getMinCoordinate()) < this.distanceFromCorner((Coordinate)minVoxel)) {
                    min = ai.getMinValue();
                    minVoxel.xInt = ai.getMinCoordinate().xInt;
                    minVoxel.yInt = ai.getMinCoordinate().yInt;
                    minVoxel.zInt = ai.getMinCoordinate().zInt;
                    minVoxel.seriesPoint = ai.getMinCoordinate().seriesPoint;
                }
            }
            weightedSumX += ai.getWeightedSumX();
            weightedSumY += ai.getWeightedSumY();
            weightedSumZ += ai.getWeightedSumZ();
            sum += ai.getSum();
            comSum += ai.getComSum();
            sumSquared += ai.getSumSquared();
            size += (double)ai.getCount();
        }
        mean = sum / size;
        stdev = Math.sqrt((size * sumSquared - MathUtilities.pow((double)sum, (double)2.0)) / (size * (size - 1.0)));
        centerOfMass.setValues(weightedSumX / comSum, weightedSumY / comSum, weightedSumZ / comSum, maxVoxel.seriesPoint);
        com = volData.getValue(centerOfMass.xInt, centerOfMass.yInt, centerOfMass.zInt, maxVoxel.seriesPoint);
        AnalysisImpl stats = new AnalysisImpl(mean, min, max, sum, stdev, (int)size);
        stats.setMaxCoordinate(maxVoxel);
        stats.setMinCoordinate(minVoxel);
        stats.setCentroid(com);
        stats.setCentroidCoordinate(centerOfMass);
        stats.setType(3);
        stats.setUnitSize(this.volumeManager.getBaseVolume().getXSize() * this.volumeManager.getBaseVolume().getYSize() * this.volumeManager.getBaseVolume().getZSize());
        stats.setDescription("Volume");
        stats.setName(this.volumeManager.getName((ImageVolume)this.volume));
        return stats;
    }

    private double distanceFromCorner(Coordinate coor) {
        double disX = 0 - coor.xInt;
        double disY = 0 - coor.yInt;
        double disZ = 0 - coor.zInt;
        return Math.sqrt(disX * disX + disY * disY + disZ * disZ);
    }

    @Override
    public ImageBounds getSectionBounds(int index) {
        ImageVolume volumeBase = this.volumeManager.getBaseVolume();
        int xDim = volumeBase.getXDim();
        int yDim = volumeBase.getYDim();
        int zDim = volumeBase.getZDim();
        ImageBounds bounds = null;
        if (index == 0) {
            bounds = new ImageBounds(0, xDim / 2 - 1, 0, yDim / 2 - 1, 0, zDim / 2 - 1);
        } else if (index == 1) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, 0, yDim / 2 - 1, 0, zDim / 2 - 1);
        } else if (index == 2) {
            bounds = new ImageBounds(0, xDim / 2 - 1, yDim / 2, yDim - 1, 0, zDim / 2 - 1);
        } else if (index == 3) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, yDim / 2, yDim - 1, 0, zDim / 2 - 1);
        } else if (index == 4) {
            bounds = new ImageBounds(0, xDim / 2 - 1, 0, yDim / 2 - 1, zDim / 2, zDim - 1);
        } else if (index == 5) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, 0, yDim / 2 - 1, zDim / 2, zDim - 1);
        } else if (index == 6) {
            bounds = new ImageBounds(0, xDim / 2 - 1, yDim / 2, yDim - 1, zDim / 2, zDim - 1);
        } else if (index == 7) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, yDim / 2, yDim - 1, zDim / 2, zDim - 1);
        }
        if (bounds != null) {
            bounds.setRangeT(volumeBase.getCurrentSeriesPoint(), volumeBase.getCurrentSeriesPoint());
        }
        return bounds;
    }

    public void calculateAllVolumesStatsAsync(final OperationListener listener) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                VolumeStatOp.this.calculateAllVolumesStatsSync(listener);
            }
        }, "VolumeStatOp.calculateAllVolumesStatsAsync() Thread");
        workThread.start();
    }

    public List<Analysis> calculateAllVolumesStatsSync(OperationListener listener) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        ProgressMeter pb = this.volumeManager.makeProgressMeter();
        pb.setDescription("Calculating Volume Stats");
        int xDim = this.volumeManager.getBaseVolume().getXDim();
        int yDim = this.volumeManager.getBaseVolume().getYDim();
        int zDim = this.volumeManager.getBaseVolume().getZDim();
        int tDim = this.volumeManager.getCurrentVolume().getSeriesLength();
        pb.start(0, 0, tDim);
        for (int ctr = 0; ctr < tDim; ++ctr) {
            ImageBounds bounds = new ImageBounds(0, xDim - 1, 0, yDim - 1, 0, zDim - 1);
            bounds.setRangeT(ctr, ctr);
            AnalysisImpl analysis = (AnalysisImpl)this.process(bounds);
            analysis.setType(3);
            analysis.setDescription("Volume");
            analysis.setName(this.volumeManager.getName((ImageVolume)this.volume));
            analysis.setUnitSize(this.volumeManager.getBaseVolume().getXSize() * this.volumeManager.getBaseVolume().getYSize() * this.volumeManager.getBaseVolume().getZSize());
            if (listener != null) {
                listener.operationFinished(analysis, this.volume);
                Thread.yield();
            }
            stats.add(analysis);
            pb.setValue(ctr);
        }
        pb.setValue(pb.getMax());
        return stats;
    }

    @Override
    public boolean testProcessValidity() {
        return true;
    }
}

