/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.stats;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.operations.OperationListener;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.util.ArrayList;
import java.util.List;

public class SliceStatOp {
    private final VolumeManager volumeManager;
    private final Volume volume;

    public SliceStatOp(VolumeManager volumeManager, Volume volume) {
        this.volumeManager = volumeManager;
        this.volume = volume;
    }

    public Analysis process(ImageBounds bounds) {
        int xMin = bounds.getMinX();
        int xMax = bounds.getMaxX();
        int yMin = bounds.getMinY();
        int yMax = bounds.getMaxY();
        int zMin = bounds.getMinZ();
        int zMax = bounds.getMaxZ();
        int sliceNum = this.volumeManager.getSliceNumber();
        int sliceDirection = this.volumeManager.getSliceDirection();
        int currentTimepoint = bounds.getMinT();
        VolumeData volData = new VolumeData(this.volumeManager, this.volume);
        Coordinate4D centerOfMass = new Coordinate4D(0.0, 0.0, 0.0, 0);
        Coordinate4D maxVoxel = new Coordinate4D(0.0, 0.0, 0.0, 0);
        Coordinate4D minVoxel = new Coordinate4D(0.0, 0.0, 0.0, 0);
        double max = 0.0;
        double min = 0.0;
        double com = 0.0;
        double mean = 0.0;
        double size = 0.0;
        double sum = 0.0;
        double stdev = 0.0;
        double sumSquared = 0.0;
        double weightedSumX = 0.0;
        double weightedSumY = 0.0;
        double weightedSumZ = 0.0;
        boolean notInitialized = true;
        double comSum = 0.0;
        for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
            for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                    double current = volData.getValue(ctrX, ctrY, ctrZ, currentTimepoint);
                    if (notInitialized) {
                        notInitialized = false;
                        max = min = current;
                        maxVoxel.xInt = minVoxel.xInt = ctrX;
                        maxVoxel.yInt = minVoxel.yInt = ctrY;
                        maxVoxel.zInt = minVoxel.zInt = ctrZ;
                    }
                    if (max < current) {
                        max = current;
                        maxVoxel.xInt = ctrX;
                        maxVoxel.yInt = ctrY;
                        maxVoxel.zInt = ctrZ;
                    } else if (min > current) {
                        min = current;
                        minVoxel.xInt = ctrX;
                        minVoxel.yInt = ctrY;
                        minVoxel.zInt = ctrZ;
                    }
                    double currentABS = Math.abs(current);
                    weightedSumX += currentABS * (double)ctrX;
                    weightedSumY += currentABS * (double)ctrY;
                    weightedSumZ += currentABS * (double)ctrZ;
                    sum += current;
                    comSum += currentABS;
                    sumSquared += MathUtilities.pow((double)current, (double)2.0);
                    size += 1.0;
                }
            }
        }
        maxVoxel.seriesPoint = currentTimepoint;
        minVoxel.seriesPoint = currentTimepoint;
        mean = sum / size;
        centerOfMass.setValues(weightedSumX / comSum, weightedSumY / comSum, weightedSumZ / comSum, currentTimepoint);
        com = volData.getValue(centerOfMass.xInt, centerOfMass.yInt, centerOfMass.zInt, currentTimepoint);
        stdev = Math.sqrt((size * sumSquared - MathUtilities.pow((double)sum, (double)2.0)) / (size * (size - 1.0)));
        AnalysisImpl analysis = new AnalysisImpl(mean, min, max, sum, stdev, (int)size);
        analysis.setMaxCoordinate(maxVoxel);
        analysis.setMinCoordinate(minVoxel);
        analysis.setCentroid(com);
        analysis.setCentroidCoordinate(centerOfMass);
        analysis.setType(2);
        analysis.setDescription("Slice");
        analysis.setName(this.volumeManager.getName((ImageVolume)this.volume));
        analysis.setSliceDirection(sliceDirection);
        analysis.setSliceNum(sliceNum);
        if (sliceDirection == 0) {
            analysis.setUnitSize(this.volumeManager.getBaseVolume().getXSize() * this.volumeManager.getBaseVolume().getYSize());
        } else if (sliceDirection == 1) {
            analysis.setUnitSize(this.volumeManager.getBaseVolume().getXSize() * this.volumeManager.getBaseVolume().getZSize());
        } else if (sliceDirection == 2) {
            analysis.setUnitSize(this.volumeManager.getBaseVolume().getYSize() * this.volumeManager.getBaseVolume().getZSize());
        }
        return analysis;
    }

    public void calculateAllSliceStatsAsync(final int sliceDirection, final OperationListener listener) {
        Thread workThread = new Thread(){

            @Override
            public void run() {
                SliceStatOp.this.calculateAllSliceStatsSync(sliceDirection, listener);
            }
        };
        workThread.start();
    }

    public List<Analysis> calculateAllSliceStatsSync(int sliceDirection, OperationListener listener) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        int xDimViewer = this.volumeManager.getBaseVolume().getXDim();
        int yDimViewer = this.volumeManager.getBaseVolume().getYDim();
        int zDimViewer = this.volumeManager.getBaseVolume().getZDim();
        ProgressMeter pb = this.volumeManager.makeProgressMeter();
        pb.setDescription("Calculating Slice Stats");
        if (sliceDirection == 0) {
            pb.start(0, 0, zDimViewer);
            for (int ctr = 0; ctr < zDimViewer; ++ctr) {
                Analysis analysis = this.process(new ImageBounds(0, xDimViewer - 1, 0, yDimViewer - 1, ctr, ctr));
                if (listener != null) {
                    listener.operationFinished(analysis, this.volume);
                    Thread.yield();
                }
                stats.add(analysis);
                pb.setValue(ctr);
            }
            pb.setValue(pb.getMax());
        } else if (sliceDirection == 1) {
            pb.start(0, 0, yDimViewer);
            for (int ctr = 0; ctr < yDimViewer; ++ctr) {
                Analysis analysis = this.process(new ImageBounds(0, xDimViewer - 1, ctr, ctr, 0, zDimViewer - 1));
                if (listener != null) {
                    listener.operationFinished(analysis, this.volume);
                    Thread.yield();
                }
                stats.add(analysis);
                pb.setValue(ctr);
            }
            pb.setValue(pb.getMax());
        } else if (sliceDirection == 2) {
            pb.start(0, 0, xDimViewer);
            for (int ctr = 0; ctr < xDimViewer; ++ctr) {
                Analysis analysis = this.process(new ImageBounds(ctr, ctr, 0, yDimViewer - 1, 0, zDimViewer - 1));
                if (listener != null) {
                    listener.operationFinished(analysis, this.volume);
                    Thread.yield();
                }
                stats.add(analysis);
                pb.setValue(ctr);
            }
            pb.setValue(pb.getMax());
        }
        return stats;
    }
}

