/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.stats;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.BitUtilities;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.LabelManager;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.VolumeROI;
import edu.uthscsa.ric.volume.operations.Operation;
import edu.uthscsa.ric.volume.operations.OperationListener;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SeriesStatROIOp
implements Operation<Map<Long, Analysis>> {
    private final Volume volume;
    private final VolumeManager volumeManager;
    private final LabelManager labelManager;
    private final VolumeROI roi;
    private final long selectedROIs;

    public SeriesStatROIOp(VolumeManager volumeManager, Volume volume, VolumeROI roi, long selectedROIs, LabelManager labelManager) {
        this.volumeManager = volumeManager;
        this.volume = volume;
        this.roi = roi;
        this.selectedROIs = selectedROIs;
        this.labelManager = labelManager;
    }

    @Override
    public Map<Long, Analysis> process(ImageBounds bounds) {
        int xMin = bounds.getMinX();
        int xMax = bounds.getMaxX();
        int yMin = bounds.getMinY();
        int yMax = bounds.getMaxY();
        int zMin = bounds.getMinZ();
        int zMax = bounds.getMaxZ();
        int tMin = bounds.getMinT();
        int tMax = bounds.getMaxT();
        VolumeData volData = new VolumeData(this.volumeManager, this.volume);
        boolean dynamicROI = this.roi.getSeriesLength() > 1;
        int xDimROI = this.volumeManager.getBaseVolume().getXDim() + 1;
        int yDimROI = this.volumeManager.getBaseVolume().getYDim() + 1;
        HashMap<Long, Analysis> map = new HashMap<Long, Analysis>();
        for (int ctrT = tMin; ctrT <= tMax; ++ctrT) {
            for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
                int offsetROIZ = xDimROI * yDimROI * ctrZ;
                for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                    int offsetROIY = xDimROI * ctrY;
                    for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                        long roiIndex = dynamicROI ? this.roi.get(ctrX + offsetROIY + offsetROIZ, ctrT) : this.roi.getCurrent(ctrX + offsetROIY + offsetROIZ);
                        if ((roiIndex & this.selectedROIs) == 0L) continue;
                        roiIndex &= this.selectedROIs;
                        double current = volData.getValue(ctrX, ctrY, ctrZ, ctrT);
                        long bit = 0L;
                        while ((bit = Long.lowestOneBit(roiIndex)) != 0L) {
                            AnalysisImpl stat = (AnalysisImpl)map.get(bit);
                            if (stat == null) {
                                stat = new AnalysisImpl();
                                stat.roiIndex = BitUtilities.findHighestOneBitIndex((long)bit);
                                stat.centroidCoordinate = new Coordinate4D(0.0, 0.0, 0.0, 0);
                                stat.maxCoordinate = new Coordinate4D(0.0, 0.0, 0.0, 0);
                                stat.minCoordinate = new Coordinate4D(0.0, 0.0, 0.0, 0);
                                stat.maxCoordinate.seriesPoint = ctrT;
                                stat.minCoordinate.seriesPoint = ctrT;
                                map.put(bit, stat);
                                stat.max = stat.min = current;
                                stat.maxCoordinate.xInt = stat.minCoordinate.xInt = ctrX;
                                stat.maxCoordinate.yInt = stat.minCoordinate.yInt = ctrY;
                                stat.maxCoordinate.zInt = stat.minCoordinate.zInt = ctrZ;
                            }
                            if (stat.max < current) {
                                stat.max = current;
                                stat.maxCoordinate.xInt = ctrX;
                                stat.maxCoordinate.yInt = ctrY;
                                stat.maxCoordinate.zInt = ctrZ;
                                stat.maxCoordinate.seriesPoint = ctrT;
                            } else if (stat.min > current) {
                                stat.min = current;
                                stat.minCoordinate.xInt = ctrX;
                                stat.minCoordinate.yInt = ctrY;
                                stat.minCoordinate.zInt = ctrZ;
                                stat.minCoordinate.seriesPoint = ctrT;
                            }
                            double currentABS = Math.abs(current);
                            stat.weightedSumX += currentABS * (double)ctrX;
                            stat.weightedSumY += currentABS * (double)ctrY;
                            stat.weightedSumZ += currentABS * (double)ctrZ;
                            stat.weightedSumT += currentABS * (double)ctrT;
                            stat.sum += current;
                            stat.comSum += currentABS;
                            stat.sumSquared += MathUtilities.pow((double)current, (double)2.0);
                            ++stat.count;
                            roiIndex &= bit ^ 0xFFFFFFFFFFFFFFFFL;
                        }
                    }
                }
            }
        }
        for (Analysis stat : map.values()) {
            AnalysisImpl statImpl = (AnalysisImpl)stat;
            statImpl.mean = statImpl.sum / (double)statImpl.count;
            statImpl.stdev = Math.sqrt(((double)statImpl.count * statImpl.sumSquared - MathUtilities.pow((double)statImpl.sum, (double)2.0)) / ((double)statImpl.count * ((double)statImpl.count - 1.0)));
            statImpl.centroidCoordinate.setValues(statImpl.weightedSumX / statImpl.comSum, statImpl.weightedSumY / statImpl.comSum, statImpl.weightedSumZ / statImpl.comSum, (int)Math.round(statImpl.weightedSumT / statImpl.comSum));
            statImpl.centroid = volData.getValue(statImpl.centroidCoordinate.xInt, statImpl.centroidCoordinate.yInt, statImpl.centroidCoordinate.zInt, statImpl.centroidCoordinate.seriesPoint);
        }
        return map;
    }

    @Override
    public Map<Long, Analysis> accumulate(List<Map<Long, Analysis>> results) {
        VolumeData volData = new VolumeData(this.volumeManager);
        TreeMap<Long, Analysis> map = new TreeMap<Long, Analysis>();
        for (Map<Long, Analysis> map2 : results) {
            for (Map.Entry<Long, Analysis> resultStatEntry : map2.entrySet()) {
                AnalysisImpl mappedStat = (AnalysisImpl)map.get(resultStatEntry.getKey());
                AnalysisImpl resultStat = (AnalysisImpl)resultStatEntry.getValue();
                if (mappedStat == null) {
                    mappedStat = new AnalysisImpl();
                    mappedStat.roiIndex = resultStat.roiIndex;
                    mappedStat.centroidCoordinate = new Coordinate4D(0.0, 0.0, 0.0, 0);
                    mappedStat.maxCoordinate = new Coordinate4D(0.0, 0.0, 0.0, 0);
                    mappedStat.minCoordinate = new Coordinate4D(0.0, 0.0, 0.0, 0);
                    map.put(resultStatEntry.getKey(), mappedStat);
                    mappedStat.max = resultStat.max;
                    mappedStat.maxCoordinate.xInt = resultStat.getMaxCoordinate().xInt;
                    mappedStat.maxCoordinate.yInt = resultStat.getMaxCoordinate().yInt;
                    mappedStat.maxCoordinate.zInt = resultStat.getMaxCoordinate().zInt;
                    mappedStat.maxCoordinate.seriesPoint = resultStat.getMaxCoordinate().seriesPoint;
                    mappedStat.min = resultStat.min;
                    mappedStat.minCoordinate.xInt = resultStat.getMinCoordinate().xInt;
                    mappedStat.minCoordinate.yInt = resultStat.getMinCoordinate().yInt;
                    mappedStat.minCoordinate.zInt = resultStat.getMinCoordinate().zInt;
                    mappedStat.minCoordinate.seriesPoint = resultStat.getMinCoordinate().seriesPoint;
                } else {
                    if (mappedStat.max < resultStat.getMaxValue() || mappedStat.max == resultStat.getMaxValue() && this.distanceFromCorner(resultStat.getMaxCoordinate()) < this.distanceFromCorner(mappedStat.maxCoordinate)) {
                        mappedStat.max = resultStat.getMaxValue();
                        mappedStat.maxCoordinate.xInt = resultStat.getMaxCoordinate().xInt;
                        mappedStat.maxCoordinate.yInt = resultStat.getMaxCoordinate().yInt;
                        mappedStat.maxCoordinate.zInt = resultStat.getMaxCoordinate().zInt;
                        mappedStat.maxCoordinate.seriesPoint = resultStat.getMaxCoordinate().seriesPoint;
                    }
                    if (mappedStat.min > resultStat.getMinValue() || mappedStat.min == resultStat.getMinValue() && this.distanceFromCorner(resultStat.getMinCoordinate()) < this.distanceFromCorner(mappedStat.minCoordinate)) {
                        mappedStat.min = resultStat.getMinValue();
                        mappedStat.minCoordinate.xInt = resultStat.getMinCoordinate().xInt;
                        mappedStat.minCoordinate.yInt = resultStat.getMinCoordinate().yInt;
                        mappedStat.minCoordinate.zInt = resultStat.getMinCoordinate().zInt;
                        mappedStat.minCoordinate.seriesPoint = resultStat.getMinCoordinate().seriesPoint;
                    }
                }
                mappedStat.weightedSumX += resultStat.getWeightedSumX();
                mappedStat.weightedSumY += resultStat.getWeightedSumY();
                mappedStat.weightedSumZ += resultStat.getWeightedSumZ();
                mappedStat.weightedSumT += resultStat.getWeightedSumT();
                mappedStat.sum += resultStat.getSum();
                mappedStat.comSum += resultStat.getComSum();
                mappedStat.sumSquared += resultStat.getSumSquared();
                mappedStat.count += resultStat.getCount();
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            AnalysisImpl stat = (AnalysisImpl)entry.getValue();
            stat.mean = stat.sum / (double)stat.count;
            stat.stdev = Math.sqrt(((double)stat.count * stat.sumSquared - MathUtilities.pow((double)stat.sum, (double)2.0)) / ((double)stat.count * ((double)stat.count - 1.0)));
            stat.centroidCoordinate.setValues(stat.weightedSumX / stat.comSum, stat.weightedSumY / stat.comSum, stat.weightedSumZ / stat.comSum, (int)Math.round(stat.weightedSumT / stat.comSum));
            stat.centroid = volData.getValue(stat.centroidCoordinate.xInt, stat.centroidCoordinate.yInt, stat.centroidCoordinate.zInt, stat.centroidCoordinate.seriesPoint);
            stat.setMaxCoordinate(stat.maxCoordinate);
            stat.setMinCoordinate(stat.minCoordinate);
            stat.setCentroidCoordinate(stat.centroidCoordinate);
            stat.setType(4);
            stat.setUnitSize(this.volumeManager.getBaseVolume().getXSize() * this.volumeManager.getBaseVolume().getYSize() * this.volumeManager.getBaseVolume().getZSize());
            stat.setDescription("Series");
            stat.setDescription(this.labelManager.getLabel(stat.getROI(), "ROI " + stat.getDescription()));
            stat.setName(this.volumeManager.getName((ImageVolume)this.volume));
        }
        return map;
    }

    private double distanceFromCorner(Coordinate4D coor) {
        double disX = 0 - coor.xInt;
        double disY = 0 - coor.yInt;
        double disZ = 0 - coor.zInt;
        double disT = 0 - coor.seriesPoint;
        return Math.sqrt(disX * disX + disY * disY + disZ * disZ + disT * disT);
    }

    @Override
    public ImageBounds getSectionBounds(int index) {
        ImageVolume volumeBase = this.volumeManager.getBaseVolume();
        int xDim = volumeBase.getXDim();
        int yDim = volumeBase.getYDim();
        int zDim = volumeBase.getZDim();
        ImageBounds bounds = null;
        if (index == 0) {
            bounds = new ImageBounds(0, xDim / 2 - 1, 0, yDim / 2 - 1, 0, zDim / 2 - 1);
        } else if (index == 1) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, 0, yDim / 2 - 1, 0, zDim / 2 - 1);
        } else if (index == 2) {
            bounds = new ImageBounds(0, xDim / 2 - 1, yDim / 2, yDim - 1, 0, zDim / 2 - 1);
        } else if (index == 3) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, yDim / 2, yDim - 1, 0, zDim / 2 - 1);
        } else if (index == 4) {
            bounds = new ImageBounds(0, xDim / 2 - 1, 0, yDim / 2 - 1, zDim / 2, zDim - 1);
        } else if (index == 5) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, 0, yDim / 2 - 1, zDim / 2, zDim - 1);
        } else if (index == 6) {
            bounds = new ImageBounds(0, xDim / 2 - 1, yDim / 2, yDim - 1, zDim / 2, zDim - 1);
        } else if (index == 7) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, yDim / 2, yDim - 1, zDim / 2, zDim - 1);
        }
        if (bounds != null) {
            bounds.setRangeT(0, volumeBase.getSeriesLength() - 1);
        }
        return bounds;
    }

    public void calculateAllVolumesStatsAsync(final OperationListener listener) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SeriesStatROIOp.this.calculateAllVolumesStatsSync(listener);
            }
        }, "VolumeStatOp.calculateAllVolumesStatsAsync() Thread");
        workThread.start();
    }

    public List<Analysis> calculateAllVolumesStatsSync(OperationListener listener) {
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        ProgressMeter pb = this.volumeManager.makeProgressMeter();
        pb.setDescription("Calculating Volume Stats");
        int xDim = this.volumeManager.getBaseVolume().getXDim();
        int yDim = this.volumeManager.getBaseVolume().getYDim();
        int zDim = this.volumeManager.getBaseVolume().getZDim();
        int tDim = this.volumeManager.getCurrentVolume().getSeriesLength();
        pb.start(0, 0, tDim);
        for (int ctr = 0; ctr < tDim; ++ctr) {
            ImageBounds bounds = new ImageBounds(0, xDim - 1, 0, yDim - 1, 0, zDim - 1);
            bounds.setRangeT(ctr, ctr);
            AnalysisImpl analysis = (AnalysisImpl)this.process(bounds);
            analysis.setType(3);
            analysis.setDescription("Volume");
            analysis.setName(this.volumeManager.getName((ImageVolume)this.volume));
            analysis.setUnitSize(this.volumeManager.getBaseVolume().getXSize() * this.volumeManager.getBaseVolume().getYSize() * this.volumeManager.getBaseVolume().getZSize());
            if (listener != null) {
                listener.operationFinished(analysis, this.volume);
                Thread.yield();
            }
            stats.add(analysis);
            pb.setValue(ctr);
        }
        pb.setValue(pb.getMax());
        return stats;
    }

    @Override
    public boolean testProcessValidity() {
        return true;
    }
}

