/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.stats;

import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.roi.points.POI;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.VolumeROI;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import org.apache.commons.lang3.StringUtils;

public class PointStatROIOp {
    private final Volume volume;
    private final VolumeManager volumeManager;
    private final VolumeROI roi;

    public PointStatROIOp(VolumeManager volumeManager, Volume volume, VolumeROI roi) {
        this.volumeManager = volumeManager;
        this.volume = volume;
        this.roi = roi;
    }

    public Analysis process(POI point, int currentTimepoint) {
        VolumeData volData = new VolumeData(this.volumeManager, this.volume);
        double value = volData.getValue(point.getX(), point.getY(), point.getZ(), currentTimepoint);
        int color = point.getColor();
        Coordinate4D coor = new Coordinate4D((double)point.getX(), (double)point.getY(), (double)point.getZ(), currentTimepoint);
        AnalysisImpl stats = new AnalysisImpl(value, value, value, value, 0.0, 1);
        stats.setMaxCoordinate(coor);
        stats.setMinCoordinate(coor);
        stats.setCentroid(value);
        stats.setCentroidCoordinate(coor);
        stats.setType(0);
        stats.setRoiIndex(color, this.roi.getMaximumColors());
        stats.setSliceDirection(-1);
        stats.setSliceNum(-1);
        stats.setUnitSize(1.0);
        stats.setName(this.volumeManager.getName((ImageVolume)this.volume));
        stats.setRegionSize(this.volumeManager.getBaseVolume().getVoxelDimensions().getVolume());
        String des = point.getLabel(false);
        if (StringUtils.isBlank((CharSequence)des)) {
            des = "ROI Point";
        }
        stats.setDescription(des);
        return stats;
    }

    public double process(Coordinate4D point, int currentTimepoint) {
        VolumeData volData = new VolumeData(this.volumeManager, this.volume);
        return volData.getValue(point.xInt, point.yInt, point.zInt, currentTimepoint);
    }

    public Analysis calculateSeriesPointROI(POI point) {
        VolumeData volData = new VolumeData(this.volumeManager);
        int numTimepoints = this.volumeManager.getCurrentVolume().getSeriesLength();
        int color = point.getColor();
        int xLoc = point.getX();
        int yLoc = point.getY();
        int zLoc = point.getZ();
        Coordinate4D centerOfMass = new Coordinate4D(0.0, 0.0, 0.0, 0);
        Coordinate4D maxVoxel = new Coordinate4D(0.0, 0.0, 0.0, 0);
        Coordinate4D minVoxel = new Coordinate4D(0.0, 0.0, 0.0, 0);
        double max = 0.0;
        double min = 0.0;
        double com = 0.0;
        double mean = 0.0;
        double sum = 0.0;
        double sumSquared = 0.0;
        double weightedSumT = 0.0;
        double comSum = 0.0;
        double stdev = 0.0;
        boolean initialized = false;
        for (int ctrT = 0; ctrT < numTimepoints; ++ctrT) {
            double currentValue = volData.getValue(xLoc, yLoc, zLoc, ctrT);
            if (!initialized) {
                initialized = true;
                max = min = currentValue;
                maxVoxel.xInt = xLoc;
                maxVoxel.yInt = yLoc;
                maxVoxel.zInt = zLoc;
                minVoxel.xInt = xLoc;
                minVoxel.yInt = yLoc;
                minVoxel.zInt = zLoc;
                maxVoxel.seriesPoint = ctrT;
                minVoxel.seriesPoint = ctrT;
            }
            if (max < currentValue) {
                max = currentValue;
                maxVoxel.xInt = xLoc;
                maxVoxel.yInt = yLoc;
                maxVoxel.zInt = zLoc;
                maxVoxel.seriesPoint = ctrT;
            } else if (min > currentValue) {
                min = currentValue;
                minVoxel.xInt = xLoc;
                minVoxel.yInt = yLoc;
                minVoxel.zInt = zLoc;
                minVoxel.seriesPoint = ctrT;
            }
            double currentABS = Math.abs(currentValue);
            weightedSumT += currentABS * (double)ctrT;
            sum += currentValue;
            comSum += currentABS;
            sumSquared += MathUtilities.pow((double)currentValue, (double)2.0);
        }
        centerOfMass.setValues((double)xLoc, (double)yLoc, (double)zLoc, (int)Math.round(weightedSumT / comSum));
        com = volData.getValue(centerOfMass.xInt, centerOfMass.yInt, centerOfMass.zInt, centerOfMass.seriesPoint);
        mean = sum / (double)numTimepoints;
        stdev = Math.sqrt(((double)numTimepoints * sumSquared - MathUtilities.pow((double)sum, (double)2.0)) / ((double)numTimepoints * (double)(numTimepoints - 1)));
        AnalysisImpl stats = new AnalysisImpl(mean, min, max, sum, stdev, numTimepoints);
        stats.setMaxCoordinate(maxVoxel);
        stats.setMinCoordinate(minVoxel);
        stats.setCentroid(com);
        stats.setCentroidCoordinate(centerOfMass);
        stats.setType(4);
        stats.setRoiIndex(color, this.roi.getMaximumColors());
        stats.setSliceDirection(-1);
        stats.setSliceNum(-1);
        stats.setUnitSize(1.0);
        stats.setName(this.volumeManager.getName((ImageVolume)this.volume));
        stats.setRegionSize(this.volumeManager.getBaseVolume().getVoxelDimensions().getVolume());
        String des = point.getLabel(false);
        if (StringUtils.isBlank((CharSequence)des)) {
            des = "ROI Point";
        }
        stats.setDescription(des);
        return stats;
    }
}

