/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.stats;

import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.roi.lines.display.LOIShape;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.VolumeROI;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.awt.Point;
import java.awt.geom.PathIterator;
import org.apache.commons.lang3.StringUtils;

public class LineStatROIOp {
    private final Volume volume;
    private final VolumeManager volumeManager;
    private final VolumeROI roi;

    public LineStatROIOp(VolumeManager volumeManager, Volume volume, VolumeROI roi) {
        this.volumeManager = volumeManager;
        this.volume = volume;
        this.roi = roi;
    }

    public Analysis process(LOIShape loi, int sliceDirection, int currentTimepointVal) {
        int currentTimepoint = currentTimepointVal;
        VolumeData volData = new VolumeData(this.volumeManager, this.volume);
        if (currentTimepoint < 0) {
            currentTimepoint = volData.getTimepoint();
        }
        int xDimROI = this.volumeManager.getBaseVolume().getXDim() + 1;
        int yDimROI = this.volumeManager.getBaseVolume().getYDim() + 1;
        int zDimROI = this.volumeManager.getBaseVolume().getZDim() + 1;
        int slice = loi.getSliceNum();
        int color = loi.getColor();
        PathIterator it = null;
        Coordinate4D centerOfMass = new Coordinate4D(0.0, 0.0, 0.0, 0);
        Coordinate4D maxVoxel = new Coordinate4D(0.0, 0.0, 0.0, 0);
        Coordinate4D minVoxel = new Coordinate4D(0.0, 0.0, 0.0, 0);
        double max = 0.0;
        double min = 0.0;
        double com = 0.0;
        double mean = 0.0;
        double sum = 0.0;
        double sumSquared = 0.0;
        double weightedSumX = 0.0;
        double weightedSumY = 0.0;
        double weightedSumZ = 0.0;
        double comSum = 0.0;
        double stdev = 0.0;
        double numPoints = 0.0;
        double size = 0.0;
        double[] segment = new double[4];
        Point destination = new Point();
        Point previous = new Point();
        Point current = new Point();
        int ctrX = 0;
        int ctrY = 0;
        int ctrZ = 0;
        it = loi.getPathIterator(null);
        it.currentSegment(segment);
        previous.setLocation((int)segment[0], (int)segment[1]);
        it.next();
        current.setLocation(previous);
        if (sliceDirection == 0) {
            ctrX = current.x;
            ctrY = current.y;
            ctrZ = slice;
        } else if (sliceDirection == 1) {
            ctrX = current.x;
            ctrY = slice;
            ctrZ = current.y;
        } else {
            ctrX = slice;
            ctrY = current.x;
            ctrZ = current.y;
        }
        double currentValue = ctrX >= 0 && ctrX < xDimROI && ctrY >= 0 && ctrY < yDimROI && ctrZ >= 0 && ctrZ < zDimROI ? volData.getValue(ctrX, ctrY, ctrZ, currentTimepoint) : 0.0;
        max = min = currentValue;
        maxVoxel.xInt = ctrX;
        maxVoxel.yInt = ctrY;
        maxVoxel.zInt = ctrZ;
        minVoxel.xInt = ctrX;
        minVoxel.yInt = ctrY;
        minVoxel.zInt = ctrZ;
        double currentABS = Math.abs(currentValue);
        weightedSumX += currentABS * (double)ctrX;
        weightedSumY += currentABS * (double)ctrY;
        weightedSumZ += currentABS * (double)ctrZ;
        sum += currentValue;
        comSum += currentABS;
        sumSquared += MathUtilities.pow((double)currentValue, (double)2.0);
        numPoints += 1.0;
        while (!it.isDone()) {
            int ctr;
            int incrementY;
            it.currentSegment(segment);
            destination.setLocation((int)segment[0], (int)segment[1]);
            int distanceX = Math.abs(destination.x - previous.x);
            int distanceY = Math.abs(destination.y - previous.y);
            double slopeX = distanceY == 0 ? 0.0 : (double)distanceX / (double)distanceY;
            double slopeY = distanceX == 0 ? 0.0 : (double)distanceY / (double)distanceX;
            int incrementX = destination.x - previous.x > 0 ? 1 : -1;
            int n = incrementY = destination.y - previous.y > 0 ? 1 : -1;
            if (distanceX > 0 && distanceX >= distanceY) {
                for (ctr = 1; ctr < distanceX; ++ctr) {
                    current.setLocation(ctr * incrementX + previous.x, (int)((double)previous.y + (double)ctr * slopeY * (double)incrementY + 0.5));
                    if (sliceDirection == 0) {
                        ctrX = current.x;
                        ctrY = current.y;
                        ctrZ = slice;
                    } else if (sliceDirection == 1) {
                        ctrX = current.x;
                        ctrY = slice;
                        ctrZ = current.y;
                    } else {
                        ctrX = slice;
                        ctrY = current.x;
                        ctrZ = current.y;
                    }
                    currentValue = ctrX >= 0 && ctrX < xDimROI && ctrY >= 0 && ctrY < yDimROI && ctrZ >= 0 && ctrZ < zDimROI ? volData.getValue(ctrX, ctrY, ctrZ, currentTimepoint) : 0.0;
                    if (max < currentValue) {
                        max = currentValue;
                        maxVoxel.xInt = ctrX;
                        maxVoxel.yInt = ctrY;
                        maxVoxel.zInt = ctrZ;
                    } else if (min > currentValue) {
                        min = currentValue;
                        minVoxel.xInt = ctrX;
                        minVoxel.yInt = ctrY;
                        minVoxel.zInt = ctrZ;
                    }
                    currentABS = Math.abs(currentValue);
                    weightedSumX += currentABS * (double)ctrX;
                    weightedSumY += currentABS * (double)ctrY;
                    weightedSumZ += currentABS * (double)ctrZ;
                    sum += currentValue;
                    comSum += currentABS;
                    sumSquared += MathUtilities.pow((double)currentValue, (double)2.0);
                    numPoints += 1.0;
                }
            } else if (distanceY > 0 && distanceY > distanceX) {
                for (ctr = 1; ctr < distanceY; ++ctr) {
                    current.setLocation((int)((double)previous.x + (double)ctr * slopeX * (double)incrementX + 0.5), ctr * incrementY + previous.y);
                    if (sliceDirection == 0) {
                        ctrX = current.x;
                        ctrY = current.y;
                        ctrZ = slice;
                    } else if (sliceDirection == 1) {
                        ctrX = current.x;
                        ctrY = slice;
                        ctrZ = current.y;
                    } else {
                        ctrX = slice;
                        ctrY = current.x;
                        ctrZ = current.y;
                    }
                    currentValue = ctrX >= 0 && ctrX < xDimROI && ctrY >= 0 && ctrY < yDimROI && ctrZ >= 0 && ctrZ < zDimROI ? volData.getValue(ctrX, ctrY, ctrZ, currentTimepoint) : 0.0;
                    if (max < currentValue) {
                        max = currentValue;
                        maxVoxel.xInt = ctrX;
                        maxVoxel.yInt = ctrY;
                        maxVoxel.zInt = ctrZ;
                    } else if (min > currentValue) {
                        min = currentValue;
                        minVoxel.xInt = ctrX;
                        minVoxel.yInt = ctrY;
                        minVoxel.zInt = ctrZ;
                    }
                    currentABS = Math.abs(currentValue);
                    weightedSumX += currentABS * (double)ctrX;
                    weightedSumY += currentABS * (double)ctrY;
                    weightedSumZ += currentABS * (double)ctrZ;
                    sum += currentValue;
                    comSum += currentABS;
                    sumSquared += MathUtilities.pow((double)currentValue, (double)2.0);
                    numPoints += 1.0;
                }
            }
            current.setLocation(destination);
            if (sliceDirection == 0) {
                ctrX = current.x;
                ctrY = current.y;
                ctrZ = slice;
            } else if (sliceDirection == 1) {
                ctrX = current.x;
                ctrY = slice;
                ctrZ = current.y;
            } else {
                ctrX = slice;
                ctrY = current.x;
                ctrZ = current.y;
            }
            currentValue = ctrX >= 0 && ctrX < xDimROI && ctrY >= 0 && ctrY < yDimROI && ctrZ >= 0 && ctrZ < zDimROI ? volData.getValue(ctrX, ctrY, ctrZ, currentTimepoint) : 0.0;
            maxVoxel.seriesPoint = currentTimepoint;
            minVoxel.seriesPoint = currentTimepoint;
            if (max < currentValue) {
                max = currentValue;
                maxVoxel.xInt = ctrX;
                maxVoxel.yInt = ctrY;
                maxVoxel.zInt = ctrZ;
            } else if (min > currentValue) {
                min = currentValue;
                minVoxel.xInt = ctrX;
                minVoxel.yInt = ctrY;
                minVoxel.zInt = ctrZ;
            }
            currentABS = Math.abs(currentValue);
            weightedSumX += currentABS * (double)ctrX;
            weightedSumY += currentABS * (double)ctrY;
            weightedSumZ += currentABS * (double)ctrZ;
            sum += currentValue;
            comSum += currentABS;
            sumSquared += MathUtilities.pow((double)currentValue, (double)2.0);
            numPoints += 1.0;
            previous.setLocation(destination);
            it.next();
        }
        centerOfMass.setValues(weightedSumX / comSum, weightedSumY / comSum, weightedSumZ / comSum, currentTimepoint);
        com = volData.getValue(centerOfMass.xInt, centerOfMass.yInt, centerOfMass.zInt, currentTimepoint);
        mean = sum / numPoints;
        stdev = Math.sqrt((numPoints * sumSquared - MathUtilities.pow((double)sum, (double)2.0)) / (numPoints * (numPoints - 1.0)));
        size = sliceDirection == 0 ? loi.getLength(this.volumeManager.getBaseVolume().getXSize(), this.volumeManager.getBaseVolume().getYSize()) : (sliceDirection == 1 ? loi.getLength(this.volumeManager.getBaseVolume().getXSize(), this.volumeManager.getBaseVolume().getZSize()) : loi.getLength(this.volumeManager.getBaseVolume().getYSize(), this.volumeManager.getBaseVolume().getZSize()));
        AnalysisImpl stats = new AnalysisImpl(mean, min, max, sum, stdev, (int)numPoints);
        stats.setMaxCoordinate(maxVoxel);
        stats.setMinCoordinate(minVoxel);
        stats.setCentroid(com);
        stats.setCentroidCoordinate(centerOfMass);
        stats.setType(1);
        stats.setRoiIndex(color, this.roi.getMaximumColors());
        stats.setSliceDirection(-1);
        stats.setSliceNum(-1);
        stats.setUnitSize(1.0);
        stats.setRegionSize(size);
        stats.setName(this.volumeManager.getName((ImageVolume)this.volume));
        String des = loi.getLabel(false);
        if (StringUtils.isBlank((CharSequence)des)) {
            des = "ROI Line";
        }
        stats.setDescription(des);
        return stats;
    }

    public AnalysisImpl calculateSeriesLineROI(LOIShape loi, int sliceDirection) {
        VolumeData volData = new VolumeData(this.volumeManager);
        int slice = loi.getSliceNum();
        int color = loi.getColor();
        int xDimROI = this.volumeManager.getBaseVolume().getXDim() + 1;
        int yDimROI = this.volumeManager.getBaseVolume().getYDim() + 1;
        int zDimROI = this.volumeManager.getBaseVolume().getZDim() + 1;
        int numTimepoints = this.volumeManager.getCurrentVolume().getSeriesLength();
        PathIterator it = null;
        Coordinate4D centerOfMass = new Coordinate4D(0.0, 0.0, 0.0, 0);
        Coordinate4D maxVoxel = new Coordinate4D(0.0, 0.0, 0.0, 0);
        Coordinate4D minVoxel = new Coordinate4D(0.0, 0.0, 0.0, 0);
        double max = 0.0;
        double min = 0.0;
        double com = 0.0;
        double mean = 0.0;
        double sum = 0.0;
        double sumSquared = 0.0;
        double weightedSumX = 0.0;
        double weightedSumY = 0.0;
        double weightedSumZ = 0.0;
        double weightedSumT = 0.0;
        double comSum = 0.0;
        double stdev = 0.0;
        double numPoints = 0.0;
        double size = 0.0;
        double[] segment = new double[4];
        Point destination = new Point();
        Point previous = new Point();
        Point current = new Point();
        int ctrX = 0;
        int ctrY = 0;
        int ctrZ = 0;
        boolean initialized = false;
        for (int ctrT = 0; ctrT < numTimepoints; ++ctrT) {
            it = loi.getPathIterator(null);
            it.currentSegment(segment);
            previous.setLocation((int)segment[0], (int)segment[1]);
            it.next();
            current.setLocation(previous);
            if (sliceDirection == 0) {
                ctrX = current.x;
                ctrY = current.y;
                ctrZ = slice;
            } else if (sliceDirection == 1) {
                ctrX = current.x;
                ctrY = slice;
                ctrZ = current.y;
            } else {
                ctrX = slice;
                ctrY = current.x;
                ctrZ = current.y;
            }
            double currentValue = ctrX >= 0 && ctrX < xDimROI && ctrY >= 0 && ctrY < yDimROI && ctrZ >= 0 && ctrZ < zDimROI ? volData.getValue(ctrX, ctrY, ctrZ, ctrT) : 0.0;
            if (!initialized) {
                max = min = currentValue;
                maxVoxel.xInt = ctrX;
                maxVoxel.yInt = ctrY;
                maxVoxel.zInt = ctrZ;
                minVoxel.xInt = ctrX;
                minVoxel.yInt = ctrY;
                minVoxel.zInt = ctrZ;
                maxVoxel.seriesPoint = ctrT;
                minVoxel.seriesPoint = ctrT;
                initialized = true;
            }
            if (max < currentValue) {
                max = currentValue;
                maxVoxel.xInt = ctrX;
                maxVoxel.yInt = ctrY;
                maxVoxel.zInt = ctrZ;
                maxVoxel.seriesPoint = ctrT;
            } else if (min > currentValue) {
                min = currentValue;
                minVoxel.xInt = ctrX;
                minVoxel.yInt = ctrY;
                minVoxel.zInt = ctrZ;
                minVoxel.seriesPoint = ctrT;
            }
            double currentABS = Math.abs(currentValue);
            weightedSumX += currentABS * (double)ctrX;
            weightedSumY += currentABS * (double)ctrY;
            weightedSumZ += currentABS * (double)ctrZ;
            weightedSumT += currentABS * (double)ctrT;
            sum += currentValue;
            comSum += currentABS;
            sumSquared += MathUtilities.pow((double)currentValue, (double)2.0);
            numPoints += 1.0;
            while (!it.isDone()) {
                int ctr;
                int incrementY;
                it.currentSegment(segment);
                destination.setLocation((int)segment[0], (int)segment[1]);
                int distanceX = Math.abs(destination.x - previous.x);
                int distanceY = Math.abs(destination.y - previous.y);
                double slopeX = distanceY == 0 ? 0.0 : (double)distanceX / (double)distanceY;
                double slopeY = distanceX == 0 ? 0.0 : (double)distanceY / (double)distanceX;
                int incrementX = destination.x - previous.x > 0 ? 1 : -1;
                int n = incrementY = destination.y - previous.y > 0 ? 1 : -1;
                if (distanceX > 0 && distanceX >= distanceY) {
                    for (ctr = 1; ctr < distanceX; ++ctr) {
                        current.setLocation(ctr * incrementX + previous.x, (int)((double)previous.y + (double)ctr * slopeY * (double)incrementY + 0.5));
                        if (sliceDirection == 0) {
                            ctrX = current.x;
                            ctrY = current.y;
                            ctrZ = slice;
                        } else if (sliceDirection == 1) {
                            ctrX = current.x;
                            ctrY = slice;
                            ctrZ = current.y;
                        } else {
                            ctrX = slice;
                            ctrY = current.x;
                            ctrZ = current.y;
                        }
                        currentValue = ctrX >= 0 && ctrX < xDimROI && ctrY >= 0 && ctrY < yDimROI && ctrZ >= 0 && ctrZ < zDimROI ? volData.getValue(ctrX, ctrY, ctrZ, ctrT) : 0.0;
                        if (max < currentValue) {
                            max = currentValue;
                            maxVoxel.xInt = ctrX;
                            maxVoxel.yInt = ctrY;
                            maxVoxel.zInt = ctrZ;
                            maxVoxel.seriesPoint = ctrT;
                        } else if (min > currentValue) {
                            min = currentValue;
                            minVoxel.xInt = ctrX;
                            minVoxel.yInt = ctrY;
                            minVoxel.zInt = ctrZ;
                            minVoxel.seriesPoint = ctrT;
                        }
                        currentABS = Math.abs(currentValue);
                        weightedSumX += currentABS * (double)ctrX;
                        weightedSumY += currentABS * (double)ctrY;
                        weightedSumZ += currentABS * (double)ctrZ;
                        weightedSumT += currentABS * (double)ctrT;
                        sum += currentValue;
                        comSum += currentABS;
                        sumSquared += MathUtilities.pow((double)currentValue, (double)2.0);
                        numPoints += 1.0;
                    }
                } else if (distanceY > 0 && distanceY > distanceX) {
                    for (ctr = 1; ctr < distanceY; ++ctr) {
                        current.setLocation((int)((double)previous.x + (double)ctr * slopeX * (double)incrementX + 0.5), ctr * incrementY + previous.y);
                        if (sliceDirection == 0) {
                            ctrX = current.x;
                            ctrY = current.y;
                            ctrZ = slice;
                        } else if (sliceDirection == 1) {
                            ctrX = current.x;
                            ctrY = slice;
                            ctrZ = current.y;
                        } else {
                            ctrX = slice;
                            ctrY = current.x;
                            ctrZ = current.y;
                        }
                        currentValue = ctrX >= 0 && ctrX < xDimROI && ctrY >= 0 && ctrY < yDimROI && ctrZ >= 0 && ctrZ < zDimROI ? volData.getValue(ctrX, ctrY, ctrZ, ctrT) : 0.0;
                        if (max < currentValue) {
                            max = currentValue;
                            maxVoxel.xInt = ctrX;
                            maxVoxel.yInt = ctrY;
                            maxVoxel.zInt = ctrZ;
                            maxVoxel.seriesPoint = ctrT;
                        } else if (min > currentValue) {
                            min = currentValue;
                            minVoxel.xInt = ctrX;
                            minVoxel.yInt = ctrY;
                            minVoxel.zInt = ctrZ;
                            minVoxel.seriesPoint = ctrT;
                        }
                        currentABS = Math.abs(currentValue);
                        weightedSumX += currentABS * (double)ctrX;
                        weightedSumY += currentABS * (double)ctrY;
                        weightedSumZ += currentABS * (double)ctrZ;
                        weightedSumT += currentABS * (double)ctrT;
                        sum += currentValue;
                        comSum += currentABS;
                        sumSquared += MathUtilities.pow((double)currentValue, (double)2.0);
                        numPoints += 1.0;
                    }
                }
                current.setLocation(destination);
                if (sliceDirection == 0) {
                    ctrX = current.x;
                    ctrY = current.y;
                    ctrZ = slice;
                } else if (sliceDirection == 1) {
                    ctrX = current.x;
                    ctrY = slice;
                    ctrZ = current.y;
                } else {
                    ctrX = slice;
                    ctrY = current.x;
                    ctrZ = current.y;
                }
                currentValue = ctrX >= 0 && ctrX < xDimROI && ctrY >= 0 && ctrY < yDimROI && ctrZ >= 0 && ctrZ < zDimROI ? volData.getValue(ctrX, ctrY, ctrZ, ctrT) : 0.0;
                if (max < currentValue) {
                    max = currentValue;
                    maxVoxel.xInt = ctrX;
                    maxVoxel.yInt = ctrY;
                    maxVoxel.zInt = ctrZ;
                    maxVoxel.seriesPoint = ctrT;
                } else if (min > currentValue) {
                    min = currentValue;
                    minVoxel.xInt = ctrX;
                    minVoxel.yInt = ctrY;
                    minVoxel.zInt = ctrZ;
                    minVoxel.seriesPoint = ctrT;
                }
                currentABS = Math.abs(currentValue);
                weightedSumX += currentABS * (double)ctrX;
                weightedSumY += currentABS * (double)ctrY;
                weightedSumZ += currentABS * (double)ctrZ;
                weightedSumT += currentABS * (double)ctrT;
                sum += currentValue;
                comSum += currentABS;
                sumSquared += MathUtilities.pow((double)currentValue, (double)2.0);
                numPoints += 1.0;
                previous.setLocation(destination);
                it.next();
            }
        }
        centerOfMass.setValues(weightedSumX / comSum, weightedSumY / comSum, weightedSumZ / comSum, (int)Math.round(weightedSumT / comSum));
        com = volData.getValue(centerOfMass.xInt, centerOfMass.yInt, centerOfMass.zInt, centerOfMass.seriesPoint);
        mean = sum / numPoints;
        stdev = Math.sqrt((numPoints * sumSquared - MathUtilities.pow((double)sum, (double)2.0)) / (numPoints * (numPoints - 1.0)));
        size = sliceDirection == 0 ? loi.getLength(this.volumeManager.getBaseVolume().getXSize(), this.volumeManager.getBaseVolume().getYSize()) * (double)numTimepoints : (sliceDirection == 1 ? loi.getLength(this.volumeManager.getBaseVolume().getXSize(), this.volumeManager.getBaseVolume().getZSize()) * (double)numTimepoints : loi.getLength(this.volumeManager.getBaseVolume().getYSize(), this.volumeManager.getBaseVolume().getZSize()) * (double)numTimepoints);
        AnalysisImpl stats = new AnalysisImpl(mean, min, max, sum, stdev, (int)numPoints);
        stats.setMaxCoordinate(maxVoxel);
        stats.setMinCoordinate(minVoxel);
        stats.setCentroid(com);
        stats.setCentroidCoordinate(centerOfMass);
        stats.setType(4);
        stats.setRoiIndex(color, this.roi.getMaximumColors());
        stats.setSliceDirection(-1);
        stats.setSliceNum(-1);
        stats.setUnitSize(1.0);
        stats.setRegionSize(size);
        stats.setName(this.volumeManager.getName((ImageVolume)this.volume));
        String des = loi.getLabel(false);
        if (StringUtils.isBlank((CharSequence)des)) {
            des = "ROI Line";
        }
        stats.setDescription(des);
        return stats;
    }
}

