/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.range;

import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.operations.Operation;
import edu.uthscsa.ric.volume.operations.range.Range;
import java.util.List;

public class VolumeRangeOp
implements Operation<Range> {
    protected final VolumeManager volumeManager;
    protected final Volume volume;

    public VolumeRangeOp(VolumeManager volumeManager, Volume volume) {
        this.volumeManager = volumeManager;
        this.volume = volume;
    }

    @Override
    public Range process(ImageBounds bounds) {
        int xMin = bounds.getMinX();
        int xMax = bounds.getMaxX();
        int yMin = bounds.getMinY();
        int yMax = bounds.getMaxY();
        int zMin = bounds.getMinZ();
        int zMax = bounds.getMaxZ();
        int tMin = bounds.getMinT();
        int tMax = bounds.getMaxT();
        VolumeData volData = new VolumeData(this.volumeManager, this.volume);
        double max = 0.0;
        double min = 0.0;
        boolean possibleBinaryValues = true;
        boolean notInitialized = true;
        int minOffset = 0;
        int maxOffset = 0;
        for (int ctrT = tMin; ctrT <= tMax; ++ctrT) {
            for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
                for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                    for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                        double current = volData.getValue(ctrX, ctrY, ctrZ, ctrT);
                        if (Double.isNaN(current) || Double.isInfinite(current)) continue;
                        if (notInitialized) {
                            notInitialized = false;
                            min = current;
                            max = current;
                            maxOffset = minOffset = volData.getOffsetAt(ctrX, ctrY, ctrZ, ctrT);
                        }
                        if (max < current) {
                            max = current;
                            maxOffset = volData.getOffsetAt(ctrX, ctrY, ctrZ, ctrT);
                        } else if (min > current) {
                            min = current;
                            minOffset = volData.getOffsetAt(ctrX, ctrY, ctrZ, ctrT);
                        }
                        if (current == min || current == max) continue;
                        possibleBinaryValues = false;
                    }
                }
            }
        }
        Range range = new Range(min, max);
        range.setBinary(possibleBinaryValues);
        range.setMaxOffset(maxOffset);
        range.setMinOffset(minOffset);
        return range;
    }

    @Override
    public Range accumulate(List<Range> results) {
        double max = 0.0;
        double min = 0.0;
        boolean notInitialized = true;
        boolean binary = true;
        int minOffset = 0;
        int maxOffset = 0;
        for (Range range : results) {
            if (notInitialized) {
                notInitialized = false;
                min = range.getMin();
                max = range.getMax();
                minOffset = range.getMinOffset();
                maxOffset = range.getMaxOffset();
                binary = range.isBinary();
                continue;
            }
            if (max < range.getMax()) {
                max = range.getMax();
                maxOffset = range.getMaxOffset();
            } else if (min > range.getMin()) {
                min = range.getMin();
                minOffset = range.getMinOffset();
            }
            binary &= range.isBinary();
        }
        Range range = new Range(min, max);
        range.setBinary(binary);
        range.setMaxOffset(maxOffset);
        range.setMinOffset(minOffset);
        return range;
    }

    @Override
    public ImageBounds getSectionBounds(int index) {
        ImageVolume volumeBase = this.volumeManager.getBaseVolume();
        int xDim = volumeBase.getXDim();
        int yDim = volumeBase.getYDim();
        int zDim = volumeBase.getZDim();
        ImageBounds bounds = null;
        if (index == 0) {
            bounds = new ImageBounds(0, xDim / 2 - 1, 0, yDim / 2 - 1, 0, zDim / 2 - 1);
        } else if (index == 1) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, 0, yDim / 2 - 1, 0, zDim / 2 - 1);
        } else if (index == 2) {
            bounds = new ImageBounds(0, xDim / 2 - 1, yDim / 2, yDim - 1, 0, zDim / 2 - 1);
        } else if (index == 3) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, yDim / 2, yDim - 1, 0, zDim / 2 - 1);
        } else if (index == 4) {
            bounds = new ImageBounds(0, xDim / 2 - 1, 0, yDim / 2 - 1, zDim / 2, zDim - 1);
        } else if (index == 5) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, 0, yDim / 2 - 1, zDim / 2, zDim - 1);
        } else if (index == 6) {
            bounds = new ImageBounds(0, xDim / 2 - 1, yDim / 2, yDim - 1, zDim / 2, zDim - 1);
        } else if (index == 7) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, yDim / 2, yDim - 1, zDim / 2, zDim - 1);
        }
        if (bounds != null) {
            bounds.setRangeT(volumeBase.getCurrentSeriesPoint(), volumeBase.getCurrentSeriesPoint());
        }
        return bounds;
    }

    @Override
    public boolean testProcessValidity() {
        return true;
    }
}

