/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.histogram;

import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.volume.Histogram;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.VolumeROI;
import edu.uthscsa.ric.volume.operations.Operation;
import edu.uthscsa.ric.volume.operations.histogram.AnalysisHistogramImpl;
import edu.uthscsa.ric.volume.operations.histogram.HistogramOp;

public class HistogramROIOp
extends HistogramOp
implements Operation<Histogram> {
    private final VolumeROI roi;
    private final long selectedROIs;

    public HistogramROIOp(VolumeManager volumeManager, Volume volume, VolumeROI roi, long selectedROIs, AnalysisHistogramImpl histogram) {
        super(volumeManager, volume, histogram);
        this.roi = roi;
        this.selectedROIs = selectedROIs;
    }

    @Override
    public Histogram process(ImageBounds bounds) {
        double binHalf;
        double binSize;
        AnalysisHistogramImpl histogram = new AnalysisHistogramImpl(this.stat.getNumBins(), this.stat.getMin(), this.stat.getMax());
        histogram.setExcludeZero(this.stat.isExcludeZero());
        histogram.setIntegerMode(this.stat.isIntegerMode());
        int xMin = bounds.getMinX();
        int xMax = bounds.getMaxX();
        int yMin = bounds.getMinY();
        int yMax = bounds.getMaxY();
        int zMin = bounds.getMinZ();
        int zMax = bounds.getMaxZ();
        VolumeData volData = new VolumeData(this.volumeManager, this.volume);
        int xDimROI = this.volumeManager.getBaseVolume().getXDim() + 1;
        int yDimROI = this.volumeManager.getBaseVolume().getYDim() + 1;
        int numBins = histogram.getNumBins();
        int[] bins = histogram.getBinCounts();
        double min = histogram.getMin();
        double max = histogram.getMax();
        double[] binMins = histogram.getBinRangeMinimums();
        double[] binMaxs = histogram.getBinRangeMaximums();
        if (histogram.isIntegerMode()) {
            double precision = this.volume.getImageRange().getDataScaleSlopes()[0];
            binSize = ((max - min) / precision + 1.0) * precision / (double)numBins;
            binHalf = precision / 2.0;
        } else {
            binSize = (max - min) / (double)numBins;
            binHalf = 0.0;
        }
        for (int ctr = 0; ctr < numBins; ++ctr) {
            binMins[ctr] = (double)ctr * binSize + min - binHalf;
            binMaxs[ctr] = (double)(ctr + 1) * binSize + min - binHalf;
        }
        double binMultiplier = 1.0 / binSize;
        for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
            int roiOffsetZ = xDimROI * yDimROI * ctrZ;
            for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                int roiOffsetY = xDimROI * ctrY;
                for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                    int index;
                    double current;
                    long roiIndex = this.roi.getCurrent(ctrX + roiOffsetY + roiOffsetZ);
                    if ((roiIndex & this.selectedROIs) == 0L || !((current = volData.getValue(ctrX, ctrY, ctrZ)) >= min) || !(current < max) || histogram.isExcludeZero() && !(Math.abs(current) > 1.0E-10) || (index = (int)((current - min) * binMultiplier)) < 0 || index >= bins.length) continue;
                    int n = index;
                    bins[n] = bins[n] + 1;
                }
            }
        }
        return histogram;
    }
}

