/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.filter;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.volume.operations.calculation.ImageOperationTreeNode;
import edu.uthscsa.ric.volume.operations.filter.AbstractFilter;
import edu.uthscsa.ric.volume.operations.filter.FilterBuffer;
import edu.uthscsa.ric.volume.operations.filter.FilterSlice;
import java.nio.FloatBuffer;

public class FilterVolume
extends AbstractFilter
implements Cloneable,
Comparable<Object> {
    private FilterSlice sliceFilter;
    private String formula;
    private String formulaSlice;
    private float[] kernelSlice;
    private float[][][] kernel3D;
    public static final String TYPE_STRING = "VOLUME";
    public static final int NUM_DIMENSIONS = 2;

    public FilterVolume(String aName, String aFormula1, String aFormula2, String aFormula3, int size, boolean norm) {
        super(aName, norm);
        this.sliceFilter = new FilterSlice(aName, aFormula1, aFormula2, size, norm);
        this.formulaSlice = aFormula3;
        this.makeValues(size);
    }

    protected FilterVolume(String aName, float[] kernel1, float[] kernel2, float[] kernel3, boolean norm) {
        super(aName, norm);
        this.sliceFilter = new FilterSlice(aName, kernel1, kernel2, norm);
        this.kernelSlice = kernel3;
    }

    protected FilterVolume(String aName, float[][][] kernel, boolean norm) {
        super(aName, norm);
        this.kernel3D = kernel;
    }

    protected FilterVolume(String aName, String aFormula, int size, boolean norm) {
        super(aName, norm);
        this.formula = aFormula;
        this.makeValues(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filter(FilterBuffer filterBuffer) {
        int rowOffsetGetting = 0;
        int rowKernel = 0;
        int sliceKernel = 0;
        int slicePosBuf = 0;
        int kernelSize = 0;
        int colPos = 0;
        int rowPos = 0;
        int slicePos = 0;
        int offset = 0;
        int sliceOffsetPutting = 0;
        int sliceOffsetGetting = 0;
        int sliceSize = filterBuffer.sliceSize;
        float[][] bufferVolume = null;
        float[] first = filterBuffer.bufferFirst;
        float minimum = (float)filterBuffer.getIntercept();
        ProgressMeter pb = this.volumeManager.makeProgressMeter();
        pb.setDescription("Filtering Image");
        try {
            if (this.kernel3D != null) {
                int halfLength = this.kernel3D.length / 2;
                if (this.kernel3D.length > filterBuffer.bufferVolume.length) {
                    filterBuffer.bufferVolume = new float[this.kernel3D.length][filterBuffer.sliceSize];
                    bufferVolume = filterBuffer.bufferVolume;
                } else {
                    bufferVolume = filterBuffer.bufferVolume;
                }
                kernelSize = this.kernel3D.length;
                pb.start(0, 0, this.slices * this.timepoints, true);
                pb.setDescription("Filtering Volume");
                for (int ctrT = 0; ctrT < this.timepoints; ++ctrT) {
                    int ctrSlices;
                    FloatBuffer workBuffer = filterBuffer.getWorkBuffer(ctrT, this.timepoints);
                    int numSlicesToPrime = Math.min(halfLength, this.slices);
                    for (ctrSlices = 0; ctrSlices < numSlicesToPrime; ++ctrSlices) {
                        offset = ctrSlices * sliceSize;
                        workBuffer.position(offset);
                        workBuffer.get(bufferVolume[ctrSlices]);
                    }
                    for (ctrSlices = 0; ctrSlices < this.slices; ++ctrSlices) {
                        if (ctrSlices + halfLength < this.slices) {
                            offset = (ctrSlices + halfLength) * sliceSize;
                            workBuffer.position(offset);
                            workBuffer.get(bufferVolume[(ctrSlices + halfLength) % kernelSize]);
                        }
                        for (int ctrRows = 0; ctrRows < this.rows; ++ctrRows) {
                            for (int ctrCols = 0; ctrCols < this.cols; ++ctrCols) {
                                sliceOffsetPutting = ctrRows * this.cols + ctrCols;
                                first[ctrRows * this.cols + ctrCols] = 0.0f;
                                for (int ctrKSlices = -halfLength; ctrKSlices <= halfLength; ++ctrKSlices) {
                                    slicePos = ctrSlices + ctrKSlices;
                                    slicePosBuf = slicePos % kernelSize;
                                    sliceKernel = ctrKSlices + halfLength;
                                    for (int ctrKRows = -halfLength; ctrKRows <= halfLength; ++ctrKRows) {
                                        rowPos = ctrRows + ctrKRows;
                                        rowKernel = ctrKRows + halfLength;
                                        rowOffsetGetting = rowPos * this.cols;
                                        for (int ctrKCols = -halfLength; ctrKCols <= halfLength; ++ctrKCols) {
                                            colPos = ctrCols + ctrKCols;
                                            if (slicePos >= 0 && slicePos < this.slices && rowPos >= 0 && rowPos < this.rows && colPos >= 0 && colPos < this.cols) {
                                                sliceOffsetGetting = rowOffsetGetting + colPos;
                                                int n = sliceOffsetPutting;
                                                first[n] = first[n] + this.kernel3D[sliceKernel][rowKernel][ctrKCols + halfLength] * bufferVolume[slicePosBuf][sliceOffsetGetting];
                                                continue;
                                            }
                                            int n = sliceOffsetPutting;
                                            first[n] = first[n] + this.kernel3D[sliceKernel][rowKernel][ctrKCols + halfLength] * minimum;
                                        }
                                    }
                                }
                            }
                        }
                        workBuffer.position(ctrSlices * sliceSize);
                        workBuffer.put(first);
                        pb.setValue(ctrT * this.slices + ctrSlices);
                    }
                }
            } else {
                this.sliceFilter.filter(filterBuffer);
                int halfLength = this.kernelSlice.length / 2;
                if (this.kernelSlice.length > filterBuffer.bufferVolume.length) {
                    filterBuffer.bufferVolume = new float[this.kernelSlice.length][filterBuffer.sliceSize];
                    bufferVolume = filterBuffer.bufferVolume;
                } else {
                    bufferVolume = filterBuffer.bufferVolume;
                }
                kernelSize = this.kernelSlice.length;
                pb.start(0, 0, this.slices * this.timepoints, true);
                pb.setDescription("Filtering Across Slices");
                for (int ctrT = 0; ctrT < this.timepoints; ++ctrT) {
                    int ctrSlices;
                    FloatBuffer workBuffer = filterBuffer.getWorkBuffer(ctrT, this.timepoints);
                    int numSlicesToPrime = Math.min(halfLength, this.slices);
                    for (ctrSlices = 0; ctrSlices < numSlicesToPrime; ++ctrSlices) {
                        offset = ctrSlices * sliceSize;
                        workBuffer.position(offset);
                        workBuffer.get(bufferVolume[ctrSlices]);
                    }
                    for (ctrSlices = 0; ctrSlices < this.slices; ++ctrSlices) {
                        if (ctrSlices + halfLength < this.slices) {
                            offset = (ctrSlices + halfLength) * sliceSize;
                            workBuffer.position(offset);
                            workBuffer.get(bufferVolume[(ctrSlices + halfLength) % kernelSize]);
                        }
                        for (int ctrRows = 0; ctrRows < this.rows; ++ctrRows) {
                            for (int ctrCols = 0; ctrCols < this.cols; ++ctrCols) {
                                sliceOffsetPutting = ctrRows * this.cols + ctrCols;
                                first[ctrRows * this.cols + ctrCols] = 0.0f;
                                for (int ctrKSlices = -halfLength; ctrKSlices <= halfLength; ++ctrKSlices) {
                                    slicePos = ctrSlices + ctrKSlices;
                                    slicePosBuf = slicePos % kernelSize;
                                    if (slicePos >= 0 && slicePos < this.slices) {
                                        int n = sliceOffsetPutting;
                                        first[n] = first[n] + FilterVolume.getWeight(ctrSlices, this.slices, this.kernelSlice, ctrKSlices + halfLength) * bufferVolume[slicePosBuf][sliceOffsetPutting];
                                        continue;
                                    }
                                    int n = sliceOffsetPutting;
                                    first[n] = first[n] + FilterVolume.getWeight(ctrSlices, this.slices, this.kernelSlice, ctrKSlices + halfLength) * minimum;
                                }
                            }
                        }
                        workBuffer.position(ctrSlices * sliceSize);
                        workBuffer.put(first);
                        pb.setValue(ctrT * this.slices + ctrSlices);
                    }
                }
            }
        }
        finally {
            pb.setValue(pb.getMax());
        }
    }

    @Override
    public Object getFullFilterArray() {
        float[][][] array = null;
        if (this.kernel3D != null) {
            int size = this.kernel3D.length;
            array = new float[size][size][size];
            for (int ctrSlices = 0; ctrSlices < size; ++ctrSlices) {
                for (int ctrRow = 0; ctrRow < size; ++ctrRow) {
                    for (int ctrCol = 0; ctrCol < size; ++ctrCol) {
                        array[ctrSlices][ctrRow][ctrCol] = this.kernel3D[ctrSlices][ctrRow][ctrCol];
                    }
                }
            }
        } else {
            int size = this.kernelSlice.length;
            array = new float[size][size][size];
            float[] kernelRow = this.sliceFilter.getRowFilterArray();
            float[] kernelCol = this.sliceFilter.getColFilterArray();
            for (int ctrSlices = 0; ctrSlices < size; ++ctrSlices) {
                for (int ctrRow = 0; ctrRow < size; ++ctrRow) {
                    for (int ctrCol = 0; ctrCol < size; ++ctrCol) {
                        array[ctrSlices][ctrRow][ctrCol] = this.kernelSlice[ctrSlices] * kernelRow[ctrCol] * kernelCol[ctrRow];
                    }
                }
            }
        }
        return array;
    }

    @Override
    public int getNumDimensions() {
        return 2;
    }

    @Override
    public int getSize() {
        int size = 0;
        size = this.kernel3D != null ? this.kernel3D.length : this.kernelSlice.length;
        return size;
    }

    public FilterSlice getSliceFilter() {
        return this.sliceFilter;
    }

    @Override
    public String getStringFormattedFilter() {
        String string = "";
        if (this.formula != null) {
            string = "(" + this.formula + ")";
        } else if (this.formulaSlice != null) {
            string = this.sliceFilter.getStringFormattedFilter() + " | (" + this.formulaSlice + ")";
        } else if (this.kernel3D != null) {
            StringBuffer sb = new StringBuffer();
            int size = this.kernel3D.length;
            for (int ctrSlices = 0; ctrSlices < size; ++ctrSlices) {
                for (int ctrRow = 0; ctrRow < size; ++ctrRow) {
                    for (int ctrCol = 0; ctrCol < size; ++ctrCol) {
                        sb.append(FORMATTER.format(this.kernel3D[ctrSlices][ctrRow][ctrCol]));
                        sb.append(' ');
                    }
                }
            }
            string = "(" + sb.toString().trim() + ")";
        } else {
            StringBuffer sbStringSlice = new StringBuffer();
            int size = this.kernelSlice.length;
            for (int ctr = 0; ctr < size; ++ctr) {
                sbStringSlice.append(FORMATTER.format(this.kernelSlice[ctr]));
                sbStringSlice.append(' ');
            }
            String stringSlice = "(" + sbStringSlice.toString().trim() + ")";
            string = this.sliceFilter.getStringFormattedFilter() + " | " + stringSlice;
        }
        return string;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public String getTypeAsString() {
        return TYPE_STRING;
    }

    @Override
    public boolean isFormula() {
        return this.formula != null || this.formulaSlice != null;
    }

    @Override
    public boolean isSeparable() {
        return this.kernel3D == null;
    }

    @Override
    public void normalize() {
        double sum = 0.0;
        if (this.kernel3D != null) {
            int ctrCol;
            int ctrRow;
            int ctrSlices;
            int size = this.kernel3D.length;
            for (ctrSlices = 0; ctrSlices < size; ++ctrSlices) {
                for (ctrRow = 0; ctrRow < size; ++ctrRow) {
                    for (ctrCol = 0; ctrCol < size; ++ctrCol) {
                        sum += (double)this.kernel3D[ctrSlices][ctrRow][ctrCol];
                    }
                }
            }
            if (sum != 0.0) {
                for (ctrSlices = 0; ctrSlices < size; ++ctrSlices) {
                    for (ctrRow = 0; ctrRow < size; ++ctrRow) {
                        ctrCol = 0;
                        while (ctrCol < size) {
                            float[] fArray = this.kernel3D[ctrSlices][ctrRow];
                            int n = ctrCol++;
                            fArray[n] = (float)((double)fArray[n] / sum);
                        }
                    }
                }
            }
        } else {
            int ctr;
            int size = this.kernelSlice.length;
            for (ctr = 0; ctr < size; ++ctr) {
                sum += (double)this.kernelSlice[ctr];
            }
            if (sum != 0.0) {
                ctr = 0;
                while (ctr < size) {
                    int n = ctr++;
                    this.kernelSlice[n] = (float)((double)this.kernelSlice[n] / sum);
                }
            }
            this.sliceFilter.normalize();
        }
    }

    @Override
    public void setBounds(int aCols, int aRows, int aSlices, int aTimepoints) {
        super.setBounds(aCols, aRows, aSlices, aTimepoints);
        if (this.sliceFilter != null) {
            this.sliceFilter.setBounds(this.cols, this.rows, this.slices, this.timepoints);
        }
    }

    @Override
    public void setUser(VolumeManager aUser) {
        this.volumeManager = aUser;
        if (this.sliceFilter != null) {
            this.sliceFilter.setUser(aUser);
        }
    }

    private void makeValues(int size) {
        int halfSize = size / 2;
        if (this.formula != null) {
            StringBuffer operationString = new StringBuffer(this.formula);
            double[] parsedValues = ImageOperationTreeNode.makeReplacements(operationString);
            ImageOperationTreeNode startNode = ImageOperationTreeNode.makeOperationTree(operationString.toString(), parsedValues, null, null);
            this.kernel3D = new float[size][size][size];
            for (int ctrS = -halfSize; ctrS <= halfSize; ++ctrS) {
                for (int ctrR = -halfSize; ctrR <= halfSize; ++ctrR) {
                    for (int ctrC = -halfSize; ctrC <= halfSize; ++ctrC) {
                        this.kernel3D[ctrS + halfSize][ctrR + halfSize][ctrC + halfSize] = (float)startNode.getLookupTableResultAtIndex(ctrC, ctrR, ctrS, 0);
                    }
                }
            }
        } else {
            StringBuffer operationString = new StringBuffer(this.formulaSlice);
            double[] parsedValues = ImageOperationTreeNode.makeReplacements(operationString);
            ImageOperationTreeNode startNode = ImageOperationTreeNode.makeOperationTree(operationString.toString(), parsedValues, null, null);
            this.kernelSlice = new float[size];
            for (int ctr = -halfSize; ctr <= halfSize; ++ctr) {
                this.kernelSlice[ctr + halfSize] = (float)startNode.getLookupTableResultAtIndex(0, 0, ctr, 0);
            }
            this.sliceFilter.makeValues(size);
        }
    }
}

