/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.filter;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.volume.operations.calculation.ImageOperationTreeNode;
import edu.uthscsa.ric.volume.operations.filter.AbstractFilter;
import edu.uthscsa.ric.volume.operations.filter.FilterBuffer;
import java.nio.FloatBuffer;

public class FilterTime
extends AbstractFilter
implements Cloneable,
Comparable<Object> {
    private String formula;
    private float[] kernel;
    public static final String TYPE_STRING = "TIME";
    public static final int NUM_DIMENSIONS = 1;

    protected FilterTime(String aName, float[] aKernel, boolean norm) {
        super(aName, norm);
        this.kernel = aKernel;
    }

    protected FilterTime(String aName, String aFormula, int size, boolean norm) {
        super(aName, norm);
        this.formula = aFormula;
        this.makeValues(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filter(FilterBuffer filterBuffer) {
        float[] timeBuffer = new float[this.timepoints];
        float temp = 0.0f;
        int volSize = this.cols * this.rows * this.slices;
        int offset = 0;
        int offsetSlices = 0;
        int offsetVol = 0;
        int offsetRows = 0;
        int timePos = 0;
        int halfLength = this.kernel.length / 2;
        ProgressMeter pb = this.volumeManager.makeProgressMeter();
        pb.setDescription("Filtering Image");
        try {
            pb.start(0, 0, volSize, true);
            pb.setDescription("Filtering Across Time");
            for (int ctrSlices = 0; ctrSlices < this.slices; ++ctrSlices) {
                offsetSlices = this.cols * this.rows * ctrSlices;
                for (int ctrRows = 0; ctrRows < this.rows; ++ctrRows) {
                    offsetRows = this.cols * ctrRows;
                    for (int ctrCols = 0; ctrCols < this.cols; ++ctrCols) {
                        FloatBuffer workBuffer;
                        int ctrT;
                        offsetVol = offsetSlices + offsetRows + ctrCols;
                        for (ctrT = 0; ctrT < this.timepoints; ++ctrT) {
                            workBuffer = filterBuffer.getWorkBuffer(ctrT, this.timepoints);
                            offset = offsetVol;
                            timeBuffer[ctrT] = workBuffer.get(offset);
                        }
                        for (ctrT = 0; ctrT < this.timepoints; ++ctrT) {
                            workBuffer = filterBuffer.getWorkBuffer(ctrT, this.timepoints);
                            offset = offsetVol;
                            temp = 0.0f;
                            for (int ctrK = -halfLength; ctrK <= halfLength; ++ctrK) {
                                timePos = ctrT + ctrK;
                                if (timePos < 0 || timePos >= this.timepoints) continue;
                                temp += FilterTime.getWeight(ctrT, this.timepoints, this.kernel, ctrK + halfLength) * timeBuffer[ctrT + ctrK];
                            }
                            workBuffer.put(offset, temp);
                        }
                        pb.setValue(offsetVol);
                    }
                }
            }
        }
        finally {
            pb.setValue(pb.getMax());
        }
    }

    @Override
    public Object getFullFilterArray() {
        float[] array = null;
        int size = this.kernel.length;
        array = new float[size];
        for (int ctr = 0; ctr < size; ++ctr) {
            array[ctr] = this.kernel[ctr];
        }
        return array;
    }

    @Override
    public int getNumDimensions() {
        return 1;
    }

    @Override
    public int getSize() {
        return this.kernel.length;
    }

    @Override
    public String getStringFormattedFilter() {
        StringBuffer sb = new StringBuffer();
        String string = null;
        if (this.formula != null) {
            sb.append("(" + this.formula + ")");
            string = sb.toString();
        } else if (this.kernel != null) {
            int size = this.kernel.length;
            for (int ctr = 0; ctr < size; ++ctr) {
                sb.append(FORMATTER.format(this.kernel[ctr]));
                sb.append(' ');
            }
            string = "(" + sb.toString().trim() + ")";
        }
        return string;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getTypeAsString() {
        return TYPE_STRING;
    }

    @Override
    public boolean isFormula() {
        return this.formula != null;
    }

    @Override
    public boolean isSeparable() {
        return false;
    }

    @Override
    public void normalize() {
        int ctr;
        double sum = 0.0;
        int size = this.kernel.length;
        for (ctr = 0; ctr < size; ++ctr) {
            sum += (double)this.kernel[ctr];
        }
        if (sum != 0.0) {
            ctr = 0;
            while (ctr < size) {
                int n = ctr++;
                this.kernel[n] = (float)((double)this.kernel[n] / sum);
            }
        }
    }

    private void makeValues(int size) {
        int halfSize = size / 2;
        StringBuffer operationString = new StringBuffer(this.formula);
        double[] parsedValues = ImageOperationTreeNode.makeReplacements(operationString);
        ImageOperationTreeNode startNode = ImageOperationTreeNode.makeOperationTree(operationString.toString(), parsedValues, null, null);
        this.kernel = new float[size];
        for (int ctr = -halfSize; ctr <= halfSize; ++ctr) {
            this.kernel[ctr + halfSize] = (float)startNode.getLookupTableResultAtIndex(0, 0, 0, ctr);
        }
    }
}

