/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.filter;

import edu.uthscsa.ric.utilities.RankSearch;
import edu.uthscsa.ric.volume.operations.filter.AbstractFilterRank;
import edu.uthscsa.ric.volume.operations.filter.FilterBuffer;
import java.nio.FloatBuffer;

public class FilterRankTime
extends AbstractFilterRank
implements Cloneable {
    public FilterRankTime(int type, int size) {
        super(type, size);
    }

    @Override
    public void filter(FilterBuffer filterBuffer) {
        float[] timeBuffer = new float[this.timepoints];
        float temp = 0.0f;
        int offset = 0;
        int offsetSlices = 0;
        int offsetVol = 0;
        int offsetRows = 0;
        int timePos = 0;
        int halfLength = this.size / 2;
        float minimum = (float)filterBuffer.getIntercept();
        boolean isMedian = (this.type & 2) == 2;
        boolean isMax = (this.type & 4) == 4;
        boolean isMin = (this.type & 1) == 1;
        float[] sort = new float[this.size];
        int medianStartIndex = this.size / 2 + 2;
        if (this.pb != null) {
            this.pb.start(0, 0, this.cols * this.rows * this.slices);
            this.pb.setDescription("Filtering Across Time");
        }
        for (int ctrSlices = 0; ctrSlices < this.slices; ++ctrSlices) {
            offsetSlices = this.cols * this.rows * ctrSlices;
            for (int ctrRows = 0; ctrRows < this.rows; ++ctrRows) {
                offsetRows = this.cols * ctrRows;
                for (int ctrCols = 0; ctrCols < this.cols; ++ctrCols) {
                    FloatBuffer workBuffer;
                    int ctrT;
                    offsetVol = offsetSlices + offsetRows + ctrCols;
                    for (ctrT = 0; ctrT < this.timepoints; ++ctrT) {
                        workBuffer = filterBuffer.getWorkBuffer(ctrT, this.timepoints);
                        offset = offsetVol;
                        timeBuffer[ctrT] = workBuffer.get(offset);
                    }
                    for (ctrT = 0; ctrT < this.timepoints; ++ctrT) {
                        workBuffer = filterBuffer.getWorkBuffer(ctrT, this.timepoints);
                        offset = offsetVol;
                        for (int ctrK = -halfLength; ctrK <= halfLength; ++ctrK) {
                            timePos = ctrT + ctrK;
                            sort[ctrK + halfLength] = timePos >= 0 && timePos < this.timepoints ? timeBuffer[ctrT + ctrK] : minimum;
                        }
                        temp = isMedian ? RankSearch.searchMedian((float[])sort, (int)medianStartIndex, (boolean)true) : (isMax ? RankSearch.searchMax((float[])sort) : (isMin ? RankSearch.searchMin((float[])sort) : 0.0f));
                        workBuffer.put(offset, temp);
                    }
                    if (this.pb == null) continue;
                    this.pb.setValue(offsetVol);
                }
            }
        }
        if (this.pb != null) {
            this.pb.setValue(this.pb.getMax());
        }
    }

    @Override
    public String toString() {
        return "Time " + super.toString();
    }

    @Override
    public int getFilterType() {
        return 1;
    }
}

