/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.filter;

import edu.uthscsa.ric.utilities.RankSearch;
import edu.uthscsa.ric.volume.operations.filter.AbstractFilterRank;
import edu.uthscsa.ric.volume.operations.filter.FilterBuffer;
import java.nio.FloatBuffer;

public class FilterRankSlice
extends AbstractFilterRank
implements Cloneable {
    public FilterRankSlice(int type, int size) {
        super(type, size);
    }

    @Override
    public void filter(FilterBuffer filterBuffer) {
        float[] first = filterBuffer.bufferFirst;
        float[] second = filterBuffer.bufferSecond;
        int sliceSize = filterBuffer.sliceSize;
        int offset = 0;
        float minimum = (float)filterBuffer.getIntercept();
        if (this.pb != null) {
            this.pb.start(0, 0, this.slices * this.timepoints);
            this.pb.setDescription("Filtering Slices");
        }
        for (int ctrT = 0; ctrT < this.timepoints; ++ctrT) {
            FloatBuffer workBuffer = filterBuffer.getWorkBuffer(ctrT, this.timepoints);
            for (int ctr = 0; ctr < this.slices; ++ctr) {
                offset = ctr * sliceSize;
                workBuffer.position(offset);
                workBuffer.get(first);
                float[] filteredData = this.filterSlice(first, second, minimum);
                workBuffer.position(offset);
                workBuffer.put(filteredData);
                if (this.pb == null) continue;
                this.pb.setValue(ctrT * this.slices + ctr);
            }
        }
        if (this.pb != null) {
            this.pb.setValue(this.pb.getMax());
        }
    }

    @Override
    public String toString() {
        return "Slice " + super.toString();
    }

    private float[] filterSlice(float[] first, float[] second, float minimum) {
        int rowOffset = 0;
        int rowOffsetK = 0;
        int offset = 0;
        int colPos = 0;
        int rowPos = 0;
        int length = this.size;
        int halfLength = length / 2;
        boolean isMedian = (this.type & 2) == 2;
        boolean isMax = (this.type & 4) == 4;
        boolean isMin = (this.type & 1) == 1;
        int medianStartIndex = this.size * this.size / 2 + 2;
        float[] sort = new float[this.size * this.size];
        for (int ctrRows = 0; ctrRows < this.rows; ++ctrRows) {
            rowOffset = ctrRows * this.cols;
            for (int ctrCols = 0; ctrCols < this.cols; ++ctrCols) {
                offset = rowOffset + ctrCols;
                for (int ctrRowK = -halfLength; ctrRowK <= halfLength; ++ctrRowK) {
                    rowOffsetK = (ctrRowK + halfLength) * length;
                    for (int ctrColK = -halfLength; ctrColK <= halfLength; ++ctrColK) {
                        colPos = ctrCols + ctrColK;
                        rowPos = ctrRows + ctrRowK;
                        sort[rowOffsetK + (ctrColK + halfLength)] = colPos >= 0 && colPos < this.cols && rowPos >= 0 && rowPos < this.rows ? first[rowPos * this.cols + colPos] : minimum;
                    }
                }
                second[offset] = isMedian ? RankSearch.searchMedian((float[])sort, (int)medianStartIndex, (boolean)true) : (isMax ? RankSearch.searchMax((float[])sort) : (isMin ? RankSearch.searchMin((float[])sort) : 0.0f));
            }
        }
        return second;
    }

    @Override
    public int getFilterType() {
        return 2;
    }
}

