/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.operations.calculation;

import edu.uthscsa.ric.mango.MangoContext;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.roi.ROIData;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.MathUtilities;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.ImageBounds;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeData;
import edu.uthscsa.ric.volume.operations.Operation;
import edu.uthscsa.ric.volume.operations.calculation.ImageCalcExpression;
import edu.uthscsa.ric.volume.operations.calculation.ImageOperationTreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CalcOp
implements Operation<Void> {
    private List<Double> valueList;
    private List<VolumeManager> managerList;
    private String preparedInput;
    private final ImageCalcExpression expression;
    private final MangoContext context;
    private final VolumeManager volumeManager;
    private Map<Integer, Analysis> roiStatsHolder;

    public CalcOp(MangoContext context, VolumeManager volumeManager, ImageCalcExpression expression) {
        this.context = context;
        this.volumeManager = volumeManager;
        this.expression = expression;
    }

    @Override
    public Void accumulate(List<Void> results) {
        return null;
    }

    @Override
    public ImageBounds getSectionBounds(int index) {
        ImageVolume volumeBase = this.volumeManager.getBaseVolume();
        int xDim = volumeBase.getXDim();
        int yDim = volumeBase.getYDim();
        int zDim = volumeBase.getZDim();
        ImageBounds bounds = null;
        if (index == 0) {
            bounds = new ImageBounds(0, xDim / 2 - 1, 0, yDim / 2 - 1, 0, zDim / 2 - 1);
        } else if (index == 1) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, 0, yDim / 2 - 1, 0, zDim / 2 - 1);
        } else if (index == 2) {
            bounds = new ImageBounds(0, xDim / 2 - 1, yDim / 2, yDim - 1, 0, zDim / 2 - 1);
        } else if (index == 3) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, yDim / 2, yDim - 1, 0, zDim / 2 - 1);
        } else if (index == 4) {
            bounds = new ImageBounds(0, xDim / 2 - 1, 0, yDim / 2 - 1, zDim / 2, zDim - 1);
        } else if (index == 5) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, 0, yDim / 2 - 1, zDim / 2, zDim - 1);
        } else if (index == 6) {
            bounds = new ImageBounds(0, xDim / 2 - 1, yDim / 2, yDim - 1, zDim / 2, zDim - 1);
        } else if (index == 7) {
            bounds = new ImageBounds(xDim / 2, xDim - 1, yDim / 2, yDim - 1, zDim / 2, zDim - 1);
        }
        if (bounds != null) {
            bounds.setRangeT(volumeBase.getCurrentSeriesPoint(), volumeBase.getCurrentSeriesPoint());
        }
        return bounds;
    }

    @Override
    public Void process(ImageBounds bounds) {
        ImageOperationTreeNode node = this.makeImageOperationTreeNode(this.preparedInput, this.managerList, this.volumeManager, this.valueList);
        node.setROIStatsHolder(this.roiStatsHolder);
        Volume volume = (Volume)this.volumeManager.getBaseVolume();
        VolumeData volData = new VolumeData(this.volumeManager);
        VolumeData volDataOriginating = new VolumeData(this.expression.getOriginatingManager());
        volume.setImageDirty(true);
        volume.setOperationInProgress(true);
        int imageDimX = volume.getXDim();
        int imageDimY = volume.getYDim();
        int imageDimZ = volume.getZDim();
        int roiDimX = imageDimX + 1;
        int roiDimY = imageDimY + 1;
        int sliceDirection = this.expression.getSliceDirection();
        boolean isOnlyROISlice = this.expression.isOnlyROISlices();
        boolean isAllTimepoints = this.expression.isAllSeriesPoints();
        boolean isInside = this.expression.getAreaSelection() == 2;
        boolean hasROI = this.expression.getAreaSelection() == 2 || this.expression.getAreaSelection() == 3;
        boolean currentSliceContainsROI = false;
        ROIData roi = this.expression.getOriginatingManager().getRoiData();
        boolean[] sliceContainsROI = null;
        if (isOnlyROISlice) {
            int ctr;
            if (sliceDirection == 0) {
                sliceContainsROI = new boolean[imageDimZ];
                for (ctr = 0; ctr < imageDimZ; ++ctr) {
                    sliceContainsROI[ctr] = roi.hasSelectedMaskInRange(0, imageDimX, 0, imageDimY, ctr, ctr);
                }
            } else if (sliceDirection == 1) {
                sliceContainsROI = new boolean[imageDimY];
                for (ctr = 0; ctr < imageDimY; ++ctr) {
                    sliceContainsROI[ctr] = roi.hasSelectedMaskInRange(0, imageDimX, ctr, ctr, 0, imageDimZ);
                }
            } else {
                sliceContainsROI = new boolean[imageDimX];
                for (ctr = 0; ctr < imageDimX; ++ctr) {
                    sliceContainsROI[ctr] = roi.hasSelectedMaskInRange(ctr, ctr, 0, imageDimY, 0, imageDimZ);
                }
            }
        }
        int xMin = bounds.getMinX();
        int xMax = bounds.getMaxX();
        int yMin = bounds.getMinY();
        int yMax = bounds.getMaxY();
        int zMin = bounds.getMinZ();
        int zMax = bounds.getMaxZ();
        int tMin = bounds.getMinT();
        int tMax = bounds.getMaxT();
        if (isAllTimepoints) {
            tMin = 0;
            tMax = volume.getNumTimepoints() - 1;
        } else {
            tMin = tMax = volume.getCurrentTimepoint();
        }
        for (int ctrT = tMin; ctrT <= tMax; ++ctrT) {
            for (int ctrZ = zMin; ctrZ <= zMax; ++ctrZ) {
                int roiOffsetZ = roiDimX * roiDimY * ctrZ;
                for (int ctrY = yMin; ctrY <= yMax; ++ctrY) {
                    int roiOffsetY = roiDimX * ctrY;
                    for (int ctrX = xMin; ctrX <= xMax; ++ctrX) {
                        int roiOffset = ctrX + roiOffsetY + roiOffsetZ;
                        if (isOnlyROISlice) {
                            if (sliceDirection == 0) {
                                currentSliceContainsROI = sliceContainsROI[ctrZ];
                            } else if (sliceDirection == 1) {
                                currentSliceContainsROI = sliceContainsROI[ctrY];
                            } else if (sliceDirection == 2) {
                                currentSliceContainsROI = sliceContainsROI[ctrX];
                            }
                        }
                        if (isOnlyROISlice && !currentSliceContainsROI) continue;
                        double result = node.getResultAtIndex(ctrX, ctrY, ctrZ, ctrT);
                        if (!hasROI || roi.isInsideSelectedMaskAtOffset(roiOffset) ^ !isInside) {
                            if (Double.isInfinite(result)) {
                                volData.putValue(ctrX, ctrY, ctrZ, ctrT, 0.0);
                                continue;
                            }
                            if (MathUtilities.essentiallyEqual((double)result, (double)Double.MAX_VALUE)) {
                                volData.putValue(ctrX, ctrY, ctrZ, ctrT, volDataOriginating.getValue(ctrX, ctrY, ctrZ, ctrT));
                                continue;
                            }
                            if (MathUtilities.essentiallyEqual((double)result, (double)Double.MIN_VALUE)) {
                                volData.putValue(ctrX, ctrY, ctrZ, ctrT, 0.0);
                                continue;
                            }
                            volData.putValue(ctrX, ctrY, ctrZ, ctrT, result);
                            continue;
                        }
                        volData.putValue(ctrX, ctrY, ctrZ, ctrT, volDataOriginating.getValue(ctrX, ctrY, ctrZ, ctrT));
                    }
                }
            }
        }
        volume.setOperationInProgress(false);
        return null;
    }

    @Override
    public boolean testProcessValidity() {
        if (this.validateImageOperationExpression(this.expression.getExpression())) {
            this.managerList = new ArrayList<VolumeManager>();
            this.valueList = new ArrayList<Double>();
            this.preparedInput = this.prepareImageOperationTreeNode(this.expression.getExpression(), this.managerList, this.expression.getOriginatingManager(), this.valueList);
            ImageOperationTreeNode testNode = this.makeImageOperationTreeNode(this.preparedInput, this.managerList, this.expression.getOriginatingManager(), this.valueList);
            this.roiStatsHolder = testNode.makeROIStatsHolder();
            if (this.validateImageOperationTreeNode(testNode)) {
                return true;
            }
        }
        return false;
    }

    private ImageOperationTreeNode makeImageOperationTreeNode(String preparedInput, List<VolumeManager> managerList, VolumeManager originatingManager, List<Double> valueList) {
        return ImageOperationTreeNode.makeOperationTree(preparedInput, CollectionUtilities.arrayDoubles(valueList), managerList.toArray(new VolumeManager[managerList.size()]), originatingManager);
    }

    private String prepareImageOperationTreeNode(String input, List<VolumeManager> managerList, VolumeManager originatingManager, List<Double> valueList) {
        double[] parsedValues;
        List currentManagers = this.context.getAllVolumeManagers();
        for (VolumeManager manager : currentManagers) {
            if (manager == originatingManager) continue;
            managerList.add(manager);
        }
        managerList.add(0, originatingManager);
        StringBuffer sb = new StringBuffer(input);
        for (double value : parsedValues = ImageOperationTreeNode.makeReplacements(sb, originatingManager)) {
            valueList.add(value);
        }
        return sb.toString();
    }

    private boolean validateImageOperationExpression(String input) {
        return ImageOperationTreeNode.hasValidParentheses(input);
    }

    private boolean validateImageOperationTreeNode(ImageOperationTreeNode node) {
        if (node == null) {
            return false;
        }
        return ImageOperationTreeNode.isValidStartNode(node);
    }
}

