/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.tiff;

import edu.uthscsa.ric.utilities.ByteUtilities;
import edu.uthscsa.ric.volume.formats.tiff.Rational;
import edu.uthscsa.ric.volume.formats.tiff.TIFF;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Tag {
    private final Object data;
    private final int code;
    private final int type;
    private final long numValues;

    protected static Object getData(int aCode, int aType, int aNumValues, byte[] aData, boolean isLittleEndian, RandomAccessFile fileReader) throws IOException {
        Object someData = null;
        if (aNumValues <= 0) {
            return someData;
        }
        if (aType == 1) {
            if (aNumValues == 1) {
                someData = Tag.getByte(aData, 0, true);
            } else if (aNumValues <= 4) {
                Integer[] array = new Integer[aNumValues];
                for (int ctr = 0; ctr < aNumValues; ++ctr) {
                    array[ctr] = Tag.getByte(aData, ctr, true);
                }
                someData = array;
            } else {
                Integer[] array = new Integer[aNumValues];
                byte[] readData = Tag.getData(aData, aNumValues, isLittleEndian, fileReader);
                for (int ctr = 0; ctr < aNumValues; ++ctr) {
                    array[ctr] = Tag.getByte(readData, ctr, true);
                }
                someData = array;
            }
        } else if (aType == 2) {
            if (aNumValues <= 4) {
                someData = new String(aData).trim();
            } else {
                byte[] readData = Tag.getData(aData, aNumValues, isLittleEndian, fileReader);
                someData = new String(readData).trim();
            }
        } else if (aType == 3) {
            if (aNumValues == 1) {
                someData = Tag.getShort(aData, 0, true, isLittleEndian);
            } else if (aNumValues == 2) {
                Integer[] array = new Integer[]{Tag.getShort(aData, 0, true, isLittleEndian), Tag.getShort(aData, 2, true, isLittleEndian)};
                someData = array;
            } else {
                Integer[] array = new Integer[aNumValues];
                byte[] readData = Tag.getData(aData, aNumValues * 2, isLittleEndian, fileReader);
                for (int ctr = 0; ctr < aNumValues; ++ctr) {
                    array[ctr] = Tag.getShort(readData, ctr * 2, true, isLittleEndian);
                }
                someData = array;
            }
        } else if (aType == 4) {
            if (aNumValues == 1) {
                someData = Tag.getInt(aData, 0, true, isLittleEndian);
            } else {
                Long[] array = new Long[aNumValues];
                byte[] readData = Tag.getData(aData, aNumValues * 4, isLittleEndian, fileReader);
                for (int ctr = 0; ctr < aNumValues; ++ctr) {
                    array[ctr] = Tag.getInt(readData, ctr * 4, true, isLittleEndian);
                }
                someData = array;
            }
        } else if (aType == 5) {
            if (aNumValues == 1) {
                byte[] readData = Tag.getData(aData, 8, isLittleEndian, fileReader);
                someData = Tag.getRational(readData, 0, true, isLittleEndian);
            } else {
                Rational[] array = new Rational[aNumValues];
                byte[] readData = Tag.getData(aData, aNumValues * 8, isLittleEndian, fileReader);
                for (int ctr = 0; ctr < aNumValues; ++ctr) {
                    array[ctr] = Tag.getRational(readData, ctr * 8, true, isLittleEndian);
                }
                someData = array;
            }
        } else if (aType == 6) {
            if (aNumValues == 1) {
                someData = Tag.getByte(aData, 0, false);
            } else if (aNumValues <= 4) {
                Integer[] array = new Integer[aNumValues];
                for (int ctr = 0; ctr < aNumValues; ++ctr) {
                    array[ctr] = Tag.getByte(aData, ctr, false);
                }
                someData = array;
            } else {
                Integer[] array = new Integer[aNumValues];
                byte[] readData = Tag.getData(aData, aNumValues, isLittleEndian, fileReader);
                for (int ctr = 0; ctr < aNumValues; ++ctr) {
                    array[ctr] = Tag.getByte(readData, ctr, false);
                }
                someData = array;
            }
        } else if (aType == 7) {
            if (aNumValues <= 4) {
                someData = new String(aData).trim();
            } else {
                byte[] readData = Tag.getData(aData, aNumValues, isLittleEndian, fileReader);
                someData = new String(readData).trim();
            }
        } else if (aType == 8) {
            if (aNumValues == 1) {
                someData = Tag.getShort(aData, 0, false, isLittleEndian);
            } else if (aNumValues == 2) {
                Integer[] array = new Integer[]{Tag.getShort(aData, 0, false, isLittleEndian), Tag.getShort(aData, 2, false, isLittleEndian)};
                someData = array;
            } else {
                Integer[] array = new Integer[aNumValues];
                byte[] readData = Tag.getData(aData, aNumValues * 2, isLittleEndian, fileReader);
                for (int ctr = 0; ctr < aNumValues; ++ctr) {
                    array[ctr] = Tag.getShort(readData, ctr * 2, false, isLittleEndian);
                }
                someData = array;
            }
        } else if (aType == 9) {
            if (aNumValues == 1) {
                someData = Tag.getInt(aData, 0, false, isLittleEndian);
            } else {
                Long[] array = new Long[aNumValues];
                byte[] readData = Tag.getData(aData, aNumValues * 4, isLittleEndian, fileReader);
                for (int ctr = 0; ctr < aNumValues; ++ctr) {
                    array[ctr] = Tag.getInt(readData, ctr * 4, false, isLittleEndian);
                }
                someData = array;
            }
        } else if (aType == 10) {
            if (aNumValues == 1) {
                byte[] readData = Tag.getData(aData, 8, isLittleEndian, fileReader);
                someData = Tag.getRational(readData, 0, false, isLittleEndian);
            } else {
                Rational[] array = new Rational[aNumValues];
                byte[] readData = Tag.getData(aData, aNumValues * 8, isLittleEndian, fileReader);
                for (int ctr = 0; ctr < aNumValues; ++ctr) {
                    array[ctr] = Tag.getRational(readData, ctr * 8, false, isLittleEndian);
                }
                someData = array;
            }
        } else if (aType == 11) {
            if (aNumValues == 1) {
                someData = Tag.getFloat(aData, 0, isLittleEndian);
            } else {
                Double[] array = new Double[aNumValues];
                byte[] readData = Tag.getData(aData, aNumValues * 4, isLittleEndian, fileReader);
                for (int ctr = 0; ctr < aNumValues; ++ctr) {
                    array[ctr] = Tag.getFloat(readData, ctr * 4, isLittleEndian);
                }
                someData = array;
            }
        } else if (aType == 12) {
            if (aNumValues == 1) {
                byte[] readData = Tag.getData(aData, 8, isLittleEndian, fileReader);
                someData = Tag.getDouble(readData, 0, isLittleEndian);
            } else {
                Double[] array = new Double[aNumValues];
                byte[] readData = Tag.getData(aData, aNumValues * 8, isLittleEndian, fileReader);
                for (int ctr = 0; ctr < aNumValues; ++ctr) {
                    array[ctr] = Tag.getDouble(readData, ctr * 8, isLittleEndian);
                }
                someData = array;
            }
        }
        return someData;
    }

    private static Integer getByte(byte[] aData, int index, boolean isUnsigned) {
        int value = aData[index];
        if (isUnsigned) {
            value &= 0xFF;
        }
        return value;
    }

    private static byte[] getData(byte[] aData, int bytesToRead, boolean isLittleEndian, RandomAccessFile fileReader) throws IOException {
        long offset = Tag.getOffset(aData, isLittleEndian);
        byte[] readData = new byte[bytesToRead];
        fileReader.seek(offset);
        fileReader.readFully(readData);
        return readData;
    }

    private static Double getDouble(byte[] aData, int index, boolean isLittleEndian) {
        byte[] someDataBytes = new byte[]{aData[index], aData[index + 1], aData[index + 2], aData[index + 3], aData[index + 4], aData[index + 5], aData[index + 6], aData[index + 7]};
        if (isLittleEndian) {
            someDataBytes = ByteUtilities.swap((byte[])someDataBytes);
        }
        return new Double(ByteUtilities.getDouble((byte[])someDataBytes, (int)0));
    }

    private static Double getFloat(byte[] aData, int index, boolean isLittleEndian) {
        byte[] someDataBytes = new byte[]{aData[index], aData[index + 1], aData[index + 2], aData[index + 3]};
        if (isLittleEndian) {
            someDataBytes = ByteUtilities.swap((byte[])someDataBytes);
        }
        return new Double(ByteUtilities.getFloat((byte[])someDataBytes, (int)0));
    }

    private static Long getInt(byte[] aData, int index, boolean isUnsigned, boolean isLittleEndian) {
        byte[] someDataBytes = new byte[]{aData[index], aData[index + 1], aData[index + 2], aData[index + 3]};
        if (isLittleEndian) {
            someDataBytes = ByteUtilities.swap((byte[])someDataBytes);
        }
        long value = ByteUtilities.getInt((byte[])someDataBytes, (int)0);
        if (isUnsigned) {
            value &= 0xFFFFFFFFL;
        }
        return value;
    }

    private static long getOffset(byte[] aData, boolean isLittleEndian) {
        byte[] someDataOffset = null;
        someDataOffset = isLittleEndian ? ByteUtilities.swap((byte[])aData) : aData;
        long offset = (long)ByteUtilities.getInt((byte[])someDataOffset, (int)0) & 0xFFFFFFFFL;
        return offset;
    }

    private static Rational getRational(byte[] aData, int index, boolean isUnsigned, boolean isLittleEndian) {
        byte[] numBytes = new byte[4];
        byte[] denBytes = new byte[4];
        numBytes[0] = aData[index];
        numBytes[1] = aData[index + 1];
        numBytes[2] = aData[index + 2];
        numBytes[3] = aData[index + 3];
        denBytes[0] = aData[index + 4];
        denBytes[1] = aData[index + 5];
        denBytes[2] = aData[index + 6];
        denBytes[3] = aData[index + 7];
        Long numerator = Tag.getInt(numBytes, 0, isUnsigned, isLittleEndian);
        Long denominator = Tag.getInt(denBytes, 0, isUnsigned, isLittleEndian);
        return new Rational(numerator, denominator);
    }

    private static Integer getShort(byte[] aData, int index, boolean isUnsigned, boolean isLittleEndian) {
        byte[] someDataBytes = new byte[]{aData[index], aData[index + 1]};
        if (isLittleEndian) {
            someDataBytes = ByteUtilities.swap((byte[])someDataBytes);
        }
        int value = ByteUtilities.getShort((byte[])someDataBytes, (int)0);
        if (isUnsigned) {
            value &= 0xFFFF;
        }
        return value;
    }

    protected Tag(int code, int type, long numValues, Object data) {
        this.code = code;
        this.type = type;
        this.numValues = numValues;
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public String getCodeName() {
        String name = null;
        if (this.code < TIFF.TIFF_TAG_NAMES.length) {
            name = TIFF.TIFF_TAG_NAMES[this.code];
        }
        return name;
    }

    public Object getData() {
        return this.data;
    }

    public long getNumValues() {
        return this.numValues;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        String name = null;
        if (this.type < TIFF.TAG_TYPE_NAMES.length) {
            name = TIFF.TAG_TYPE_NAMES[this.type];
        }
        return name;
    }

    public String getValueAsString() {
        String valueString = "";
        if (this.data instanceof Integer || this.data instanceof Long || this.data instanceof Double || this.data instanceof String || this.data instanceof Rational) {
            valueString = valueString + this.data;
        } else if (this.data instanceof Integer[]) {
            StringBuffer sb = new StringBuffer("[");
            Integer[] array = (Integer[])this.data;
            for (int ctr = 0; ctr < array.length - 1; ++ctr) {
                sb.append(array[ctr]).append(", ");
            }
            sb.append(array[array.length - 1] + "]");
            valueString = valueString + sb.toString();
        } else if (this.data instanceof Long[]) {
            StringBuffer sb = new StringBuffer("[");
            Long[] array = (Long[])this.data;
            for (int ctr = 0; ctr < array.length - 1; ++ctr) {
                sb.append(array[ctr]).append(", ");
            }
            sb.append(array[array.length - 1] + "]");
            valueString = valueString + sb.toString();
        } else if (this.data instanceof Double[]) {
            StringBuffer sb = new StringBuffer("[");
            Double[] array = (Double[])this.data;
            for (int ctr = 0; ctr < array.length - 1; ++ctr) {
                sb.append(array[ctr]).append(", ");
            }
            sb.append(array[array.length - 1] + "]");
            valueString = valueString + sb.toString();
        } else if (this.data instanceof Rational[]) {
            StringBuffer sb = new StringBuffer("[");
            Rational[] array = (Rational[])this.data;
            for (int ctr = 0; ctr < array.length - 1; ++ctr) {
                sb.append(array[ctr]).append(", ");
            }
            sb.append(array[array.length - 1] + "]");
            valueString = valueString + sb.toString();
        }
        return valueString;
    }

    public String toString() {
        String des = "";
        String codeName = this.getCodeName();
        String codeString = "00000000" + Integer.toHexString(this.code);
        codeString = "0x" + codeString.substring(codeString.length() - 4);
        des = des + "(" + codeString + ") ";
        des = codeName == null ? des + "Unknown: " : des + codeName + ": ";
        des = des + this.getValueAsString();
        return des;
    }
}

