/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.tiff;

import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.formats.tiff.Rational;
import edu.uthscsa.ric.volume.formats.tiff.Tag;

public class IFD {
    private final Tag[] tags;
    private final long offset;
    private final long offsetNext;

    protected IFD(long aOffset, Tag[] aTags, long aOffsetNext) {
        this.tags = aTags;
        this.offset = aOffset;
        this.offsetNext = aOffsetNext;
    }

    public int[] getBlockOffsets() {
        int[] offsets;
        block5: {
            Number[] array;
            Object data;
            block7: {
                block6: {
                    block4: {
                        Tag tag;
                        data = null;
                        offsets = null;
                        if (this.hasTiledOffsets()) {
                            tag = this.findTag(324);
                            data = tag.getData();
                        } else {
                            tag = this.findTag(273);
                            data = tag.getData();
                        }
                        if (!(data instanceof Integer)) break block4;
                        offsets = new int[]{(Integer)data};
                        break block5;
                    }
                    if (!(data instanceof Long)) break block6;
                    offsets = new int[]{((Long)data).intValue()};
                    break block5;
                }
                if (!(data instanceof Integer[])) break block7;
                array = (Integer[])data;
                offsets = new int[array.length];
                for (int ctr = 0; ctr < array.length; ++ctr) {
                    offsets[ctr] = (Integer)array[ctr];
                }
                break block5;
            }
            if (!(data instanceof Long[])) break block5;
            array = (Long[])data;
            offsets = new int[array.length];
            for (int ctr = 0; ctr < array.length; ++ctr) {
                offsets[ctr] = ((Long)array[ctr]).intValue();
            }
        }
        return offsets;
    }

    public int[] getBlockSums() {
        int[] sums;
        block5: {
            Number[] array;
            Object data;
            block7: {
                block6: {
                    block4: {
                        Tag tag;
                        data = null;
                        sums = null;
                        int count = 0;
                        if (this.hasTiledOffsets()) {
                            tag = this.findTag(325);
                            data = tag.getData();
                        } else {
                            tag = this.findTag(279);
                            data = tag.getData();
                        }
                        if (!(data instanceof Integer)) break block4;
                        sums = new int[]{(Integer)data};
                        break block5;
                    }
                    if (!(data instanceof Long)) break block6;
                    sums = new int[]{((Long)data).intValue()};
                    break block5;
                }
                if (!(data instanceof Integer[])) break block7;
                array = (Integer[])data;
                sums = new int[array.length];
                sums[0] = 0;
                for (int ctr = 0; ctr < array.length - 1; ++ctr) {
                    sums[ctr + 1] = count += ((Integer)array[ctr]).intValue();
                }
                break block5;
            }
            if (!(data instanceof Long[])) break block5;
            array = (Long[])data;
            sums = new int[array.length];
            sums[0] = 0;
            for (int ctr = 0; ctr < array.length - 1; ++ctr) {
                sums[ctr + 1] = count += ((Long)array[ctr]).intValue();
            }
        }
        return sums;
    }

    public String getDateTime() {
        Tag tag = this.findTag(306);
        String string = "";
        if (tag != null) {
            string = (String)tag.getData();
        }
        return string;
    }

    public String getDescription() {
        Tag tag = this.findTag(270);
        String string = "";
        if (tag != null) {
            string = (String)tag.getData();
        }
        return string;
    }

    public String getDocumentInfo() {
        String string = "";
        Tag tag = this.findTag(269);
        if (tag != null) {
            string = (String)tag.getData();
        }
        if ((tag = this.findTag(285)) != null) {
            string = string + " " + (String)tag.getData();
        }
        return string;
    }

    public int getImageHeight() {
        Tag tag = this.findTag(257);
        Object data = tag.getData();
        if (data instanceof Integer) {
            return (Integer)data;
        }
        if (data instanceof Long) {
            return ((Long)data).intValue();
        }
        return 0;
    }

    public int getImageWidth() {
        Tag tag = this.findTag(256);
        Object data = tag.getData();
        if (data instanceof Integer) {
            return (Integer)data;
        }
        if (data instanceof Long) {
            return ((Long)data).intValue();
        }
        return 0;
    }

    public String getMakeModel() {
        String string = "";
        Tag tag = this.findTag(271);
        if (tag != null) {
            string = (String)tag.getData();
        }
        if ((tag = this.findTag(272)) != null) {
            string = string + " " + (String)tag.getData();
        }
        return string;
    }

    public long getNextOffset() {
        return this.offsetNext;
    }

    public int getNumBitsStored() throws InvalidHeaderException {
        return this.getNumBytes() * 8;
    }

    public int getNumBytes() throws InvalidHeaderException {
        Tag tagNumBits = this.findTag(258);
        Object data = tagNumBits.getData();
        int numBits = 0;
        if (data instanceof Integer[]) {
            numBits = ((Integer[])data).length * 8;
        } else if (data instanceof Long[]) {
            numBits = ((Long[])data).length * 8;
        } else if (data instanceof Integer) {
            numBits = (Integer)data;
        } else if (data instanceof Long) {
            numBits = ((Long)data).intValue();
        }
        if (numBits < 8) {
            return 1;
        }
        return numBits / 8;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getOrientationCode() {
        Tag tag = this.findTag(274);
        int value = 0;
        if (tag != null) {
            Object data = tag.getData();
            if (data instanceof Integer) {
                value = (Integer)data;
            } else if (data instanceof Long) {
                value = ((Long)data).intValue();
            }
        }
        return value;
    }

    public int getSpatialUnit() {
        int resCode = this.getResolutionType();
        if (resCode == 2) {
            return 2;
        }
        if (resCode == 3) {
            return 2;
        }
        return 0;
    }

    public int getTileHeight() {
        Tag tag = this.findTag(323);
        Object data = tag.getData();
        if (data instanceof Integer) {
            return (Integer)data;
        }
        if (data instanceof Long) {
            return ((Long)data).intValue();
        }
        return 0;
    }

    public int getTileWidth() {
        Tag tag = this.findTag(322);
        Object data = tag.getData();
        if (data instanceof Integer) {
            return (Integer)data;
        }
        if (data instanceof Long) {
            return ((Long)data).intValue();
        }
        return 0;
    }

    public int getTotalBytes() {
        int count;
        block5: {
            Number[] array;
            Object data;
            block7: {
                block6: {
                    block4: {
                        Tag tag;
                        data = null;
                        count = 0;
                        if (this.hasTiledOffsets()) {
                            tag = this.findTag(325);
                            data = tag.getData();
                        } else {
                            tag = this.findTag(279);
                            data = tag.getData();
                        }
                        if (!(data instanceof Integer)) break block4;
                        count = (Integer)data;
                        break block5;
                    }
                    if (!(data instanceof Long)) break block6;
                    count = ((Long)data).intValue();
                    break block5;
                }
                if (!(data instanceof Integer[])) break block7;
                array = (Integer[])data;
                for (Integer n : array) {
                    count += n.intValue();
                }
                break block5;
            }
            if (!(data instanceof Long[])) break block5;
            for (Number number : array = (Long[])data) {
                count += ((Long)number).intValue();
            }
        }
        return count;
    }

    public double getVoxelSizeX() {
        int resCode;
        Tag tag = this.findTag(282);
        double resX = 1.0;
        double pixelsPerUnit = 0.0;
        if (tag != null) {
            pixelsPerUnit = ((Rational)tag.getData()).getDividend();
        }
        if (pixelsPerUnit != 0.0) {
            resX = 1.0 / pixelsPerUnit;
        }
        if ((resCode = this.getResolutionType()) == 2) {
            resX *= 25.4;
        } else if (resCode == 3) {
            resX *= 10.0;
        }
        return resX;
    }

    public double getVoxelSizeY() {
        int resCode;
        Tag tag = this.findTag(283);
        double resY = 1.0;
        double pixelsPerUnit = 0.0;
        if (tag != null) {
            pixelsPerUnit = ((Rational)tag.getData()).getDividend();
        }
        if (pixelsPerUnit != 0.0) {
            resY = 1.0 / pixelsPerUnit;
        }
        if ((resCode = this.getResolutionType()) == 2) {
            resY *= 25.4;
        } else if (resCode == 3) {
            resY *= 10.0;
        }
        return resY;
    }

    public boolean isRGB() {
        Tag tag = this.findTag(262);
        Object data = tag.getData();
        int code = 0;
        if (data instanceof Integer) {
            code = (Integer)data;
        } else if (data instanceof Long) {
            code = ((Long)data).intValue();
        }
        return code == 2;
    }

    public boolean isTiled() {
        Tag tagW = this.findTag(322);
        Tag tagL = this.findTag(323);
        Tag tagO = this.findTag(324);
        Tag tagC = this.findTag(325);
        return tagW != null || tagL != null || tagO != null || tagC != null;
    }

    public boolean isUsingCompression() {
        Tag tagNumBits = this.findTag(259);
        return (Integer)tagNumBits.getData() > 1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(32);
        sb.append("IFD (" + this.offset + ", " + this.offsetNext + "): " + this.tags.length + " tags\n");
        for (Tag tag : this.tags) {
            sb.append(tag).append('\n');
        }
        return sb.toString();
    }

    private Tag findTag(int tagCode) {
        Tag tag = null;
        for (Tag tag2 : this.tags) {
            if (tag2.getCode() != tagCode) continue;
            tag = tag2;
            break;
        }
        return tag;
    }

    private int getResolutionType() {
        Tag tag = this.findTag(296);
        int resCode = 0;
        if (tag != null) {
            Object data = tag.getData();
            if (data instanceof Integer) {
                resCode = (Integer)data;
            } else if (data instanceof Long) {
                resCode = ((Long)data).intValue();
            }
        }
        return resCode;
    }

    private boolean hasTiledOffsets() {
        Tag tagO = this.findTag(324);
        return tagO != null;
    }
}

