/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.nifti;

import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.ByteUtilities;
import edu.uthscsa.ric.utilities.CompressionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.EditableHeader;
import edu.uthscsa.ric.volume.ImageDescription;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.WritableHeader;
import edu.uthscsa.ric.volume.formats.nifti.NIFTI;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NIFTI2
extends NIFTI
implements EditableHeader,
ReadableHeader,
WritableHeader {
    private static final byte[] EMPTY = new byte[100];
    private static final byte[] MAGIC_NUMBER2 = new byte[]{110, 43, 50, 0, 13, 10, 26, 10};
    public static final String NAME = "NIFTI-2";
    public static final int FIELD_SIZE_UNUSED = 15;
    public static final int MAGIC_NUMBER_INDEX = 4;
    public static final int NIFTI_2_MAGIC_FIELD_SIZE = 8;
    public static final int NIFTI_2_SIZE_OF = 540;
    public static final int EXTENSION_FLAG_SIZE = 4;

    @Override
    public String getPluginName() {
        return NAME;
    }

    @Override
    protected int getExtensionFlagOffset() {
        return 540;
    }

    @Override
    public Map<String, List<String>> getEditableFieldValues() {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        map.put("Datatype", Arrays.asList(String.valueOf(this.dataType)));
        map.put("Bits Per Voxel", Arrays.asList(String.valueOf(this.bitPix)));
        map.put("Image Dimensions", Arrays.asList(String.valueOf(this.dim[0]), String.valueOf(this.dim[1]), String.valueOf(this.dim[2]), String.valueOf(this.dim[3]), String.valueOf(this.dim[4]), String.valueOf(this.dim[5]), String.valueOf(this.dim[6]), String.valueOf(this.dim[7])));
        map.put("Intent Parameters", Arrays.asList(String.valueOf(this.intentP[0]), String.valueOf(this.intentP[1]), String.valueOf(this.intentP[2])));
        map.put("Voxel Dimensions", Arrays.asList(String.valueOf(this.pixDim[0]), String.valueOf(this.pixDim[1]), String.valueOf(this.pixDim[2]), String.valueOf(this.pixDim[3]), String.valueOf(this.pixDim[4]), String.valueOf(this.pixDim[5]), String.valueOf(this.pixDim[6]), String.valueOf(this.pixDim[7])));
        map.put("Image Offset", Arrays.asList(String.valueOf(this.voxOffset)));
        map.put("Data Scale (Slope, Intercept)", Arrays.asList(String.valueOf(this.dataSlope), String.valueOf(this.dataIntercept)));
        map.put("Display Range (Max, Min)", Arrays.asList(String.valueOf(this.calMax), String.valueOf(this.calMin)));
        map.put("Slice Duration", Arrays.asList(String.valueOf(this.sliceDuration)));
        map.put("Time Axis Shift", Arrays.asList(String.valueOf(this.tOffset)));
        map.put("Slice Start", Arrays.asList(String.valueOf(this.sliceStart)));
        map.put("Slice End", Arrays.asList(String.valueOf(this.sliceEnd)));
        try {
            map.put("Description", Arrays.asList(new String(this.description, "UTF-8").trim()));
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        try {
            map.put("Auxiliary File", Arrays.asList(new String(this.auxFile, "UTF-8").trim()));
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        map.put("Q-Form Code", Arrays.asList(String.valueOf(this.qFormCode)));
        map.put("S-Form Code", Arrays.asList(String.valueOf(this.sFormCode)));
        map.put("Quaternion Parameters", Arrays.asList(String.valueOf(this.quaternB), String.valueOf(this.quaternC), String.valueOf(this.quaternD)));
        map.put("Quaternion Offsets", Arrays.asList(String.valueOf(this.offsetX), String.valueOf(this.offsetY), String.valueOf(this.offsetZ)));
        map.put("S-Form Parameters X", Arrays.asList(String.valueOf(this.affine[0][0]), String.valueOf(this.affine[0][1]), String.valueOf(this.affine[0][2]), String.valueOf(this.affine[0][3])));
        map.put("S-Form Parameters Y", Arrays.asList(String.valueOf(this.affine[1][0]), String.valueOf(this.affine[1][1]), String.valueOf(this.affine[1][2]), String.valueOf(this.affine[1][3])));
        map.put("S-Form Parameters Z", Arrays.asList(String.valueOf(this.affine[2][0]), String.valueOf(this.affine[2][1]), String.valueOf(this.affine[2][2]), String.valueOf(this.affine[2][3])));
        map.put("Slice Code", Arrays.asList(String.valueOf(this.sliceCode)));
        map.put("Units Code (Spatial, Temporal)", Arrays.asList(String.valueOf(this.units & 7), String.valueOf(this.units & 0x38)));
        map.put("Intent Code", Arrays.asList(String.valueOf(this.intentCode)));
        try {
            map.put("Intent Name", Arrays.asList(new String(this.intentName, "UTF-8").trim()));
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        map.put("Dim Info", Arrays.asList(String.valueOf(this.dimInfo)));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isThisFormat(File file) {
        boolean success = false;
        boolean usesGZIPExtension = CompressionUtilities.usesGZIPFileExtension((String)file.toString());
        boolean isGZIPFile = usesGZIPExtension || CompressionUtilities.isPossibleGZIPFile((File)file);
        BufferedInputStream fileIn = null;
        ByteBuffer byteBuffer = null;
        byte[] byteArray = new byte[this.getHeaderSize()];
        try {
            fileIn = FileUtilities.getInputStream((URI)file.toURI(), (boolean)isGZIPFile);
            FileUtilities.readFully((InputStream)fileIn, (byte[])byteArray);
            byteBuffer = ByteBuffer.wrap(byteArray);
            if (byteBuffer.getInt(0) == 540 || ByteUtilities.swap((int)byteBuffer.getInt(0)) == 540) {
                byte[] magic = new byte[8];
                for (int ctr = 0; ctr < magic.length; ++ctr) {
                    magic[ctr] = byteBuffer.get(4 + ctr);
                }
                if (Arrays.equals(magic, MAGIC_NUMBER2)) {
                    success = true;
                }
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        return success;
    }

    @Override
    public void readHeader(URI file, File tempDir) throws InvalidHeaderException {
        int ctr;
        BufferedInputStream fileIn = null;
        ByteBuffer byteBuffer = null;
        this.headerFile = file;
        try {
            int bytesRead;
            boolean isGZIPFile;
            boolean usesGZIPExtension = CompressionUtilities.usesGZIPFileExtension((String)file.toString());
            this.compressed = isGZIPFile = usesGZIPExtension || CompressionUtilities.isPossibleGZIPFile((File)new File(file));
            fileIn = FileUtilities.getInputStream((URI)file, (boolean)this.compressed);
            byte[] byteArray = new byte[this.getHeaderSize()];
            for (int totalBytesRead = bytesRead = fileIn.read(byteArray); totalBytesRead > 0 && totalBytesRead < byteArray.length; totalBytesRead += bytesRead) {
                bytesRead = fileIn.read(byteArray, totalBytesRead, byteArray.length - totalBytesRead);
            }
            byteBuffer = ByteBuffer.wrap(byteArray);
        }
        catch (IOException ex) {
            throw new InvalidHeaderException(ex.getMessage(), (Exception)ex);
        }
        finally {
            try {
                if (fileIn != null) {
                    fileIn.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        if (byteBuffer.getInt(0) == 540) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else if (ByteUtilities.swap((int)byteBuffer.getInt(0)) == 540) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            throw new InvalidHeaderException("Does not appear to be a valid NIFTI-2 file: Size field does not equal 540.");
        }
        this.littleEndian = byteBuffer.order().toString().equals(ByteOrder.LITTLE_ENDIAN.toString());
        byte[] magic = new byte[8];
        for (ctr = 0; ctr < magic.length; ++ctr) {
            magic[ctr] = byteBuffer.get(4 + ctr);
        }
        this.twoFileFormat = false;
        this.dataType = byteBuffer.getShort(12);
        this.bitPix = byteBuffer.getShort(14);
        this.dim[0] = byteBuffer.getLong(16);
        this.dim[1] = byteBuffer.getLong(24);
        this.dim[2] = byteBuffer.getLong(32);
        this.dim[3] = byteBuffer.getLong(40);
        this.dim[4] = byteBuffer.getLong(48);
        this.dim[5] = byteBuffer.getLong(56);
        this.dim[6] = byteBuffer.getLong(64);
        this.dim[7] = byteBuffer.getLong(72);
        this.intentP[0] = byteBuffer.getDouble(80);
        this.intentP[1] = byteBuffer.getDouble(88);
        this.intentP[2] = byteBuffer.getDouble(96);
        this.pixDim[0] = byteBuffer.getDouble(104);
        this.pixDim[1] = byteBuffer.getDouble(112);
        this.pixDim[2] = byteBuffer.getDouble(120);
        this.pixDim[3] = byteBuffer.getDouble(128);
        this.pixDim[4] = byteBuffer.getDouble(136);
        this.pixDim[5] = byteBuffer.getDouble(144);
        this.pixDim[6] = byteBuffer.getDouble(152);
        this.pixDim[7] = byteBuffer.getDouble(160);
        this.voxOffset = byteBuffer.getLong(168);
        this.dataSlope = byteBuffer.getDouble(176);
        this.dataIntercept = byteBuffer.getDouble(184);
        this.calMax = byteBuffer.getDouble(192);
        this.calMin = byteBuffer.getDouble(200);
        this.sliceDuration = byteBuffer.getDouble(208);
        this.tOffset = byteBuffer.getDouble(216);
        this.sliceStart = byteBuffer.getShort(224);
        this.sliceEnd = byteBuffer.getShort(232);
        this.description = new byte[80];
        for (ctr = 0; ctr < 80; ++ctr) {
            this.description[ctr] = byteBuffer.get(240 + ctr);
        }
        this.auxFile = new byte[24];
        for (ctr = 0; ctr < 24; ++ctr) {
            this.auxFile[ctr] = byteBuffer.get(320 + ctr);
        }
        this.qFormCode = byteBuffer.getInt(344);
        this.sFormCode = byteBuffer.getInt(348);
        this.quaternB = byteBuffer.getDouble(352);
        this.quaternC = byteBuffer.getDouble(360);
        this.quaternD = byteBuffer.getDouble(368);
        this.offsetX = byteBuffer.getDouble(376);
        this.offsetY = byteBuffer.getDouble(384);
        this.offsetZ = byteBuffer.getDouble(392);
        this.affine[0][0] = byteBuffer.getDouble(400);
        this.affine[0][1] = byteBuffer.getDouble(408);
        this.affine[0][2] = byteBuffer.getDouble(416);
        this.affine[0][3] = byteBuffer.getDouble(424);
        this.affine[1][0] = byteBuffer.getDouble(432);
        this.affine[1][1] = byteBuffer.getDouble(440);
        this.affine[1][2] = byteBuffer.getDouble(448);
        this.affine[1][3] = byteBuffer.getDouble(456);
        this.affine[2][0] = byteBuffer.getDouble(464);
        this.affine[2][1] = byteBuffer.getDouble(472);
        this.affine[2][2] = byteBuffer.getDouble(480);
        this.affine[2][3] = byteBuffer.getDouble(488);
        this.affine[3][0] = 0.0;
        this.affine[3][1] = 0.0;
        this.affine[3][2] = 0.0;
        this.affine[3][3] = 1.0;
        this.sliceCode = byteBuffer.getInt(496);
        this.units = byteBuffer.getInt(500);
        this.intentCode = byteBuffer.getInt(504);
        this.intentName = new byte[16];
        for (ctr = 0; ctr < 16; ++ctr) {
            this.intentName[ctr] = byteBuffer.get(508 + ctr);
        }
        this.dimInfo = byteBuffer.get(524);
        this.unused = new byte[15];
        for (ctr = 0; ctr < 15; ++ctr) {
            this.unused[ctr] = byteBuffer.get(525 + ctr);
        }
        this.extensionFlag = new byte[4];
        for (ctr = 0; ctr < this.extensionFlag.length; ++ctr) {
            this.extensionFlag[ctr] = byteBuffer.get(540 + ctr);
        }
        if (this.extensionFlag[0] != 0) {
            if (!this.ignoreExtension && this.isExtensionValid(file, -1L)) {
                this.readExtension(file);
            } else {
                this.extensionFlag[0] = 0;
            }
        }
    }

    @Override
    public int getHeaderSize() {
        return 544;
    }

    @Override
    public String toString() {
        String string = "";
        DecimalFormat fmt = new DecimalFormat("0.0####");
        String equals = " = ";
        string = string + "Datatype = " + this.dataType + "\n";
        string = string + "Bits Per Voxel = " + this.bitPix + "\n";
        string = string + "Image Dimensions (1-8): " + this.dim[0] + ", " + this.dim[1] + ", " + this.dim[2] + ", " + this.dim[3] + ", " + this.dim[4] + ", " + this.dim[5] + ", " + this.dim[6] + ", " + this.dim[7] + "\n";
        string = string + "Intent Parameters (1-3): " + this.intentP[0] + ", " + this.intentP[1] + ", " + this.intentP[2] + "\n";
        string = string + "Voxel Dimensions (1-8): " + fmt.format(this.pixDim[0]) + ", " + fmt.format(this.pixDim[1]) + ", " + fmt.format(this.pixDim[2]) + ", " + fmt.format(this.pixDim[3]) + ", " + fmt.format(this.pixDim[4]) + ", " + fmt.format(this.pixDim[5]) + ", " + fmt.format(this.pixDim[6]) + ", " + fmt.format(this.pixDim[7]) + "\n";
        string = string + "Image Offset = " + this.voxOffset + "\n";
        string = string + "Data Scale (Slope, Intercept):  Slope = " + fmt.format(this.dataSlope) + "  Intercept = " + fmt.format(this.dataIntercept) + "\n";
        string = string + "Display Range (Max, Min):  Max = " + this.calMax + "  Min = " + this.calMin + "\n";
        string = string + "Slice Duration = " + this.sliceDuration + "\n";
        string = string + "Time Axis Shift = " + this.tOffset + "\n";
        string = string + "Slice Start = " + this.sliceStart + "\n";
        string = string + "Slice End = " + this.sliceEnd + "\n";
        string = string + "Description: \"" + StringUtilities.convertToPrintableASCIIString((byte[])this.description) + "\"\n";
        string = string + "Auxiliary File: \"" + StringUtilities.convertToPrintableASCIIString((byte[])this.auxFile) + "\"\n";
        string = string + "Q-Form Code = " + this.qFormCode + "\n";
        string = string + "S-Form Code = " + this.sFormCode + "\n";
        string = string + "Quaternion Parameters:  b = " + fmt.format(this.quaternB) + "  c = " + fmt.format(this.quaternC) + "  d = " + fmt.format(this.quaternD) + "\n";
        string = string + "Quaternion Offsets:  x = " + fmt.format(this.offsetX) + "  y = " + fmt.format(this.offsetY) + "  z = " + fmt.format(this.offsetZ) + "\n";
        string = string + "S-Form Parameters X: " + fmt.format(this.affine[0][0]) + ", " + fmt.format(this.affine[0][1]) + ", " + fmt.format(this.affine[0][2]) + ", " + fmt.format(this.affine[0][3]) + "\n";
        string = string + "S-Form Parameters Y: " + fmt.format(this.affine[1][0]) + ", " + fmt.format(this.affine[1][1]) + ", " + fmt.format(this.affine[1][2]) + ", " + fmt.format(this.affine[1][3]) + "\n";
        string = string + "S-Form Parameters Z: " + fmt.format(this.affine[2][0]) + ", " + fmt.format(this.affine[2][1]) + ", " + fmt.format(this.affine[2][2]) + ", " + fmt.format(this.affine[2][3]) + "\n";
        string = string + "Slice Code = " + this.sliceCode + "\n";
        string = string + "Units Code (Spatial, Temporal) = " + this.units + "\n";
        string = string + "Intent Code = " + this.intentCode + "\n";
        string = string + "Intent Name: \"" + StringUtilities.convertToPrintableASCIIString((byte[])this.intentName) + "\"\n";
        string = string + "Dim Info = " + this.dimInfo + "\n";
        if (this.getExtension() != null) {
            string = string + "Extension:  Code = " + this.extCode + "  Size = " + StringUtilities.makeNiceFileSizeString((long)this.getExtension().length) + "\n";
        }
        return string;
    }

    @Override
    public byte[] writeHeader(ImageDimensions id, VoxelDimensions vd, ImageType it, ImageRange ir, ImageDescription des, boolean compress, Coordinate origin, String orientation, ImageTransform[] transforms, File headerFile, File imageFile, ByteBuffer[] imageBuffers, File tempDir) throws IOException, InvalidHeaderException {
        if (id != null) {
            this.updateDims4D(id.getCols(), id.getRows(), id.getSlices(), id.getTimepoints());
            this.voxOffset = id.getImageOffset();
        }
        if (vd != null) {
            this.updatePixDims4D(vd.getColSize(true), vd.getRowSize(true), vd.getSliceThickness(true), vd.getTR());
            this.units = (byte)(vd.getSpatialUnit() | vd.getTemporalUnit());
        }
        if (it != null) {
            this.updateDataType(it.getNumBytesPerVoxel(), it.getByteType(), it.isLittleEndian());
        }
        if (ir != null) {
            if (ir.hasGlobalDataScaleSlope()) {
                this.setDataSlope(ir.getDataScaleSlopes()[0]);
            } else {
                this.setDataSlope(1.0f);
            }
            if (ir.hasGlobalDataScaleIntercept()) {
                this.setDataIntercept(ir.getDataScaleIntercepts()[0]);
            } else {
                this.setDataIntercept(0.0f);
            }
            this.updateDisplayRange(ir.getDisplayMax(), ir.getDisplayMin());
        }
        if (origin != null && orientation != null) {
            this.updateOrientation(orientation, origin);
        }
        if (des != null) {
            this.description = (des.getDescription() + " " + des.getAllID() + " " + des.getStudyDateTimeString()).getBytes("UTF-8");
        }
        this.compressed = compress;
        ByteBuffer byteBuffer = null;
        byteBuffer = ByteBuffer.wrap(new byte[this.getHeaderSize()]);
        if (this.littleEndian) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        byteBuffer.putInt(540);
        byteBuffer.put(MAGIC_NUMBER2, 0, MAGIC_NUMBER2.length);
        byteBuffer.putShort(this.dataType);
        byteBuffer.putShort(this.bitPix);
        byteBuffer.putLong(this.dim[0]);
        byteBuffer.putLong(this.dim[1]);
        byteBuffer.putLong(this.dim[2]);
        byteBuffer.putLong(this.dim[3]);
        byteBuffer.putLong(this.dim[4]);
        byteBuffer.putLong(this.dim[5]);
        byteBuffer.putLong(this.dim[6]);
        byteBuffer.putLong(this.dim[7]);
        byteBuffer.putDouble(this.intentP[0]);
        byteBuffer.putDouble(this.intentP[1]);
        byteBuffer.putDouble(this.intentP[2]);
        byteBuffer.putDouble(this.pixDim[0]);
        byteBuffer.putDouble(this.pixDim[1]);
        byteBuffer.putDouble(this.pixDim[2]);
        byteBuffer.putDouble(this.pixDim[3]);
        byteBuffer.putDouble(this.pixDim[4]);
        byteBuffer.putDouble(this.pixDim[5]);
        byteBuffer.putDouble(this.pixDim[6]);
        byteBuffer.putDouble(this.pixDim[7]);
        long offset = this.voxOffset;
        if (!this.twoFileFormat && offset < (long)this.getHeaderSize()) {
            offset = this.getHeaderSize();
        }
        byteBuffer.putLong(offset);
        byteBuffer.putDouble(this.dataSlope);
        byteBuffer.putDouble(this.dataIntercept);
        byteBuffer.putDouble(this.calMax);
        byteBuffer.putDouble(this.calMin);
        byteBuffer.putDouble(this.sliceDuration);
        byteBuffer.putDouble(this.tOffset);
        byteBuffer.putLong(this.sliceStart);
        byteBuffer.putLong(this.sliceEnd);
        if (this.description == null || this.description.length == 0) {
            this.description = new byte[80];
        }
        if (this.description.length < 80) {
            byteBuffer.put(this.description, 0, this.description.length);
            byteBuffer.put(EMPTY, 0, 80 - this.description.length);
        } else {
            byteBuffer.put(this.description, 0, 80);
        }
        if (this.auxFile == null || this.auxFile.length == 0) {
            this.auxFile = new byte[24];
        }
        if (this.auxFile.length < 24) {
            byteBuffer.put(this.auxFile, 0, this.auxFile.length);
            byteBuffer.put(EMPTY, 0, 24 - this.auxFile.length);
        } else {
            byteBuffer.put(this.auxFile, 0, 24);
        }
        byteBuffer.putInt(this.qFormCode);
        byteBuffer.putInt(this.sFormCode);
        byteBuffer.putDouble(this.quaternB);
        byteBuffer.putDouble(this.quaternC);
        byteBuffer.putDouble(this.quaternD);
        byteBuffer.putDouble(this.offsetX);
        byteBuffer.putDouble(this.offsetY);
        byteBuffer.putDouble(this.offsetZ);
        byteBuffer.putDouble(this.affine[0][0]);
        byteBuffer.putDouble(this.affine[0][1]);
        byteBuffer.putDouble(this.affine[0][2]);
        byteBuffer.putDouble(this.affine[0][3]);
        byteBuffer.putDouble(this.affine[1][0]);
        byteBuffer.putDouble(this.affine[1][1]);
        byteBuffer.putDouble(this.affine[1][2]);
        byteBuffer.putDouble(this.affine[1][3]);
        byteBuffer.putDouble(this.affine[2][0]);
        byteBuffer.putDouble(this.affine[2][1]);
        byteBuffer.putDouble(this.affine[2][2]);
        byteBuffer.putDouble(this.affine[2][3]);
        byteBuffer.putInt(this.sliceCode);
        byteBuffer.putInt(this.units);
        byteBuffer.putInt(this.intentCode);
        if (this.intentName == null || this.intentName.length == 0) {
            this.intentName = new byte[16];
        }
        if (this.intentName.length < 16) {
            byteBuffer.put(this.intentName, 0, this.intentName.length);
            byteBuffer.put(EMPTY, 0, 16 - this.intentName.length);
        } else {
            byteBuffer.put(this.intentName, 0, 16);
        }
        byteBuffer.put(this.dimInfo);
        byteBuffer.put(EMPTY, 0, 15);
        byteBuffer.put(EMPTY, 0, 4);
        this.headerFile = headerFile.toURI();
        return byteBuffer.array();
    }
}

