/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.nifti;

import Jama.Matrix;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.ByteUtilities;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.CompressionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.EditableHeader;
import edu.uthscsa.ric.volume.ImageDescription;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageIntent;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.Orientation;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.SimpleTransform;
import edu.uthscsa.ric.volume.Transform;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.WritableHeader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;

public class NIFTI
implements EditableHeader,
ReadableHeader,
WritableHeader {
    private static final String[] NIFTI_UNIT_STRING = new String[49];
    private static final byte[] EMPTY = new byte[100];
    private static final byte[] MAGIC_NUMBER1 = new byte[]{110, 105, 49, 0};
    private static final byte[] MAGIC_NUMBER2 = new byte[]{110, 43, 49, 0};
    private static final byte[] NIFTI_HEADER_EXTENSION_MAGIC_NUMBER_1 = new byte[]{1, 0, 0, 0};
    private static final byte[] NIFTI_HEADER_EXTENSION_MAGIC_NUMBER_OLD = new byte[]{77, 0, 0, 0};
    protected URI headerFile;
    protected boolean compressed;
    protected boolean ignoreExtension;
    protected boolean littleEndian;
    protected boolean orientationUpdated;
    protected boolean twoFileFormat;
    protected byte dimInfo;
    protected byte[] auxFile;
    protected byte[] description;
    protected byte[] extension;
    protected byte[] extensionFlag;
    protected byte[] intentName;
    protected byte[] unused;
    protected double calMax;
    protected double calMin;
    protected double dataIntercept;
    protected double dataSlope;
    protected double offsetX;
    protected double offsetY;
    protected double offsetZ;
    protected double quaternB;
    protected double quaternC;
    protected double quaternD;
    protected double sliceDuration;
    protected double tOffset;
    protected double[][] affine;
    protected int extCode;
    protected int extSize;
    protected int intentCode;
    protected int qFormCode;
    protected int sFormCode;
    protected int sliceCode;
    protected int units;
    protected long sliceEnd;
    protected long sliceStart;
    protected long voxOffset;
    protected short bitPix;
    protected short dataType;
    protected final double[] intentP;
    protected final double[] pixDim;
    protected final long[] dim = new long[8];
    public static final String CHARACTER_ENCODING = "UTF-8";
    public static final String NAME = "NIFTI";
    public static final String PREFERRED_EXTENSION = "nii";
    public static final String TEXT_AUXILIARY_FILE = "Auxiliary File";
    public static final String TEXT_BITS_PER_VOXEL = "Bits Per Voxel";
    public static final String TEXT_DATATYPE = "Datatype";
    public static final String TEXT_DATA_SCALE = "Data Scale (Slope, Intercept)";
    public static final String TEXT_DESCRIPTION = "Description";
    public static final String TEXT_DIM_INFO = "Dim Info";
    public static final String TEXT_DISPLAY_RANGE = "Display Range (Max, Min)";
    public static final String TEXT_IMAGE_DIMENSIONS = "Image Dimensions";
    public static final String TEXT_IMAGE_OFFSET = "Image Offset";
    public static final String TEXT_INTENT_CODE = "Intent Code";
    public static final String TEXT_INTENT_NAME = "Intent Name";
    public static final String TEXT_INTENT_PARAMETERS = "Intent Parameters";
    public static final String TEXT_NIFTI = "NIFTI";
    public static final String TEXT_QUATERNION_OFFSETS = "Quaternion Offsets";
    public static final String TEXT_QUATERNION_PARAMETERS = "Quaternion Parameters";
    public static final String TEXT_Q_FORM_CODE = "Q-Form Code";
    public static final String TEXT_SLICE_CODE = "Slice Code";
    public static final String TEXT_SLICE_DURATION = "Slice Duration";
    public static final String TEXT_SLICE_END = "Slice End";
    public static final String TEXT_SLICE_START = "Slice Start";
    public static final String TEXT_S_FORM_CODE = "S-Form Code";
    public static final String TEXT_S_FORM_PARAMETERS_X = "S-Form Parameters X";
    public static final String TEXT_S_FORM_PARAMETERS_Y = "S-Form Parameters Y";
    public static final String TEXT_S_FORM_PARAMETERS_Z = "S-Form Parameters Z";
    public static final String TEXT_TIME_AXIS_SHIFT = "Time Axis Shift";
    public static final String TEXT_UNITS_CODE = "Units Code (Spatial, Temporal)";
    public static final String TEXT_VOXEL_DIMENSIONS = "Voxel Dimensions";
    public static final String UNKNOWN = "Unknown";
    public static final int ANZ_HDR_SIZE = 348;
    public static final int BUFFER_SIZE = 2048;
    public static final int EXTENSION_HEADER_SIZE = 8;
    public static final int FIELD_SIZE_AUXFILE = 24;
    public static final int FIELD_SIZE_DESCRIPTION = 80;
    public static final int FIELD_SIZE_INTENT_NAME = 16;
    public static final int FIELD_SIZE_UNUSED = 35;
    public static final int LENGTH_INTEGRAL = 16;
    public static final int MAGIC_NUMBER_INDEX = 344;
    public static final int NIFTI_1_SIZE_OF = 348;
    public static final int NIFTI_INTENT_BETA = 7;
    public static final int NIFTI_INTENT_BINOM = 8;
    public static final int NIFTI_INTENT_CHI = 19;
    public static final int NIFTI_INTENT_CHISQ = 6;
    public static final int NIFTI_INTENT_CHISQ_NONC = 13;
    public static final int NIFTI_INTENT_CORREL = 2;
    public static final int NIFTI_INTENT_EXTVAL = 21;
    public static final int NIFTI_INTENT_FTEST = 4;
    public static final int NIFTI_INTENT_FTEST_NONC = 12;
    public static final int NIFTI_INTENT_GAMMA = 9;
    public static final int NIFTI_INTENT_INVGAUSS = 20;
    public static final int NIFTI_INTENT_LAPLACE = 15;
    public static final int NIFTI_INTENT_LOG10PVAL = 24;
    public static final int NIFTI_INTENT_LOGISTIC = 14;
    public static final int NIFTI_INTENT_LOGPVAL = 23;
    public static final int NIFTI_INTENT_NONE = 0;
    public static final int NIFTI_INTENT_NORMAL = 11;
    public static final int NIFTI_INTENT_POISSON = 10;
    public static final int NIFTI_INTENT_PVAL = 22;
    public static final int NIFTI_INTENT_TTEST = 3;
    public static final int NIFTI_INTENT_TTEST_NONC = 17;
    public static final int NIFTI_INTENT_UNIFORM = 16;
    public static final int NIFTI_INTENT_WEIBULL = 18;
    public static final int NIFTI_INTENT_ZSCORE = 5;
    public static final int NIFTI_MAGIC_FIELD_SIZE = 4;
    public static final int NIFTI_SLICE_ALT_DEC = 4;
    public static final int NIFTI_SLICE_ALT_INC = 3;
    public static final int NIFTI_SLICE_SEQ_DEC = 2;
    public static final int NIFTI_SLICE_SEQ_INC = 1;
    public static final int NIFTI_SLICE_UNKNOWN = 0;
    public static final int NII_HDR_SIZE = 352;
    public static final int SPATIAL_UNITS_MASK = 7;
    public static final int TEMPORAL_UNITS_MASK = 56;
    public static final short DT_ALL = 255;
    public static final short DT_BINARY = 1;
    public static final short DT_NONE = 0;
    public static final short NIFTI_TYPE_COMPLEX128 = 1792;
    public static final short NIFTI_TYPE_COMPLEX256 = 2048;
    public static final short NIFTI_TYPE_COMPLEX64 = 32;
    public static final short NIFTI_TYPE_FLOAT128 = 1536;
    public static final short NIFTI_TYPE_FLOAT32 = 16;
    public static final short NIFTI_TYPE_FLOAT64 = 64;
    public static final short NIFTI_TYPE_INT16 = 4;
    public static final short NIFTI_TYPE_INT32 = 8;
    public static final short NIFTI_TYPE_INT64 = 1024;
    public static final short NIFTI_TYPE_INT8 = 256;
    public static final short NIFTI_TYPE_RGB24 = 128;
    public static final short NIFTI_TYPE_UINT16 = 512;
    public static final short NIFTI_TYPE_UINT32 = 768;
    public static final short NIFTI_TYPE_UINT64 = 1280;
    public static final short NIFTI_TYPE_UINT8 = 2;
    public static final short NIFTI_UNITS_HZ = 32;
    public static final short NIFTI_UNITS_METER = 1;
    public static final short NIFTI_UNITS_MICRON = 3;
    public static final short NIFTI_UNITS_MM = 2;
    public static final short NIFTI_UNITS_MSEC = 16;
    public static final short NIFTI_UNITS_PPM = 40;
    public static final short NIFTI_UNITS_RADS = 48;
    public static final short NIFTI_UNITS_SEC = 8;
    public static final short NIFTI_UNITS_UNKNOWN = 0;
    public static final short NIFTI_UNITS_USEC = 24;
    public static final short NIFTI_XFORM_ALIGNED_ANAT = 2;
    public static final short NIFTI_XFORM_MNI_152 = 4;
    public static final short NIFTI_XFORM_SCANNER_ANAT = 1;
    public static final short NIFTI_XFORM_TALAIRACH = 3;
    public static final short NIFTI_XFORM_UNKNOWN = 0;

    public static byte[] getHeaderExtensionMagicNumber1() {
        return Arrays.copyOf(NIFTI_HEADER_EXTENSION_MAGIC_NUMBER_1, NIFTI_HEADER_EXTENSION_MAGIC_NUMBER_1.length);
    }

    public static byte[] getHeaderExtensionMagicNumberOld() {
        return Arrays.copyOf(NIFTI_HEADER_EXTENSION_MAGIC_NUMBER_OLD, NIFTI_HEADER_EXTENSION_MAGIC_NUMBER_OLD.length);
    }

    public static byte[] getMagicNumber1() {
        return Arrays.copyOf(MAGIC_NUMBER1, MAGIC_NUMBER1.length);
    }

    public static byte[] getMagicNumber2() {
        return Arrays.copyOf(MAGIC_NUMBER2, MAGIC_NUMBER2.length);
    }

    public static String getNiftiUnitString(int code) {
        return NIFTI_UNIT_STRING[code];
    }

    public static String getTransformCodeLabel(int code) {
        if (code == 0) {
            return UNKNOWN;
        }
        if (code == 1) {
            return "Scanner";
        }
        if (code == 2) {
            return "Aligned";
        }
        if (code == 3) {
            return "Aligned to Talairach";
        }
        if (code == 4) {
            return "Aligned to MNI";
        }
        return null;
    }

    public static byte[] setNiftiHeaderExtensionFlag(byte[] headerArray) {
        if (CollectionUtilities.isNotEmpty((Object)headerArray)) {
            int index = 0;
            for (int ctr = headerArray.length - 4; ctr < headerArray.length; ++ctr) {
                headerArray[ctr] = NIFTI_HEADER_EXTENSION_MAGIC_NUMBER_1[index++];
            }
        }
        return headerArray;
    }

    public NIFTI() {
        this.pixDim = new double[8];
        this.intentP = new double[3];
        this.affine = new double[4][4];
    }

    public boolean canCompress() {
        return true;
    }

    public void clearTransforms() {
        this.offsetZ = 0.0;
        this.offsetY = 0.0;
        this.offsetX = 0.0;
        this.quaternD = 0.0;
        this.quaternC = 0.0;
        this.quaternB = 0.0;
        this.pixDim[0] = 0.0;
        this.sFormCode = 0;
        this.qFormCode = 0;
        this.affine = new double[4][4];
    }

    public File formatImageFile(File headerFile) {
        return new File(this.makeImageURI(headerFile.toURI()));
    }

    public int getByteTypeValue() {
        if (this.dataType == 2) {
            return 3;
        }
        if (this.dataType == 4) {
            return 2;
        }
        if (this.dataType == 8) {
            return 2;
        }
        if (this.dataType == 16) {
            return 4;
        }
        if (this.dataType == 32) {
            return 5;
        }
        if (this.dataType == 64) {
            return 4;
        }
        if (this.dataType == 128) {
            return 6;
        }
        if (this.dataType == 256) {
            return 2;
        }
        if (this.dataType == 512) {
            return 3;
        }
        if (this.dataType == 768) {
            return 3;
        }
        if (this.dataType == 1024) {
            return 2;
        }
        if (this.dataType == 1280) {
            return 3;
        }
        if (this.dataType == 1536) {
            return 4;
        }
        if (this.dataType == 1792) {
            return 5;
        }
        if (this.dataType == 2048) {
            return 5;
        }
        return 0;
    }

    public Map<String, List<String>> getEditableFieldValues() {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        map.put(TEXT_DIM_INFO, Arrays.asList(String.valueOf(this.dimInfo)));
        map.put(TEXT_IMAGE_DIMENSIONS, Arrays.asList(String.valueOf(this.dim[0]), String.valueOf(this.dim[1]), String.valueOf(this.dim[2]), String.valueOf(this.dim[3]), String.valueOf(this.dim[4]), String.valueOf(this.dim[5]), String.valueOf(this.dim[6]), String.valueOf(this.dim[7])));
        map.put(TEXT_INTENT_PARAMETERS, Arrays.asList(String.valueOf(this.intentP[0]), String.valueOf(this.intentP[1]), String.valueOf(this.intentP[2])));
        map.put(TEXT_INTENT_CODE, Arrays.asList(String.valueOf(this.intentCode)));
        map.put(TEXT_DATATYPE, Arrays.asList(String.valueOf(this.dataType)));
        map.put(TEXT_BITS_PER_VOXEL, Arrays.asList(String.valueOf(this.bitPix)));
        map.put(TEXT_SLICE_START, Arrays.asList(String.valueOf(this.sliceStart)));
        map.put(TEXT_VOXEL_DIMENSIONS, Arrays.asList(String.valueOf(this.pixDim[0]), String.valueOf(this.pixDim[1]), String.valueOf(this.pixDim[2]), String.valueOf(this.pixDim[3]), String.valueOf(this.pixDim[4]), String.valueOf(this.pixDim[5]), String.valueOf(this.pixDim[6]), String.valueOf(this.pixDim[7])));
        map.put(TEXT_IMAGE_OFFSET, Arrays.asList(String.valueOf(this.voxOffset)));
        map.put(TEXT_DATA_SCALE, Arrays.asList(String.valueOf(this.dataSlope), String.valueOf(this.dataIntercept)));
        map.put(TEXT_SLICE_END, Arrays.asList(String.valueOf(this.sliceEnd)));
        map.put(TEXT_SLICE_CODE, Arrays.asList(String.valueOf(this.sliceCode)));
        map.put(TEXT_UNITS_CODE, Arrays.asList(String.valueOf(this.units & 7), String.valueOf(this.units & 0x38)));
        map.put(TEXT_DISPLAY_RANGE, Arrays.asList(String.valueOf(this.calMax), String.valueOf(this.calMin)));
        map.put(TEXT_SLICE_DURATION, Arrays.asList(String.valueOf(this.sliceDuration)));
        map.put(TEXT_TIME_AXIS_SHIFT, Arrays.asList(String.valueOf(this.tOffset)));
        try {
            map.put(TEXT_DESCRIPTION, Arrays.asList(new String(this.description, CHARACTER_ENCODING).trim()));
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        try {
            map.put(TEXT_AUXILIARY_FILE, Arrays.asList(new String(this.auxFile, CHARACTER_ENCODING).trim()));
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        map.put(TEXT_Q_FORM_CODE, Arrays.asList(String.valueOf(this.qFormCode)));
        map.put(TEXT_S_FORM_CODE, Arrays.asList(String.valueOf(this.sFormCode)));
        map.put(TEXT_QUATERNION_PARAMETERS, Arrays.asList(String.valueOf(this.quaternB), String.valueOf(this.quaternC), String.valueOf(this.quaternD)));
        map.put(TEXT_QUATERNION_OFFSETS, Arrays.asList(String.valueOf(this.offsetX), String.valueOf(this.offsetY), String.valueOf(this.offsetZ)));
        map.put(TEXT_S_FORM_PARAMETERS_X, Arrays.asList(String.valueOf(this.affine[0][0]), String.valueOf(this.affine[0][1]), String.valueOf(this.affine[0][2]), String.valueOf(this.affine[0][3])));
        map.put(TEXT_S_FORM_PARAMETERS_Y, Arrays.asList(String.valueOf(this.affine[1][0]), String.valueOf(this.affine[1][1]), String.valueOf(this.affine[1][2]), String.valueOf(this.affine[1][3])));
        map.put(TEXT_S_FORM_PARAMETERS_Z, Arrays.asList(String.valueOf(this.affine[2][0]), String.valueOf(this.affine[2][1]), String.valueOf(this.affine[2][2]), String.valueOf(this.affine[2][3])));
        try {
            map.put(TEXT_INTENT_NAME, Arrays.asList(new String(this.intentName, CHARACTER_ENCODING).trim()));
        }
        catch (UnsupportedEncodingException ex) {
            AppLogger.error((Throwable)ex);
        }
        return map;
    }

    public byte[] getExtension() {
        return this.extension;
    }

    public int getExtensionCode() {
        return this.extCode;
    }

    public int getExtensionFlag() {
        return this.extensionFlag[0];
    }

    public int getExtensionSize() {
        return this.extSize;
    }

    public int getHeaderSize() {
        return this.twoFileFormat ? 348 : 352;
    }

    public Map<String, List<EditableHeader.CodeOption>> getHumanReadableFieldOptions() {
        LinkedHashMap<String, List<EditableHeader.CodeOption>> map = new LinkedHashMap<String, List<EditableHeader.CodeOption>>();
        ArrayList<EditableHeader.CodeOption> dataTypeOptions = new ArrayList<EditableHeader.CodeOption>();
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(2), "Unsigned 8-bit Integer"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(512), "Unsigned 16-bit Integer"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(768), "Unsigned 32-bit Integer"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(1280), "Unsigned 64-bit Integer"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(256), "Signed 8-bit Integer"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(4), "Signed 16-bit Integer"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(8), "Signed 32-bit Integer"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(1024), "Signed 64-bit Integer"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(16), "Float 32-bit"));
        dataTypeOptions.add(new EditableHeader.CodeOption(String.valueOf(64), "Float 64-bit"));
        Collections.sort(dataTypeOptions);
        map.put(TEXT_DATATYPE, dataTypeOptions);
        ArrayList<EditableHeader.CodeOption> qFormCodeOptions = new ArrayList<EditableHeader.CodeOption>();
        qFormCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(0), UNKNOWN));
        qFormCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(1), "Scanner-based anatomical coordinates"));
        qFormCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(2), "Coordinates aligned"));
        qFormCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(3), "Coordinates aligned to Talairach-Tournoux Atlas"));
        qFormCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(4), "MNI 152 normalized coordinates"));
        Collections.sort(qFormCodeOptions);
        map.put(TEXT_Q_FORM_CODE, qFormCodeOptions);
        ArrayList<EditableHeader.CodeOption> sFormCodeOptions = new ArrayList<EditableHeader.CodeOption>();
        sFormCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(0), UNKNOWN));
        sFormCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(1), "Scanner-based anatomical coordinates"));
        sFormCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(2), "Coordinates aligned"));
        sFormCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(3), "Coordinates aligned to Talairach-Tournoux Atlas"));
        sFormCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(4), "MNI 152 normalized coordinates"));
        Collections.sort(sFormCodeOptions);
        map.put(TEXT_S_FORM_CODE, sFormCodeOptions);
        ArrayList<EditableHeader.CodeOption> intentCodeOptions = new ArrayList<EditableHeader.CodeOption>();
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(0), UNKNOWN));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(2), "Correlation coefficient R"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(3), "Student t statistic"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(4), "Fisher F statistic"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(5), "Standard normal"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(6), "Chi-squared"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(7), "Beta distribution"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(8), "Binomial distribution"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(9), "Gamma distribution"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(10), "Poisson distribution"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(11), "Normal distribution"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(12), "Noncentral F statistic"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(13), "Noncentral chi-squared statistic"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(14), "Logistic distribution"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(15), "Laplace distribution"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(16), "Uniform distribution"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(17), "Noncentral t statistic"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(18), "Weibull distribution"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(19), "Chi distribution"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(20), "Inverse Gaussian"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(21), "Extreme value type I"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(22), "p-value"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(23), "ln(p-value)"));
        intentCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(24), "log10(p-value)"));
        Collections.sort(intentCodeOptions);
        map.put(TEXT_INTENT_CODE, intentCodeOptions);
        ArrayList<EditableHeader.CodeOption> unitCodeOptions = new ArrayList<EditableHeader.CodeOption>();
        unitCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(0), UNKNOWN));
        unitCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(1), "Meters"));
        unitCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(2), "Millimeters"));
        unitCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(3), "Micron"));
        unitCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(8), "Seconds"));
        unitCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(16), "Milliseconds"));
        unitCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(24), "Mircoseconds"));
        Collections.sort(unitCodeOptions);
        map.put(TEXT_UNITS_CODE, unitCodeOptions);
        ArrayList<EditableHeader.CodeOption> sliceCodeOptions = new ArrayList<EditableHeader.CodeOption>();
        sliceCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(0), UNKNOWN));
        sliceCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(1), "Sequential Increasing"));
        sliceCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(2), "Sequential Decreasing"));
        sliceCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(3), "Alternating Increasing"));
        sliceCodeOptions.add(new EditableHeader.CodeOption(String.valueOf(4), "Alternating Decreasing"));
        Collections.sort(sliceCodeOptions);
        map.put(TEXT_SLICE_CODE, sliceCodeOptions);
        return map;
    }

    @Deprecated
    public ByteBuffer getImage() {
        return null;
    }

    public ByteBuffer[] getImageBuffers() {
        return new ByteBuffer[0];
    }

    public ImageDescription getImageDescription() {
        ImageDescription id = new ImageDescription("", "", null, this.makeImageDescriptionString());
        id.setFile(this.headerFile);
        return id;
    }

    public ImageDimensions getImageDimensions() {
        ImageDimensions imageDimensions = new ImageDimensions((int)this.dim[1], (int)this.dim[2], (int)this.dim[3], (int)this.dim[4]);
        int offset = (int)this.voxOffset;
        if (!this.twoFileFormat && offset < this.getHeaderSize()) {
            offset = this.getHeaderSize();
        }
        imageDimensions.setImageOffset(offset);
        return imageDimensions;
    }

    public URI getImageFile() {
        return this.makeImageURI(this.headerFile);
    }

    public ImageIntent getImageIntent() {
        return new ImageIntent(this.intentCode, new String(this.intentName), this.getIntentP(0), this.getIntentP(1), this.getIntentP(2));
    }

    public ImageRange getImageRange() {
        int dimTime;
        int dimSlice;
        ImageRange imageRange = new ImageRange(0.0, 0.0, this.calMin, this.calMax);
        double slope = this.dataSlope;
        if (slope == 0.0) {
            slope = 1.0;
        }
        if ((dimSlice = (int)this.dim[3]) == 0) {
            dimSlice = 1;
        }
        if ((dimTime = (int)this.dim[4]) == 0) {
            dimTime = 1;
        }
        imageRange.setGlobalDataScaleSlope(dimSlice * dimTime, (float)slope);
        imageRange.setGlobalDataScaleIntercept(dimSlice * dimTime, (float)this.dataIntercept);
        return imageRange;
    }

    public ImageType getImageType() {
        ImageType it = new ImageType(this.getNumBytesPerVoxel(), this.getByteTypeValue(), this.getNumBytesPerVoxel() * 8, this.littleEndian);
        it.setCompressionType(this.compressed ? 1 : 0);
        it.setRGBMode(this.dataType == 128);
        return it;
    }

    public String getMinimumVersionSupported() {
        return null;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public double getOffsetZ() {
        return this.offsetZ;
    }

    public String getOrientation() {
        String orientation = null;
        if (this.qFormCode > 0 && !this.qFormHasRotations()) {
            orientation = this.getOrientationQform();
        }
        if (this.getSFormCode() > this.qFormCode && !this.sFormHasRotations()) {
            orientation = this.getOrientationSform();
        }
        if (orientation == null) {
            orientation = Orientation.getDefaultOrientation("NIFTI");
        }
        return orientation;
    }

    public int getOrientationCertainty() {
        int orientationCertainty = 0;
        if (this.qFormCode > 0 || this.sFormCode > 0) {
            Coordinate origin;
            String orientation = this.getOrientation();
            if (orientation != null && Orientation.isValidOrientationString(orientation)) {
                orientationCertainty = 1;
            }
            if (orientationCertainty > 0 && (origin = this.getOrigin()) != null && !origin.isAllZeros()) {
                orientationCertainty = 2;
            }
        }
        return orientationCertainty;
    }

    public Coordinate getOrigin() {
        return this.getOrigin(false, false);
    }

    public String getPluginName() {
        return "NIFTI";
    }

    public URL getPluginURL() {
        return null;
    }

    public String getPreferredFileExtension() {
        return ".nii";
    }

    public float[] getPreviewImage() {
        return new float[0];
    }

    public int getQFormCode() {
        return this.qFormCode;
    }

    public int getSFormCode() {
        return this.sFormCode;
    }

    public Matrix getSFormMat() {
        return new Matrix(this.affine);
    }

    public double[][] getSFormMatArray() {
        return this.affine;
    }

    public Matrix getSFormMatInverse() {
        Matrix returnMat = null;
        try {
            returnMat = this.getSFormMat().inverse();
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
            returnMat = this.getSFormMat();
        }
        return returnMat;
    }

    public short[] getSliceAnnotation(int slice, int seriesPoint) {
        return CollectionUtilities.EMPTY_SHORT_ARRAY;
    }

    public String getSliceMetadata(int slice, int seriesPoint) {
        return null;
    }

    public int[] getSupportedBytesForType(int type) {
        if (type == 2) {
            return new int[]{1, 2, 4};
        }
        if (type == 3) {
            return new int[]{1, 2, 4};
        }
        if (type == 4) {
            return new int[]{4};
        }
        return null;
    }

    public String[] getSupportedOrientations() {
        return CollectionUtilities.EMPTY_STRING_ARRAY;
    }

    public int[] getSupportedTypesForBytes(int bytes) {
        if (bytes == 1) {
            return new int[]{2, 3};
        }
        if (bytes == 2) {
            return new int[]{2, 3};
        }
        if (bytes == 4) {
            return new int[]{2, 3, 4};
        }
        return null;
    }

    public ImageTransform[] getTransforms() {
        Vector<SimpleTransform> xforms = new Vector<SimpleTransform>();
        double[][] affineQform = Orientation.convertNiftiQFormToNiftiSForm(this.quaternB, this.quaternC, this.quaternD, this.offsetX, this.offsetY, this.offsetZ, this.pixDim[1], this.pixDim[2], this.pixDim[3], this.pixDim[0]);
        xforms.add(new SimpleTransform(affineQform, this.getOrigin(true, false)));
        xforms.add(new SimpleTransform(this.affine, this.getOrigin(false, true)));
        return xforms.toArray(new ImageTransform[xforms.size()]);
    }

    public String getVersion() {
        return null;
    }

    public VoxelDimensions getVoxelDimensions() {
        VoxelDimensions voxelDimensions = new VoxelDimensions(this.pixDim[1], this.pixDim[2], this.pixDim[3], this.pixDim[4]);
        voxelDimensions.setSpatialUnit(this.units & 7);
        voxelDimensions.setTemporalUnit(this.units & 0x38);
        voxelDimensions.setFlip(this.pixDim[0] == -1.0);
        return voxelDimensions;
    }

    public boolean hasNewerVersion() {
        return false;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public boolean isIgnoreExtension() {
        return this.ignoreExtension;
    }

    public boolean isSupportedBigEndian() {
        return true;
    }

    public boolean isSupportedDataScaleIntercept() {
        return true;
    }

    public boolean isSupportedDataScaleSlope() {
        return true;
    }

    public boolean isSupportedLittleEndian() {
        return true;
    }

    public boolean isSupportedMultipleDataScales() {
        return false;
    }

    public boolean isTextEditableHeader() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThisFormat(File file) {
        boolean success = false;
        boolean usesGZIPExtension = CompressionUtilities.usesGZIPFileExtension((String)file.toString());
        boolean isGZIPFile = usesGZIPExtension || CompressionUtilities.isPossibleGZIPFile((File)file);
        BufferedInputStream fileIn = null;
        ByteBuffer byteBuffer = null;
        byte[] byteArray = new byte[348];
        try {
            fileIn = FileUtilities.getInputStream((URI)file.toURI(), (boolean)isGZIPFile);
            FileUtilities.readFully((InputStream)fileIn, (byte[])byteArray);
            byteBuffer = ByteBuffer.wrap(byteArray);
            if (byteBuffer.getInt(0) == 348 || ByteUtilities.swap((int)byteBuffer.getInt(0)) == 348) {
                byte[] magic = new byte[4];
                for (int ctr = 0; ctr < magic.length; ++ctr) {
                    magic[ctr] = byteBuffer.get(344 + ctr);
                }
                if (Arrays.equals(magic, MAGIC_NUMBER1)) {
                    success = true;
                } else if (Arrays.equals(magic, MAGIC_NUMBER2)) {
                    success = true;
                }
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        return success;
    }

    public void readHeader(File file, File tempDir) throws InvalidHeaderException {
        this.readHeader(file.toURI(), tempDir);
    }

    public void readHeader(URI file, File tempDir) throws InvalidHeaderException {
        int ctr;
        int ctr2;
        BufferedInputStream fileIn = null;
        ByteBuffer byteBuffer = null;
        this.headerFile = file;
        try {
            int bytesRead;
            boolean isGZIPFile;
            boolean usesGZIPExtension = CompressionUtilities.usesGZIPFileExtension((String)file.toString());
            this.compressed = isGZIPFile = usesGZIPExtension || CompressionUtilities.isPossibleGZIPFile((File)new File(file));
            fileIn = FileUtilities.getInputStream((URI)file, (boolean)this.compressed);
            byte[] byteArray = new byte[this.getHeaderSize()];
            for (int totalBytesRead = bytesRead = fileIn.read(byteArray); totalBytesRead > 0 && totalBytesRead < byteArray.length; totalBytesRead += bytesRead) {
                bytesRead = fileIn.read(byteArray, totalBytesRead, byteArray.length - totalBytesRead);
            }
            byteBuffer = ByteBuffer.wrap(byteArray);
        }
        catch (IOException ex) {
            throw new InvalidHeaderException(ex.getMessage(), (Exception)ex);
        }
        finally {
            try {
                if (fileIn != null) {
                    fileIn.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        if (byteBuffer.getInt(0) == 348) {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        } else if (ByteUtilities.swap((int)byteBuffer.getInt(0)) == 348) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            throw new InvalidHeaderException("Does not appear to be a valid NIFTI file: Size field does not equal 348.");
        }
        this.littleEndian = byteBuffer.order().toString().equals(ByteOrder.LITTLE_ENDIAN.toString());
        this.unused = new byte[35];
        for (ctr2 = 0; ctr2 < 35; ++ctr2) {
            this.unused[ctr2] = byteBuffer.get(4 + ctr2);
        }
        this.dimInfo = byteBuffer.get(39);
        this.dim[0] = byteBuffer.getShort(40);
        this.dim[1] = byteBuffer.getShort(42);
        this.dim[2] = byteBuffer.getShort(44);
        this.dim[3] = byteBuffer.getShort(46);
        this.dim[4] = byteBuffer.getShort(48);
        this.dim[5] = byteBuffer.getShort(50);
        this.dim[6] = byteBuffer.getShort(52);
        this.dim[7] = byteBuffer.getShort(54);
        this.intentP[0] = byteBuffer.getFloat(56);
        this.intentP[1] = byteBuffer.getFloat(60);
        this.intentP[2] = byteBuffer.getFloat(64);
        this.intentCode = byteBuffer.getShort(68);
        this.dataType = byteBuffer.getShort(70);
        this.bitPix = byteBuffer.getShort(72);
        this.sliceStart = byteBuffer.getShort(74);
        this.pixDim[0] = byteBuffer.getFloat(76);
        this.pixDim[1] = byteBuffer.getFloat(80);
        this.pixDim[2] = byteBuffer.getFloat(84);
        this.pixDim[3] = byteBuffer.getFloat(88);
        this.pixDim[4] = byteBuffer.getFloat(92);
        this.pixDim[5] = byteBuffer.getFloat(96);
        this.pixDim[6] = byteBuffer.getFloat(100);
        this.pixDim[7] = byteBuffer.getFloat(104);
        this.voxOffset = (long)byteBuffer.getFloat(108);
        this.dataSlope = byteBuffer.getFloat(112);
        this.dataIntercept = byteBuffer.getFloat(116);
        this.sliceEnd = byteBuffer.getShort(120);
        this.sliceCode = byteBuffer.get(122);
        this.units = byteBuffer.get(123);
        this.calMax = byteBuffer.getFloat(124);
        this.calMin = byteBuffer.getFloat(128);
        this.sliceDuration = byteBuffer.getFloat(132);
        this.tOffset = byteBuffer.getFloat(136);
        this.description = new byte[80];
        for (ctr2 = 0; ctr2 < 80; ++ctr2) {
            this.description[ctr2] = byteBuffer.get(148 + ctr2);
        }
        this.auxFile = new byte[24];
        for (ctr2 = 0; ctr2 < 24; ++ctr2) {
            this.auxFile[ctr2] = byteBuffer.get(228 + ctr2);
        }
        this.qFormCode = byteBuffer.getShort(252);
        this.sFormCode = byteBuffer.getShort(254);
        this.quaternB = byteBuffer.getFloat(256);
        this.quaternC = byteBuffer.getFloat(260);
        this.quaternD = byteBuffer.getFloat(264);
        this.offsetX = byteBuffer.getFloat(268);
        this.offsetY = byteBuffer.getFloat(272);
        this.offsetZ = byteBuffer.getFloat(276);
        this.affine[0][0] = byteBuffer.getFloat(280);
        this.affine[0][1] = byteBuffer.getFloat(284);
        this.affine[0][2] = byteBuffer.getFloat(288);
        this.affine[0][3] = byteBuffer.getFloat(292);
        this.affine[1][0] = byteBuffer.getFloat(296);
        this.affine[1][1] = byteBuffer.getFloat(300);
        this.affine[1][2] = byteBuffer.getFloat(304);
        this.affine[1][3] = byteBuffer.getFloat(308);
        this.affine[2][0] = byteBuffer.getFloat(312);
        this.affine[2][1] = byteBuffer.getFloat(316);
        this.affine[2][2] = byteBuffer.getFloat(320);
        this.affine[2][3] = byteBuffer.getFloat(324);
        this.affine[3][0] = 0.0;
        this.affine[3][1] = 0.0;
        this.affine[3][2] = 0.0;
        this.affine[3][3] = 1.0;
        this.intentName = new byte[16];
        for (ctr2 = 0; ctr2 < 16; ++ctr2) {
            this.intentName[ctr2] = byteBuffer.get(328 + ctr2);
        }
        byte[] magic = new byte[4];
        for (ctr = 0; ctr < magic.length; ++ctr) {
            magic[ctr] = byteBuffer.get(344 + ctr);
        }
        this.twoFileFormat = Arrays.equals(magic, MAGIC_NUMBER1);
        this.extensionFlag = new byte[4];
        for (ctr = 0; ctr < this.extensionFlag.length; ++ctr) {
            this.extensionFlag[ctr] = byteBuffer.get(348 + ctr);
        }
        if (this.extensionFlag[0] != 0) {
            if (!this.ignoreExtension && this.isExtensionValid(file, -1L)) {
                this.readExtension(file);
            } else {
                this.extensionFlag[0] = 0;
            }
        }
    }

    public void setDataIntercept(float dataIntercept) {
        this.dataIntercept = dataIntercept;
    }

    public void setDataSlope(float dataSlope) {
        this.dataSlope = dataSlope;
    }

    public void setEditableFieldValue(String name, String value, int index) {
        if (name.equals(TEXT_DIM_INFO)) {
            this.dimInfo = (byte)Integer.parseInt(value);
        } else if (name.equals(TEXT_IMAGE_DIMENSIONS)) {
            this.dim[index] = Integer.parseInt(value);
        } else if (name.equals(TEXT_INTENT_PARAMETERS)) {
            this.intentP[index] = Double.parseDouble(value);
        } else if (name.equals(TEXT_INTENT_CODE)) {
            this.intentCode = Integer.parseInt(value);
        } else if (name.equals(TEXT_DATATYPE)) {
            this.dataType = (short)Integer.parseInt(value);
        } else if (name.equals(TEXT_BITS_PER_VOXEL)) {
            this.bitPix = (short)Integer.parseInt(value);
        } else if (name.equals(TEXT_SLICE_START)) {
            this.sliceStart = Integer.parseInt(value);
        } else if (name.equals(TEXT_VOXEL_DIMENSIONS)) {
            this.pixDim[index] = Double.parseDouble(value);
        } else if (name.equals(TEXT_IMAGE_OFFSET)) {
            this.voxOffset = Integer.parseInt(value);
        } else if (name.equals(TEXT_DATA_SCALE)) {
            if (index == 0) {
                this.dataSlope = Double.parseDouble(value);
            } else if (index == 1) {
                this.dataIntercept = Double.parseDouble(value);
            }
        } else if (name.equals(TEXT_SLICE_END)) {
            this.sliceEnd = Integer.parseInt(value);
        } else if (name.equals(TEXT_SLICE_CODE)) {
            this.sliceCode = Integer.parseInt(value);
        } else if (name.equals(TEXT_UNITS_CODE)) {
            if (index == 0) {
                this.units &= 0xFFFFFFF8;
                this.units |= Integer.parseInt(value);
            } else {
                this.units &= 0xFFFFFFC7;
                this.units |= Integer.parseInt(value);
            }
        } else if (name.equals(TEXT_DISPLAY_RANGE)) {
            if (index == 0) {
                this.calMax = Double.parseDouble(value);
            } else if (index == 1) {
                this.calMin = Double.parseDouble(value);
            }
        } else if (name.equals(TEXT_SLICE_DURATION)) {
            this.sliceDuration = Double.parseDouble(value);
        } else if (name.equals(TEXT_TIME_AXIS_SHIFT)) {
            this.tOffset = Double.parseDouble(value);
        } else if (name.equals(TEXT_DESCRIPTION)) {
            try {
                this.description = value.getBytes(CHARACTER_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                AppLogger.error((Throwable)ex);
            }
        } else if (name.equals(TEXT_AUXILIARY_FILE)) {
            try {
                this.auxFile = value.getBytes(CHARACTER_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                AppLogger.error((Throwable)ex);
            }
        } else if (name.equals(TEXT_Q_FORM_CODE)) {
            this.qFormCode = Integer.parseInt(value);
        } else if (name.equals(TEXT_S_FORM_CODE)) {
            this.sFormCode = Integer.parseInt(value);
        } else if (name.equals(TEXT_QUATERNION_PARAMETERS)) {
            if (index == 0) {
                this.quaternB = Double.parseDouble(value);
            } else if (index == 1) {
                this.quaternC = Double.parseDouble(value);
            } else if (index == 2) {
                this.quaternD = Double.parseDouble(value);
            }
        } else if (name.equals(TEXT_QUATERNION_OFFSETS)) {
            if (index == 0) {
                this.offsetX = Double.parseDouble(value);
            } else if (index == 1) {
                this.offsetY = Double.parseDouble(value);
            } else if (index == 2) {
                this.offsetZ = Double.parseDouble(value);
            }
        } else if (name.equals(TEXT_S_FORM_PARAMETERS_X)) {
            if (index == 0) {
                this.affine[0][0] = Double.parseDouble(value);
            } else if (index == 1) {
                this.affine[0][1] = Double.parseDouble(value);
            } else if (index == 2) {
                this.affine[0][2] = Double.parseDouble(value);
            } else if (index == 3) {
                this.affine[0][3] = Double.parseDouble(value);
            }
        } else if (name.equals(TEXT_S_FORM_PARAMETERS_Y)) {
            if (index == 0) {
                this.affine[1][0] = Double.parseDouble(value);
            } else if (index == 1) {
                this.affine[1][1] = Double.parseDouble(value);
            } else if (index == 2) {
                this.affine[1][2] = Double.parseDouble(value);
            } else if (index == 3) {
                this.affine[1][3] = Double.parseDouble(value);
            }
        } else if (name.equals(TEXT_S_FORM_PARAMETERS_Z)) {
            if (index == 0) {
                this.affine[2][0] = Double.parseDouble(value);
            } else if (index == 1) {
                this.affine[2][1] = Double.parseDouble(value);
            } else if (index == 2) {
                this.affine[2][2] = Double.parseDouble(value);
            } else if (index == 3) {
                this.affine[2][3] = Double.parseDouble(value);
            }
        } else if (name.equals(TEXT_INTENT_NAME)) {
            try {
                this.intentName = value.getBytes(CHARACTER_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    public void setIgnoreExtension(boolean ignoreExtension) {
        this.ignoreExtension = ignoreExtension;
    }

    public void setOrientation(NIFTI nifti) {
        if (nifti != null) {
            this.qFormCode = nifti.qFormCode;
            this.pixDim[0] = nifti.pixDim[0];
            this.quaternB = nifti.quaternB;
            this.quaternC = nifti.quaternC;
            this.quaternD = nifti.quaternD;
            this.offsetX = nifti.offsetX;
            this.offsetY = nifti.offsetY;
            this.offsetZ = nifti.offsetZ;
            this.sFormCode = nifti.getSFormCode();
            double[][] affineCopy = nifti.getSFormMatArray();
            for (int ctrOut = 0; ctrOut < 4; ++ctrOut) {
                for (int ctrIn = 0; ctrIn < 4; ++ctrIn) {
                    this.affine[ctrOut][ctrIn] = affineCopy[ctrOut][ctrIn];
                }
            }
            this.orientationUpdated = true;
        }
    }

    public String toString() {
        String string = "";
        DecimalFormat fmt = new DecimalFormat("0.0####");
        String equals = " = ";
        string = string + "Dim Info = " + this.dimInfo + "\n";
        string = string + "Image Dimensions (1-8): " + this.dim[0] + ", " + this.dim[1] + ", " + this.dim[2] + ", " + this.dim[3] + ", " + this.dim[4] + ", " + this.dim[5] + ", " + this.dim[6] + ", " + this.dim[7] + "\n";
        string = string + "Intent Parameters (1-3): " + this.intentP[0] + ", " + this.intentP[1] + ", " + this.intentP[2] + "\n";
        string = string + "Intent Code = " + this.intentCode + "\n";
        string = string + "Datatype = " + this.dataType + "\n";
        string = string + "Bits Per Voxel = " + this.bitPix + "\n";
        string = string + "Slice Start = " + this.sliceStart + "\n";
        string = string + "Voxel Dimensions (1-8): " + fmt.format(this.pixDim[0]) + ", " + fmt.format(this.pixDim[1]) + ", " + fmt.format(this.pixDim[2]) + ", " + fmt.format(this.pixDim[3]) + ", " + fmt.format(this.pixDim[4]) + ", " + fmt.format(this.pixDim[5]) + ", " + fmt.format(this.pixDim[6]) + ", " + fmt.format(this.pixDim[7]) + "\n";
        string = string + "Image Offset = " + this.voxOffset + "\n";
        string = string + "Data Scale (Slope, Intercept):  Slope = " + fmt.format(this.dataSlope) + "  Intercept = " + fmt.format(this.dataIntercept) + "\n";
        string = string + "Slice End = " + this.sliceEnd + "\n";
        string = string + "Slice Code = " + this.sliceCode + "\n";
        string = string + "Units Code (Spatial, Temporal) = " + this.units + "\n";
        string = string + "Display Range (Max, Min):  Max = " + this.calMax + "  Min = " + this.calMin + "\n";
        string = string + "Slice Duration = " + this.sliceDuration + "\n";
        string = string + "Time Axis Shift = " + this.tOffset + "\n";
        string = string + "Description: \"" + StringUtilities.convertToPrintableASCIIString((byte[])this.description) + "\"\n";
        string = string + "Auxiliary File: \"" + StringUtilities.convertToPrintableASCIIString((byte[])this.auxFile) + "\"\n";
        string = string + "Q-Form Code = " + this.qFormCode + "\n";
        string = string + "S-Form Code = " + this.sFormCode + "\n";
        string = string + "Quaternion Parameters:  b = " + fmt.format(this.quaternB) + "  c = " + fmt.format(this.quaternC) + "  d = " + fmt.format(this.quaternD) + "\n";
        string = string + "Quaternion Offsets:  x = " + fmt.format(this.offsetX) + "  y = " + fmt.format(this.offsetY) + "  z = " + fmt.format(this.offsetZ) + "\n";
        string = string + "S-Form Parameters X: " + fmt.format(this.affine[0][0]) + ", " + fmt.format(this.affine[0][1]) + ", " + fmt.format(this.affine[0][2]) + ", " + fmt.format(this.affine[0][3]) + "\n";
        string = string + "S-Form Parameters Y: " + fmt.format(this.affine[1][0]) + ", " + fmt.format(this.affine[1][1]) + ", " + fmt.format(this.affine[1][2]) + ", " + fmt.format(this.affine[1][3]) + "\n";
        string = string + "S-Form Parameters Z: " + fmt.format(this.affine[2][0]) + ", " + fmt.format(this.affine[2][1]) + ", " + fmt.format(this.affine[2][2]) + ", " + fmt.format(this.affine[2][3]) + "\n";
        string = string + "Intent Name: \"" + StringUtilities.convertToPrintableASCIIString((byte[])this.intentName) + "\"\n";
        if (this.getExtension() != null) {
            string = string + "Extension:  Code = " + this.extCode + "  Size = " + StringUtilities.makeNiceFileSizeString((long)this.getExtension().length) + "\n";
        }
        return string;
    }

    public boolean willWriteImage() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeader() {
        FilterOutputStream output = null;
        InputStream input = null;
        File headerFileF = new File(this.headerFile);
        try {
            byte[] header = this.writeHeader(null, null, null, null, null, this.compressed, null, null, null, headerFileF, headerFileF, null, null);
            if (!this.twoFileFormat) {
                long bytesSkipped;
                int offset = header.length;
                ByteBuffer outputBuffer = ByteBuffer.allocateDirect(offset);
                if (this.littleEndian) {
                    outputBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else {
                    outputBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                if (this.extension != null) {
                    for (int ctr = 0; ctr < this.extensionFlag.length; ++ctr) {
                        header[this.getExtensionFlagOffset() + ctr] = this.extensionFlag[ctr];
                    }
                }
                outputBuffer.put(header);
                File outputFile = File.createTempFile(FileUtilities.removeExtension((String)headerFileF.getName()), "." + FileUtilities.getFullExtension((File)headerFileF), headerFileF.getParentFile());
                output = this.compressed ? new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(outputFile))) : new BufferedOutputStream(new FileOutputStream(outputFile));
                byte[] buffer = new byte[2048];
                int bytesRead = 0;
                outputBuffer.rewind();
                outputBuffer.get(buffer, 0, header.length);
                ((BufferedOutputStream)output).write(buffer, 0, header.length);
                if (this.extension != null) {
                    ((BufferedOutputStream)output).write(this.extension, 0, this.extension.length);
                }
                input = FileUtilities.getInputStream((URI)this.headerFile, (boolean)this.compressed);
                long bytesToSkip = offset + (this.extension != null ? this.extension.length : 0);
                for (long totalBytesSkipped = bytesSkipped = input.skip(bytesToSkip); totalBytesSkipped < bytesToSkip; totalBytesSkipped += bytesSkipped) {
                    bytesSkipped = input.skip(bytesToSkip - totalBytesSkipped);
                }
                while ((bytesRead = input.read(buffer, 0, buffer.length)) > 0) {
                    ((BufferedOutputStream)output).write(buffer, 0, bytesRead);
                }
                FileUtilities.renameTo((File)outputFile, (File)headerFileF);
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    public byte[] writeHeader(ImageDimensions id, VoxelDimensions vd, ImageType it, ImageRange ir, ImageDescription des, boolean compress, Coordinate origin, String orientation, ImageTransform[] transforms, File headerFile, File imageFile, ByteBuffer[] imageBuffers, File tempDir) throws IOException, InvalidHeaderException {
        boolean bl = this.twoFileFormat = headerFile.getName().indexOf(".hdr") != -1;
        if (id != null) {
            this.updateDims4D((short)id.getCols(), (short)id.getRows(), (short)id.getSlices(), (short)id.getTimepoints());
            this.voxOffset = id.getImageOffset();
        }
        if (vd != null) {
            this.updatePixDims4D((float)vd.getColSize(true), (float)vd.getRowSize(true), (float)vd.getSliceThickness(true), (float)vd.getTR());
            this.units = (byte)(vd.getSpatialUnit() | vd.getTemporalUnit());
        }
        if (it != null) {
            this.updateDataType(it.getNumBytesPerVoxel(), it.getByteType(), it.isLittleEndian());
        }
        if (ir != null) {
            if (ir.hasGlobalDataScaleSlope()) {
                this.setDataSlope(ir.getDataScaleSlopes()[0]);
            } else {
                this.setDataSlope(1.0f);
            }
            if (ir.hasGlobalDataScaleIntercept()) {
                this.setDataIntercept(ir.getDataScaleIntercepts()[0]);
            } else {
                this.setDataIntercept(0.0f);
            }
            this.updateDisplayRange((float)ir.getDisplayMax(), (float)ir.getDisplayMin());
        }
        if (origin != null && orientation != null) {
            this.updateOrientation(orientation, origin);
        }
        if (des != null) {
            this.description = (des.getDescription() + " " + des.getAllID() + " " + des.getStudyDateString()).getBytes(CHARACTER_ENCODING);
        }
        this.compressed = compress;
        byte[] returnArray = null;
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[this.getHeaderSize()]);
        if (this.littleEndian) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        byteBuffer.putInt(348);
        byteBuffer.put(EMPTY, 0, 10);
        byteBuffer.put(EMPTY, 0, 18);
        byteBuffer.putInt(16384);
        byteBuffer.putShort((short)0);
        byteBuffer.put((byte)114);
        byteBuffer.put(this.dimInfo);
        byteBuffer.putShort((short)this.dim[0]);
        byteBuffer.putShort((short)this.dim[1]);
        byteBuffer.putShort((short)this.dim[2]);
        byteBuffer.putShort((short)this.dim[3]);
        byteBuffer.putShort((short)this.dim[4]);
        byteBuffer.putShort((short)this.dim[5]);
        byteBuffer.putShort((short)this.dim[6]);
        byteBuffer.putShort((short)this.dim[7]);
        byteBuffer.putFloat((float)this.getIntentP(0));
        byteBuffer.putFloat((float)this.getIntentP(1));
        byteBuffer.putFloat((float)this.getIntentP(2));
        byteBuffer.putShort((short)this.intentCode);
        byteBuffer.putShort(this.dataType);
        byteBuffer.putShort(this.bitPix);
        byteBuffer.putShort((short)this.sliceStart);
        byteBuffer.putFloat((float)this.pixDim[0]);
        byteBuffer.putFloat((float)this.pixDim[1]);
        byteBuffer.putFloat((float)this.pixDim[2]);
        byteBuffer.putFloat((float)this.pixDim[3]);
        byteBuffer.putFloat((float)this.pixDim[4]);
        byteBuffer.putFloat((float)this.pixDim[5]);
        byteBuffer.putFloat((float)this.pixDim[6]);
        byteBuffer.putFloat((float)this.pixDim[7]);
        float offset = this.voxOffset;
        if (!this.twoFileFormat && offset < (float)this.getHeaderSize()) {
            offset = this.getHeaderSize();
        }
        byteBuffer.putFloat(offset);
        byteBuffer.putFloat((float)this.dataSlope);
        byteBuffer.putFloat((float)this.dataIntercept);
        byteBuffer.putShort((short)this.sliceEnd);
        byteBuffer.put((byte)this.sliceCode);
        byteBuffer.put((byte)this.units);
        byteBuffer.putFloat((float)this.calMax);
        byteBuffer.putFloat((float)this.calMin);
        byteBuffer.putFloat((float)this.sliceDuration);
        byteBuffer.putFloat((float)this.tOffset);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        if (this.description == null || this.description.length == 0) {
            this.description = new byte[80];
        }
        if (this.description.length < 80) {
            byteBuffer.put(this.description, 0, this.description.length);
            byteBuffer.put(EMPTY, 0, 80 - this.description.length);
        } else {
            byteBuffer.put(this.description, 0, 80);
        }
        if (this.auxFile == null || this.auxFile.length == 0) {
            this.auxFile = new byte[24];
        }
        if (this.auxFile.length < 24) {
            byteBuffer.put(this.auxFile, 0, this.auxFile.length);
            byteBuffer.put(EMPTY, 0, 24 - this.auxFile.length);
        } else {
            byteBuffer.put(this.auxFile, 0, 24);
        }
        byteBuffer.putShort((short)this.qFormCode);
        byteBuffer.putShort((short)this.sFormCode);
        byteBuffer.putFloat((float)this.quaternB);
        byteBuffer.putFloat((float)this.quaternC);
        byteBuffer.putFloat((float)this.quaternD);
        byteBuffer.putFloat((float)this.offsetX);
        byteBuffer.putFloat((float)this.offsetY);
        byteBuffer.putFloat((float)this.offsetZ);
        byteBuffer.putFloat((float)this.affine[0][0]);
        byteBuffer.putFloat((float)this.affine[0][1]);
        byteBuffer.putFloat((float)this.affine[0][2]);
        byteBuffer.putFloat((float)this.affine[0][3]);
        byteBuffer.putFloat((float)this.affine[1][0]);
        byteBuffer.putFloat((float)this.affine[1][1]);
        byteBuffer.putFloat((float)this.affine[1][2]);
        byteBuffer.putFloat((float)this.affine[1][3]);
        byteBuffer.putFloat((float)this.affine[2][0]);
        byteBuffer.putFloat((float)this.affine[2][1]);
        byteBuffer.putFloat((float)this.affine[2][2]);
        byteBuffer.putFloat((float)this.affine[2][3]);
        if (this.intentName == null || this.intentName.length == 0) {
            this.intentName = new byte[16];
        }
        if (this.intentName.length < 16) {
            byteBuffer.put(this.intentName, 0, this.intentName.length);
            byteBuffer.put(EMPTY, 0, 16 - this.intentName.length);
        } else {
            byteBuffer.put(this.intentName, 0, 16);
        }
        FilterOutputStream fileOut = null;
        try {
            this.headerFile = headerFile.toURI();
            if (this.twoFileFormat) {
                fileOut = this.compressed ? new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(headerFile))) : new BufferedOutputStream(new FileOutputStream(headerFile));
                byteBuffer.put(MAGIC_NUMBER1);
                fileOut.write(byteBuffer.array());
            } else {
                byteBuffer.put(MAGIC_NUMBER2);
                byteBuffer.put(EMPTY, 0, 4);
                returnArray = byteBuffer.array();
            }
        }
        catch (FileNotFoundException ex) {
            throw new InvalidHeaderException(ex.getMessage(), (Exception)ex);
        }
        catch (IOException ex) {
            throw new InvalidHeaderException(ex.getMessage(), (Exception)ex);
        }
        finally {
            try {
                if (fileOut != null) {
                    fileOut.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return returnArray;
    }

    public byte[][] writeSeriesHeaders(ImageDimensions id, VoxelDimensions vd, ImageType it, ImageRange ir, ImageDescription des, boolean compress, Coordinate origin, String orientation, ImageTransform[] transforms, File headerFile, File imageFile, ByteBuffer[] imageBuffers, File tempDir) {
        return new byte[0][0];
    }

    protected int getExtensionFlagOffset() {
        return 348;
    }

    protected boolean isExtensionValid(URI uri, long extSize) {
        ImageDimensions id = this.getImageDimensions();
        ImageType it = this.getImageType();
        if (FileUtilities.uriIsFile((URI)uri) && !this.twoFileFormat) {
            long imageSize;
            long fileSizeShouldBeWithNoExtension;
            File file = new File(uri);
            long fileSizeIs = this.compressed ? (long)FileUtilities.getUncompressedFileSize((File)file) : file.length();
            if (fileSizeIs > (fileSizeShouldBeWithNoExtension = (imageSize = id.getNumVoxelsTimeseries() * (long)it.getNumBytesPerVoxel()) + (long)this.getHeaderSize())) {
                if (extSize == -1L) {
                    return true;
                }
                long diff = fileSizeIs - fileSizeShouldBeWithNoExtension;
                return diff <= extSize;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean readExtension(URI file) {
        boolean validExt;
        block16: {
            BufferedInputStream fileIn = null;
            validExt = true;
            try {
                int totalBytesRead;
                int bytesRead;
                long bytesSkipped;
                fileIn = FileUtilities.getInputStream((URI)file, (boolean)this.compressed);
                long bytesToSkip = this.getHeaderSize();
                for (long totalBytesSkipped = bytesSkipped = fileIn.skip(bytesToSkip); totalBytesSkipped < bytesToSkip; totalBytesSkipped += bytesSkipped) {
                    bytesSkipped = fileIn.skip(bytesToSkip - totalBytesSkipped);
                }
                fileIn.mark(9);
                byte[] extHdrArray = new byte[8];
                for (totalBytesRead = bytesRead = fileIn.read(extHdrArray); totalBytesRead < extHdrArray.length && (bytesRead = fileIn.read(extHdrArray, totalBytesRead, extHdrArray.length - totalBytesRead)) >= 0; totalBytesRead += bytesRead) {
                }
                ByteBuffer extHdrBuf = ByteBuffer.wrap(extHdrArray);
                extHdrBuf.order(this.littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                this.extSize = extHdrBuf.getInt();
                this.extCode = extHdrBuf.getInt();
                if (this.isExtensionValid(file, this.extSize)) {
                    this.extension = new byte[this.extSize];
                    fileIn.reset();
                    for (totalBytesRead = bytesRead = fileIn.read(this.extension); totalBytesRead < this.extension.length; totalBytesRead += bytesRead) {
                        bytesRead = fileIn.read(this.extension, totalBytesRead, this.extension.length - totalBytesRead);
                        if (bytesRead >= 0) continue;
                        break block16;
                    }
                    break block16;
                }
                validExt = false;
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
            finally {
                try {
                    if (fileIn != null) {
                        fileIn.close();
                    }
                }
                catch (IOException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        return validExt;
    }

    protected void updateDataType(int numBytesPerVoxel, int byteType, boolean bool) {
        this.dataType = numBytesPerVoxel == 1 && byteType == 3 ? (short)2 : (numBytesPerVoxel == 2 && byteType == 2 ? (short)4 : (numBytesPerVoxel == 4 && byteType == 2 ? (short)8 : (numBytesPerVoxel == 4 && byteType == 4 ? (short)16 : (numBytesPerVoxel == 8 && byteType == 5 ? (short)32 : (numBytesPerVoxel == 8 && byteType == 4 ? (short)64 : (numBytesPerVoxel == 3 && byteType == 6 ? (short)128 : (numBytesPerVoxel == 1 && byteType == 2 ? (short)256 : (numBytesPerVoxel == 2 && byteType == 3 ? (short)512 : (numBytesPerVoxel == 4 && byteType == 3 ? (short)768 : (numBytesPerVoxel == 8 && byteType == 3 ? (short)1280 : (numBytesPerVoxel == 16 && byteType == 4 ? (short)1536 : (numBytesPerVoxel == 16 && byteType == 5 ? (short)1792 : (numBytesPerVoxel == 32 && byteType == 5 ? (short)2048 : (short)0)))))))))))));
        this.littleEndian = bool;
        this.bitPix = (short)(numBytesPerVoxel * 8);
    }

    protected void updateDims4D(long dim1, long dim2, long dim3, long dim4) {
        this.dim[0] = 4L;
        this.dim[1] = dim1;
        this.dim[2] = dim2;
        this.dim[3] = dim3;
        this.dim[4] = dim4;
    }

    protected void updateDisplayRange(double aMax, double aMin) {
        this.calMin = aMin;
        this.calMax = aMax;
    }

    protected void updateOrientation(String orientation, Coordinate originVal) {
        if (this.orientationUpdated) {
            this.orientationUpdated = false;
            return;
        }
        Coordinate origin = originVal;
        int xIndex = orientation.indexOf(88);
        int yIndex = orientation.indexOf(89);
        int zIndex = orientation.indexOf(90);
        if (origin == null) {
            origin = new Coordinate();
            origin.setValuesRound((double)this.dim[1] / 2.0, (double)this.dim[2] / 2.0, (double)this.dim[3] / 2.0);
        }
        if (!(origin.equals((Object)this.getOrigin()) && orientation.equals(this.getOrientation()) || this.qFormCode == 0 && this.sFormCode == 0)) {
            this.clearTransforms();
            this.affine = Orientation.convertNEMAToNiftiSForm2(orientation, origin.xDbl, origin.yDbl, origin.zDbl, this.pixDim[xIndex + 1], this.pixDim[yIndex + 1], this.pixDim[zIndex + 1]);
            this.sFormCode = 2;
        } else if (this.qFormCode == 0 && this.sFormCode == 0) {
            double[][] qform = Orientation.convertNEMAToNiftiSForm2(orientation, origin.xDbl, origin.yDbl, origin.zDbl, this.pixDim[xIndex + 1], this.pixDim[yIndex + 1], this.pixDim[zIndex + 1]);
            double[] quaterns = new double[3];
            double[] offsets = new double[3];
            this.pixDim[0] = (float)Orientation.convertNiftiSFormToNiftiQForm(qform, quaterns, offsets);
            this.offsetX = (float)offsets[0];
            this.offsetY = (float)offsets[1];
            this.offsetZ = (float)offsets[2];
            this.quaternB = (float)quaterns[0];
            this.quaternC = (float)quaterns[1];
            this.quaternD = (float)quaterns[2];
            this.qFormCode = 1;
        }
    }

    protected void updatePixDims4D(double dim1, double dim2, double dim3, double dim4) {
        this.pixDim[1] = dim1;
        this.pixDim[2] = dim2;
        this.pixDim[3] = dim3;
        this.pixDim[4] = dim4;
    }

    private double getIntentP(int index) {
        return this.intentP[index];
    }

    private int getNumBytesPerVoxel() {
        if (this.dataType == 2) {
            return 1;
        }
        if (this.dataType == 4) {
            return 2;
        }
        if (this.dataType == 8) {
            return 4;
        }
        if (this.dataType == 16) {
            return 4;
        }
        if (this.dataType == 32) {
            return 8;
        }
        if (this.dataType == 64) {
            return 8;
        }
        if (this.dataType == 128) {
            return 3;
        }
        if (this.dataType == 256) {
            return 1;
        }
        if (this.dataType == 512) {
            return 2;
        }
        if (this.dataType == 768) {
            return 4;
        }
        if (this.dataType == 1024) {
            return 8;
        }
        if (this.dataType == 1280) {
            return 8;
        }
        if (this.dataType == 1536) {
            return 16;
        }
        if (this.dataType == 1792) {
            return 16;
        }
        if (this.dataType == 2048) {
            return 32;
        }
        return 0;
    }

    private String getOrientationQform() {
        String orientation = null;
        double[][] qFormMatParams = Orientation.convertNiftiQFormToNiftiSForm(this.quaternB, this.quaternC, this.quaternD, this.offsetX, this.offsetY, this.offsetZ, this.pixDim[1], this.pixDim[2], this.pixDim[3], this.pixDim[0]);
        if (this.qFormCode > 0) {
            orientation = Orientation.convertNiftiSFormToNEMA(qFormMatParams);
            if (!Orientation.isValidOrientationString(orientation)) {
                orientation = Orientation.getDefaultOrientation("NIFTI");
            }
        } else {
            orientation = Orientation.getDefaultOrientation("NIFTI");
        }
        return orientation;
    }

    private String getOrientationSform() {
        String orientation = Orientation.convertNiftiSFormToNEMA(this.affine);
        if (!Orientation.isValidOrientationString(orientation)) {
            orientation = Orientation.getDefaultOrientation("NIFTI");
        }
        return orientation;
    }

    private Coordinate getOrigin(boolean forceQ, boolean forceS) {
        Coordinate origin = new Coordinate(0.0, 0.0, 0.0);
        if (this.qFormCode > 0 && !forceS) {
            double[][] affineQform = Orientation.convertNiftiQFormToNiftiSForm(this.quaternB, this.quaternC, this.quaternD, this.offsetX, this.offsetY, this.offsetZ, this.pixDim[1], this.pixDim[2], this.pixDim[3], this.pixDim[0]);
            if (this.qFormHasRotations()) {
                double[][] affineQformInverse = new Matrix(affineQform).inverse().getArray();
                double originX = 0.0 * affineQformInverse[0][0] + 0.0 * affineQformInverse[0][1] + 0.0 * affineQformInverse[0][2] + affineQformInverse[0][3];
                double originY = 0.0 * affineQformInverse[1][0] + 0.0 * affineQformInverse[1][1] + 0.0 * affineQformInverse[1][2] + affineQformInverse[1][3];
                double originZ = 0.0 * affineQformInverse[2][0] + 0.0 * affineQformInverse[2][1] + 0.0 * affineQformInverse[2][2] + affineQformInverse[2][3];
                origin.setValues(originX, originY, originZ);
            } else {
                String orientation = Orientation.convertNiftiSFormToNEMA(affineQform);
                if (!Orientation.isValidOrientationString(orientation)) {
                    orientation = Orientation.getDefaultOrientation("NIFTI");
                }
                String xyz = orientation.substring(0, 3).toUpperCase();
                String sense = orientation.substring(3);
                int xIndex = xyz.indexOf(88);
                int yIndex = xyz.indexOf(89);
                int zIndex = xyz.indexOf(90);
                boolean xFlip = sense.charAt(xIndex) == '+';
                boolean yFlip = sense.charAt(yIndex) == '+';
                boolean zFlip = sense.charAt(zIndex) == '+';
                double[] someOffsets = new double[]{this.offsetX / this.pixDim[xIndex + 1] * (double)(xFlip ? -1 : 1), this.offsetY / this.pixDim[yIndex + 1] * (double)(yFlip ? -1 : 1), this.offsetZ / this.pixDim[zIndex + 1] * (double)(zFlip ? -1 : 1)};
                origin.setValuesRound(someOffsets[0], someOffsets[1], someOffsets[2]);
            }
        } else if (this.getSFormCode() > 0 && !forceQ) {
            if (this.sFormHasRotations()) {
                double[][] affineQformInverse = new Matrix(this.affine).inverse().getArray();
                double originX = 0.0 * affineQformInverse[0][0] + 0.0 * affineQformInverse[0][1] + 0.0 * affineQformInverse[0][2] + affineQformInverse[0][3];
                double originY = 0.0 * affineQformInverse[1][0] + 0.0 * affineQformInverse[1][1] + 0.0 * affineQformInverse[1][2] + affineQformInverse[1][3];
                double originZ = 0.0 * affineQformInverse[2][0] + 0.0 * affineQformInverse[2][1] + 0.0 * affineQformInverse[2][2] + affineQformInverse[2][3];
                origin.setValues(originX, originY, originZ);
            } else {
                String orientation = Orientation.convertNiftiSFormToNEMA(this.affine);
                if (!Orientation.isValidOrientationString(orientation)) {
                    orientation = Orientation.getDefaultOrientation("NIFTI");
                }
                String xyz = orientation.substring(0, 3).toUpperCase();
                String sense = orientation.substring(3);
                int xIndex = xyz.indexOf(88);
                int yIndex = xyz.indexOf(89);
                int zIndex = xyz.indexOf(90);
                boolean xFlip = sense.charAt(xIndex) == '+';
                boolean yFlip = sense.charAt(yIndex) == '+';
                boolean zFlip = sense.charAt(zIndex) == '+';
                double[] someOffsets = new double[]{this.affine[0][3] / this.pixDim[xIndex + 1] * (double)(xFlip ? -1 : 1), this.affine[1][3] / this.pixDim[yIndex + 1] * (double)(yFlip ? -1 : 1), this.affine[2][3] / this.pixDim[zIndex + 1] * (double)(zFlip ? -1 : 1)};
                origin.setValuesRound(someOffsets[0], someOffsets[1], someOffsets[2]);
            }
        } else if (this.qFormCode == 0 && this.getSFormCode() == 0) {
            origin.setValuesRound((double)this.dim[1] / 2.0, (double)this.dim[2] / 2.0, (double)this.dim[3] / 2.0);
        }
        return origin;
    }

    private String makeImageDescriptionString() {
        return new String(StringUtilities.convertToPrintableASCII((byte[])this.description)) + "\n";
    }

    private URI makeImageURI(URI headerURI) {
        URI imageFile = null;
        try {
            if (this.twoFileFormat) {
                String scheme = headerURI.getScheme();
                String userInfo = headerURI.getUserInfo();
                String host = headerURI.getHost();
                int port = headerURI.getPort();
                String path = headerURI.getPath();
                String name = FileUtilities.getName((URI)headerURI);
                imageFile = this.compressed ? new URI(scheme, userInfo, host, port, path.substring(0, path.lastIndexOf(".hdr.gz")) + ".img.gz", null, null) : (name.indexOf(46) == -1 ? new URI(scheme, userInfo, host, port, path + ".img", null, null) : new URI(scheme, userInfo, host, port, path.substring(0, path.lastIndexOf(46)) + ".img", null, null));
            } else {
                imageFile = headerURI;
            }
        }
        catch (URISyntaxException ex) {
            AppLogger.error((Throwable)ex);
        }
        return imageFile;
    }

    private boolean qFormHasRotations() {
        double[][] affineQform = Orientation.convertNiftiQFormToNiftiSForm(this.quaternB, this.quaternC, this.quaternD, this.offsetX, this.offsetY, this.offsetZ, this.pixDim[1], this.pixDim[2], this.pixDim[3], this.pixDim[0]);
        return Transform.isNonOrthogonal(affineQform);
    }

    private boolean sFormHasRotations() {
        if (this.affine != null) {
            return Transform.isNonOrthogonal(this.affine);
        }
        return false;
    }

    public List<String> getAnonymizableFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TEXT_DESCRIPTION);
        return list;
    }

    public Map<String, List<String>> anonymize() {
        this.description = "ANONYMIZED".getBytes();
        return this.getEditableFieldValues();
    }

    static {
        NIFTI.NIFTI_UNIT_STRING[0] = "Unknown Unit";
        NIFTI.NIFTI_UNIT_STRING[1] = "Meters";
        NIFTI.NIFTI_UNIT_STRING[2] = "Millimeters";
        NIFTI.NIFTI_UNIT_STRING[3] = "Microns";
        NIFTI.NIFTI_UNIT_STRING[8] = "Seconds";
        NIFTI.NIFTI_UNIT_STRING[16] = "Milliseconds";
        NIFTI.NIFTI_UNIT_STRING[24] = "Microseconds";
        NIFTI.NIFTI_UNIT_STRING[32] = "Hertz";
        NIFTI.NIFTI_UNIT_STRING[40] = "Parts-per-million";
        NIFTI.NIFTI_UNIT_STRING[48] = "Radians-per-second";
    }
}

