/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.minc;

import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.formats.minc.MINC1;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import ucar.nc2.Variable;

public class MINC2
extends MINC1
implements ReadableHeader {
    private static final int[] MAGIC_NUMBER_MINC2 = new int[]{137, 72, 68, 70};
    public static final String NAME = "MINC2";
    public static final String ATT_IMAGE_UNSIGNED = "_Unsigned";

    @Override
    public ImageDimensions getImageDimensions() {
        int[] indices = this.getDimensionIndices();
        int[] dims = new int[3];
        List vars = this.ncfile.getVariables();
        for (Variable var : vars) {
            String name = var.getShortName();
            if (name.equals("xspace")) {
                dims[indices[0]] = var.findAttribute("length").getValues().getInt(0);
                continue;
            }
            if (name.equals("yspace")) {
                dims[indices[1]] = var.findAttribute("length").getValues().getInt(0);
                continue;
            }
            if (!name.equals("zspace")) continue;
            dims[indices[2]] = var.findAttribute("length").getValues().getInt(0);
        }
        return new ImageDimensions(dims[2], dims[1], dims[0], 1);
    }

    @Override
    protected int[] getMagicNumber() {
        return MAGIC_NUMBER_MINC2;
    }

    @Override
    protected boolean isUnsignedByMetadata() {
        String signtype = (String)this.imageAttributes.get(ATT_IMAGE_UNSIGNED);
        if (StringUtils.isNotBlank((CharSequence)signtype)) {
            signtype = signtype.trim();
            return signtype.equals("true");
        }
        return false;
    }

    @Override
    public String getPluginName() {
        return NAME;
    }
}

