/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.minc;

import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.CompressionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageDescription;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.formats.dicom.Dictionary;
import edu.uthscsa.ric.volume.formats.dicom.Tag;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class MINC1
implements ReadableHeader {
    private ByteBuffer data;
    private DataType datatype;
    private File file;
    private final SimpleDateFormat[] birthDateFormats = new SimpleDateFormat[]{new SimpleDateFormat("yyyyMMdd"), new SimpleDateFormat("yyyy.MM.dd")};
    private final SimpleDateFormat[] studyDateFormats = new SimpleDateFormat[]{new SimpleDateFormat("yyyyMMdd HHmmss.SS"), new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SS"), new SimpleDateFormat("yyyyMMdd HHmmssSS"), new SimpleDateFormat("yyyy.MM.dd HH:mm:ssSS"), new SimpleDateFormat("yyyyMMdd"), new SimpleDateFormat("yyyy.MM.dd")};
    private static final int[] MAGIC_NUMBER_MINC1 = new int[]{67, 68, 70};
    protected Map<String, Map<String, String>> attributes;
    protected Map<String, String> acquisitionAttributes;
    protected Map<String, String> imageAttributes;
    protected Map<String, String> patientAttributes;
    protected Map<String, String> studyAttributes;
    protected Map<String, String> xSpaceAttributes;
    protected Map<String, String> ySpaceAttributes;
    protected Map<String, String> zSpaceAttributes;
    protected Map<String, Variable> variables;
    protected NetcdfFile ncfile;
    static final Map<String, String> MINC_TO_DICOM_MODALITY_MAP = new HashMap<String, String>();
    public static final String ATT_ACQUISITION_COMMENTS = "comments";
    public static final String ATT_ACQUISITION_ECHO_TIME = "echo_time";
    public static final String ATT_ACQUISITION_FLIP_ANGLE = "flip_angle";
    public static final String ATT_ACQUISITION_IMAGED_NUCLEUS = "imaged_nucleus";
    public static final String ATT_ACQUISITION_IMAGING_FREQ = "imaging_frequency";
    public static final String ATT_ACQUISITION_INVERSION_TIME = "inversion_time";
    public static final String ATT_ACQUISITION_NUM_AVERAGES = "num_averages";
    public static final String ATT_ACQUISITION_REP_TIME = "repetition_time";
    public static final String ATT_ACQUSITION = "acquisition";
    public static final String ATT_IMAGE = "image";
    public static final String ATT_IMAGE_MAX = "image-max";
    public static final String ATT_IMAGE_MIN = "image-min";
    public static final String ATT_IMAGE_SIGNTYPE = "signtype";
    public static final String ATT_PATIENT = "patient";
    public static final String ATT_PATIENT_BIRTHDATE = "birthdate";
    public static final String ATT_PATIENT_GENDER = "sex";
    public static final String ATT_PATIENT_NAME = "full_name";
    public static final String ATT_PATIENT_WEIGHT = "weight";
    public static final String ATT_SPACE_STEP = "step";
    public static final String ATT_STUDY = "study";
    public static final String ATT_STUDY_ACQUISITION_ID = "acquisition_id";
    public static final String ATT_STUDY_ID = "study_id";
    public static final String ATT_STUDY_INSTITUTION = "institution";
    public static final String ATT_STUDY_MANUFACTURER = "manufacturer";
    public static final String ATT_STUDY_MODALITY = "modality";
    public static final String ATT_STUDY_PROCEDURE = "procedure";
    public static final String ATT_STUDY_START_TIME = "start_time";
    public static final String ATT_XSPACE = "xspace";
    public static final String ATT_YSPACE = "yspace";
    public static final String ATT_ZSPACE = "zspace";
    public static final String[] EXTENSIONS = new String[]{"mnc", "mnc.gz"};
    public static final String IMAGE_DIMS_X = "xspace";
    public static final String IMAGE_DIMS_Y = "yspace";
    public static final String IMAGE_DIMS_Z = "zspace";
    public static final String NAME = "MINC1";
    public static final String PREFERRED_EXTENSION = "mnc";
    public static final String VALUE_GENDER_FEMALE = "female";
    public static final String VALUE_GENDER_MALE = "male__";
    public static final String VALUE_GENDER_OTHER = "other_";
    public static final String VALUE_IMAGE_SIGNTYPE_SIGNED = "signed__";
    public static final String VALUE_IMAGE_SIGNTYPE_UNSIGNED = "unsigned";

    @Deprecated
    public ByteBuffer getImage() {
        this.readImage();
        return this.data;
    }

    public ByteBuffer[] getImageBuffers() {
        this.readImage();
        return new ByteBuffer[]{this.data};
    }

    public ImageDescription getImageDescription() {
        String studyName = "";
        long studyDate = this.convertToDicomStudyDate(this.studyAttributes.get(ATT_STUDY_START_TIME));
        String patientName = this.patientAttributes.get(ATT_PATIENT_NAME);
        if (StringUtils.isNotBlank((CharSequence)patientName)) {
            studyName = patientName;
        }
        Attribute history = this.ncfile.findGlobalAttribute("history");
        String description = "";
        if (history != null) {
            description = history.toString();
            int firstQuote = description.indexOf(46);
            int lastQuote = description.lastIndexOf(46);
            if (firstQuote != -1 && lastQuote != -1) {
                description = description.substring(firstQuote + 1, lastQuote);
                description = description.replace("\\n", " ");
            }
        }
        ImageDescription id = new ImageDescription("", studyName, new Date(studyDate), description);
        Map<Long, String> dicomMetadataMap = this.generateDicomItems();
        id.setDicomItems(dicomMetadataMap);
        id.setFile(this.file.toURI());
        return id;
    }

    public ImageDimensions getImageDimensions() {
        Vector<Integer> dimensions = new Vector<Integer>();
        List dims = this.ncfile.getDimensions();
        for (Dimension dim : dims) {
            int size = dim.getLength();
            dimensions.add(size);
        }
        int col = (Integer)dimensions.get(2);
        int row = (Integer)dimensions.get(1);
        int slice = (Integer)dimensions.get(0);
        ImageDimensions id = new ImageDimensions(col, row, slice, 1);
        return id;
    }

    public URI getImageFile() {
        return this.file.toURI();
    }

    public ImageRange getImageRange() {
        double[] realMaxs;
        double[] realMins;
        double imageMin = Double.MAX_VALUE;
        double imageMax = -1.7976931348623157E308;
        for (double value : realMins = this.getRealMins()) {
            if (!(value < imageMin)) continue;
            imageMin = value;
        }
        for (double value : realMaxs = this.getRealMaxs()) {
            if (!(value > imageMax)) continue;
            imageMax = value;
        }
        ImageRange ir = new ImageRange(imageMin, imageMax, 0.0, 0.0);
        ImageDimensions id = this.getImageDimensions();
        ir.setGlobalDataScaleSlope(id.getSlices(), 1.0f);
        ir.setGlobalDataScaleIntercept(id.getSlices(), 0.0f);
        return ir;
    }

    public ImageType getImageType() {
        ImageType it = new ImageType(4, 4, 32, ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN);
        int numBytes = this.datatype.getSize();
        int byteType = this.getDatatype();
        ImageType nativeType = new ImageType(numBytes, byteType, numBytes * 8, false);
        it.setNativeType(nativeType);
        return it;
    }

    public String getMinimumVersionSupported() {
        return null;
    }

    public String getOrientation() {
        String order = this.getOrientationOrder();
        String sense = this.getOrientationSense();
        return order + sense;
    }

    public int getOrientationCertainty() {
        return 2;
    }

    public Coordinate getOrigin() {
        return new Coordinate(0.0, 0.0, 0.0);
    }

    public String getPluginName() {
        return NAME;
    }

    public URL getPluginURL() {
        return null;
    }

    public String getPreferredFileExtension() {
        return PREFERRED_EXTENSION;
    }

    public float[] getPreviewImage() {
        float[] previewData = null;
        try {
            Variable image = this.variables.get(ATT_IMAGE);
            Array imageArray = image.read();
            ImageDimensions id = this.getImageDimensions();
            int numVoxelsSlice = id.getNumVoxelsSlice();
            int numSlices = id.getSlices();
            int startIndex = numVoxelsSlice * (numSlices / 2);
            ImageType it = this.getImageType().getNativeType();
            int numBytes = it.getNumBytesPerVoxel();
            int numType = it.getByteType();
            long mask = it.createBitMask();
            previewData = new float[numVoxelsSlice];
            for (int ctr = 0; ctr < numVoxelsSlice; ++ctr) {
                previewData[ctr] = numBytes == 1 && (numType == 3 || numType == 2) ? (float)((long)imageArray.getByte(startIndex + ctr) & mask) : (numBytes == 2 && (numType == 3 || numType == 2) ? (float)((long)imageArray.getShort(startIndex + ctr) & mask) : (numBytes == 4 && (numType == 3 || numType == 2) ? (float)((long)imageArray.getInt(startIndex + ctr) & mask) : (numBytes == 4 && numType == 4 ? imageArray.getFloat(startIndex + ctr) : (numBytes == 8 && (numType == 3 || numType == 2) ? (float)(imageArray.getLong(startIndex + ctr) & mask) : (numBytes == 8 && numType == 4 ? imageArray.getFloat(startIndex + ctr) : 0.0f)))));
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        return previewData;
    }

    public short[] getSliceAnnotation(int slice, int seriesPoint) {
        return CollectionUtilities.EMPTY_SHORT_ARRAY;
    }

    public String getSliceMetadata(int slice, int seriesPoint) {
        return null;
    }

    public ImageTransform[] getTransforms() {
        return new ImageTransform[0];
    }

    public String getVersion() {
        return null;
    }

    public VoxelDimensions getVoxelDimensions() {
        int[] indices = this.getDimensionIndices();
        float[] voxelDims = new float[3];
        voxelDims[indices[0]] = Math.abs(Float.valueOf(this.xSpaceAttributes.get(ATT_SPACE_STEP)).floatValue());
        voxelDims[indices[1]] = Math.abs(Float.valueOf(this.ySpaceAttributes.get(ATT_SPACE_STEP)).floatValue());
        voxelDims[indices[2]] = Math.abs(Float.valueOf(this.zSpaceAttributes.get(ATT_SPACE_STEP)).floatValue());
        VoxelDimensions vd = new VoxelDimensions((double)voxelDims[2], (double)voxelDims[1], (double)voxelDims[0], 0.0);
        vd.setSpatialUnit(2);
        return vd;
    }

    public boolean hasNewerVersion() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThisFormat(File file) {
        InputStream fileIn = null;
        boolean isFormat = false;
        try {
            boolean usesGZIPExtension = CompressionUtilities.usesGZIPFileExtension((String)file.toString());
            boolean isPossibleGZIPFile = FileUtilities.uriIsFile((URI)file.toURI()) && CompressionUtilities.isPossibleGZIPFile((File)file);
            fileIn = FileUtilities.getInputStream((URI)file.toURI(), (usesGZIPExtension || isPossibleGZIPFile ? 1 : 0) != 0);
            int[] magicNum = this.getMagicNumber();
            byte[] firstBytes = new byte[magicNum.length];
            int bytesRead = fileIn.read(firstBytes);
            int matchCount = 0;
            for (int ctr = 0; ctr < bytesRead; ++ctr) {
                if (magicNum[ctr] != (0xFF & firstBytes[ctr])) continue;
                ++matchCount;
            }
            isFormat = matchCount == magicNum.length;
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                if (fileIn != null) {
                    fileIn.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return isFormat;
    }

    public void readHeader(File file, File tempDir) throws InvalidHeaderException {
        this.init();
        this.file = file;
        try {
            this.ncfile = NetcdfFile.open((String)file.toString());
        }
        catch (IOException ex) {
            throw new InvalidHeaderException(ex.getMessage(), (Exception)ex);
        }
        List vars = this.ncfile.getVariables();
        for (Variable var : vars) {
            String name = var.getShortName();
            this.variables.put(name, var);
            Map<String, String> map = this.attributes.get(name);
            if (map == null) continue;
            List atts = var.getAttributes();
            for (Attribute att : atts) {
                map.put(att.getShortName(), att.getValues().toString());
            }
        }
        Variable image = this.variables.get(ATT_IMAGE);
        this.datatype = image.getDataType();
    }

    public void readHeader(URI uri, File tempDir) throws InvalidHeaderException {
        this.readHeader(new File(uri), tempDir);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(32);
        sb.append(this.ncfile.getDetailInfo()).append("\n\n").append(this.ncfile.getGlobalAttributes()).append("\n\n");
        List vars = this.ncfile.getVariables();
        for (Variable var : vars) {
            sb.append(var.getFullName()).append('\n');
            List atts = var.getAttributes();
            for (Attribute att : atts) {
                sb.append("    " + att.getFullName() + " = " + att.getValues() + "\n");
            }
        }
        return sb.toString();
    }

    protected int[] getDimensionIndices() {
        int[] indices = new int[3];
        String dimOrder = this.imageAttributes.get("dimorder");
        if (StringUtils.isNotBlank((CharSequence)dimOrder)) {
            StringBuffer sbOrder = new StringBuffer();
            StringTokenizer tokenizer = new StringTokenizer(dimOrder, ",");
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken();
                if ((name = name.trim()).equals("xspace")) {
                    sbOrder.append('X');
                    continue;
                }
                if (name.equals("yspace")) {
                    sbOrder.append('Y');
                    continue;
                }
                if (!name.equals("zspace")) continue;
                sbOrder.append('Z');
            }
            String order = sbOrder.toString();
            indices[0] = order.indexOf(88);
            indices[1] = order.indexOf(89);
            indices[2] = order.indexOf(90);
        } else {
            Variable dimVar = this.ncfile.findVariable("dimensions");
            if (dimVar == null) {
                dimVar = this.ncfile.findVariable(ATT_IMAGE);
            }
            if (dimVar != null) {
                indices[0] = dimVar.findDimensionIndex("xspace");
                indices[1] = dimVar.findDimensionIndex("yspace");
                indices[2] = dimVar.findDimensionIndex("zspace");
            } else {
                List dims = this.ncfile.getDimensions();
                Iterator it = dims.iterator();
                int index = 0;
                while (it.hasNext()) {
                    Dimension dim = (Dimension)it.next();
                    indices[index++] = dim.getLength();
                }
            }
        }
        return indices;
    }

    protected int[] getMagicNumber() {
        return MAGIC_NUMBER_MINC1;
    }

    protected boolean isUnsignedByMetadata() {
        String signtype = this.imageAttributes.get(ATT_IMAGE_SIGNTYPE);
        if (StringUtils.isNotBlank((CharSequence)signtype)) {
            signtype = signtype.trim();
            return signtype.equals(VALUE_IMAGE_SIGNTYPE_UNSIGNED);
        }
        return false;
    }

    private long convertToDicomBirthDate(String stringDateVal) {
        String stringDate = stringDateVal;
        if (StringUtils.isNotBlank((CharSequence)stringDate)) {
            stringDate = stringDate.trim();
            Date date = null;
            for (SimpleDateFormat dateFormat : this.birthDateFormats) {
                try {
                    date = dateFormat.parse(stringDate);
                    return date.getTime();
                }
                catch (ParseException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        return -1L;
    }

    private String convertToDicomGender(String genderMincVal) {
        String genderMinc = genderMincVal;
        if (StringUtils.isNotBlank((CharSequence)genderMinc)) {
            if ((genderMinc = genderMinc.trim()).equals(VALUE_GENDER_MALE)) {
                return "M";
            }
            if (genderMinc.equals(VALUE_GENDER_FEMALE)) {
                return "F";
            }
            if (genderMinc.equals(VALUE_GENDER_OTHER)) {
                return "O";
            }
        }
        return null;
    }

    private String convertToDicomModality(String modalitiyVal) {
        String dicomModality;
        String modality = modalitiyVal;
        if (StringUtils.isNotBlank((CharSequence)modality) && StringUtils.isNotBlank((CharSequence)(dicomModality = MINC_TO_DICOM_MODALITY_MAP.get(modality = modality.trim())))) {
            return dicomModality;
        }
        return "OT";
    }

    private int convertToDicomSeriesId(String acquisitionId) {
        if (StringUtils.isNotBlank((CharSequence)acquisitionId)) {
            int studyId;
            try {
                studyId = Integer.parseInt(acquisitionId.trim());
            }
            catch (NumberFormatException ex) {
                studyId = -1;
            }
            return studyId;
        }
        return 0;
    }

    private long convertToDicomStudyDate(String stringDateVal) {
        String stringDate = stringDateVal;
        if (StringUtils.isNotBlank((CharSequence)stringDate)) {
            stringDate = stringDate.trim();
            Date date = null;
            for (SimpleDateFormat dateFormat : this.studyDateFormats) {
                try {
                    date = dateFormat.parse(stringDate);
                    return date.getTime();
                }
                catch (ParseException ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
        return -1L;
    }

    private Map<Long, String> generateDicomItems() {
        String comments;
        String imagedNucleus;
        String imagingFreq;
        String numAverages;
        String flipAngle;
        String inversionTime;
        String echoTime;
        String repetitionTime;
        String modality;
        int acquisitionId;
        String studyId;
        String procedure;
        String manufacturer;
        long studyDate;
        String gender;
        String weight;
        HashMap<Long, String> dicomItems = new HashMap<Long, String>();
        long birthDate = this.convertToDicomBirthDate(this.patientAttributes.get(ATT_PATIENT_BIRTHDATE));
        if (birthDate != -1L) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0010_PATIENT_BIRTH_DATE), String.valueOf(birthDate));
        }
        if (StringUtils.isNotBlank((CharSequence)(weight = this.patientAttributes.get(ATT_PATIENT_WEIGHT)))) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0010_PATIENT_WEIGHT), weight);
        }
        if (StringUtils.isNotBlank((CharSequence)(gender = this.convertToDicomGender(this.patientAttributes.get(ATT_PATIENT_GENDER))))) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0010_PATIENT_SEX), gender);
        }
        if ((studyDate = this.convertToDicomStudyDate(this.studyAttributes.get(ATT_STUDY_START_TIME))) != -1L) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0008_ACQUISITION_DATETIME), String.valueOf(studyDate));
        }
        if (StringUtils.isNotBlank((CharSequence)(manufacturer = this.studyAttributes.get(ATT_STUDY_MANUFACTURER)))) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0008_MANUFACTURER), manufacturer.trim());
        } else {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0008_MANUFACTURER), "UNKNOWN");
        }
        String institution = this.studyAttributes.get(ATT_STUDY_INSTITUTION);
        if (StringUtils.isNotBlank((CharSequence)institution)) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0008_INSTITUTION_NAME), institution.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(procedure = this.studyAttributes.get(ATT_STUDY_PROCEDURE)))) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0008_STUDY_DESCRIPTION), procedure.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(studyId = this.studyAttributes.get(ATT_STUDY_ID)))) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0020_STUDY_ID), studyId.trim());
        }
        if ((acquisitionId = this.convertToDicomSeriesId(this.studyAttributes.get(ATT_STUDY_ACQUISITION_ID))) != -1) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0020_SERIES_ID), String.valueOf(acquisitionId));
        }
        if (StringUtils.isNotBlank((CharSequence)(modality = this.studyAttributes.get(ATT_STUDY_MODALITY)))) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0008_MODALITY), this.convertToDicomModality(modality));
        }
        if (StringUtils.isNotBlank((CharSequence)(repetitionTime = this.acquisitionAttributes.get(ATT_ACQUISITION_REP_TIME)))) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_REPETITION_TIME), repetitionTime);
        }
        if (StringUtils.isNotBlank((CharSequence)(echoTime = this.acquisitionAttributes.get(ATT_ACQUISITION_ECHO_TIME)))) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_ECHO_TIME), echoTime);
        }
        if (StringUtils.isNotBlank((CharSequence)(inversionTime = this.acquisitionAttributes.get(ATT_ACQUISITION_INVERSION_TIME)))) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_INVERSION_TIME), inversionTime);
        }
        if (StringUtils.isNotBlank((CharSequence)(flipAngle = this.acquisitionAttributes.get(ATT_ACQUISITION_FLIP_ANGLE)))) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_FLIP_ANGLE), flipAngle);
        }
        if (StringUtils.isNotBlank((CharSequence)(numAverages = this.acquisitionAttributes.get(ATT_ACQUISITION_NUM_AVERAGES)))) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_NUM_AVERAGES), numAverages);
        }
        if (StringUtils.isNotBlank((CharSequence)(imagingFreq = this.acquisitionAttributes.get(ATT_ACQUISITION_IMAGING_FREQ)))) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_IMAGING_FREQUENCY), imagingFreq);
        }
        if (StringUtils.isNotBlank((CharSequence)(imagedNucleus = this.acquisitionAttributes.get(ATT_ACQUISITION_IMAGED_NUCLEUS)))) {
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0018_IMAGED_NUCLEUS), imagedNucleus);
        }
        if (StringUtils.isNotBlank((CharSequence)(comments = this.acquisitionAttributes.get(ATT_ACQUISITION_COMMENTS)))) {
            comments = comments.trim().replaceAll(" +", " ");
            dicomItems.put(Tag.makeMappableDicomId((Tag)Dictionary.TAG_0008_SERIES_DESCRIPTION), comments);
        }
        return dicomItems;
    }

    private int getDatatype() {
        int numBytes = this.datatype.getSize();
        boolean integer = this.datatype.isIntegral();
        boolean unsigned = this.isUnsignedByMetadata() ? true : numBytes == 1;
        if (integer) {
            if (unsigned) {
                return 3;
            }
            return 2;
        }
        return 4;
    }

    private String getOrientationOrder() {
        int[] indices = this.getDimensionIndices();
        char[] order = new char[3];
        order[indices[0]] = 88;
        order[indices[1]] = 89;
        order[indices[2]] = 90;
        StringBuffer sb = new StringBuffer(new String(order));
        return sb.reverse().toString();
    }

    private String getOrientationSense() {
        int[] indices = this.getDimensionIndices();
        char[] senseChars = new char[3];
        senseChars[indices[0]] = this.getOrientationSense(this.xSpaceAttributes).charAt(0);
        senseChars[indices[1]] = this.getOrientationSense(this.ySpaceAttributes).charAt(0);
        senseChars[indices[2]] = this.getOrientationSense(this.zSpaceAttributes).charAt(0);
        StringBuffer sb = new StringBuffer(new String(senseChars));
        return sb.reverse().toString();
    }

    private String getOrientationSense(Map<String, String> attributes) {
        String step = attributes.get(ATT_SPACE_STEP).toString();
        double value = 0.0;
        if (StringUtils.isNotBlank((CharSequence)step)) {
            value = Double.valueOf(step);
        }
        if (value < 0.0) {
            return "-";
        }
        return "+";
    }

    private double[] getRealMaxs() {
        double[] realMaxs = null;
        Variable max = this.variables.get(ATT_IMAGE_MAX);
        try {
            Array arrayMax = max.read();
            long length = max.getSize();
            realMaxs = new double[(int)length];
            int ctr = 0;
            while ((long)ctr < length) {
                double value;
                realMaxs[ctr] = value = (double)arrayMax.getFloat(ctr);
                ++ctr;
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        return realMaxs;
    }

    private double[] getRealMins() {
        double[] realMins = null;
        Variable min = this.variables.get(ATT_IMAGE_MIN);
        try {
            Array arrayMin = min.read();
            long length = min.getSize();
            realMins = new double[(int)length];
            int ctr = 0;
            while ((long)ctr < length) {
                double value;
                realMins[ctr] = value = (double)arrayMin.getFloat(ctr);
                ++ctr;
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        return realMins;
    }

    private void init() {
        this.xSpaceAttributes = new HashMap<String, String>();
        this.ySpaceAttributes = new HashMap<String, String>();
        this.zSpaceAttributes = new HashMap<String, String>();
        this.imageAttributes = new HashMap<String, String>();
        this.patientAttributes = new HashMap<String, String>();
        this.studyAttributes = new HashMap<String, String>();
        this.acquisitionAttributes = new HashMap<String, String>();
        this.attributes = new HashMap<String, Map<String, String>>();
        this.variables = new HashMap<String, Variable>();
        this.attributes.put("xspace", this.xSpaceAttributes);
        this.attributes.put("yspace", this.ySpaceAttributes);
        this.attributes.put("zspace", this.zSpaceAttributes);
        this.attributes.put(ATT_IMAGE, this.imageAttributes);
        this.attributes.put(ATT_PATIENT, this.patientAttributes);
        this.attributes.put(ATT_STUDY, this.studyAttributes);
        this.attributes.put(ATT_ACQUSITION, this.acquisitionAttributes);
    }

    private void readImage() {
        if (this.data == null) {
            Variable image = this.variables.get(ATT_IMAGE);
            ImageDimensions id = this.getImageDimensions();
            int numVoxelsSlice = id.getNumVoxelsSlice();
            int numSlices = id.getSlices();
            ImageType it = this.getImageType().getNativeType();
            int numBytes = it.getNumBytesPerVoxel();
            int numType = it.getByteType();
            long mask = it.createBitMask();
            double[] realMins = this.getRealMins();
            double[] realMaxs = this.getRealMaxs();
            try {
                Array imageArray = image.read();
                this.data = ByteBuffer.allocateDirect(id.getNumVoxelsVolume() * 4);
                this.data.order(ByteOrder.nativeOrder());
                FloatBuffer floatBuffer = this.data.asFloatBuffer();
                float[] slice = new float[numVoxelsSlice];
                for (int ctrS = 0; ctrS < numSlices; ++ctrS) {
                    float min = Float.MAX_VALUE;
                    float max = -3.4028235E38f;
                    for (int ctr = 0; ctr < numVoxelsSlice; ++ctr) {
                        float value = numBytes == 1 && (numType == 3 || numType == 2) ? (float)((long)imageArray.getByte(ctr + ctrS * numVoxelsSlice) & mask) : (numBytes == 2 && (numType == 3 || numType == 2) ? (float)((long)imageArray.getShort(ctr + ctrS * numVoxelsSlice) & mask) : (numBytes == 4 && (numType == 3 || numType == 2) ? (float)((long)imageArray.getInt(ctr + ctrS * numVoxelsSlice) & mask) : (numBytes == 4 && numType == 4 ? imageArray.getFloat(ctr + ctrS * numVoxelsSlice) : (numBytes == 8 && (numType == 3 || numType == 2) ? (float)(imageArray.getLong(ctr + ctrS * numVoxelsSlice) & mask) : (numBytes == 8 && numType == 4 ? imageArray.getFloat(ctr + ctrS * numVoxelsSlice) : 0.0f)))));
                        if (value > max) {
                            max = value;
                        }
                        if (value < min) {
                            min = value;
                        }
                        slice[ctr] = value;
                    }
                    double diff = max - min;
                    double dataScale = 1.0;
                    double dataScaleOffset = 0.0;
                    if (diff != 0.0) {
                        dataScale = (float)((realMaxs[ctrS] - realMins[ctrS]) / diff);
                        dataScaleOffset = (float)(realMins[ctrS] - (double)min * dataScale);
                    }
                    for (int ctr = 0; ctr < numVoxelsSlice; ++ctr) {
                        slice[ctr] = (float)((double)slice[ctr] * dataScale + dataScaleOffset);
                    }
                    floatBuffer.put(slice);
                }
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
    }

    static {
        MINC_TO_DICOM_MODALITY_MAP.put("PET__", "PT");
        MINC_TO_DICOM_MODALITY_MAP.put("SPECT", "ST");
        MINC_TO_DICOM_MODALITY_MAP.put("MRI__", "MR");
        MINC_TO_DICOM_MODALITY_MAP.put("CT___", "CT");
    }
}

