/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.micropet;

import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.ImageDescription;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageRange;
import edu.uthscsa.ric.volume.ImageTransform;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.ReadableHeader;
import edu.uthscsa.ric.volume.VoxelDimensions;
import edu.uthscsa.ric.volume.formats.micropet.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class MicroPET
implements ReadableHeader {
    private String filename;
    private String headerOriginal;
    private String injectedCompound;
    private String investigator;
    private String operator;
    private String scanTime;
    private String studyIdentifier;
    private String subjectIdentifier;
    private URI headerURI;
    private double axialPlaneSize;
    private double pixelSize;
    private double pixelSizeX;
    private double pixelSizeY;
    private double pixelSizeZ;
    private int dataOrder;
    private int dataType;
    private int totalFrames;
    private int volumeOriginX;
    private int volumeOriginY;
    private int volumeOriginZ;
    private int xDimension;
    private int yDimension;
    private int zDimension;
    private final Vector<Frame> frames = new Vector();
    private final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE MMM dd HH:mm:ss YYYY");
    public static final String AXIAL_PLANE_SIZE = "axial_plane_size";
    public static final String DATA_ORDER = "data_order";
    public static final String DATA_TYPE = "data_type";
    public static final String FILE_NAME = "file_name";
    public static final String INJECTED_COMPOUND = "injected_compound";
    public static final String INVESTIGATOR = "investigator";
    public static final String MIN_MANGO_SUPPORTED = "3.1";
    public static final String NAME = "Concorde microPET Reader";
    public static final String OPERATOR = "operator";
    public static final String PIXEL_SIZE = "pixel_size";
    public static final String PIXEL_SIZE_X = "pixel_size_x";
    public static final String PIXEL_SIZE_Y = "pixel_size_y";
    public static final String PIXEL_SIZE_Z = "pixel_size_z";
    public static final String PLUGIN_URL = "http://rii.uthscsa.edu/mango/plugin_micropet.html";
    public static final String PREFERRED_EXT = ".hdr";
    public static final String SCAN_TIME = "scan_time";
    public static final String STUDY_IDENTIFIER = "study_identifier";
    public static final String SUBJECT_IDENTIFIER = "subject_identifier";
    public static final String TOTAL_FRAMES = "total_frames";
    public static final String VERSION = "1.0.2";
    public static final String VOLUME_ORIGIN_X = "volume_origin_x";
    public static final String VOLUME_ORIGIN_Y = "volume_origin_y";
    public static final String VOLUME_ORIGIN_Z = "volume_origin_z";
    public static final String X_DIMENSION = "x_dimension";
    public static final String Y_DIMENSION = "y_dimension";
    public static final String Z_DIMENSION = "z_dimension";

    @Deprecated
    public ByteBuffer getImage() {
        return null;
    }

    public ByteBuffer[] getImageBuffers() {
        return new ByteBuffer[0];
    }

    public ImageDescription getImageDescription() {
        Date date = null;
        if (StringUtils.isNotBlank((CharSequence)this.scanTime)) {
            try {
                date = this.DATE_FORMAT.parse(this.scanTime);
            }
            catch (ParseException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        ImageDescription id = new ImageDescription("", this.subjectIdentifier, date, this.investigator + " " + this.operator + " " + this.studyIdentifier + " " + this.injectedCompound);
        id.setFile(this.headerURI);
        return id;
    }

    public ImageDimensions getImageDimensions() {
        return new ImageDimensions(this.xDimension, this.yDimension, this.zDimension, this.totalFrames);
    }

    public URI getImageFile() {
        File headerFile = new File(this.headerURI);
        String fileName = this.getFileName(this.filename);
        return new File(headerFile.getParent(), fileName).toURI();
    }

    public ImageRange getImageRange() {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        float[] scales = new float[this.frames.size() * this.zDimension];
        float[] intercepts = new float[this.frames.size() * this.zDimension];
        int index = 0;
        for (Frame frame : this.frames) {
            float scaleFactor = 1.0f;
            if (frame.getScaleFactor() != 0.0) {
                scaleFactor = (float)frame.getScaleFactor();
            }
            double currentMin = frame.getMinimum() * (double)scaleFactor;
            double currentMax = frame.getMaximum() * (double)scaleFactor;
            if (currentMin < min) {
                min = currentMin;
            }
            if (currentMax > max) {
                max = currentMax;
            }
            for (int ctr = 0; ctr < this.zDimension; ++ctr) {
                scales[index * this.zDimension + ctr] = scaleFactor;
                intercepts[index * this.zDimension + ctr] = 0.0f;
            }
            ++index;
        }
        ImageRange ir = new ImageRange(min, max, min, max);
        ir.setDataScaleSlopes(scales);
        ir.setDataScaleIntercepts(intercepts);
        return ir;
    }

    public ImageType getImageType() {
        boolean isLittle;
        int byteType;
        int numBytes;
        if (this.dataType == 1) {
            numBytes = 1;
            byteType = 2;
            isLittle = false;
        } else if (this.dataType == 2) {
            numBytes = 2;
            byteType = 2;
            isLittle = true;
        } else if (this.dataType == 3) {
            numBytes = 4;
            byteType = 2;
            isLittle = true;
        } else if (this.dataType == 4) {
            numBytes = 4;
            byteType = 4;
            isLittle = true;
        } else if (this.dataType == 5) {
            numBytes = 4;
            byteType = 4;
            isLittle = false;
        } else if (this.dataType == 6) {
            numBytes = 2;
            byteType = 2;
            isLittle = false;
        } else if (this.dataType == 7) {
            numBytes = 4;
            byteType = 2;
            isLittle = false;
        } else {
            numBytes = 0;
            byteType = 0;
            isLittle = false;
        }
        return new ImageType(numBytes, byteType, numBytes * 8, isLittle);
    }

    public String getMinimumVersionSupported() {
        return MIN_MANGO_SUPPORTED;
    }

    public String getOrientation() {
        if (this.dataOrder == 1) {
            return "XZY++-";
        }
        return "XYZ+-+";
    }

    public int getOrientationCertainty() {
        return 1;
    }

    public Coordinate getOrigin() {
        return new Coordinate((double)this.volumeOriginX, (double)this.volumeOriginY, (double)this.volumeOriginZ);
    }

    public String getPluginName() {
        return NAME;
    }

    public URL getPluginURL() {
        try {
            return new URL(PLUGIN_URL);
        }
        catch (MalformedURLException ex) {
            AppLogger.warn((Throwable)ex);
            return null;
        }
    }

    public String getPreferredFileExtension() {
        return PREFERRED_EXT;
    }

    public float[] getPreviewImage() {
        return new float[0];
    }

    public short[] getSliceAnnotation(int slice, int seriesPoint) {
        return CollectionUtilities.EMPTY_SHORT_ARRAY;
    }

    public String getSliceMetadata(int slice, int seriesPoint) {
        return null;
    }

    public ImageTransform[] getTransforms() {
        return new ImageTransform[0];
    }

    public String getVersion() {
        return VERSION;
    }

    public VoxelDimensions getVoxelDimensions() {
        double xSize = this.pixelSizeX != 0.0 ? this.pixelSizeX : this.pixelSize * 10.0;
        double ySize = this.pixelSizeY != 0.0 ? this.pixelSizeY : this.pixelSize * 10.0;
        double zSize = this.pixelSizeZ != 0.0 ? this.pixelSizeZ : this.axialPlaneSize * 10.0;
        double tSize = this.frames.get(0).getFrameDuration();
        VoxelDimensions vd = new VoxelDimensions(xSize, ySize, zSize, tSize);
        vd.setSpatialUnit(2);
        vd.setTemporalUnit(8);
        return vd;
    }

    public boolean hasNewerVersion() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThisFormat(File file) {
        byte[] buffer = new byte[2048];
        BufferedInputStream input = null;
        boolean isFormat = false;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            int bytesRead = input.read(buffer);
            if (bytesRead > 0) {
                String string = new String(buffer, 0, bytesRead);
                isFormat = string.indexOf("version 00") != -1;
            }
        }
        catch (IOException ex) {
            if (AppLogger.isDebugEnabled()) {
                AppLogger.debug((String)ex.getMessage());
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        return isFormat;
    }

    public void readHeader(File file, File tempDir) throws InvalidHeaderException {
        this.readHeader(file.toURI(), tempDir);
    }

    public void readHeader(URI uri, File tempDir) throws InvalidHeaderException {
        this.headerURI = uri;
        BufferedReader reader = null;
        StringBuffer headerOriginalSb = new StringBuffer();
        try {
            reader = FileUtilities.getReader((URI)uri);
            String line = reader.readLine();
            Frame currentFrame = null;
            while (line != null) {
                headerOriginalSb.append(line);
                headerOriginalSb.append('\n');
                line = line.trim();
                if (line.charAt(0) != '#') {
                    if (line.startsWith("end_of_header")) {
                        if (currentFrame != null) {
                            this.frames.add(currentFrame);
                        }
                        currentFrame = new Frame();
                    } else {
                        this.setHeaderField(currentFrame, line);
                    }
                }
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException ex) {
            throw new InvalidHeaderException(ex.getMessage(), (Exception)ex);
        }
        catch (IOException ex) {
            throw new InvalidHeaderException(ex.getMessage(), (Exception)ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                AppLogger.warn((Throwable)ex);
            }
        }
        this.headerOriginal = headerOriginalSb.toString();
    }

    public String toString() {
        return this.headerOriginal;
    }

    private String getFileName(String str) {
        String fileName = str;
        int startIndex = fileName.lastIndexOf(92);
        if (startIndex != -1) {
            fileName = fileName.substring(startIndex + 1);
        }
        return fileName;
    }

    private void setHeaderField(Frame frame, String line) {
        int delimiterIndex = line.indexOf(32);
        if (delimiterIndex != -1) {
            String fieldName = line.substring(0, delimiterIndex);
            String value = line.substring(delimiterIndex).trim();
            if (fieldName.equals(AXIAL_PLANE_SIZE)) {
                this.axialPlaneSize = Double.parseDouble(value);
            } else if (fieldName.equals(PIXEL_SIZE)) {
                this.pixelSize = Double.parseDouble(value);
            } else if (fieldName.equals(PIXEL_SIZE_X)) {
                this.pixelSizeX = Double.parseDouble(value);
            } else if (fieldName.equals(PIXEL_SIZE_Y)) {
                this.pixelSizeY = Double.parseDouble(value);
            } else if (fieldName.equals(PIXEL_SIZE_Z)) {
                this.pixelSizeZ = Double.parseDouble(value);
            } else if (fieldName.equals(FILE_NAME)) {
                this.filename = value;
            } else if (fieldName.equals(SCAN_TIME)) {
                this.scanTime = value;
            } else if (fieldName.equals(INVESTIGATOR)) {
                this.investigator = value;
            } else if (fieldName.equals(OPERATOR)) {
                this.operator = value;
            } else if (fieldName.equals(STUDY_IDENTIFIER)) {
                this.studyIdentifier = value;
            } else if (fieldName.equals(INJECTED_COMPOUND)) {
                this.injectedCompound = value;
            } else if (fieldName.equals(SUBJECT_IDENTIFIER)) {
                this.subjectIdentifier = value;
            } else if (fieldName.equals(TOTAL_FRAMES)) {
                this.totalFrames = Integer.parseInt(value);
            } else if (fieldName.equals(DATA_TYPE)) {
                this.dataType = Integer.parseInt(value);
            } else if (fieldName.equals(X_DIMENSION)) {
                this.xDimension = Integer.parseInt(value);
            } else if (fieldName.equals(Y_DIMENSION)) {
                this.yDimension = Integer.parseInt(value);
            } else if (fieldName.equals(Z_DIMENSION)) {
                this.zDimension = Integer.parseInt(value);
            } else if (fieldName.equals(VOLUME_ORIGIN_X)) {
                this.volumeOriginX = Integer.parseInt(value);
            } else if (fieldName.equals(VOLUME_ORIGIN_Y)) {
                this.volumeOriginY = Integer.parseInt(value);
            } else if (fieldName.equals(VOLUME_ORIGIN_Z)) {
                this.volumeOriginZ = Integer.parseInt(value);
            } else if (fieldName.equals(DATA_ORDER)) {
                this.dataOrder = Integer.parseInt(value);
            } else if (frame != null) {
                if (fieldName.equals("singles")) {
                    frame.getSingles().add(value);
                } else if (fieldName.equals("maximum")) {
                    frame.setMaximum(Double.parseDouble(value));
                } else if (fieldName.equals("minimum")) {
                    frame.setMinimum(Double.parseDouble(value));
                } else if (fieldName.equals("scale_factor")) {
                    frame.setScaleFactor(Double.parseDouble(value));
                } else if (fieldName.equals("frame_duration")) {
                    frame.setFrameDuration(Double.parseDouble(value));
                }
            }
        }
    }
}

