/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.cti;

import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.ByteUtilities;
import edu.uthscsa.ric.volume.formats.cti.Record;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;

public class MainHeader
extends Record {
    protected Date dob;
    protected Date doseStart;
    protected Date scanStart;
    protected String acqModeS;
    protected String acqTypeS;
    protected String angComS;
    protected String axialS;
    protected String calibLabelS;
    protected String calibUnitsS;
    protected String coinS;
    protected String comCodeS;
    protected String dataUnits;
    protected String facilityName;
    protected String fileTypeS;
    protected String isotopeName;
    protected String magicNumber;
    protected String operatorName;
    protected String orientS;
    protected String originalFilename;
    protected String patientDexterity;
    protected String patientId;
    protected String patientName;
    protected String patientSex;
    protected String physicianName;
    protected String radiopharmaceutical;
    protected String septaS;
    protected String serialNumber;
    protected String studyDescription;
    protected String studyType;
    protected String transmTypeS;
    protected String userProcessCode;
    protected float bedElevation;
    protected float binSize;
    protected float branchingFraction;
    protected float distanceScanned;
    protected float dosage;
    protected float ecatCalibrationFactor;
    protected float gantryRotation;
    protected float gantryTilt;
    protected float initBedPosition;
    protected float intrinsicTilt;
    protected float isotopeHalfLife;
    protected float patientAge;
    protected float patientHeight;
    protected float patientWeight;
    protected float planeSeparation;
    protected float transaxialFov;
    protected float wellCounterCorrFactor;
    protected float[] bedPosition;
    protected long doseStartTime;
    protected long patientBirthDate;
    protected long scanStartTime;
    protected short acquisitionMode;
    protected short acquisitionType;
    protected short angularCompression;
    protected short axialSampMode;
    protected short calibrationUnits;
    protected short calibrationUnitsLabel;
    protected short coinSampMode;
    protected short compressionCode;
    protected short fileType;
    protected short lwrSctrThres;
    protected short lwrTrueThres;
    protected short numBedPos;
    protected short numFrames;
    protected short numGates;
    protected short numPlanes;
    protected short patientOrientation;
    protected short septaState;
    protected short softwareVersion;
    protected short systemType;
    protected short transmissionSourceType;
    protected short uprTrueThres;
    protected short wobbleSpeed;
    protected short[] fill = new short[6];

    public MainHeader() {
        this.bedPosition = new float[15];
    }

    @Override
    public void out() {
        this.out("./main_header.doc");
    }

    @Override
    public void out(String name) {
        try {
            String IN_CM = ", in cm";
            PrintWriter out = new PrintWriter(new FileOutputStream(name));
            out.println("MainHeader\n");
            out.println("magic number:\t\t\t\t" + this.magicNumber);
            out.println("original file name:\t\t\t" + this.originalFilename);
            out.println("sw version:\t\t\t\t\t" + this.softwareVersion);
            out.println("system type:\t\t\t\t" + this.systemType + ", Scanner model");
            out.println("file type:\t\t\t\t\t" + this.fileType + ", " + this.fileTypeS);
            out.println("serial number:\t\t\t\t" + this.serialNumber + ", gantry serial number");
            out.println("scan start time:\t\t\t" + this.scanStart);
            out.println("isotope name:\t\t\t\t" + this.isotopeName);
            out.println("isotope half life:\t\t\t" + this.isotopeHalfLife + ", in seconds");
            out.println("radiopharmaceutical:\t\t" + this.radiopharmaceutical);
            out.println("gantry tilt:\t\t\t\t" + this.gantryTilt + ", in degrees");
            out.println("gantry rotation:\t\t\t" + this.gantryRotation + ", in degrees");
            out.println("bed_elevation:\t\t\t\t" + this.bedElevation + ", cm from lowest point");
            out.println("intrinsic tilt:\t\t\t\t" + this.intrinsicTilt + ", in degrees");
            out.println("wobble speed:\t\t\t\t" + this.wobbleSpeed + " revolutions per minute");
            out.println("transm source type:\t\t\t" + this.transmissionSourceType + ", " + this.transmTypeS);
            out.println("distance scanned:\t\t\t" + this.distanceScanned + ", in cm");
            out.println("transaxial fov:\t\t\t\t" + this.transaxialFov + ", diameter in cm");
            out.println("angular compression:\t\t" + this.angularCompression + ", " + this.angComS);
            out.println("coin samp mode:\t\t\t\t" + this.coinSampMode + ", " + this.coinS);
            out.println("axial samp mode:\t\t\t" + this.axialSampMode + ", " + this.axialS);
            out.println("ecat calibration factor:\t" + this.ecatCalibrationFactor);
            out.println("calibration units:\t\t\t" + this.calibrationUnits + ", " + this.calibUnitsS);
            out.println("calibration units label:\t" + this.calibrationUnitsLabel + ", " + this.calibLabelS);
            out.println("compression code:\t\t\t" + this.compressionCode + ", " + this.comCodeS);
            out.println("study type:\t\t\t\t\t" + this.studyType);
            out.println("patient id:\t\t\t\t\t" + this.patientId);
            out.println("patient name:\t\t\t\t" + this.patientName);
            out.println("patient sex:\t\t\t\t" + this.patientSex + ", [m, f, u]");
            out.println("patient dexterity:\t\t\t" + this.patientDexterity + ", [r, l, u]");
            out.println("patient age:\t\t\t\t" + this.patientAge + ", in years");
            out.println("patient height:\t\t\t\t" + this.patientHeight + ", in cm");
            out.println("patient weight:\t\t\t\t" + this.patientWeight + ", in kg");
            out.println("patient birth date:\t\t\t" + this.patientBirthDate + ", " + this.dob);
            out.println("physician name:\t\t\t\t" + this.physicianName);
            out.println("operator name:\t\t\t\t" + this.operatorName);
            out.println("study description:\t\t\t" + this.studyDescription);
            out.println("acquisition type:\t\t\t" + this.acquisitionType + ", " + this.acqTypeS);
            out.println("patient orientation:\t\t" + this.patientOrientation + ", " + this.orientS);
            out.println("facility name:\t\t\t\t" + this.facilityName);
            out.println("num planes:\t\t\t\t\t" + this.numPlanes);
            out.println("num frames:\t\t\t\t\t" + this.numFrames);
            out.println("num gates:\t\t\t\t\t" + this.numGates);
            out.println("num bed pos:\t\t\t\t" + this.numBedPos);
            out.println("init bed position:\t\t\t" + this.initBedPosition + ", in cm");
            for (int i = 0; i < this.numBedPos; ++i) {
                out.println("bed position " + (i + 1) + ": \t\t\t" + this.bedPosition[i] + ", in cm");
            }
            out.println("plane separation:\t\t\t" + this.planeSeparation + ", in cm");
            out.println("lwr sctr thres:\t\t\t\t" + this.lwrSctrThres + ", in KeV");
            out.println("lwr true thres:\t\t\t\t" + this.lwrTrueThres + ", in KeV");
            out.println("upr true thres:\t\t\t\t" + this.uprTrueThres + ", in KeV");
            out.println("user process code:\t\t\t" + this.userProcessCode);
            out.println("acquisition mode:\t\t\t" + this.acquisitionMode + ", " + this.acqModeS);
            out.println("bin size:\t\t\t\t\t" + this.binSize + ", in cm");
            out.println("branching fraction:\t\t\t" + this.branchingFraction);
            out.println("dose start time:\t\t\t" + this.doseStart);
            out.println("dosage:\t\t\t\t\t\t" + this.dosage + ", in bequerels/cc");
            out.println("well counter corr factor:\t" + this.wellCounterCorrFactor);
            out.println("data units:\t\t\t\t\t" + this.dataUnits);
            out.println("septa state:\t\t\t\t" + this.septaState + ", " + this.septaS);
            out.flush();
            out.close();
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    @Override
    public void read(byte[] buf) {
        int i;
        super.read(buf);
        this.magicNumber = ByteUtilities.getString((byte[])buf, (int)0, (int)14);
        this.originalFilename = ByteUtilities.getString((byte[])buf, (int)14, (int)32);
        this.softwareVersion = ByteUtilities.getShort((byte[])buf, (int)46);
        this.systemType = ByteUtilities.getShort((byte[])buf, (int)48);
        this.fileType = ByteUtilities.getShort((byte[])buf, (int)50);
        this.serialNumber = ByteUtilities.getString((byte[])buf, (int)52, (int)10);
        this.scanStartTime = ByteUtilities.getInt((byte[])buf, (int)62);
        this.isotopeName = ByteUtilities.getString((byte[])buf, (int)66, (int)8);
        this.isotopeHalfLife = ByteUtilities.getFloat((byte[])buf, (int)74);
        this.radiopharmaceutical = ByteUtilities.getString((byte[])buf, (int)78, (int)32);
        this.gantryTilt = ByteUtilities.getFloat((byte[])buf, (int)110);
        this.gantryRotation = ByteUtilities.getFloat((byte[])buf, (int)114);
        this.bedElevation = ByteUtilities.getFloat((byte[])buf, (int)118);
        this.intrinsicTilt = ByteUtilities.getFloat((byte[])buf, (int)122);
        this.wobbleSpeed = ByteUtilities.getShort((byte[])buf, (int)126);
        this.transmissionSourceType = ByteUtilities.getShort((byte[])buf, (int)128);
        this.distanceScanned = ByteUtilities.getFloat((byte[])buf, (int)130);
        this.transaxialFov = ByteUtilities.getFloat((byte[])buf, (int)134);
        this.angularCompression = ByteUtilities.getShort((byte[])buf, (int)138);
        this.coinSampMode = ByteUtilities.getShort((byte[])buf, (int)140);
        this.axialSampMode = ByteUtilities.getShort((byte[])buf, (int)142);
        this.ecatCalibrationFactor = ByteUtilities.getFloat((byte[])buf, (int)144);
        this.calibrationUnits = ByteUtilities.getShort((byte[])buf, (int)148);
        this.calibrationUnitsLabel = ByteUtilities.getShort((byte[])buf, (int)150);
        this.compressionCode = ByteUtilities.getShort((byte[])buf, (int)152);
        this.studyType = ByteUtilities.getString((byte[])buf, (int)154, (int)12);
        this.patientId = ByteUtilities.getString((byte[])buf, (int)166, (int)16);
        this.patientName = ByteUtilities.getString((byte[])buf, (int)182, (int)32);
        this.patientSex = ByteUtilities.getString((byte[])buf, (int)214, (int)1);
        this.patientDexterity = ByteUtilities.getString((byte[])buf, (int)215, (int)1);
        this.patientAge = ByteUtilities.getFloat((byte[])buf, (int)216);
        this.patientHeight = ByteUtilities.getFloat((byte[])buf, (int)220);
        this.patientWeight = ByteUtilities.getFloat((byte[])buf, (int)224);
        this.patientBirthDate = ByteUtilities.getInt((byte[])buf, (int)228);
        this.physicianName = ByteUtilities.getString((byte[])buf, (int)232, (int)32);
        this.operatorName = ByteUtilities.getString((byte[])buf, (int)264, (int)32);
        this.studyDescription = ByteUtilities.getString((byte[])buf, (int)296, (int)32);
        this.acquisitionType = ByteUtilities.getShort((byte[])buf, (int)328);
        this.patientOrientation = ByteUtilities.getShort((byte[])buf, (int)330);
        this.facilityName = ByteUtilities.getString((byte[])buf, (int)332, (int)20);
        this.numPlanes = ByteUtilities.getShort((byte[])buf, (int)352);
        this.numFrames = ByteUtilities.getShort((byte[])buf, (int)354);
        this.numGates = ByteUtilities.getShort((byte[])buf, (int)356);
        this.numBedPos = ByteUtilities.getShort((byte[])buf, (int)358);
        this.initBedPosition = ByteUtilities.getFloat((byte[])buf, (int)360);
        for (i = 0; i < 15; ++i) {
            this.bedPosition[i] = ByteUtilities.getFloat((byte[])buf, (int)(364 + 4 * i));
        }
        this.planeSeparation = ByteUtilities.getFloat((byte[])buf, (int)424);
        this.lwrSctrThres = ByteUtilities.getShort((byte[])buf, (int)428);
        this.lwrTrueThres = ByteUtilities.getShort((byte[])buf, (int)430);
        this.uprTrueThres = ByteUtilities.getShort((byte[])buf, (int)432);
        this.userProcessCode = ByteUtilities.getString((byte[])buf, (int)434, (int)10);
        this.acquisitionMode = ByteUtilities.getShort((byte[])buf, (int)444);
        this.binSize = ByteUtilities.getFloat((byte[])buf, (int)446);
        this.branchingFraction = ByteUtilities.getFloat((byte[])buf, (int)450);
        this.doseStartTime = ByteUtilities.getInt((byte[])buf, (int)454);
        this.dosage = ByteUtilities.getFloat((byte[])buf, (int)458);
        this.wellCounterCorrFactor = ByteUtilities.getFloat((byte[])buf, (int)462);
        this.dataUnits = ByteUtilities.getString((byte[])buf, (int)466, (int)32);
        this.septaState = ByteUtilities.getShort((byte[])buf, (int)498);
        for (i = 0; i < 6; ++i) {
            this.fill[i] = ByteUtilities.getShort((byte[])buf, (int)(500 + 2 * i));
        }
        this.scanStart = new Date(this.scanStartTime * 1000L);
        this.doseStart = new Date(this.doseStartTime * 1000L);
        this.dob = new Date(this.patientBirthDate * 1000L);
        this.fileTypeS = "";
        switch (this.fileType) {
            case 0: {
                this.fileTypeS = "unknown";
                break;
            }
            case 1: {
                this.fileTypeS = "Sinogram";
                break;
            }
            case 2: {
                this.fileTypeS = "Image-16";
                break;
            }
            case 3: {
                this.fileTypeS = "Attenuation Correction";
                break;
            }
            case 4: {
                this.fileTypeS = "Normalization";
                break;
            }
            case 5: {
                this.fileTypeS = "Polar Map";
                break;
            }
            case 6: {
                this.fileTypeS = "Volume 8";
                break;
            }
            case 7: {
                this.fileTypeS = "Volume 16";
                break;
            }
            case 8: {
                this.fileTypeS = "Projection 8";
                break;
            }
            case 9: {
                this.fileTypeS = "Projection 16";
                break;
            }
            case 10: {
                this.fileTypeS = "Image 8";
                break;
            }
            case 11: {
                this.fileTypeS = "3D Sinogram 16";
                break;
            }
            case 12: {
                this.fileTypeS = "3D Sinogram 8";
                break;
            }
            case 13: {
                this.fileTypeS = "3D Normalization";
                break;
            }
            case 14: {
                this.fileTypeS = "3D Sinogram Fit";
                break;
            }
        }
        this.transmTypeS = "";
        switch (this.transmissionSourceType) {
            case 0: {
                this.transmTypeS = "SRC_NONE";
                break;
            }
            case 1: {
                this.transmTypeS = "SRC_RRING";
                break;
            }
            case 2: {
                this.transmTypeS = "SRC_RING";
                break;
            }
            case 3: {
                this.transmTypeS = "SRC_ROD";
                break;
            }
            case 4: {
                this.transmTypeS = "SRC_RROD";
                break;
            }
        }
        this.angComS = "";
        switch (this.angularCompression) {
            case 0: {
                this.angComS = "no mash";
                break;
            }
            case 1: {
                this.angComS = "mash of 2";
                break;
            }
            case 2: {
                this.angComS = "mash of 4";
                break;
            }
        }
        this.coinS = "";
        switch (this.coinSampMode) {
            case 0: {
                this.coinS = "Net Trues";
                break;
            }
            case 1: {
                this.coinS = "Prompts and Delayed";
                break;
            }
            case 3: {
                this.coinS = "Prompts, Delayed, and Multiples";
                break;
            }
        }
        this.axialS = "";
        switch (this.axialSampMode) {
            case 0: {
                this.axialS = "Normal";
                break;
            }
            case 1: {
                this.axialS = "2X";
                break;
            }
            case 2: {
                this.axialS = "3X";
                break;
            }
        }
        this.calibUnitsS = "";
        if (this.calibrationUnits == 1) {
            this.calibUnitsS = "Uncalibrated";
        } else if (this.calibrationUnits == 2) {
            this.calibUnitsS = "Calibrated";
        }
        this.calibLabelS = "";
        if (this.calibrationUnitsLabel == 1) {
            this.calibLabelS = "BLOOD_FLOW";
        } else if (this.calibrationUnitsLabel == 2) {
            this.calibLabelS = "LMRGLU";
        }
        this.comCodeS = "";
        if (this.compressionCode == 0) {
            this.comCodeS = "COMP_NONE";
        }
        this.acqTypeS = "";
        switch (this.acquisitionType) {
            case 0: {
                this.acqTypeS = "Undefined";
                break;
            }
            case 1: {
                this.acqTypeS = "Blank";
                break;
            }
            case 2: {
                this.acqTypeS = "Transmition";
                break;
            }
            case 3: {
                this.acqTypeS = "Static emission";
                break;
            }
            case 4: {
                this.acqTypeS = "Dynamic emission";
                break;
            }
            case 5: {
                this.acqTypeS = "Gated emission";
                break;
            }
            case 6: {
                this.acqTypeS = "Transmittion rectilinear";
                break;
            }
            case 7: {
                this.acqTypeS = "Emission rectilinear";
                break;
            }
        }
        this.orientS = "";
        switch (this.patientOrientation) {
            case 0: {
                this.orientS = "Feet First Prone";
                break;
            }
            case 1: {
                this.orientS = "Head First Prone";
                break;
            }
            case 2: {
                this.orientS = "Feet First Supine";
                break;
            }
            case 3: {
                this.orientS = "Head First Supine";
                break;
            }
            case 4: {
                this.orientS = "Feet First Right Lateral";
                break;
            }
            case 5: {
                this.orientS = "Head First Right Lateral";
                break;
            }
            case 6: {
                this.orientS = "Feet First Left Lateral";
                break;
            }
            case 7: {
                this.orientS = "Head First Left Lateral";
                break;
            }
        }
        this.acqModeS = "";
        switch (this.acquisitionMode) {
            case 0: {
                this.acqModeS = "Normal";
                break;
            }
            case 1: {
                this.acqModeS = "Windowed";
                break;
            }
            case 2: {
                this.acqModeS = "Windowed & Nonwindowed";
                break;
            }
            case 3: {
                this.acqModeS = "Dual energy";
                break;
            }
            case 4: {
                this.acqModeS = "Upper energy";
                break;
            }
            case 5: {
                this.acqModeS = "Emission and Transmission";
                break;
            }
        }
        this.septaS = "";
        if (this.septaState == 0) {
            this.septaS = "septa extended";
        } else if (this.septaState == 1) {
            this.septaS = "septa retracted";
        }
    }

    public String toString() {
        String CM = "cm";
        StringBuffer sb = new StringBuffer(2048);
        sb.append("MainHeader\n\nmagic number: ").append(this.magicNumber).append("\noriginal file name: ").append(this.originalFilename).append("\nsw version: ").append(this.softwareVersion).append("\nsystem type: ").append(this.systemType).append("  # scanner model\nfile type: ").append(this.fileType).append(" (").append(this.fileTypeS).append(")\nserial number: ").append(this.serialNumber).append("  # gantry serial number\nscan start time: ").append(this.scanStartTime).append(" (").append(this.scanStart).append(")\nisotope name: ").append(this.isotopeName).append("\nisotope half life: ").append(this.isotopeHalfLife).append(" s\nradiopharmaceutical: ").append(this.radiopharmaceutical).append("\ngantry tilt: ").append(this.gantryTilt).append(" deg\ngantry rotation: ").append(this.gantryRotation).append(" deg\nbed_elevation: ").append(this.bedElevation).append(" cm  # from lowest point\nintrinsic tilt: ").append(this.intrinsicTilt).append(" deg\nwobble speed: ").append(this.wobbleSpeed).append(" rev/min\ntransm source type: ").append(this.transmissionSourceType).append(" (").append(this.transmTypeS).append(")\ndistance scanned: ").append(this.distanceScanned).append(' ').append("cm").append("\ntransaxial fov: ").append(this.transaxialFov).append(" cm  # diameter\nangular compression: ").append(this.angularCompression).append(" (").append(this.angComS).append(")\ncoin samp mode: ").append(this.coinSampMode).append(" (").append(this.coinS).append(")\naxial samp mode: ").append(this.axialSampMode).append(" (").append(this.axialS).append(")\necat calibration factor: ").append(this.ecatCalibrationFactor).append("\ncalibration units: ").append(this.calibrationUnits).append(" (").append(this.calibUnitsS).append(")\ncalibration units label: ").append(this.calibrationUnitsLabel).append(" (").append(this.calibLabelS).append(")\ncompression code: ").append(this.compressionCode).append(" (").append(this.comCodeS).append(")\nstudy type: ").append(this.studyType).append("\npatient id: ").append(this.patientId).append("\npatient name: ").append(this.patientName).append("\npatient sex: ").append(this.patientSex).append("  # [M, F, U]\npatient dexterity: ").append(this.patientDexterity).append("  # [R, L, U]\npatient age: ").append(this.patientAge).append(" y\npatient height: ").append(this.patientHeight).append(' ').append("cm").append("\npatient weight: ").append(this.patientWeight).append(" kg\npatient birth date: ").append(this.patientBirthDate).append(" (").append(this.dob).append(")\nphysician name: ").append(this.physicianName).append("\noperator name: ").append(this.operatorName).append("\nstudy description: ").append(this.studyDescription).append("\nacquisition type: ").append(this.acquisitionType).append(" (").append(this.acqTypeS).append(")\npatient orientation: ").append(this.patientOrientation).append(" (").append(this.orientS).append(")\nfacility name: ").append(this.facilityName).append("\nnum planes: ").append(this.numPlanes).append("\nnum frames: ").append(this.numFrames).append("\nnum gates: ").append(this.numGates).append("\nnum bed pos: ").append(this.numBedPos).append("\ninit bed position: ").append(this.initBedPosition).append(' ').append("cm").append('\n');
        for (int i = 0; i < this.numBedPos; ++i) {
            sb.append("bed position ").append(i + 1).append(": ").append(this.bedPosition[i]).append(' ').append("cm").append('\n');
        }
        sb.append("plane separation: ").append(this.planeSeparation).append(' ').append("cm").append("\nlwr sctr thres: ").append(this.lwrSctrThres).append(" KeV\nlwr true thres: ").append(this.lwrTrueThres).append(" KeV\nupr true thres: ").append(this.uprTrueThres).append(" KeV\nuser process code: ").append(this.userProcessCode).append("\nacquisition mode: ").append(this.acquisitionMode).append(" (").append(this.acqModeS).append(")\nbin size: ").append(this.binSize).append(' ').append("cm").append("\nbranching fraction: ").append(this.branchingFraction).append("\ndose start time: ").append(this.doseStartTime).append(" (").append(this.doseStart).append(")\ndosage: ").append(this.dosage).append(" Bq/cc\nwell counter corr factor: ").append(this.wellCounterCorrFactor).append("\ndata units: ").append(this.dataUnits).append("\nsepta state: ").append(this.septaState).append(" (").append(this.septaS).append(")\n");
        return sb.toString();
    }
}

