/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.volume.formats.cti;

import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.volume.formats.cti.DirectoryList;
import edu.uthscsa.ric.volume.formats.cti.MainHeader;
import edu.uthscsa.ric.volume.formats.cti.Subheader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class HeaderIO {
    protected Vector<Subheader> getSubheaders(String fileName, int fileType) {
        Vector<Subheader> subheaders = new Vector<Subheader>();
        Subheader subHeader = new Subheader();
        long dirRecord = 2L;
        block0: do {
            DirectoryList dirList;
            if ((dirList = this.readDirList(dirRecord, fileName)) == null) {
                AppLogger.warn((String)"HeaderIO.getSubheaders() - directory list was null");
                return null;
            }
            dirRecord = dirList.getFirstRecord(0);
            for (int i = 1; i < 32; ++i) {
                long status = dirList.getMatrixStatus(i);
                long first = dirList.getFirstRecord(i);
                long last = dirList.getLastRecord(i);
                if (status == 0L) continue block0;
                if (status == -1L) continue;
                if (status == 1L) {
                    byte[] bytes = this.getBytes(first, fileName);
                    if (bytes == null) {
                        AppLogger.error((String)("Problems reading subheader " + i + " of file " + fileName));
                        return null;
                    }
                    subHeader = subHeader.init(fileType, first, last);
                    subHeader.read(bytes);
                    subheaders.addElement(subHeader);
                    continue;
                }
                AppLogger.error((String)("Error reading directory list\nMatrixStatus of matrix " + i + " is " + status));
            }
        } while (dirRecord != 2L);
        return subheaders;
    }

    protected MainHeader readMain(String fileName) {
        byte[] mainH = this.getBytes(1L, fileName);
        if (mainH == null) {
            AppLogger.error((String)("Can not read main header of file " + fileName));
            return null;
        }
        MainHeader mainHeader = new MainHeader();
        mainHeader.read(mainH);
        if (!mainHeader.magicNumber.startsWith("MATRIX72")) {
            AppLogger.error((String)("The main header was probably stripped in " + fileName));
        }
        return mainHeader;
    }

    private void close(RandomAccessFile f) {
        try {
            f.close();
        }
        catch (IOException io) {
            AppLogger.error((String)"Error closing file");
        }
    }

    private byte[] getBytes(long record, RandomAccessFile file) {
        byte[] bytes = new byte[512];
        long offset = (record - 1L) * 512L;
        int bytesRead = 0;
        try {
            file.seek(offset);
            bytesRead = file.read(bytes);
            if (bytesRead != 512) {
                throw new IOException("End of file reached before expected");
            }
        }
        catch (IOException io) {
            if (bytesRead != -1) {
                AppLogger.error((String)"Problems reading file - unexpected end of file");
            }
            return null;
        }
        return bytes;
    }

    private byte[] getBytes(long record, String filePath) {
        RandomAccessFile file = this.open(filePath, "r");
        if (file == null) {
            return null;
        }
        byte[] bytes = this.getBytes(record, file);
        this.close(file);
        return bytes;
    }

    private RandomAccessFile open(String name, String access) {
        RandomAccessFile file;
        try {
            file = new RandomAccessFile(name, access);
        }
        catch (IOException io) {
            AppLogger.error((String)("Problems accessing file " + name));
            return null;
        }
        return file;
    }

    private DirectoryList readDirList(long record, String fileName) {
        byte[] dirList = this.getBytes(record, fileName);
        if (dirList == null) {
            AppLogger.error((String)("Can not read directory list of file " + fileName));
            return null;
        }
        DirectoryList directoryList = new DirectoryList();
        directoryList.read(dirList);
        return directoryList;
    }
}

